/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.tunnelyP2p.udp;

import java.io.IOException;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.security.GeneralSecurityException;
import java.util.UUID;
import org.texboobcat.tunnelyP2p.crypto.CryptoManager;
import org.texboobcat.tunnelyP2p.crypto.SessionKeys;
import org.texboobcat.tunnelyP2p.udp.ReliableUdpStream;

public class UdpConnectionManager
implements AutoCloseable {
    private final DatagramSocket socket;
    private final ReliableUdpStream stream;
    private final SessionKeys sessionKeys;
    private final UUID sessionId;
    private volatile long bytesSent = 0L;
    private volatile long bytesReceived = 0L;

    public UdpConnectionManager(DatagramSocket socket, InetAddress remoteAddress, int remotePort, SessionKeys sessionKeys, UUID sessionId) {
        this.socket = socket;
        this.stream = new ReliableUdpStream(socket, remoteAddress, remotePort);
        this.sessionKeys = sessionKeys;
        this.sessionId = sessionId;
        this.stream.setDataReceiver(this::handleReceivedData);
    }

    public void start() {
        this.stream.start();
    }

    public void sendData(byte[] data) throws IOException, GeneralSecurityException {
        byte[] nonce = CryptoManager.generateNonce();
        byte[] encrypted = CryptoManager.encryptChaCha20Poly1305(this.sessionKeys.getRawEncryptionKey(), nonce, data, null);
        byte[] payload = new byte[nonce.length + encrypted.length];
        System.arraycopy(nonce, 0, payload, 0, nonce.length);
        System.arraycopy(encrypted, 0, payload, nonce.length, encrypted.length);
        this.stream.send(payload);
        this.bytesSent += (long)payload.length;
    }

    private void handleReceivedData(byte[] data) {
        try {
            byte[] nonce = new byte[12];
            byte[] encrypted = new byte[data.length - 12];
            System.arraycopy(data, 0, nonce, 0, 12);
            System.arraycopy(data, 12, encrypted, 0, encrypted.length);
            byte[] decrypted = CryptoManager.decryptChaCha20Poly1305(this.sessionKeys.getRawEncryptionKey(), nonce, encrypted, null);
            this.bytesReceived += (long)data.length;
        }
        catch (GeneralSecurityException e) {
            System.err.println("[UDP] Decryption failed: " + e.getMessage());
        }
    }

    public int getEstimatedRTT() {
        return this.stream.getEstimatedRTT();
    }

    public int getSendWindowSize() {
        return this.stream.getSendWindowSize();
    }

    public long getBytesSent() {
        return this.bytesSent;
    }

    public long getBytesReceived() {
        return this.bytesReceived;
    }

    @Override
    public void close() {
        this.stream.close();
        if (this.socket != null && !this.socket.isClosed()) {
            this.socket.close();
        }
        this.sessionKeys.clear();
    }
}

