/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.tunnelyP2p.udp;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketTimeoutException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicBoolean;
import org.texboobcat.tunnelyP2p.util.Log;

public class UdpHolePuncher {
    private static final int PUNCH_TIMEOUT_MS = 5000;
    private static final int PUNCH_INTERVAL_MS = 100;
    private static final byte[] PUNCH_MESSAGE = "TUNNEL_PUNCH".getBytes();
    private static final byte[] PUNCH_RESPONSE = "TUNNEL_PUNCH_ACK".getBytes();
    private final int localPort;
    private DatagramSocket socket;

    public UdpHolePuncher(int localPort) {
        this.localPort = localPort;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DatagramSocket punchHole(String remoteIP, int remotePort) throws IOException {
        InetAddress remoteAddress = InetAddress.getByName(remoteIP);
        this.socket = new DatagramSocket(this.localPort);
        this.socket.setSoTimeout(100);
        AtomicBoolean success = new AtomicBoolean(false);
        ExecutorService executor = Executors.newFixedThreadPool(2);
        try {
            Future<Boolean> sendFuture = executor.submit(() -> this.sendPunches(remoteAddress, remotePort, success));
            Future<Boolean> receiveFuture = executor.submit(() -> this.receivePunchResponse(success));
            long startTime = System.currentTimeMillis();
            while (!success.get() && System.currentTimeMillis() - startTime < 5000L) {
                Thread.sleep(50L);
            }
            if (success.get()) {
                Log.d("[UDP Hole Punch] Success! Connected to " + remoteIP + ":" + remotePort);
                this.socket.setSoTimeout(0);
                DatagramSocket datagramSocket = this.socket;
                return datagramSocket;
            }
            this.socket.close();
            this.socket = null;
            DatagramSocket datagramSocket = null;
            return datagramSocket;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            if (this.socket != null) {
                this.socket.close();
            }
            DatagramSocket datagramSocket = null;
            return datagramSocket;
        }
        finally {
            executor.shutdownNow();
        }
    }

    private boolean sendPunches(InetAddress remoteAddress, int remotePort, AtomicBoolean success) {
        try {
            byte[] message = PUNCH_MESSAGE;
            DatagramPacket packet = new DatagramPacket(message, message.length, remoteAddress, remotePort);
            while (!success.get()) {
                this.socket.send(packet);
                Thread.sleep(100L);
            }
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    private boolean receivePunchResponse(AtomicBoolean success) {
        try {
            byte[] buffer = new byte[256];
            DatagramPacket packet = new DatagramPacket(buffer, buffer.length);
            while (!success.get()) {
                try {
                    this.socket.receive(packet);
                    byte[] received = new byte[packet.getLength()];
                    System.arraycopy(packet.getData(), 0, received, 0, packet.getLength());
                    if (!this.matches(received, PUNCH_MESSAGE) && !this.matches(received, PUNCH_RESPONSE)) continue;
                    DatagramPacket response = new DatagramPacket(PUNCH_RESPONSE, PUNCH_RESPONSE.length, packet.getAddress(), packet.getPort());
                    this.socket.send(response);
                    success.set(true);
                    return true;
                }
                catch (SocketTimeoutException socketTimeoutException) {
                }
            }
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    private boolean matches(byte[] a, byte[] b) {
        if (a.length != b.length) {
            return false;
        }
        for (int i = 0; i < a.length; ++i) {
            if (a[i] == b[i]) continue;
            return false;
        }
        return true;
    }

    public static DatagramSocket waitForPunch(int localPort, long timeoutMs) throws IOException {
        DatagramSocket socket = new DatagramSocket(localPort);
        socket.setSoTimeout(100);
        long startTime = System.currentTimeMillis();
        byte[] buffer = new byte[256];
        DatagramPacket packet = new DatagramPacket(buffer, buffer.length);
        try {
            while (System.currentTimeMillis() - startTime < timeoutMs) {
                try {
                    socket.receive(packet);
                    byte[] received = new byte[packet.getLength()];
                    System.arraycopy(packet.getData(), 0, received, 0, packet.getLength());
                    if (!new String(received).equals(new String(PUNCH_MESSAGE))) continue;
                    DatagramPacket response = new DatagramPacket(PUNCH_RESPONSE, PUNCH_RESPONSE.length, packet.getAddress(), packet.getPort());
                    socket.send(response);
                    Log.d("[UDP Hole Punch] Received punch from " + String.valueOf(packet.getAddress()) + ":" + packet.getPort());
                    socket.setSoTimeout(0);
                    return socket;
                }
                catch (SocketTimeoutException received) {
                }
            }
            socket.close();
            return null;
        }
        catch (Exception e) {
            socket.close();
            throw e;
        }
    }
}

