/*
 * Decompiled with CFR 0.152.
 */
package org.fourthline.cling.model.message.header;

import org.fourthline.cling.model.message.header.InvalidHeaderException;
import org.fourthline.cling.model.message.header.UpnpHeader;
import org.seamless.util.MimeType;

public class ContentTypeHeader
extends UpnpHeader<MimeType> {
    public static final MimeType DEFAULT_CONTENT_TYPE = MimeType.valueOf("text/xml");
    public static final MimeType DEFAULT_CONTENT_TYPE_UTF8 = MimeType.valueOf("text/xml;charset=\"utf-8\"");

    public ContentTypeHeader() {
        this.setValue(DEFAULT_CONTENT_TYPE);
    }

    public ContentTypeHeader(MimeType contentType) {
        this.setValue(contentType);
    }

    public ContentTypeHeader(String s) throws InvalidHeaderException {
        this.setString(s);
    }

    @Override
    public void setString(String s) throws InvalidHeaderException {
        this.setValue(MimeType.valueOf(s));
    }

    @Override
    public String getString() {
        return ((MimeType)this.getValue()).toString();
    }

    public boolean isUDACompliantXML() {
        return this.isText() && ((MimeType)this.getValue()).getSubtype().equals(DEFAULT_CONTENT_TYPE.getSubtype());
    }

    public boolean isText() {
        return this.getValue() != null && ((MimeType)this.getValue()).getType().equals(DEFAULT_CONTENT_TYPE.getType());
    }
}

