/*
 * Decompiled with CFR 0.152.
 */
package org.fourthline.cling.support.contentdirectory;

import java.io.InputStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.net.URI;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.fourthline.cling.model.XMLUtil;
import org.fourthline.cling.model.types.Datatype;
import org.fourthline.cling.model.types.InvalidValueException;
import org.fourthline.cling.support.model.DIDLAttribute;
import org.fourthline.cling.support.model.DIDLContent;
import org.fourthline.cling.support.model.DIDLObject;
import org.fourthline.cling.support.model.DescMeta;
import org.fourthline.cling.support.model.Person;
import org.fourthline.cling.support.model.PersonWithRole;
import org.fourthline.cling.support.model.ProtocolInfo;
import org.fourthline.cling.support.model.Res;
import org.fourthline.cling.support.model.StorageMedium;
import org.fourthline.cling.support.model.WriteStatus;
import org.fourthline.cling.support.model.container.Container;
import org.fourthline.cling.support.model.item.Item;
import org.seamless.util.Exceptions;
import org.seamless.util.io.IO;
import org.seamless.xml.SAXParser;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class DIDLParser
extends SAXParser {
    private static final Logger log = Logger.getLogger(DIDLParser.class.getName());
    public static final String UNKNOWN_TITLE = "Unknown Title";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DIDLContent parseResource(String resource) throws Exception {
        try (InputStream is = null;){
            is = Thread.currentThread().getContextClassLoader().getResourceAsStream(resource);
            DIDLContent dIDLContent = this.parse(IO.readLines(is));
            return dIDLContent;
        }
    }

    public DIDLContent parse(String xml) throws Exception {
        if (xml == null || xml.length() == 0) {
            throw new RuntimeException("Null or empty XML");
        }
        DIDLContent content = new DIDLContent();
        this.createRootHandler(content, this);
        log.fine("Parsing DIDL XML content");
        this.parse(new InputSource(new StringReader(xml)));
        return content;
    }

    protected RootHandler createRootHandler(DIDLContent instance, SAXParser parser) {
        return new RootHandler(instance, parser);
    }

    protected ContainerHandler createContainerHandler(Container instance, SAXParser.Handler parent) {
        return new ContainerHandler(instance, parent);
    }

    protected ItemHandler createItemHandler(Item instance, SAXParser.Handler parent) {
        return new ItemHandler(instance, parent);
    }

    protected ResHandler createResHandler(Res instance, SAXParser.Handler parent) {
        return new ResHandler(instance, parent);
    }

    protected DescMetaHandler createDescMetaHandler(DescMeta instance, SAXParser.Handler parent) {
        return new DescMetaHandler(instance, parent);
    }

    protected Container createContainer(Attributes attributes) {
        Container container = new Container();
        container.setId(attributes.getValue("id"));
        container.setParentID(attributes.getValue("parentID"));
        if (attributes.getValue("childCount") != null) {
            container.setChildCount(Integer.valueOf(attributes.getValue("childCount")));
        }
        try {
            Boolean value = (Boolean)Datatype.Builtin.BOOLEAN.getDatatype().valueOf(attributes.getValue("restricted"));
            if (value != null) {
                container.setRestricted(value);
            }
            if ((value = (Boolean)Datatype.Builtin.BOOLEAN.getDatatype().valueOf(attributes.getValue("searchable"))) != null) {
                container.setSearchable(value);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return container;
    }

    protected Item createItem(Attributes attributes) {
        Item item = new Item();
        item.setId(attributes.getValue("id"));
        item.setParentID(attributes.getValue("parentID"));
        try {
            Boolean value = (Boolean)Datatype.Builtin.BOOLEAN.getDatatype().valueOf(attributes.getValue("restricted"));
            if (value != null) {
                item.setRestricted(value);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (attributes.getValue("refID") != null) {
            item.setRefID(attributes.getValue("refID"));
        }
        return item;
    }

    protected Res createResource(Attributes attributes) {
        Res res = new Res();
        if (attributes.getValue("importUri") != null) {
            res.setImportUri(URI.create(attributes.getValue("importUri")));
        }
        try {
            res.setProtocolInfo(new ProtocolInfo(attributes.getValue("protocolInfo")));
        }
        catch (InvalidValueException ex) {
            log.warning("In DIDL content, invalid resource protocol info: " + Exceptions.unwrap(ex));
            return null;
        }
        if (attributes.getValue("size") != null) {
            res.setSize(this.toLongOrNull(attributes.getValue("size")));
        }
        if (attributes.getValue("duration") != null) {
            res.setDuration(attributes.getValue("duration"));
        }
        if (attributes.getValue("bitrate") != null) {
            res.setBitrate(this.toLongOrNull(attributes.getValue("bitrate")));
        }
        if (attributes.getValue("sampleFrequency") != null) {
            res.setSampleFrequency(this.toLongOrNull(attributes.getValue("sampleFrequency")));
        }
        if (attributes.getValue("bitsPerSample") != null) {
            res.setBitsPerSample(this.toLongOrNull(attributes.getValue("bitsPerSample")));
        }
        if (attributes.getValue("nrAudioChannels") != null) {
            res.setNrAudioChannels(this.toLongOrNull(attributes.getValue("nrAudioChannels")));
        }
        if (attributes.getValue("colorDepth") != null) {
            res.setColorDepth(this.toLongOrNull(attributes.getValue("colorDepth")));
        }
        if (attributes.getValue("protection") != null) {
            res.setProtection(attributes.getValue("protection"));
        }
        if (attributes.getValue("resolution") != null) {
            res.setResolution(attributes.getValue("resolution"));
        }
        return res;
    }

    private Long toLongOrNull(String value) {
        try {
            return Long.valueOf(value);
        }
        catch (NumberFormatException x) {
            return null;
        }
    }

    protected DescMeta createDescMeta(Attributes attributes) {
        DescMeta desc = new DescMeta();
        desc.setId(attributes.getValue("id"));
        if (attributes.getValue("type") != null) {
            desc.setType(attributes.getValue("type"));
        }
        if (attributes.getValue("nameSpace") != null) {
            desc.setNameSpace(URI.create(attributes.getValue("nameSpace")));
        }
        return desc;
    }

    public String generate(DIDLContent content) throws Exception {
        return this.generate(content, false);
    }

    public String generate(DIDLContent content, boolean nestedItems) throws Exception {
        return this.documentToString(this.buildDOM(content, nestedItems), true);
    }

    protected String documentToString(Document document, boolean omitProlog) throws Exception {
        TransformerFactory transFactory = TransformerFactory.newInstance();
        Transformer transformer = transFactory.newTransformer();
        if (omitProlog) {
            transformer.setOutputProperty("omit-xml-declaration", "yes");
        }
        StringWriter out = new StringWriter();
        transformer.transform(new DOMSource(document), new StreamResult(out));
        return out.toString();
    }

    protected Document buildDOM(DIDLContent content, boolean nestedItems) throws Exception {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        Document d = factory.newDocumentBuilder().newDocument();
        this.generateRoot(content, d, nestedItems);
        return d;
    }

    protected void generateRoot(DIDLContent content, Document descriptor, boolean nestedItems) {
        Element rootElement = descriptor.createElementNS("urn:schemas-upnp-org:metadata-1-0/DIDL-Lite/", "DIDL-Lite");
        descriptor.appendChild(rootElement);
        rootElement.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:upnp", "urn:schemas-upnp-org:metadata-1-0/upnp/");
        rootElement.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:dc", "http://purl.org/dc/elements/1.1/");
        rootElement.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:sec", "http://www.sec.co.kr/");
        for (Container container : content.getContainers()) {
            if (container == null) continue;
            this.generateContainer(container, descriptor, rootElement, nestedItems);
        }
        for (Item item : content.getItems()) {
            if (item == null) continue;
            this.generateItem(item, descriptor, rootElement);
        }
        for (DescMeta descMeta : content.getDescMetadata()) {
            if (descMeta == null) continue;
            this.generateDescMetadata(descMeta, descriptor, rootElement);
        }
    }

    protected void generateContainer(Container container, Document descriptor, Element parent, boolean nestedItems) {
        if (container.getClazz() == null) {
            throw new RuntimeException("Missing 'upnp:class' element for container: " + container.getId());
        }
        Element containerElement = XMLUtil.appendNewElement(descriptor, parent, "container");
        if (container.getId() == null) {
            throw new NullPointerException("Missing id on container: " + container);
        }
        containerElement.setAttribute("id", container.getId());
        if (container.getParentID() == null) {
            throw new NullPointerException("Missing parent id on container: " + container);
        }
        containerElement.setAttribute("parentID", container.getParentID());
        if (container.getChildCount() != null) {
            containerElement.setAttribute("childCount", Integer.toString(container.getChildCount()));
        }
        containerElement.setAttribute("restricted", this.booleanToInt(container.isRestricted()));
        containerElement.setAttribute("searchable", this.booleanToInt(container.isSearchable()));
        String title = container.getTitle();
        if (title == null) {
            log.warning("Missing 'dc:title' element for container: " + container.getId());
            title = UNKNOWN_TITLE;
        }
        XMLUtil.appendNewElementIfNotNull(descriptor, containerElement, "dc:title", (Object)title, "http://purl.org/dc/elements/1.1/");
        XMLUtil.appendNewElementIfNotNull(descriptor, containerElement, "dc:creator", (Object)container.getCreator(), "http://purl.org/dc/elements/1.1/");
        XMLUtil.appendNewElementIfNotNull(descriptor, containerElement, "upnp:writeStatus", (Object)container.getWriteStatus(), "urn:schemas-upnp-org:metadata-1-0/upnp/");
        this.appendClass(descriptor, containerElement, container.getClazz(), "upnp:class", false);
        for (DIDLObject.Class searchClass : container.getSearchClasses()) {
            this.appendClass(descriptor, containerElement, searchClass, "upnp:searchClass", true);
        }
        for (DIDLObject.Class createClass : container.getCreateClasses()) {
            this.appendClass(descriptor, containerElement, createClass, "upnp:createClass", true);
        }
        this.appendProperties(descriptor, containerElement, container, "upnp", DIDLObject.Property.UPNP.NAMESPACE.class, "urn:schemas-upnp-org:metadata-1-0/upnp/");
        this.appendProperties(descriptor, containerElement, container, "dc", DIDLObject.Property.DC.NAMESPACE.class, "http://purl.org/dc/elements/1.1/");
        if (nestedItems) {
            for (Item item : container.getItems()) {
                if (item == null) continue;
                this.generateItem(item, descriptor, containerElement);
            }
        }
        for (Res resource : container.getResources()) {
            if (resource == null) continue;
            this.generateResource(resource, descriptor, containerElement);
        }
        for (DescMeta descMeta : container.getDescMetadata()) {
            if (descMeta == null) continue;
            this.generateDescMetadata(descMeta, descriptor, containerElement);
        }
    }

    protected void generateItem(Item item, Document descriptor, Element parent) {
        if (item.getClazz() == null) {
            throw new RuntimeException("Missing 'upnp:class' element for item: " + item.getId());
        }
        Element itemElement = XMLUtil.appendNewElement(descriptor, parent, "item");
        if (item.getId() == null) {
            throw new NullPointerException("Missing id on item: " + item);
        }
        itemElement.setAttribute("id", item.getId());
        if (item.getParentID() == null) {
            throw new NullPointerException("Missing parent id on item: " + item);
        }
        itemElement.setAttribute("parentID", item.getParentID());
        if (item.getRefID() != null) {
            itemElement.setAttribute("refID", item.getRefID());
        }
        itemElement.setAttribute("restricted", this.booleanToInt(item.isRestricted()));
        String title = item.getTitle();
        if (title == null) {
            log.warning("Missing 'dc:title' element for item: " + item.getId());
            title = UNKNOWN_TITLE;
        }
        XMLUtil.appendNewElementIfNotNull(descriptor, itemElement, "dc:title", (Object)title, "http://purl.org/dc/elements/1.1/");
        XMLUtil.appendNewElementIfNotNull(descriptor, itemElement, "dc:creator", (Object)item.getCreator(), "http://purl.org/dc/elements/1.1/");
        XMLUtil.appendNewElementIfNotNull(descriptor, itemElement, "upnp:writeStatus", (Object)item.getWriteStatus(), "urn:schemas-upnp-org:metadata-1-0/upnp/");
        this.appendClass(descriptor, itemElement, item.getClazz(), "upnp:class", false);
        this.appendProperties(descriptor, itemElement, item, "upnp", DIDLObject.Property.UPNP.NAMESPACE.class, "urn:schemas-upnp-org:metadata-1-0/upnp/");
        this.appendProperties(descriptor, itemElement, item, "dc", DIDLObject.Property.DC.NAMESPACE.class, "http://purl.org/dc/elements/1.1/");
        this.appendProperties(descriptor, itemElement, item, "sec", DIDLObject.Property.SEC.NAMESPACE.class, "http://www.sec.co.kr/");
        for (Res resource : item.getResources()) {
            if (resource == null) continue;
            this.generateResource(resource, descriptor, itemElement);
        }
        for (DescMeta descMeta : item.getDescMetadata()) {
            if (descMeta == null) continue;
            this.generateDescMetadata(descMeta, descriptor, itemElement);
        }
    }

    protected void generateResource(Res resource, Document descriptor, Element parent) {
        if (resource.getValue() == null) {
            throw new RuntimeException("Missing resource URI value" + resource);
        }
        if (resource.getProtocolInfo() == null) {
            throw new RuntimeException("Missing resource protocol info: " + resource);
        }
        Element resourceElement = XMLUtil.appendNewElement(descriptor, parent, "res", resource.getValue());
        resourceElement.setAttribute("protocolInfo", resource.getProtocolInfo().toString());
        if (resource.getImportUri() != null) {
            resourceElement.setAttribute("importUri", resource.getImportUri().toString());
        }
        if (resource.getSize() != null) {
            resourceElement.setAttribute("size", resource.getSize().toString());
        }
        if (resource.getDuration() != null) {
            resourceElement.setAttribute("duration", resource.getDuration());
        }
        if (resource.getBitrate() != null) {
            resourceElement.setAttribute("bitrate", resource.getBitrate().toString());
        }
        if (resource.getSampleFrequency() != null) {
            resourceElement.setAttribute("sampleFrequency", resource.getSampleFrequency().toString());
        }
        if (resource.getBitsPerSample() != null) {
            resourceElement.setAttribute("bitsPerSample", resource.getBitsPerSample().toString());
        }
        if (resource.getNrAudioChannels() != null) {
            resourceElement.setAttribute("nrAudioChannels", resource.getNrAudioChannels().toString());
        }
        if (resource.getColorDepth() != null) {
            resourceElement.setAttribute("colorDepth", resource.getColorDepth().toString());
        }
        if (resource.getProtection() != null) {
            resourceElement.setAttribute("protection", resource.getProtection());
        }
        if (resource.getResolution() != null) {
            resourceElement.setAttribute("resolution", resource.getResolution());
        }
    }

    protected void generateDescMetadata(DescMeta descMeta, Document descriptor, Element parent) {
        if (descMeta.getId() == null) {
            throw new RuntimeException("Missing id of description metadata: " + descMeta);
        }
        if (descMeta.getNameSpace() == null) {
            throw new RuntimeException("Missing namespace of description metadata: " + descMeta);
        }
        Element descElement = XMLUtil.appendNewElement(descriptor, parent, "desc");
        descElement.setAttribute("id", descMeta.getId());
        descElement.setAttribute("nameSpace", descMeta.getNameSpace().toString());
        if (descMeta.getType() != null) {
            descElement.setAttribute("type", descMeta.getType());
        }
        this.populateDescMetadata(descElement, descMeta);
    }

    protected void populateDescMetadata(Element descElement, DescMeta descMeta) {
        if (descMeta.getMetadata() instanceof Document) {
            Document doc = (Document)descMeta.getMetadata();
            NodeList nl = doc.getDocumentElement().getChildNodes();
            for (int i = 0; i < nl.getLength(); ++i) {
                Node n = nl.item(i);
                if (n.getNodeType() != 1) continue;
                Node clone = descElement.getOwnerDocument().importNode(n, true);
                descElement.appendChild(clone);
            }
        } else {
            log.warning("Unknown desc metadata content, please override populateDescMetadata(): " + descMeta.getMetadata());
        }
    }

    protected void appendProperties(Document descriptor, Element parent, DIDLObject object, String prefix, Class<? extends DIDLObject.Property.NAMESPACE> namespace, String namespaceURI) {
        for (DIDLObject.Property property : object.getPropertiesByNamespace(namespace)) {
            Element el = descriptor.createElementNS(namespaceURI, prefix + ":" + property.getDescriptorName());
            parent.appendChild(el);
            property.setOnElement(el);
        }
    }

    protected void appendClass(Document descriptor, Element parent, DIDLObject.Class clazz, String element, boolean appendDerivation) {
        Element classElement = XMLUtil.appendNewElementIfNotNull(descriptor, parent, element, (Object)clazz.getValue(), "urn:schemas-upnp-org:metadata-1-0/upnp/");
        if (clazz.getFriendlyName() != null && clazz.getFriendlyName().length() > 0) {
            classElement.setAttribute("name", clazz.getFriendlyName());
        }
        if (appendDerivation) {
            classElement.setAttribute("includeDerived", Boolean.toString(clazz.isIncludeDerived()));
        }
    }

    protected String booleanToInt(boolean b) {
        return b ? "1" : "0";
    }

    public void debugXML(String s) {
        if (log.isLoggable(Level.FINE)) {
            log.fine("-------------------------------------------------------------------------------------");
            log.fine("\n" + s);
            log.fine("-------------------------------------------------------------------------------------");
        }
    }

    public class DescMetaHandler
    extends SAXParser.Handler<DescMeta> {
        protected Element current;

        public DescMetaHandler(DescMeta instance, SAXParser.Handler parent) {
            super(instance, parent);
            instance.setMetadata(instance.createMetadataDocument());
            this.current = ((Document)((DescMeta)this.getInstance()).getMetadata()).getDocumentElement();
        }

        @Override
        public DescMeta<Document> getInstance() {
            return (DescMeta)super.getInstance();
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            super.startElement(uri, localName, qName, attributes);
            Element newEl = ((Document)((DescMeta)this.getInstance()).getMetadata()).createElementNS(uri, qName);
            for (int i = 0; i < attributes.getLength(); ++i) {
                newEl.setAttributeNS(attributes.getURI(i), attributes.getQName(i), attributes.getValue(i));
            }
            this.current.appendChild(newEl);
            this.current = newEl;
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            super.endElement(uri, localName, qName);
            if (this.isLastElement(uri, localName, qName)) {
                return;
            }
            if (this.getCharacters().length() > 0 && !this.getCharacters().matches("[\\t\\n\\x0B\\f\\r\\s]+")) {
                this.current.appendChild(((Document)((DescMeta)this.getInstance()).getMetadata()).createTextNode(this.getCharacters()));
            }
            this.current = (Element)this.current.getParentNode();
            this.characters = new StringBuilder();
            this.attributes = null;
        }

        @Override
        protected boolean isLastElement(String uri, String localName, String qName) {
            return "urn:schemas-upnp-org:metadata-1-0/DIDL-Lite/".equals(uri) && "desc".equals(localName);
        }
    }

    protected class ResHandler
    extends SAXParser.Handler<Res> {
        public ResHandler(Res instance, SAXParser.Handler parent) {
            super(instance, parent);
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            super.endElement(uri, localName, qName);
            ((Res)this.getInstance()).setValue(this.getCharacters());
        }

        @Override
        protected boolean isLastElement(String uri, String localName, String qName) {
            return "urn:schemas-upnp-org:metadata-1-0/DIDL-Lite/".equals(uri) && "res".equals(localName);
        }
    }

    public class ItemHandler
    extends DIDLObjectHandler<Item> {
        public ItemHandler(Item instance, SAXParser.Handler parent) {
            super(DIDLParser.this, (DIDLObject)instance, parent);
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            super.startElement(uri, localName, qName, attributes);
            if (!"urn:schemas-upnp-org:metadata-1-0/DIDL-Lite/".equals(uri)) {
                return;
            }
            if (localName.equals("res")) {
                Res res = DIDLParser.this.createResource(attributes);
                if (res != null) {
                    ((Item)this.getInstance()).addResource(res);
                    DIDLParser.this.createResHandler(res, this);
                }
            } else if (localName.equals("desc")) {
                DescMeta desc = DIDLParser.this.createDescMeta(attributes);
                ((Item)this.getInstance()).addDescMetadata(desc);
                DIDLParser.this.createDescMetaHandler(desc, this);
            }
        }

        @Override
        protected boolean isLastElement(String uri, String localName, String qName) {
            if ("urn:schemas-upnp-org:metadata-1-0/DIDL-Lite/".equals(uri) && "item".equals(localName)) {
                if (((Item)this.getInstance()).getTitle() == null) {
                    log.warning("In DIDL content, missing 'dc:title' element for item: " + ((Item)this.getInstance()).getId());
                }
                if (((Item)this.getInstance()).getClazz() == null) {
                    log.warning("In DIDL content, missing 'upnp:class' element for item: " + ((Item)this.getInstance()).getId());
                }
                return true;
            }
            return false;
        }
    }

    public class ContainerHandler
    extends DIDLObjectHandler<Container> {
        public ContainerHandler(Container instance, SAXParser.Handler parent) {
            super(DIDLParser.this, (DIDLObject)instance, parent);
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            Res res;
            super.startElement(uri, localName, qName, attributes);
            if (!"urn:schemas-upnp-org:metadata-1-0/DIDL-Lite/".equals(uri)) {
                return;
            }
            if (localName.equals("item")) {
                Item item = DIDLParser.this.createItem(attributes);
                ((Container)this.getInstance()).addItem(item);
                DIDLParser.this.createItemHandler(item, this);
            } else if (localName.equals("desc")) {
                DescMeta desc = DIDLParser.this.createDescMeta(attributes);
                ((Container)this.getInstance()).addDescMetadata(desc);
                DIDLParser.this.createDescMetaHandler(desc, this);
            } else if (localName.equals("res") && (res = DIDLParser.this.createResource(attributes)) != null) {
                ((Container)this.getInstance()).addResource(res);
                DIDLParser.this.createResHandler(res, this);
            }
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            super.endElement(uri, localName, qName);
            if ("urn:schemas-upnp-org:metadata-1-0/upnp/".equals(uri)) {
                if ("searchClass".equals(localName)) {
                    ((Container)this.getInstance()).getSearchClasses().add(new DIDLObject.Class(this.getCharacters(), this.getAttributes().getValue("name"), "true".equals(this.getAttributes().getValue("includeDerived"))));
                } else if ("createClass".equals(localName)) {
                    ((Container)this.getInstance()).getCreateClasses().add(new DIDLObject.Class(this.getCharacters(), this.getAttributes().getValue("name"), "true".equals(this.getAttributes().getValue("includeDerived"))));
                }
            }
        }

        @Override
        protected boolean isLastElement(String uri, String localName, String qName) {
            if ("urn:schemas-upnp-org:metadata-1-0/DIDL-Lite/".equals(uri) && "container".equals(localName)) {
                if (((Container)this.getInstance()).getTitle() == null) {
                    log.warning("In DIDL content, missing 'dc:title' element for container: " + ((Container)this.getInstance()).getId());
                }
                if (((Container)this.getInstance()).getClazz() == null) {
                    log.warning("In DIDL content, missing 'upnp:class' element for container: " + ((Container)this.getInstance()).getId());
                }
                return true;
            }
            return false;
        }
    }

    public class RootHandler
    extends SAXParser.Handler<DIDLContent> {
        RootHandler(DIDLContent instance, SAXParser parser) {
            super(instance, parser);
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            super.startElement(uri, localName, qName, attributes);
            if (!"urn:schemas-upnp-org:metadata-1-0/DIDL-Lite/".equals(uri)) {
                return;
            }
            if (localName.equals("container")) {
                Container container = DIDLParser.this.createContainer(attributes);
                ((DIDLContent)this.getInstance()).addContainer(container);
                DIDLParser.this.createContainerHandler(container, this);
            } else if (localName.equals("item")) {
                Item item = DIDLParser.this.createItem(attributes);
                ((DIDLContent)this.getInstance()).addItem(item);
                DIDLParser.this.createItemHandler(item, this);
            } else if (localName.equals("desc")) {
                DescMeta desc = DIDLParser.this.createDescMeta(attributes);
                ((DIDLContent)this.getInstance()).addDescMetadata(desc);
                DIDLParser.this.createDescMetaHandler(desc, this);
            }
        }

        @Override
        protected boolean isLastElement(String uri, String localName, String qName) {
            if ("urn:schemas-upnp-org:metadata-1-0/DIDL-Lite/".equals(uri) && "DIDL-Lite".equals(localName)) {
                ((DIDLContent)this.getInstance()).replaceGenericContainerAndItems();
                return true;
            }
            return false;
        }
    }

    public static abstract class DIDLObjectHandler<I extends DIDLObject>
    extends SAXParser.Handler<I> {
        final /* synthetic */ DIDLParser this$0;

        protected DIDLObjectHandler(I instance, SAXParser.Handler parent) {
            this.this$0 = this$0;
            super(instance, parent);
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            super.endElement(uri, localName, qName);
            if ("http://purl.org/dc/elements/1.1/".equals(uri)) {
                if ("title".equals(localName)) {
                    ((DIDLObject)this.getInstance()).setTitle(this.getCharacters());
                } else if ("creator".equals(localName)) {
                    ((DIDLObject)this.getInstance()).setCreator(this.getCharacters());
                } else if ("description".equals(localName)) {
                    ((DIDLObject)this.getInstance()).addProperty(new DIDLObject.Property.DC.DESCRIPTION(this.getCharacters()));
                } else if ("publisher".equals(localName)) {
                    ((DIDLObject)this.getInstance()).addProperty(new DIDLObject.Property.DC.PUBLISHER(new Person(this.getCharacters())));
                } else if ("contributor".equals(localName)) {
                    ((DIDLObject)this.getInstance()).addProperty(new DIDLObject.Property.DC.CONTRIBUTOR(new Person(this.getCharacters())));
                } else if ("date".equals(localName)) {
                    ((DIDLObject)this.getInstance()).addProperty(new DIDLObject.Property.DC.DATE(this.getCharacters()));
                } else if ("language".equals(localName)) {
                    ((DIDLObject)this.getInstance()).addProperty(new DIDLObject.Property.DC.LANGUAGE(this.getCharacters()));
                } else if ("rights".equals(localName)) {
                    ((DIDLObject)this.getInstance()).addProperty(new DIDLObject.Property.DC.RIGHTS(this.getCharacters()));
                } else if ("relation".equals(localName)) {
                    ((DIDLObject)this.getInstance()).addProperty(new DIDLObject.Property.DC.RELATION(URI.create(this.getCharacters())));
                }
            } else if ("urn:schemas-upnp-org:metadata-1-0/upnp/".equals(uri)) {
                if ("writeStatus".equals(localName)) {
                    try {
                        ((DIDLObject)this.getInstance()).setWriteStatus(WriteStatus.valueOf(this.getCharacters()));
                    }
                    catch (Exception ex) {
                        log.info("Ignoring invalid writeStatus value: " + this.getCharacters());
                    }
                } else if ("class".equals(localName)) {
                    ((DIDLObject)this.getInstance()).setClazz(new DIDLObject.Class(this.getCharacters(), this.getAttributes().getValue("name")));
                } else if ("artist".equals(localName)) {
                    ((DIDLObject)this.getInstance()).addProperty(new DIDLObject.Property.UPNP.ARTIST(new PersonWithRole(this.getCharacters(), this.getAttributes().getValue("role"))));
                } else if ("actor".equals(localName)) {
                    ((DIDLObject)this.getInstance()).addProperty(new DIDLObject.Property.UPNP.ACTOR(new PersonWithRole(this.getCharacters(), this.getAttributes().getValue("role"))));
                } else if ("author".equals(localName)) {
                    ((DIDLObject)this.getInstance()).addProperty(new DIDLObject.Property.UPNP.AUTHOR(new PersonWithRole(this.getCharacters(), this.getAttributes().getValue("role"))));
                } else if ("producer".equals(localName)) {
                    ((DIDLObject)this.getInstance()).addProperty(new DIDLObject.Property.UPNP.PRODUCER(new Person(this.getCharacters())));
                } else if ("director".equals(localName)) {
                    ((DIDLObject)this.getInstance()).addProperty(new DIDLObject.Property.UPNP.DIRECTOR(new Person(this.getCharacters())));
                } else if ("longDescription".equals(localName)) {
                    ((DIDLObject)this.getInstance()).addProperty(new DIDLObject.Property.UPNP.LONG_DESCRIPTION(this.getCharacters()));
                } else if ("storageUsed".equals(localName)) {
                    ((DIDLObject)this.getInstance()).addProperty(new DIDLObject.Property.UPNP.STORAGE_USED(Long.valueOf(this.getCharacters())));
                } else if ("storageTotal".equals(localName)) {
                    ((DIDLObject)this.getInstance()).addProperty(new DIDLObject.Property.UPNP.STORAGE_TOTAL(Long.valueOf(this.getCharacters())));
                } else if ("storageFree".equals(localName)) {
                    ((DIDLObject)this.getInstance()).addProperty(new DIDLObject.Property.UPNP.STORAGE_FREE(Long.valueOf(this.getCharacters())));
                } else if ("storageMaxPartition".equals(localName)) {
                    ((DIDLObject)this.getInstance()).addProperty(new DIDLObject.Property.UPNP.STORAGE_MAX_PARTITION(Long.valueOf(this.getCharacters())));
                } else if ("storageMedium".equals(localName)) {
                    ((DIDLObject)this.getInstance()).addProperty(new DIDLObject.Property.UPNP.STORAGE_MEDIUM(StorageMedium.valueOrVendorSpecificOf(this.getCharacters())));
                } else if ("genre".equals(localName)) {
                    ((DIDLObject)this.getInstance()).addProperty(new DIDLObject.Property.UPNP.GENRE(this.getCharacters()));
                } else if ("album".equals(localName)) {
                    ((DIDLObject)this.getInstance()).addProperty(new DIDLObject.Property.UPNP.ALBUM(this.getCharacters()));
                } else if ("playlist".equals(localName)) {
                    ((DIDLObject)this.getInstance()).addProperty(new DIDLObject.Property.UPNP.PLAYLIST(this.getCharacters()));
                } else if ("region".equals(localName)) {
                    ((DIDLObject)this.getInstance()).addProperty(new DIDLObject.Property.UPNP.REGION(this.getCharacters()));
                } else if ("rating".equals(localName)) {
                    ((DIDLObject)this.getInstance()).addProperty(new DIDLObject.Property.UPNP.RATING(this.getCharacters()));
                } else if ("toc".equals(localName)) {
                    ((DIDLObject)this.getInstance()).addProperty(new DIDLObject.Property.UPNP.TOC(this.getCharacters()));
                } else if ("albumArtURI".equals(localName)) {
                    DIDLObject.Property.UPNP.ALBUM_ART_URI albumArtURI = new DIDLObject.Property.UPNP.ALBUM_ART_URI(URI.create(this.getCharacters()));
                    Attributes albumArtURIAttributes = this.getAttributes();
                    for (int i = 0; i < albumArtURIAttributes.getLength(); ++i) {
                        if (!"profileID".equals(albumArtURIAttributes.getLocalName(i))) continue;
                        albumArtURI.addAttribute(new DIDLObject.Property.DLNA.PROFILE_ID(new DIDLAttribute("urn:schemas-dlna-org:metadata-1-0/", "dlna", albumArtURIAttributes.getValue(i))));
                    }
                    ((DIDLObject)this.getInstance()).addProperty(albumArtURI);
                } else if ("artistDiscographyURI".equals(localName)) {
                    ((DIDLObject)this.getInstance()).addProperty(new DIDLObject.Property.UPNP.ARTIST_DISCO_URI(URI.create(this.getCharacters())));
                } else if ("lyricsURI".equals(localName)) {
                    ((DIDLObject)this.getInstance()).addProperty(new DIDLObject.Property.UPNP.LYRICS_URI(URI.create(this.getCharacters())));
                } else if ("icon".equals(localName)) {
                    ((DIDLObject)this.getInstance()).addProperty(new DIDLObject.Property.UPNP.ICON(URI.create(this.getCharacters())));
                } else if ("radioCallSign".equals(localName)) {
                    ((DIDLObject)this.getInstance()).addProperty(new DIDLObject.Property.UPNP.RADIO_CALL_SIGN(this.getCharacters()));
                } else if ("radioStationID".equals(localName)) {
                    ((DIDLObject)this.getInstance()).addProperty(new DIDLObject.Property.UPNP.RADIO_STATION_ID(this.getCharacters()));
                } else if ("radioBand".equals(localName)) {
                    ((DIDLObject)this.getInstance()).addProperty(new DIDLObject.Property.UPNP.RADIO_BAND(this.getCharacters()));
                } else if ("channelNr".equals(localName)) {
                    ((DIDLObject)this.getInstance()).addProperty(new DIDLObject.Property.UPNP.CHANNEL_NR(Integer.valueOf(this.getCharacters())));
                } else if ("channelName".equals(localName)) {
                    ((DIDLObject)this.getInstance()).addProperty(new DIDLObject.Property.UPNP.CHANNEL_NAME(this.getCharacters()));
                } else if ("scheduledStartTime".equals(localName)) {
                    ((DIDLObject)this.getInstance()).addProperty(new DIDLObject.Property.UPNP.SCHEDULED_START_TIME(this.getCharacters()));
                } else if ("scheduledEndTime".equals(localName)) {
                    ((DIDLObject)this.getInstance()).addProperty(new DIDLObject.Property.UPNP.SCHEDULED_END_TIME(this.getCharacters()));
                } else if ("DVDRegionCode".equals(localName)) {
                    ((DIDLObject)this.getInstance()).addProperty(new DIDLObject.Property.UPNP.DVD_REGION_CODE(Integer.valueOf(this.getCharacters())));
                } else if ("originalTrackNumber".equals(localName)) {
                    ((DIDLObject)this.getInstance()).addProperty(new DIDLObject.Property.UPNP.ORIGINAL_TRACK_NUMBER(Integer.valueOf(this.getCharacters())));
                } else if ("userAnnotation".equals(localName)) {
                    ((DIDLObject)this.getInstance()).addProperty(new DIDLObject.Property.UPNP.USER_ANNOTATION(this.getCharacters()));
                }
            }
        }
    }
}

