/*
 * Decompiled with CFR 0.152.
 */
package org.fourthline.cling.support.lastchange;

import java.util.Map;
import org.fourthline.cling.model.types.Datatype;
import org.fourthline.cling.model.types.InvalidValueException;
import org.fourthline.cling.support.shared.AbstractMap;

public abstract class EventedValue<V> {
    protected final V value;

    public EventedValue(V value) {
        this.value = value;
    }

    public EventedValue(Map.Entry<String, String>[] attributes) {
        try {
            this.value = this.valueOf(attributes);
        }
        catch (InvalidValueException ex) {
            throw new RuntimeException(ex);
        }
    }

    public String getName() {
        return this.getClass().getSimpleName();
    }

    public V getValue() {
        return this.value;
    }

    public Map.Entry<String, String>[] getAttributes() {
        return new Map.Entry[]{new AbstractMap.SimpleEntry<String, String>("val", this.toString())};
    }

    protected V valueOf(Map.Entry<String, String>[] attributes) throws InvalidValueException {
        V v = null;
        for (Map.Entry<String, String> attribute : attributes) {
            if (!attribute.getKey().equals("val")) continue;
            v = this.valueOf(attribute.getValue());
        }
        return v;
    }

    protected V valueOf(String s) throws InvalidValueException {
        return this.getDatatype().valueOf(s);
    }

    public String toString() {
        return this.getDatatype().getString(this.getValue());
    }

    protected abstract Datatype getDatatype();
}

