/*
 * Decompiled with CFR 0.152.
 */
package org.fourthline.cling.support.model.dlna.message.header;

import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.fourthline.cling.model.message.header.InvalidHeaderException;
import org.fourthline.cling.model.message.header.UpnpHeader;
import org.fourthline.cling.support.model.dlna.message.header.AvailableRangeHeader;
import org.fourthline.cling.support.model.dlna.message.header.AvailableSeekRangeHeader;
import org.fourthline.cling.support.model.dlna.message.header.BufferBytesHeader;
import org.fourthline.cling.support.model.dlna.message.header.BufferInfoHeader;
import org.fourthline.cling.support.model.dlna.message.header.ContentFeaturesHeader;
import org.fourthline.cling.support.model.dlna.message.header.EventTypeHeader;
import org.fourthline.cling.support.model.dlna.message.header.FriendlyNameHeader;
import org.fourthline.cling.support.model.dlna.message.header.GetAvailableSeekRangeHeader;
import org.fourthline.cling.support.model.dlna.message.header.GetContentFeaturesHeader;
import org.fourthline.cling.support.model.dlna.message.header.MaxPrateHeader;
import org.fourthline.cling.support.model.dlna.message.header.PeerManagerHeader;
import org.fourthline.cling.support.model.dlna.message.header.PlaySpeedHeader;
import org.fourthline.cling.support.model.dlna.message.header.PragmaHeader;
import org.fourthline.cling.support.model.dlna.message.header.RealTimeInfoHeader;
import org.fourthline.cling.support.model.dlna.message.header.SCIDHeader;
import org.fourthline.cling.support.model.dlna.message.header.ScmsFlagHeader;
import org.fourthline.cling.support.model.dlna.message.header.SupportedHeader;
import org.fourthline.cling.support.model.dlna.message.header.TimeSeekRangeHeader;
import org.fourthline.cling.support.model.dlna.message.header.TransferModeHeader;
import org.fourthline.cling.support.model.dlna.message.header.WCTHeader;
import org.seamless.util.Exceptions;

public abstract class DLNAHeader<T>
extends UpnpHeader<T> {
    private static final Logger log = Logger.getLogger(DLNAHeader.class.getName());

    public static DLNAHeader newInstance(Type type, String headerValue) {
        DLNAHeader upnpHeader = null;
        for (int i = 0; i < type.getHeaderTypes().length && upnpHeader == null; ++i) {
            Class<? extends DLNAHeader> headerClass = type.getHeaderTypes()[i];
            try {
                log.finest("Trying to parse '" + (Object)((Object)type) + "' with class: " + headerClass.getSimpleName());
                upnpHeader = headerClass.newInstance();
                if (headerValue == null) continue;
                upnpHeader.setString(headerValue);
                continue;
            }
            catch (InvalidHeaderException ex) {
                log.finest("Invalid header value for tested type: " + headerClass.getSimpleName() + " - " + ex.getMessage());
                upnpHeader = null;
                continue;
            }
            catch (Exception ex) {
                log.severe("Error instantiating header of type '" + (Object)((Object)type) + "' with value: " + headerValue);
                log.log(Level.SEVERE, "Exception root cause: ", Exceptions.unwrap(ex));
            }
        }
        return upnpHeader;
    }

    public static enum Type {
        TimeSeekRange("TimeSeekRange.dlna.org", TimeSeekRangeHeader.class),
        XSeekRange("X-Seek-Range", TimeSeekRangeHeader.class),
        PlaySpeed("PlaySpeed.dlna.org", PlaySpeedHeader.class),
        AvailableSeekRange("availableSeekRange.dlna.org", AvailableSeekRangeHeader.class),
        GetAvailableSeekRange("getAvailableSeekRange.dlna.org", GetAvailableSeekRangeHeader.class),
        GetContentFeatures("getcontentFeatures.dlna.org", GetContentFeaturesHeader.class),
        ContentFeatures("contentFeatures.dlna.org", ContentFeaturesHeader.class),
        TransferMode("transferMode.dlna.org", TransferModeHeader.class),
        FriendlyName("friendlyName.dlna.org", FriendlyNameHeader.class),
        PeerManager("peerManager.dlna.org", PeerManagerHeader.class),
        AvailableRange("Available-Range.dlna.org", AvailableRangeHeader.class),
        SCID("scid.dlna.org", SCIDHeader.class),
        RealTimeInfo("realTimeInfo.dlna.org", RealTimeInfoHeader.class),
        ScmsFlag("scmsFlag.dlna.org", ScmsFlagHeader.class),
        WCT("WCT.dlna.org", WCTHeader.class),
        MaxPrate("Max-Prate.dlna.org", MaxPrateHeader.class),
        EventType("Event-Type.dlna.org", EventTypeHeader.class),
        Supported("Supported", SupportedHeader.class),
        BufferInfo("Buffer-Info.dlna.org", BufferInfoHeader.class),
        RTPH264DeInterleaving("rtp-h264-deint-buf-cap.dlna.org", BufferBytesHeader.class),
        RTPAACDeInterleaving("rtp-aac-deint-buf-cap.dlna.org", BufferBytesHeader.class),
        RTPAMRDeInterleaving("rtp-amr-deint-buf-cap.dlna.org", BufferBytesHeader.class),
        RTPAMRWBPlusDeInterleaving("rtp-amrwbplus-deint-buf-cap.dlna.org", BufferBytesHeader.class),
        PRAGMA("PRAGMA", PragmaHeader.class);

        private static Map<String, Type> byName;
        private String httpName;
        private Class<? extends DLNAHeader>[] headerTypes;

        @SafeVarargs
        private Type(String httpName, Class<? extends DLNAHeader> ... headerClass) {
            this.httpName = httpName;
            this.headerTypes = headerClass;
        }

        public String getHttpName() {
            return this.httpName;
        }

        public Class<? extends DLNAHeader>[] getHeaderTypes() {
            return this.headerTypes;
        }

        public boolean isValidHeaderType(Class<? extends DLNAHeader> clazz) {
            for (Class<? extends DLNAHeader> permissibleType : this.getHeaderTypes()) {
                if (!permissibleType.isAssignableFrom(clazz)) continue;
                return true;
            }
            return false;
        }

        public static Type getByHttpName(String httpName) {
            if (httpName == null) {
                return null;
            }
            return byName.get(httpName);
        }

        static {
            byName = new HashMap<String, Type>(){
                {
                    for (Type t : Type.values()) {
                        this.put(t.getHttpName(), t);
                    }
                }
            };
        }
    }
}

