/*
 * Decompiled with CFR 0.152.
 */
package org.fourthline.cling.support.model.dlna.message.header;

import org.fourthline.cling.model.message.header.InvalidHeaderException;
import org.fourthline.cling.model.types.BytesRange;
import org.fourthline.cling.model.types.InvalidValueException;
import org.fourthline.cling.support.model.dlna.message.header.DLNAHeader;
import org.fourthline.cling.support.model.dlna.types.NormalPlayTimeRange;
import org.fourthline.cling.support.model.dlna.types.TimeSeekRangeType;

public class TimeSeekRangeHeader
extends DLNAHeader<TimeSeekRangeType> {
    public TimeSeekRangeHeader() {
    }

    public TimeSeekRangeHeader(TimeSeekRangeType timeSeekRange) {
        this.setValue(timeSeekRange);
    }

    @Override
    public void setString(String s) throws InvalidHeaderException {
        String[] params;
        if (s.length() != 0 && (params = s.split(" ")).length > 0) {
            try {
                TimeSeekRangeType t = new TimeSeekRangeType(NormalPlayTimeRange.valueOf(params[0]));
                if (params.length > 1) {
                    t.setBytesRange(BytesRange.valueOf(params[1]));
                }
                this.setValue(t);
                return;
            }
            catch (InvalidValueException invalidValueException) {
                throw new InvalidHeaderException("Invalid TimeSeekRange header value: " + s + "; " + invalidValueException.getMessage());
            }
        }
        throw new InvalidHeaderException("Invalid TimeSeekRange header value: " + s);
    }

    @Override
    public String getString() {
        TimeSeekRangeType t = (TimeSeekRangeType)this.getValue();
        String s = t.getNormalPlayTimeRange().getString();
        if (t.getBytesRange() != null) {
            s = s + " " + t.getBytesRange().getString(true);
        }
        return s;
    }
}

