/*
 * Decompiled with CFR 0.152.
 */
package org.fourthline.cling.transport.spi;

import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.fourthline.cling.model.message.StreamRequestMessage;
import org.fourthline.cling.model.message.StreamResponseMessage;
import org.fourthline.cling.transport.spi.StreamClient;
import org.fourthline.cling.transport.spi.StreamClientConfiguration;
import org.seamless.util.Exceptions;

public abstract class AbstractStreamClient<C extends StreamClientConfiguration, REQUEST>
implements StreamClient<C> {
    private static final Logger log = Logger.getLogger(StreamClient.class.getName());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StreamResponseMessage sendRequest(StreamRequestMessage requestMessage) throws InterruptedException {
        REQUEST request;
        if (log.isLoggable(Level.FINE)) {
            log.fine("Preparing HTTP request: " + requestMessage);
        }
        if ((request = this.createRequest(requestMessage)) == null) {
            return null;
        }
        Callable<StreamResponseMessage> callable = this.createCallable(requestMessage, request);
        long start = System.currentTimeMillis();
        Future<StreamResponseMessage> future = this.getConfiguration().getRequestExecutorService().submit(callable);
        try {
            if (log.isLoggable(Level.FINE)) {
                log.fine("Waiting " + this.getConfiguration().getTimeoutSeconds() + " seconds for HTTP request to complete: " + requestMessage);
            }
            StreamResponseMessage response = future.get(this.getConfiguration().getTimeoutSeconds(), TimeUnit.SECONDS);
            long elapsed = System.currentTimeMillis() - start;
            if (log.isLoggable(Level.FINEST)) {
                log.finest("Got HTTP response in " + elapsed + "ms: " + requestMessage);
            }
            if (this.getConfiguration().getLogWarningSeconds() > 0 && elapsed > (long)(this.getConfiguration().getLogWarningSeconds() * 1000)) {
                log.warning("HTTP request took a long time (" + elapsed + "ms): " + requestMessage);
            }
            StreamResponseMessage streamResponseMessage = response;
            return streamResponseMessage;
        }
        catch (InterruptedException ex) {
            if (log.isLoggable(Level.FINE)) {
                log.fine("Interruption, aborting request: " + requestMessage);
            }
            this.abort(request);
            throw new InterruptedException("HTTP request interrupted and aborted");
        }
        catch (TimeoutException ex) {
            log.info("Timeout of " + this.getConfiguration().getTimeoutSeconds() + " seconds while waiting for HTTP request to complete, aborting: " + requestMessage);
            this.abort(request);
            StreamResponseMessage elapsed = null;
            return elapsed;
        }
        catch (ExecutionException ex) {
            Throwable cause = ex.getCause();
            if (!this.logExecutionException(cause)) {
                log.log(Level.WARNING, "HTTP request failed: " + requestMessage, Exceptions.unwrap(cause));
            }
            StreamResponseMessage streamResponseMessage = null;
            return streamResponseMessage;
        }
        finally {
            this.onFinally(request);
        }
    }

    protected abstract REQUEST createRequest(StreamRequestMessage var1);

    protected abstract Callable<StreamResponseMessage> createCallable(StreamRequestMessage var1, REQUEST var2);

    protected abstract void abort(REQUEST var1);

    protected abstract boolean logExecutionException(Throwable var1);

    protected void onFinally(REQUEST request) {
    }
}

