/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.tunnelyP2p.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.LongArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.net.ServerSocket;
import net.minecraft.class_1934;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_2583;
import net.minecraft.class_310;
import net.minecraft.class_3222;
import net.minecraft.class_437;
import net.minecraft.class_5250;
import net.minecraft.server.MinecraftServer;
import org.texboobcat.tunnelyP2p.TunnelManager;
import org.texboobcat.tunnelyP2p.config.TunnelConfig;
import org.texboobcat.tunnelyP2p.connection.PeerConnection;
import org.texboobcat.tunnelyP2p.diagnostics.NetworkDiagnostics;
import org.texboobcat.tunnelyP2p.gui.AdvancedStatusScreen;
import org.texboobcat.tunnelyP2p.gui.TunnelStatusScreen;

public class TunnelCommands {
    public static void register(CommandDispatcher<class_2168> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"tunnel").executes(TunnelCommands::showHelp)).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"create").executes(ctx -> TunnelCommands.createTunnel((CommandContext<class_2168>)ctx, 4, 3600L, -1))).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"maxPeers", (ArgumentType)IntegerArgumentType.integer((int)1, (int)32)).executes(ctx -> TunnelCommands.createTunnel((CommandContext<class_2168>)ctx, IntegerArgumentType.getInteger((CommandContext)ctx, (String)"maxPeers"), 3600L, -1))).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"ttl", (ArgumentType)LongArgumentType.longArg((long)60L, (long)86400L)).executes(ctx -> TunnelCommands.createTunnel((CommandContext<class_2168>)ctx, IntegerArgumentType.getInteger((CommandContext)ctx, (String)"maxPeers"), LongArgumentType.getLong((CommandContext)ctx, (String)"ttl"), -1))).then(class_2170.method_9244((String)"mcPort", (ArgumentType)IntegerArgumentType.integer((int)1, (int)65535)).executes(ctx -> TunnelCommands.createTunnel((CommandContext<class_2168>)ctx, IntegerArgumentType.getInteger((CommandContext)ctx, (String)"maxPeers"), LongArgumentType.getLong((CommandContext)ctx, (String)"ttl"), IntegerArgumentType.getInteger((CommandContext)ctx, (String)"mcPort")))))))).then(class_2170.method_9247((String)"token").executes(TunnelCommands::showToken))).then(class_2170.method_9247((String)"invite").executes(TunnelCommands::invitePlayer))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"connect").then(class_2170.method_9244((String)"token", (ArgumentType)StringArgumentType.greedyString()).executes(ctx -> TunnelCommands.connectToHost((CommandContext<class_2168>)ctx, StringArgumentType.getString((CommandContext)ctx, (String)"token"))))).then(class_2170.method_9247((String)"paste").executes(TunnelCommands::connectFromClipboard)))).then(class_2170.method_9247((String)"stop").executes(TunnelCommands::stopSession))).then(class_2170.method_9247((String)"status").executes(TunnelCommands::showStatus))).then(class_2170.method_9247((String)"gui").executes(TunnelCommands::openGui))).then(class_2170.method_9247((String)"advanced").executes(TunnelCommands::openAdvancedGui))).then(class_2170.method_9247((String)"diagnostics").executes(TunnelCommands::runDiagnostics))).then(class_2170.method_9247((String)"help").executes(TunnelCommands::showHelp))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"config").then(class_2170.method_9247((String)"reload").executes(TunnelCommands::reloadConfig))).then(class_2170.method_9247((String)"reset").executes(TunnelCommands::resetConfig))));
    }

    private static int createTunnel(CommandContext<class_2168> ctx, int maxPeers, long ttlSeconds, int overrideMcPort) {
        class_2168 source = (class_2168)ctx.getSource();
        TunnelManager manager = TunnelManager.getInstance();
        try {
            int minecraftPort;
            String minecraftHost;
            int bindPort;
            block42: {
                if (manager.isHosting()) {
                    source.method_9213((class_2561)class_2561.method_43470((String)"\u00a7cAlready hosting a tunnel. Use /tunnel stop first."));
                    return 0;
                }
                if (manager.isConnected()) {
                    source.method_9213((class_2561)class_2561.method_43470((String)"\u00a7cAlready connected to a host. Use /tunnel stop first."));
                    return 0;
                }
                bindPort = 25566;
                minecraftHost = "localhost";
                int n = minecraftPort = overrideMcPort > 0 ? overrideMcPort : 25565;
                if (overrideMcPort > 0) {
                    int portToShow = minecraftPort;
                    source.method_9226(() -> class_2561.method_43470((String)("\u00a77Using provided MC port: \u00a7f" + portToShow)), false);
                }
                try {
                    MinecraftServer server = source.method_9211();
                    if (!server.method_3816() && overrideMcPort <= 0) {
                        int detectedPort;
                        int requested;
                        block40: {
                            requested = TunnelCommands.findFreeTcpPort();
                            detectedPort = 0;
                            boolean published = false;
                            try {
                                try {
                                    Boolean bo;
                                    Object res = server.getClass().getMethod("isPublished", new Class[0]).invoke((Object)server, new Object[0]);
                                    if (res instanceof Boolean && (bo = (Boolean)res).booleanValue()) {
                                        published = true;
                                    }
                                }
                                catch (Throwable res) {
                                    // empty catch block
                                }
                                if (published) break block40;
                                try {
                                    boolean ok = (Boolean)server.getClass().getMethod("publishServer", class_1934.class, Boolean.TYPE, Integer.TYPE).invoke((Object)server, class_1934.field_9215, true, requested);
                                    if (ok) {
                                        published = true;
                                        source.method_9226(() -> class_2561.method_43470((String)("\u00a7aOpened LAN server (SURVIVAL, cheats ON) on port \u00a7f" + requested)), false);
                                    }
                                }
                                catch (NoSuchMethodException e1) {
                                    try {
                                        boolean ok = (Boolean)server.getClass().getMethod("openToLan", class_1934.class, Boolean.TYPE, Integer.TYPE).invoke((Object)server, class_1934.field_9215, true, requested);
                                        if (ok) {
                                            published = true;
                                            source.method_9226(() -> class_2561.method_43470((String)("\u00a7aOpened LAN server (SURVIVAL, cheats ON) on port \u00a7f" + requested)), false);
                                        }
                                    }
                                    catch (Throwable ok) {}
                                }
                            }
                            catch (Throwable e1) {
                                // empty catch block
                            }
                        }
                        for (int i = 0; i < 50 && detectedPort <= 0; ++i) {
                            try {
                                String[] connAccessors;
                                String[] srvMethods;
                                for (String m : srvMethods = new String[]{"getPort", "getServerPort", "getPublishedPort"}) {
                                    try {
                                        int p = (Integer)server.getClass().getMethod(m, new Class[0]).invoke((Object)server, new Object[0]);
                                        if (p <= 0) continue;
                                        detectedPort = p;
                                        break;
                                    }
                                    catch (Throwable p) {
                                        // empty catch block
                                    }
                                }
                                if (detectedPort > 0) break;
                                for (String acc : connAccessors = new String[]{"getConnection", "getNetworkIo"}) {
                                    try {
                                        String[] connMethods;
                                        Object connection = server.getClass().getMethod(acc, new Class[0]).invoke((Object)server, new Object[0]);
                                        if (connection == null) continue;
                                        for (String cm : connMethods = new String[]{"getServerPort", "getLocalPort", "getPort"}) {
                                            try {
                                                int p = (Integer)connection.getClass().getMethod(cm, new Class[0]).invoke(connection, new Object[0]);
                                                if (p <= 0) continue;
                                                detectedPort = p;
                                                break;
                                            }
                                            catch (Throwable throwable) {
                                                // empty catch block
                                            }
                                        }
                                        if (detectedPort <= 0) continue;
                                        break;
                                    }
                                    catch (Throwable throwable) {
                                        // empty catch block
                                    }
                                }
                            }
                            catch (Throwable throwable) {
                                // empty catch block
                            }
                            try {
                                Thread.sleep(100L);
                                continue;
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                        }
                        if (detectedPort > 0) {
                            minecraftPort = detectedPort;
                        } else {
                            minecraftPort = requested;
                            System.out.println("[TunnelCommands] Falling back to requested LAN port: " + requested);
                        }
                        break block42;
                    }
                    int detected = server.method_3756();
                    if (detected > 0) {
                        minecraftPort = detected;
                    }
                }
                catch (Throwable server) {
                    // empty catch block
                }
            }
            int mcPortFinal = minecraftPort;
            String token = manager.createHostSession(bindPort, minecraftHost, minecraftPort, maxPeers, ttlSeconds);
            source.method_9226(() -> class_2561.method_43470((String)"\u00a7a\u00a7l\u2713 Tunnel Created!"), false);
            source.method_9226(() -> class_2561.method_43470((String)("\u00a77Max Peers: \u00a7f" + maxPeers)), false);
            source.method_9226(() -> class_2561.method_43470((String)("\u00a77TTL: \u00a7f" + TunnelCommands.formatDuration(ttlSeconds))), false);
            source.method_9226(() -> class_2561.method_43470((String)("\u00a77Listening on port: \u00a7f" + bindPort)), false);
            source.method_9226(() -> class_2561.method_43470((String)("\u00a77Forwarding to local server: \u00a7flocalhost:" + mcPortFinal)), false);
            if (mcPortFinal <= 0 || mcPortFinal == 25565) {
                source.method_9226(() -> class_2561.method_43470((String)"\u00a78If singleplayer, ensure your world is opened to LAN or pass a port: /tunnel create <peers> <ttl> <mcPort>."), false);
            } else {
                source.method_9226(() -> class_2561.method_43470((String)("\u00a77Detected LAN port: \u00a7f" + mcPortFinal)), false);
            }
            source.method_9226(() -> class_2561.method_43470((String)"\u00a78Tip: If singleplayer, open your world to LAN; this auto-detects the LAN port."), false);
            source.method_9226(() -> class_2561.method_43470((String)""), false);
            boolean showToken = TunnelCommands.shouldShowTokenInChat();
            if (showToken) {
                class_5250 tokenComponent = class_2561.method_43470((String)"\u00a7e\u00a7l[CLICK TO COPY TOKEN]").method_10862(class_2583.field_24360.method_10958(new class_2558(class_2558.class_2559.field_21462, token)).method_10949(new class_2568(class_2568.class_5247.field_24342, (Object)class_2561.method_43470((String)"\u00a77Click to copy connection token"))));
                source.method_9226(() -> TunnelCommands.lambda$createTunnel$17((class_2561)tokenComponent), false);
                source.method_9226(() -> class_2561.method_43470((String)"\u00a77Share this token with friends to allow them to connect."), false);
            } else {
                source.method_9226(() -> class_2561.method_43470((String)"\u00a77Token generated (not shown for privacy)."), false);
            }
            source.method_9226(() -> class_2561.method_43470((String)"\u00a77Use \u00a7f/tunnel invite \u00a77to copy token to clipboard."), false);
            source.method_9226(() -> class_2561.method_43470((String)"\u00a77Clients can use \u00a7f/tunnel connect paste \u00a77to read token from clipboard."), false);
            return 1;
        }
        catch (Exception e) {
            source.method_9213((class_2561)class_2561.method_43470((String)("\u00a7cFailed to create tunnel: " + e.getMessage())));
            e.printStackTrace();
            return 0;
        }
    }

    private static int showToken(CommandContext<class_2168> ctx) {
        class_2168 source = (class_2168)ctx.getSource();
        TunnelManager manager = TunnelManager.getInstance();
        if (!manager.isHosting()) {
            source.method_9213((class_2561)class_2561.method_43470((String)"\u00a7cNo active tunnel. Use /tunnel create first."));
            return 0;
        }
        String token = manager.getActiveServer().getConnectionToken();
        source.method_9226(() -> class_2561.method_43470((String)"\u00a7a\u00a7lConnection Token:"), false);
        boolean showToken = TunnelCommands.shouldShowTokenInChat();
        if (showToken) {
            class_5250 tokenComponent = class_2561.method_43470((String)"\u00a7e\u00a7l[CLICK TO COPY TOKEN]").method_10862(class_2583.field_24360.method_10958(new class_2558(class_2558.class_2559.field_21462, token)).method_10949(new class_2568(class_2568.class_5247.field_24342, (Object)class_2561.method_43470((String)"\u00a77Click to copy connection token"))));
            source.method_9226(() -> TunnelCommands.lambda$showToken$23((class_2561)tokenComponent), false);
        } else {
            source.method_9226(() -> class_2561.method_43470((String)"\u00a77Token hidden for privacy. Use \u00a7f/tunnel invite \u00a77to copy to clipboard."), false);
        }
        return 1;
    }

    private static int invitePlayer(CommandContext<class_2168> ctx) {
        class_2168 source = (class_2168)ctx.getSource();
        TunnelManager manager = TunnelManager.getInstance();
        if (!manager.isHosting()) {
            source.method_9213((class_2561)class_2561.method_43470((String)"\u00a7cNo active tunnel. Use /tunnel create first."));
            return 0;
        }
        String token = manager.getActiveServer().getConnectionToken();
        if (token == null || token.isEmpty()) {
            source.method_9213((class_2561)class_2561.method_43470((String)"\u00a7cFailed to generate token."));
            return 0;
        }
        try {
            try {
                class_310.method_1551().field_1774.method_1455(token);
                source.method_9226(() -> class_2561.method_43470((String)"\u00a7a\u2713 Token copied to clipboard!"), false);
                source.method_9226(() -> class_2561.method_43470((String)"\u00a77Share it with friends to let them connect."), false);
                return 1;
            }
            catch (Throwable mcError) {
                try {
                    Clipboard clipboard;
                    Toolkit toolkit = Toolkit.getDefaultToolkit();
                    if (toolkit != null && (clipboard = toolkit.getSystemClipboard()) != null) {
                        clipboard.setContents(new StringSelection(token), null);
                        source.method_9226(() -> class_2561.method_43470((String)"\u00a7a\u2713 Token copied to clipboard!"), false);
                        source.method_9226(() -> class_2561.method_43470((String)"\u00a77Share it with friends to let them connect."), false);
                        return 1;
                    }
                }
                catch (Throwable toolkit) {
                    // empty catch block
                }
                source.method_9213((class_2561)class_2561.method_43470((String)"\u00a7cClipboard unavailable. Token must be copied manually."));
                source.method_9226(() -> class_2561.method_43470((String)("\u00a77Token: \u00a7f" + token)), false);
                return 0;
            }
        }
        catch (Exception e) {
            String errorMsg = e.getMessage() != null ? e.getMessage() : e.getClass().getSimpleName();
            source.method_9213((class_2561)class_2561.method_43470((String)("\u00a7cFailed to copy to clipboard: " + errorMsg)));
            source.method_9226(() -> class_2561.method_43470((String)("\u00a77Token: \u00a7f" + token)), false);
            e.printStackTrace();
            return 0;
        }
    }

    private static int connectToHost(CommandContext<class_2168> ctx, String token) {
        class_2168 source = (class_2168)ctx.getSource();
        TunnelManager manager = TunnelManager.getInstance();
        try {
            if (manager.isConnected()) {
                source.method_9213((class_2561)class_2561.method_43470((String)"\u00a7cAlready connected. Use /tunnel stop first."));
                return 0;
            }
            if (manager.isHosting()) {
                source.method_9213((class_2561)class_2561.method_43470((String)"\u00a7cCurrently hosting. Use /tunnel stop first."));
                return 0;
            }
            class_3222 player = source.method_44023();
            if (player == null) {
                source.method_9213((class_2561)class_2561.method_43470((String)"\u00a7cThis command must be run by a player."));
                return 0;
            }
            int localPort = 25999;
            source.method_9226(() -> class_2561.method_43470((String)"\u00a7eConnecting to host..."), false);
            manager.connectToHost(token, localPort, player.method_5667(), player.method_5477().getString());
            source.method_9226(() -> class_2561.method_43470((String)"\u00a7a\u00a7l\u2713 Connected!"), false);
            source.method_9226(() -> class_2561.method_43470((String)("\u00a77Local proxy: \u00a7flocalhost:" + localPort)), false);
            source.method_9226(() -> class_2561.method_43470((String)("\u00a77Add server: \u00a7f127.0.0.1:" + localPort)), false);
            source.method_9226(() -> class_2561.method_43470((String)"\u00a7aConnect your Minecraft client to that address to join!"), false);
            return 1;
        }
        catch (Exception e) {
            source.method_9213((class_2561)class_2561.method_43470((String)("\u00a7cConnection failed: " + e.getMessage())));
            e.printStackTrace();
            return 0;
        }
    }

    private static int connectFromClipboard(CommandContext<class_2168> ctx) {
        class_2168 source = (class_2168)ctx.getSource();
        TunnelManager manager = TunnelManager.getInstance();
        try {
            class_3222 player = source.method_44023();
            if (player == null) {
                source.method_9213((class_2561)class_2561.method_43470((String)"\u00a7cThis command must be run by a player."));
                return 0;
            }
            if (manager.isConnected()) {
                source.method_9213((class_2561)class_2561.method_43470((String)"\u00a7cAlready connected. Use /tunnel stop first."));
                return 0;
            }
            if (manager.isHosting()) {
                source.method_9213((class_2561)class_2561.method_43470((String)"\u00a7cCurrently hosting. Use /tunnel stop first."));
                return 0;
            }
            String token = null;
            try {
                token = class_310.method_1551().field_1774.method_1460();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (token == null) {
                try {
                    Clipboard cb = Toolkit.getDefaultToolkit().getSystemClipboard();
                    Object data = cb.getData(DataFlavor.stringFlavor);
                    token = data != null ? data.toString() : null;
                }
                catch (Exception ex) {
                    source.method_9213((class_2561)class_2561.method_43470((String)("\u00a7cClipboard not available: " + ex.getMessage())));
                    return 0;
                }
            }
            if (token == null || token.trim().isEmpty()) {
                source.method_9213((class_2561)class_2561.method_43470((String)"\u00a7cClipboard is empty or doesn't contain a token."));
                return 0;
            }
            int localPort = 25999;
            source.method_9226(() -> class_2561.method_43470((String)"\u00a7eConnecting to host..."), false);
            manager.connectToHost(token, localPort, player.method_5667(), player.method_5477().getString());
            source.method_9226(() -> class_2561.method_43470((String)"\u00a7a\u00a7l\u2713 Connected!"), false);
            source.method_9226(() -> class_2561.method_43470((String)("\u00a77Local proxy: \u00a7flocalhost:" + localPort)), false);
            source.method_9226(() -> class_2561.method_43470((String)("\u00a77Add server: \u00a7f127.0.0.1:" + localPort)), false);
            source.method_9226(() -> class_2561.method_43470((String)"\u00a7aConnect your Minecraft client to that address to join!"), false);
            return 1;
        }
        catch (Exception e) {
            source.method_9213((class_2561)class_2561.method_43470((String)("\u00a7cConnection failed: " + e.getMessage())));
            e.printStackTrace();
            return 0;
        }
    }

    private static int stopSession(CommandContext<class_2168> ctx) {
        class_2168 source = (class_2168)ctx.getSource();
        TunnelManager manager = TunnelManager.getInstance();
        if (!manager.isHosting() && !manager.isConnected()) {
            source.method_9213((class_2561)class_2561.method_43470((String)"\u00a7cNo active tunnel session."));
            return 0;
        }
        manager.stopAll();
        source.method_9226(() -> class_2561.method_43470((String)"\u00a7a\u2713 Tunnel session stopped."), false);
        return 1;
    }

    private static int showStatus(CommandContext<class_2168> ctx) {
        class_2168 source = (class_2168)ctx.getSource();
        TunnelManager manager = TunnelManager.getInstance();
        TunnelManager.SessionStatus status = manager.getStatus();
        source.method_9226(() -> class_2561.method_43470((String)"\u00a7b\u00a7l\u2550\u2550\u2550 Tunnel Status \u2550\u2550\u2550"), false);
        if (!status.active) {
            source.method_9226(() -> class_2561.method_43470((String)"\u00a77Mode: \u00a7cInactive"), false);
            source.method_9226(() -> class_2561.method_43470((String)"\u00a77Use \u00a7f/tunnel create \u00a77to host or \u00a7f/tunnel connect \u00a77to join."), false);
            return 1;
        }
        if ("host".equals(status.mode)) {
            source.method_9226(() -> class_2561.method_43470((String)"\u00a77Mode: \u00a7aHost"), false);
            source.method_9226(() -> class_2561.method_43470((String)("\u00a77Connected Peers: \u00a7f" + status.peerCount)), false);
            if (status.peerCount > 0) {
                source.method_9226(() -> class_2561.method_43470((String)"\u00a77Peers:"), false);
                for (PeerConnection peer : manager.getConnectedPeers()) {
                    String peerInfo = String.format("  \u00a7f%s \u00a77(\u2191 %s \u2193 %s)", peer.getPeerName(), TunnelCommands.formatBytes(peer.getBytesSent()), TunnelCommands.formatBytes(peer.getBytesReceived()));
                    source.method_9226(() -> class_2561.method_43470((String)peerInfo), false);
                }
            }
        } else if ("client".equals(status.mode)) {
            source.method_9226(() -> class_2561.method_43470((String)"\u00a77Mode: \u00a7aClient"), false);
            source.method_9226(() -> class_2561.method_43470((String)("\u00a77Connected to: \u00a7f" + status.hostName)), false);
            source.method_9226(() -> class_2561.method_43470((String)("\u00a77Local proxy: \u00a7flocalhost:" + status.localPort)), false);
            source.method_9226(() -> class_2561.method_43470((String)("\u00a77Data sent: \u00a7f" + TunnelCommands.formatBytes(status.bytesSent))), false);
            source.method_9226(() -> class_2561.method_43470((String)("\u00a77Data received: \u00a7f" + TunnelCommands.formatBytes(status.bytesReceived))), false);
        }
        source.method_9226(() -> class_2561.method_43470((String)"\u00a7b\u00a7l\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550"), false);
        return 1;
    }

    private static int openGui(CommandContext<class_2168> ctx) {
        class_2168 source = (class_2168)ctx.getSource();
        if (source.method_44023() == null) {
            source.method_9213((class_2561)class_2561.method_43470((String)"\u00a7cThis command must be run by a player."));
            return 0;
        }
        try {
            class_310.method_1551().execute(() -> class_310.method_1551().method_1507((class_437)new TunnelStatusScreen(class_310.method_1551().field_1755)));
            return 1;
        }
        catch (Exception e) {
            source.method_9213((class_2561)class_2561.method_43470((String)("\u00a7cFailed to open GUI: " + e.getMessage())));
            return 0;
        }
    }

    private static int openAdvancedGui(CommandContext<class_2168> ctx) {
        class_2168 source = (class_2168)ctx.getSource();
        if (source.method_44023() == null) {
            source.method_9213((class_2561)class_2561.method_43470((String)"\u00a7cThis command must be run by a player."));
            return 0;
        }
        try {
            class_310.method_1551().execute(() -> class_310.method_1551().method_1507((class_437)new AdvancedStatusScreen(class_310.method_1551().field_1755)));
            return 1;
        }
        catch (Exception e) {
            source.method_9213((class_2561)class_2561.method_43470((String)("\u00a7cFailed to open GUI: " + e.getMessage())));
            return 0;
        }
    }

    private static int runDiagnostics(CommandContext<class_2168> ctx) {
        class_2168 source = (class_2168)ctx.getSource();
        source.method_9226(() -> class_2561.method_43470((String)"\u00a7e\u00a7lRunning network diagnostics..."), false);
        NetworkDiagnostics.DiagnosticReport report = NetworkDiagnostics.runDiagnostics();
        source.method_9226(() -> class_2561.method_43470((String)"\u00a7b\u00a7l\u2550\u2550\u2550 Network Diagnostics \u2550\u2550\u2550"), false);
        source.method_9226(() -> class_2561.method_43470((String)("\u00a77Local IPv4: \u00a7f" + report.localIP)), false);
        source.method_9226(() -> class_2561.method_43470((String)("\u00a77Public IPv4: \u00a7f" + (report.publicIP != null ? report.publicIP : "Unknown"))), false);
        source.method_9226(() -> class_2561.method_43470((String)("\u00a77Local IPv6: \u00a7f" + (report.localIPv6 != null ? report.localIPv6 : "Not available"))), false);
        source.method_9226(() -> class_2561.method_43470((String)("\u00a77Public IPv6: \u00a7f" + (report.publicIPv6 != null ? report.publicIPv6 : "Not available"))), false);
        if (report.hasPublicIPv6) {
            source.method_9226(() -> class_2561.method_43470((String)"\u00a7a\u26a1 IPv6 Available - NAT bypass possible!"), false);
        }
        source.method_9226(() -> class_2561.method_43470((String)("\u00a77Internet (IPv4): " + (report.hasInternet ? "\u00a7a\u2713 Connected" : "\u00a7c\u2717 No connection"))), false);
        source.method_9226(() -> class_2561.method_43470((String)("\u00a77Internet (IPv6): " + (report.hasIPv6Internet ? "\u00a7a\u2713 Connected" : "\u00a7c\u2717 No connection"))), false);
        if (report.behindNAT) {
            source.method_9226(() -> class_2561.method_43470((String)("\u00a77NAT: \u00a7e\u26a0 Behind NAT (" + report.natType.getDescription() + ")")), false);
            if (report.stunOk && report.mappedPublicIP != null) {
                source.method_9226(() -> class_2561.method_43470((String)("\u00a78\u2022 STUN mapping: \u00a77" + report.mappedPublicIP + ":" + report.mappedPublicPort)), false);
                source.method_9226(() -> class_2561.method_43470((String)("\u00a78\u2022 Port-preserving: \u00a77" + (report.stunPortPreserving ? "Yes" : "No") + " \u00a78\u2502 Varies across servers: \u00a77" + (report.stunMappingVaries ? "Yes" : "No"))), false);
                source.method_9226(() -> class_2561.method_43470((String)("\u00a78\u2022 STUN reachability: \u00a77" + report.stunSuccessful + "/" + report.stunTotal + " (" + (int)(report.stunReliability * 100.0) + "%)")), false);
                if (report.stunMappings != null && !report.stunMappings.isEmpty()) {
                    StringBuilder sb = new StringBuilder();
                    int show = Math.min(report.stunMappings.size(), 3);
                    for (int i = 0; i < show; ++i) {
                        sb.append(report.stunMappings.get(i).toString());
                        if (i + 1 >= show) continue;
                        sb.append(", ");
                    }
                    if (report.stunMappings.size() > show) {
                        sb.append(" \u2026+").append(report.stunMappings.size() - show).append(" more");
                    }
                    String mappingsStr = sb.toString();
                    source.method_9226(() -> class_2561.method_43470((String)("\u00a78\u2022 STUN mappings: \u00a77" + mappingsStr)), false);
                }
                if (report.natReason != null && !report.natReason.isEmpty()) {
                    source.method_9226(() -> class_2561.method_43470((String)("\u00a78\u2022 Reason: \u00a77" + report.natReason)), false);
                }
            } else {
                source.method_9226(() -> class_2561.method_43470((String)"\u00a78\u2022 STUN: \u00a77No response from servers (UDP may be blocked)"), false);
            }
        } else {
            source.method_9226(() -> class_2561.method_43470((String)"\u00a77NAT: \u00a7a\u2713 Direct"), false);
        }
        source.method_9226(() -> class_2561.method_43470((String)("\u00a77UPnP: " + (report.upnpAvailable ? "\u00a7a\u2713 Available" : "\u00a7c\u2717 Not available"))), false);
        source.method_9226(() -> class_2561.method_43470((String)("\u00a77Firewall: " + (report.firewallDetected ? "\u00a7e\u26a0 Detected" : "\u00a7a\u2713 None detected"))), false);
        if (!report.availablePorts.isEmpty()) {
            source.method_9226(() -> class_2561.method_43470((String)("\u00a77Available ports: \u00a7f" + String.valueOf(report.availablePorts))), false);
        }
        source.method_9226(() -> class_2561.method_43470((String)""), false);
        source.method_9226(() -> class_2561.method_43470((String)"\u00a76Recommendation:"), false);
        source.method_9226(() -> class_2561.method_43470((String)("\u00a77" + report.getRecommendation())), false);
        source.method_9226(() -> class_2561.method_43470((String)"\u00a7b\u00a7l\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550"), false);
        return 1;
    }

    private static int showHelp(CommandContext<class_2168> ctx) {
        class_2168 source = (class_2168)ctx.getSource();
        source.method_9226(() -> class_2561.method_43470((String)"\u00a7b\u00a7l\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550"), false);
        source.method_9226(() -> class_2561.method_43470((String)"\u00a7b\u00a7l      Tunnely P2P - Commands"), false);
        source.method_9226(() -> class_2561.method_43470((String)"\u00a7b\u00a7l\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550"), false);
        source.method_9226(() -> class_2561.method_43470((String)""), false);
        source.method_9226(() -> class_2561.method_43470((String)"\u00a7e\u00a7lServer Commands:"), false);
        source.method_9226(() -> class_2561.method_43470((String)"\u00a77/tunnel create \u00a78[maxPeers] [ttl] [mcPort]"), false);
        source.method_9226(() -> class_2561.method_43470((String)"  \u00a77Create a P2P tunnel server"), false);
        source.method_9226(() -> class_2561.method_43470((String)"  \u00a78\u2022 \u00a77maxPeers: Max players (default: 4)"), false);
        source.method_9226(() -> class_2561.method_43470((String)"  \u00a78\u2022 \u00a77ttl: Session duration in seconds (default: 3600)"), false);
        source.method_9226(() -> class_2561.method_43470((String)"  \u00a78\u2022 \u00a77mcPort: Minecraft port (default: auto-detect)"), false);
        source.method_9226(() -> class_2561.method_43470((String)""), false);
        source.method_9226(() -> class_2561.method_43470((String)"\u00a77/tunnel token"), false);
        source.method_9226(() -> class_2561.method_43470((String)"  \u00a77Display your connection token"), false);
        source.method_9226(() -> class_2561.method_43470((String)""), false);
        source.method_9226(() -> class_2561.method_43470((String)"\u00a77/tunnel invite"), false);
        source.method_9226(() -> class_2561.method_43470((String)"  \u00a77Copy connection token to clipboard"), false);
        source.method_9226(() -> class_2561.method_43470((String)""), false);
        source.method_9226(() -> class_2561.method_43470((String)"\u00a7e\u00a7lClient Commands:"), false);
        source.method_9226(() -> class_2561.method_43470((String)"\u00a77/tunnel connect \u00a78<token>"), false);
        source.method_9226(() -> class_2561.method_43470((String)"  \u00a77Connect to a host using their token"), false);
        source.method_9226(() -> class_2561.method_43470((String)""), false);
        source.method_9226(() -> class_2561.method_43470((String)"\u00a77/tunnel connect paste"), false);
        source.method_9226(() -> class_2561.method_43470((String)"  \u00a77Connect using token from clipboard"), false);
        source.method_9226(() -> class_2561.method_43470((String)""), false);
        source.method_9226(() -> class_2561.method_43470((String)"\u00a7e\u00a7lGeneral Commands:"), false);
        source.method_9226(() -> class_2561.method_43470((String)"\u00a77/tunnel stop"), false);
        source.method_9226(() -> class_2561.method_43470((String)"  \u00a77Stop current tunnel session"), false);
        source.method_9226(() -> class_2561.method_43470((String)""), false);
        source.method_9226(() -> class_2561.method_43470((String)"\u00a77/tunnel status"), false);
        source.method_9226(() -> class_2561.method_43470((String)"  \u00a77Show current tunnel status"), false);
        source.method_9226(() -> class_2561.method_43470((String)""), false);
        source.method_9226(() -> class_2561.method_43470((String)"\u00a77/tunnel diagnostics"), false);
        source.method_9226(() -> class_2561.method_43470((String)"  \u00a77Run network diagnostics"), false);
        source.method_9226(() -> class_2561.method_43470((String)""), false);
        source.method_9226(() -> class_2561.method_43470((String)"\u00a7e\u00a7lGUI Commands:"), false);
        source.method_9226(() -> class_2561.method_43470((String)"\u00a77/tunnel gui"), false);
        source.method_9226(() -> class_2561.method_43470((String)"  \u00a77Open status screen"), false);
        source.method_9226(() -> class_2561.method_43470((String)""), false);
        source.method_9226(() -> class_2561.method_43470((String)"\u00a77/tunnel advanced"), false);
        source.method_9226(() -> class_2561.method_43470((String)"  \u00a77Open advanced status screen"), false);
        source.method_9226(() -> class_2561.method_43470((String)""), false);
        source.method_9226(() -> class_2561.method_43470((String)"\u00a7e\u00a7lConfiguration:"), false);
        source.method_9226(() -> class_2561.method_43470((String)"\u00a77/tunnel config reload"), false);
        source.method_9226(() -> class_2561.method_43470((String)"  \u00a77Reload configuration"), false);
        source.method_9226(() -> class_2561.method_43470((String)""), false);
        source.method_9226(() -> class_2561.method_43470((String)"\u00a77/tunnel config reset"), false);
        source.method_9226(() -> class_2561.method_43470((String)"  \u00a77Reset config to defaults"), false);
        source.method_9226(() -> class_2561.method_43470((String)""), false);
        source.method_9226(() -> class_2561.method_43470((String)"\u00a76\u00a7lTip:"), false);
        source.method_9226(() -> class_2561.method_43470((String)"\u00a77Press \u00a7e[U] \u00a77to open the Tunnely Management Screen"), false);
        source.method_9226(() -> class_2561.method_43470((String)"\u00a77for easy access to all features!"), false);
        source.method_9226(() -> class_2561.method_43470((String)""), false);
        source.method_9226(() -> class_2561.method_43470((String)"\u00a7b\u00a7l\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550"), false);
        return 1;
    }

    private static int reloadConfig(CommandContext<class_2168> ctx) {
        class_2168 source = (class_2168)ctx.getSource();
        try {
            TunnelConfig.getInstance().save();
            source.method_9226(() -> class_2561.method_43470((String)"\u00a7a\u2713 Configuration reloaded"), false);
            return 1;
        }
        catch (Exception e) {
            source.method_9213((class_2561)class_2561.method_43470((String)("\u00a7cFailed to reload config: " + e.getMessage())));
            return 0;
        }
    }

    private static int resetConfig(CommandContext<class_2168> ctx) {
        class_2168 source = (class_2168)ctx.getSource();
        try {
            TunnelConfig.getInstance().resetToDefaults();
            source.method_9226(() -> class_2561.method_43470((String)"\u00a7a\u2713 Configuration reset to defaults"), false);
            return 1;
        }
        catch (Exception e) {
            source.method_9213((class_2561)class_2561.method_43470((String)("\u00a7cFailed to reset config: " + e.getMessage())));
            return 0;
        }
    }

    private static String formatDuration(long seconds) {
        if (seconds < 60L) {
            return seconds + "s";
        }
        if (seconds < 3600L) {
            return seconds / 60L + "m";
        }
        return seconds / 3600L + "h";
    }

    private static String formatBytes(long bytes) {
        if (bytes < 1024L) {
            return bytes + "B";
        }
        if (bytes < 0x100000L) {
            return String.format("%.1f KB", (double)bytes / 1024.0);
        }
        if (bytes < 0x40000000L) {
            return String.format("%.1f MB", (double)bytes / 1048576.0);
        }
        return String.format("%.1f GB", (double)bytes / 1.073741824E9);
    }

    private static int findFreeTcpPort() {
        int n;
        ServerSocket ss = new ServerSocket(0);
        try {
            ss.setReuseAddress(true);
            n = ss.getLocalPort();
        }
        catch (Throwable throwable) {
            try {
                try {
                    ss.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                return 0;
            }
        }
        ss.close();
        return n;
    }

    private static boolean shouldShowTokenInChat() {
        try {
            Class.forName("dev.architectury.platform.Platform");
            TunnelConfig config = TunnelConfig.getInstance();
            return config.showTokenInChat || config.debug;
        }
        catch (Throwable e) {
            return true;
        }
    }

    private static /* synthetic */ class_2561 lambda$showToken$23(class_2561 tokenComponent) {
        return tokenComponent;
    }

    private static /* synthetic */ class_2561 lambda$createTunnel$17(class_2561 tokenComponent) {
        return tokenComponent;
    }
}

