/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.tunnelyP2p.connection;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.texboobcat.tunnelyP2p.connection.PeerConnection;
import org.texboobcat.tunnelyP2p.qos.QoSManager;

public class ConnectionPool {
    private final Map<Integer, LogicalConnection> connections = new ConcurrentHashMap<Integer, LogicalConnection>();
    private final AtomicInteger nextConnectionId = new AtomicInteger(1);
    private final PeerConnection physicalConnection;
    private final QoSManager qosManager;
    private final int maxConnections;

    public ConnectionPool(PeerConnection physicalConnection, int maxConnections) {
        this.physicalConnection = physicalConnection;
        this.maxConnections = maxConnections;
        this.qosManager = new QoSManager(0xA00000L, 0x1400000L);
    }

    public int createConnection() {
        if (this.connections.size() >= this.maxConnections) {
            return -1;
        }
        int connectionId = this.nextConnectionId.getAndIncrement();
        LogicalConnection conn = new LogicalConnection(connectionId, this.physicalConnection, this.qosManager);
        this.connections.put(connectionId, conn);
        return connectionId;
    }

    public LogicalConnection getConnection(int connectionId) {
        return this.connections.get(connectionId);
    }

    public void closeConnection(int connectionId) {
        LogicalConnection conn = this.connections.remove(connectionId);
        if (conn != null) {
            conn.close();
        }
    }

    public Collection<LogicalConnection> getActiveConnections() {
        return Collections.unmodifiableCollection(this.connections.values());
    }

    public int getConnectionCount() {
        return this.connections.size();
    }

    public QoSManager getQoSManager() {
        return this.qosManager;
    }

    public void closeAll() {
        this.connections.values().forEach(LogicalConnection::close);
        this.connections.clear();
    }

    public static class LogicalConnection {
        private final int connectionId;
        private final PeerConnection physicalConnection;
        private final QoSManager qosManager;
        private volatile boolean closed = false;
        private volatile long bytesTransferred = 0L;
        private volatile long lastActivityTime = System.currentTimeMillis();
        private volatile QoSManager.Priority priority = QoSManager.Priority.NORMAL;

        public LogicalConnection(int connectionId, PeerConnection physicalConnection, QoSManager qosManager) {
            this.connectionId = connectionId;
            this.physicalConnection = physicalConnection;
            this.qosManager = qosManager;
        }

        public int getConnectionId() {
            return this.connectionId;
        }

        public long getBytesTransferred() {
            return this.bytesTransferred;
        }

        public long getLastActivityTime() {
            return this.lastActivityTime;
        }

        public QoSManager.Priority getPriority() {
            return this.priority;
        }

        public void setPriority(QoSManager.Priority priority) {
            this.priority = priority;
        }

        public void send(byte[] data) throws Exception {
            if (this.closed) {
                throw new IllegalStateException("Connection closed");
            }
            this.qosManager.waitToSend(data.length, this.priority);
            this.physicalConnection.sendStreamData(this.connectionId, data);
            this.bytesTransferred += (long)data.length;
            this.lastActivityTime = System.currentTimeMillis();
        }

        public boolean isIdle(long idleTimeoutMs) {
            return System.currentTimeMillis() - this.lastActivityTime > idleTimeoutMs;
        }

        public boolean isClosed() {
            return this.closed;
        }

        public void close() {
            this.closed = true;
        }
    }
}

