/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.tunnelyP2p.connection;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.security.GeneralSecurityException;
import java.security.MessageDigest;
import java.util.Arrays;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import org.texboobcat.tunnelyP2p.connection.PeerConnection;
import org.texboobcat.tunnelyP2p.crypto.CryptoManager;
import org.texboobcat.tunnelyP2p.crypto.KeyPairHolder;
import org.texboobcat.tunnelyP2p.crypto.SessionKeys;
import org.texboobcat.tunnelyP2p.protocol.AuthChallengeMessage;
import org.texboobcat.tunnelyP2p.protocol.AuthResponseMessage;
import org.texboobcat.tunnelyP2p.protocol.ErrorMessage;
import org.texboobcat.tunnelyP2p.protocol.HandshakeMessage;
import org.texboobcat.tunnelyP2p.protocol.ProtocolMessage;
import org.texboobcat.tunnelyP2p.protocol.StreamAckMessage;
import org.texboobcat.tunnelyP2p.protocol.StreamCloseMessage;
import org.texboobcat.tunnelyP2p.protocol.StreamDataMessage;
import org.texboobcat.tunnelyP2p.token.ConnectionToken;
import org.texboobcat.tunnelyP2p.token.TokenCodec;
import org.texboobcat.tunnelyP2p.util.Log;

public class LocalProxy
implements AutoCloseable {
    private final int localPort;
    private final ConnectionToken token;
    private final UUID clientPlayerUUID;
    private final String clientPlayerName;
    private ServerSocket localSocket;
    private PeerConnection peerConnection;
    private final AtomicBoolean running = new AtomicBoolean(false);
    private final ExecutorService executor = Executors.newCachedThreadPool();
    private final Map<Integer, LocalClientHandler> clientHandlers = new ConcurrentHashMap<Integer, LocalClientHandler>();
    private int nextConnectionId = 1;

    public LocalProxy(int localPort, String encodedToken, UUID clientPlayerUUID, String clientPlayerName) throws TokenCodec.TokenDecodeException {
        this.localPort = localPort;
        this.token = TokenCodec.decode(encodedToken);
        this.clientPlayerUUID = clientPlayerUUID;
        this.clientPlayerName = clientPlayerName;
    }

    public void start() throws IOException, GeneralSecurityException {
        if (this.running.compareAndSet(false, true)) {
            if (this.token.isExpired()) {
                throw new IOException("Connection token has expired");
            }
            this.connectToHost();
            this.localSocket = new ServerSocket(this.localPort, 50, InetAddress.getLoopbackAddress());
            Log.d("[Client] Local proxy listening on 127.0.0.1:" + this.localPort);
            this.executor.submit(this::acceptLoop);
        }
    }

    private void connectToHost() throws IOException, GeneralSecurityException {
        ConnectionToken.NATInfo natInfo = this.token.getNatInfo();
        Socket socket = null;
        IOException lastError = null;
        if (natInfo.hasPublicIPv6Endpoint()) {
            try {
                Log.d("[Client] Trying public IPv6 endpoint [" + natInfo.getPublicIPv6() + "]:" + natInfo.getPublicPortv6());
                socket = new Socket();
                socket.connect(new InetSocketAddress(natInfo.getPublicIPv6(), (int)natInfo.getPublicPortv6()), 5000);
                Log.d("[Client] Connected to public IPv6 endpoint (NAT bypass!)");
            }
            catch (IOException e) {
                Log.e("[Client] Public IPv6 endpoint failed: " + e.getMessage());
                lastError = e;
                socket = null;
            }
        }
        if (socket == null && natInfo.hasLocalIPv6Endpoint()) {
            try {
                Log.d("[Client] Trying local IPv6 endpoint [" + natInfo.getLocalIPv6() + "]:" + natInfo.getLocalPortv6());
                socket = new Socket();
                socket.connect(new InetSocketAddress(natInfo.getLocalIPv6(), (int)natInfo.getLocalPortv6()), 5000);
                Log.d("[Client] Connected to local IPv6 endpoint");
            }
            catch (IOException e) {
                Log.e("[Client] Local IPv6 endpoint failed: " + e.getMessage());
                lastError = e;
                socket = null;
            }
        }
        if (socket == null && natInfo.hasPublicEndpoint()) {
            try {
                Log.d("[Client] Trying public IPv4 endpoint " + natInfo.getPublicIP() + ":" + natInfo.getPublicPort());
                socket = new Socket();
                socket.connect(new InetSocketAddress(natInfo.getPublicIP(), (int)natInfo.getPublicPort()), 5000);
                Log.d("[Client] Connected to public IPv4 endpoint");
            }
            catch (IOException e) {
                Log.e("[Client] Public IPv4 endpoint failed: " + e.getMessage());
                lastError = e;
                socket = null;
            }
        }
        if (socket == null && natInfo.hasLocalEndpoint()) {
            try {
                Log.d("[Client] Trying local IPv4 endpoint " + natInfo.getLocalIP() + ":" + natInfo.getLocalPort());
                socket = new Socket();
                socket.connect(new InetSocketAddress(natInfo.getLocalIP(), (int)natInfo.getLocalPort()), 5000);
                Log.d("[Client] Connected to local IPv4 endpoint");
            }
            catch (IOException e) {
                Log.e("[Client] Local IPv4 endpoint failed: " + e.getMessage());
                lastError = e;
                socket = null;
            }
        }
        if (socket == null) {
            throw new IOException("Failed to connect to host: " + (lastError != null ? lastError.getMessage() : "No valid endpoints"));
        }
        this.performHandshake(socket);
    }

    private void performHandshake(Socket socket) throws IOException, GeneralSecurityException {
        DataInputStream input = new DataInputStream(socket.getInputStream());
        DataOutputStream output = new DataOutputStream(socket.getOutputStream());
        KeyPairHolder clientKeyPair = CryptoManager.generateKeyPair();
        String tokenStr = TokenCodec.encodeCanonical(this.token);
        byte[] tokenHash = MessageDigest.getInstance("SHA-256").digest(tokenStr.getBytes());
        Log.d("[Client] Handshake tokenHash sha256 len=" + tokenHash.length);
        HandshakeMessage handshake = new HandshakeMessage(1, this.token.getSessionId(), clientKeyPair.getPublicKeyBytes(), tokenHash, System.currentTimeMillis() / 1000L);
        byte[] handshakeData = handshake.serialize();
        output.writeInt(handshakeData.length);
        output.write(handshakeData);
        output.flush();
        int length = input.readInt();
        byte[] data = new byte[length];
        input.readFully(data);
        ProtocolMessage msg = ProtocolMessage.deserialize(data);
        if (msg instanceof ErrorMessage) {
            ErrorMessage error2 = (ErrorMessage)msg;
            throw new IOException("Handshake failed: " + error2.getErrorMessage());
        }
        if (!(msg instanceof AuthChallengeMessage)) {
            throw new IOException("Expected auth challenge, got: " + String.valueOf((Object)msg.getType()));
        }
        AuthChallengeMessage challenge = (AuthChallengeMessage)msg;
        byte[] sharedSecret = CryptoManager.performECDH(clientKeyPair.getPrivateKey().getEncoded(), this.token.getHostPublicKey());
        byte[] info = "TunnelyP2P-Session".getBytes();
        SessionKeys sessionKeys = CryptoManager.deriveSessionKeys(sharedSecret, challenge.getNonce(), info);
        Log.d("[Client] Derived session keys using salt(nonce) len=" + challenge.getNonce().length);
        byte[] encryptionNonce = CryptoManager.generateNonce();
        byte[] signedNonce = CryptoManager.encryptChaCha20Poly1305(sessionKeys.getRawEncryptionKey(), encryptionNonce, challenge.getNonce(), null);
        AuthResponseMessage authResponse = new AuthResponseMessage(signedNonce, encryptionNonce, this.clientPlayerUUID, this.clientPlayerName);
        byte[] authData = authResponse.serialize();
        output.writeInt(authData.length);
        output.write(authData);
        output.flush();
        this.peerConnection = new PeerConnection(socket, sessionKeys, this.token.getSessionId(), this.token.getHostPlayerUUID(), this.token.getHostPlayerName());
        this.peerConnection.setMessageHandler(this::handlePeerMessage);
        this.peerConnection.setErrorHandler(error -> {
            Log.e("Connection to host lost: " + error.getMessage());
            this.close();
        });
        clientKeyPair.clear();
        Log.d("Connected to host: " + this.token.getHostPlayerName());
    }

    private void acceptLoop() {
        block3: {
            try {
                while (this.running.get() && !this.localSocket.isClosed()) {
                    int connectionId;
                    Socket clientSocket = this.localSocket.accept();
                    ++this.nextConnectionId;
                    LocalClientHandler handler = new LocalClientHandler(connectionId, clientSocket);
                    Log.d("[Client] Accepted local client connection id=" + connectionId);
                    this.clientHandlers.put(connectionId, handler);
                    this.executor.submit(handler::start);
                }
            }
            catch (IOException e) {
                if (!this.running.get()) break block3;
                Log.e("[Client] acceptLoop error: " + e.getMessage(), e);
            }
        }
    }

    private void handlePeerMessage(ProtocolMessage message) {
        try {
            StreamCloseMessage closeMsg;
            LocalClientHandler handler;
            if (message instanceof StreamDataMessage) {
                StreamDataMessage dataMsg = (StreamDataMessage)message;
                byte[] decrypted = CryptoManager.decryptChaCha20Poly1305(this.peerConnection.getSessionKeys().getRawEncryptionKey(), dataMsg.getNonce(), dataMsg.getEncryptedPayload(), null);
                LocalClientHandler handler2 = this.clientHandlers.get(dataMsg.getConnectionId());
                if (handler2 != null) {
                    handler2.sendToClient(decrypted);
                }
                this.peerConnection.sendMessage(new StreamAckMessage(dataMsg.getConnectionId(), dataMsg.getSequenceNumber()));
            } else if (message instanceof StreamCloseMessage && (handler = this.clientHandlers.remove((closeMsg = (StreamCloseMessage)message).getConnectionId())) != null) {
                handler.close();
            }
        }
        catch (Exception e) {
            Log.e("[LocalProxy] handlePeerMessage error: " + e.getMessage(), e);
        }
    }

    public int getLocalPort() {
        return this.localPort;
    }

    public boolean isConnected() {
        return this.peerConnection != null && this.peerConnection.isAlive();
    }

    public PeerConnection getPeerConnection() {
        return this.peerConnection;
    }

    @Override
    public void close() {
        if (this.running.compareAndSet(true, false)) {
            try {
                if (this.localSocket != null) {
                    this.localSocket.close();
                }
                if (this.peerConnection != null) {
                    this.peerConnection.close();
                }
                this.clientHandlers.values().forEach(LocalClientHandler::close);
                this.clientHandlers.clear();
                this.executor.shutdown();
            }
            catch (IOException e) {
                Log.e("[LocalProxy] close error: " + e.getMessage(), e);
            }
        }
    }

    private class LocalClientHandler
    implements AutoCloseable {
        private final int connectionId;
        private final Socket clientSocket;
        private DataOutputStream clientOutput;
        private final ExecutorService handlerExecutor = Executors.newSingleThreadExecutor();
        private final ExecutorService writeExecutor = Executors.newSingleThreadExecutor();
        private final BlockingQueue<byte[]> writeQueue = new LinkedBlockingQueue<byte[]>();

        public LocalClientHandler(int connectionId, Socket clientSocket) {
            this.connectionId = connectionId;
            this.clientSocket = clientSocket;
        }

        public void start() {
            try {
                try {
                    this.clientSocket.setTcpNoDelay(true);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.clientOutput = new DataOutputStream(this.clientSocket.getOutputStream());
                this.handlerExecutor.submit(this::readFromClient);
                this.writeExecutor.submit(this::writeToClientLoop);
            }
            catch (IOException e) {
                Log.e("[LocalProxy] start handler error: " + e.getMessage(), e);
                this.close();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void readFromClient() {
            try {
                int bytesRead;
                InputStream input = this.clientSocket.getInputStream();
                byte[] buffer = new byte[8192];
                while ((bytesRead = input.read(buffer)) != -1) {
                    byte[] data = Arrays.copyOf(buffer, bytesRead);
                    Log.d("[LocalProxy] C->P " + bytesRead + " bytes (connId=" + this.connectionId + ")");
                    LocalProxy.this.peerConnection.sendStreamData(this.connectionId, data);
                }
            }
            catch (Exception exception) {
            }
            finally {
                try {
                    LocalProxy.this.peerConnection.sendMessage(new StreamCloseMessage(this.connectionId, "Client disconnected"));
                }
                catch (IOException iOException) {}
                this.close();
            }
        }

        public void sendToClient(byte[] data) throws IOException {
            this.writeQueue.offer(data);
        }

        private void writeToClientLoop() {
            try {
                while (!this.clientSocket.isClosed()) {
                    byte[] chunk = this.writeQueue.take();
                    if (this.clientOutput == null) continue;
                    this.clientOutput.write(chunk);
                    this.clientOutput.flush();
                    Log.d("[LocalProxy] P->C " + chunk.length + " bytes (connId=" + this.connectionId + ")");
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        @Override
        public void close() {
            try {
                this.handlerExecutor.shutdown();
                this.writeExecutor.shutdown();
                if (this.clientSocket != null) {
                    this.clientSocket.close();
                }
            }
            catch (IOException e) {
                Log.e("[LocalProxy] handler close error: " + e.getMessage(), e);
            }
        }
    }
}

