/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.tunnelyP2p.crypto;

import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Security;
import java.util.Arrays;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.bouncycastle.crypto.agreement.X25519Agreement;
import org.bouncycastle.crypto.digests.SHA256Digest;
import org.bouncycastle.crypto.generators.HKDFBytesGenerator;
import org.bouncycastle.crypto.params.HKDFParameters;
import org.bouncycastle.crypto.params.X25519PrivateKeyParameters;
import org.bouncycastle.crypto.params.X25519PublicKeyParameters;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.texboobcat.tunnelyP2p.crypto.KeyPairHolder;
import org.texboobcat.tunnelyP2p.crypto.SessionKeys;
import org.texboobcat.tunnelyP2p.util.Log;

public class CryptoManager {
    private static final String PROVIDER = "BC";
    private static final int X25519_KEY_SIZE = 32;
    private static final int CHACHA20_KEY_SIZE = 32;
    private static final int CHACHA20_NONCE_SIZE = 12;
    private static final int POLY1305_TAG_SIZE = 16;
    private static volatile boolean initialized = false;

    public static synchronized void initialize() {
        if (!initialized) {
            try {
                Security.addProvider(new BouncyCastleProvider());
                Log.d("[Crypto] BouncyCastle provider added: " + (Security.getProvider(PROVIDER) != null));
                initialized = true;
            }
            catch (NoClassDefFoundError e) {
                Log.e("[Crypto] FATAL: BouncyCastle provider not found! Dependencies missing.");
                Log.e("[Crypto] Error: " + e.getMessage());
                Log.e("[Crypto] Crypto features will not work. Check mod installation.");
            }
            catch (Exception e) {
                Log.e("[Crypto] Failed to initialize BouncyCastle: " + e.getMessage());
                e.printStackTrace();
            }
        }
    }

    public static KeyPairHolder generateKeyPair() throws GeneralSecurityException {
        CryptoManager.initialize();
        SecureRandom random = new SecureRandom();
        byte[] privateKeyBytes = new byte[32];
        random.nextBytes(privateKeyBytes);
        final X25519PrivateKeyParameters privateKey = new X25519PrivateKeyParameters(privateKeyBytes, 0);
        final X25519PublicKeyParameters publicKey = privateKey.generatePublicKey();
        byte[] publicKeyBytes = publicKey.getEncoded();
        PrivateKey privKey = new PrivateKey(){

            @Override
            public String getAlgorithm() {
                return "X25519";
            }

            @Override
            public String getFormat() {
                return "RAW";
            }

            @Override
            public byte[] getEncoded() {
                return privateKey.getEncoded();
            }
        };
        PublicKey pubKey = new PublicKey(){

            @Override
            public String getAlgorithm() {
                return "X25519";
            }

            @Override
            public String getFormat() {
                return "RAW";
            }

            @Override
            public byte[] getEncoded() {
                return publicKey.getEncoded();
            }
        };
        return new KeyPairHolder(privKey, pubKey, publicKeyBytes);
    }

    public static byte[] performECDH(byte[] privateKeyBytes, byte[] peerPublicKeyBytes) throws GeneralSecurityException {
        CryptoManager.initialize();
        if (privateKeyBytes.length != 32) {
            throw new IllegalArgumentException("Invalid private key size");
        }
        if (peerPublicKeyBytes.length != 32) {
            throw new IllegalArgumentException("Invalid public key size");
        }
        X25519PrivateKeyParameters privateKey = new X25519PrivateKeyParameters(privateKeyBytes, 0);
        X25519PublicKeyParameters publicKey = new X25519PublicKeyParameters(peerPublicKeyBytes, 0);
        X25519Agreement agreement = new X25519Agreement();
        agreement.init(privateKey);
        byte[] sharedSecret = new byte[32];
        agreement.calculateAgreement(publicKey, sharedSecret, 0);
        return sharedSecret;
    }

    public static SessionKeys deriveSessionKeys(byte[] sharedSecret, byte[] salt, byte[] info) {
        CryptoManager.initialize();
        HKDFBytesGenerator hkdf = new HKDFBytesGenerator(new SHA256Digest());
        HKDFParameters params = new HKDFParameters(sharedSecret, salt, info);
        hkdf.init(params);
        byte[] derivedKey = new byte[64];
        hkdf.generateBytes(derivedKey, 0, derivedKey.length);
        byte[] encryptionKey = Arrays.copyOfRange(derivedKey, 0, 32);
        byte[] authKey = Arrays.copyOfRange(derivedKey, 32, 64);
        Arrays.fill(derivedKey, (byte)0);
        return new SessionKeys(encryptionKey, authKey);
    }

    public static byte[] encryptChaCha20Poly1305(byte[] key, byte[] nonce, byte[] plaintext, byte[] associatedData) throws GeneralSecurityException {
        CryptoManager.initialize();
        if (key.length != 32) {
            throw new IllegalArgumentException("Invalid key size");
        }
        if (nonce.length != 12) {
            throw new IllegalArgumentException("Invalid nonce size");
        }
        try {
            Cipher cipher;
            try {
                cipher = Cipher.getInstance("ChaCha20-Poly1305/None/NoPadding", PROVIDER);
                Log.d("[Crypto] Using transformation ChaCha20-Poly1305/None/NoPadding");
            }
            catch (Exception primaryErr) {
                cipher = Cipher.getInstance("ChaCha20-Poly1305", PROVIDER);
                Log.d("[Crypto] Fallback transformation ChaCha20-Poly1305");
            }
            SecretKeySpec keySpec = new SecretKeySpec(key, "ChaCha20");
            IvParameterSpec ivSpec = new IvParameterSpec(nonce);
            cipher.init(1, (Key)keySpec, ivSpec);
            if (associatedData != null && associatedData.length > 0) {
                cipher.updateAAD(associatedData);
            }
            byte[] out = cipher.doFinal(plaintext);
            Log.d(String.format("[Crypto] Encrypt ok: in=%d out=%d nonce=%s", plaintext != null ? plaintext.length : 0, out != null ? out.length : -1, CryptoManager.toHex(nonce, 12)));
            return out;
        }
        catch (Exception e) {
            Log.e(String.format("[Crypto] Encrypt failed: %s - %s (nonce=%s, inLen=%d)", e.getClass().getSimpleName(), e.getMessage(), CryptoManager.toHex(nonce, 12), plaintext != null ? plaintext.length : -1));
            throw new GeneralSecurityException("Encryption failed", e);
        }
    }

    public static byte[] decryptChaCha20Poly1305(byte[] key, byte[] nonce, byte[] ciphertext, byte[] associatedData) throws GeneralSecurityException {
        CryptoManager.initialize();
        if (key.length != 32) {
            throw new IllegalArgumentException("Invalid key size");
        }
        if (nonce.length != 12) {
            throw new IllegalArgumentException("Invalid nonce size");
        }
        try {
            Cipher cipher;
            try {
                cipher = Cipher.getInstance("ChaCha20-Poly1305/None/NoPadding", PROVIDER);
                Log.d("[Crypto] Using transformation ChaCha20-Poly1305/None/NoPadding");
            }
            catch (Exception primaryErr) {
                cipher = Cipher.getInstance("ChaCha20-Poly1305", PROVIDER);
                Log.d("[Crypto] Fallback transformation ChaCha20-Poly1305");
            }
            SecretKeySpec keySpec = new SecretKeySpec(key, "ChaCha20");
            IvParameterSpec ivSpec = new IvParameterSpec(nonce);
            cipher.init(2, (Key)keySpec, ivSpec);
            if (associatedData != null && associatedData.length > 0) {
                cipher.updateAAD(associatedData);
            }
            byte[] out = cipher.doFinal(ciphertext);
            Log.d(String.format("[Crypto] Decrypt ok: in=%d out=%d nonce=%s", ciphertext != null ? ciphertext.length : 0, out != null ? out.length : -1, CryptoManager.toHex(nonce, 12)));
            return out;
        }
        catch (Exception e) {
            Log.e(String.format("[Crypto] Decrypt failed: %s - %s (nonce=%s, inLen=%d)", e.getClass().getSimpleName(), e.getMessage(), CryptoManager.toHex(nonce, 12), ciphertext != null ? ciphertext.length : -1));
            throw new GeneralSecurityException("Decryption failed - authentication error or corrupted data", e);
        }
    }

    public static byte[] generateNonce() {
        SecureRandom random = new SecureRandom();
        byte[] nonce = new byte[12];
        random.nextBytes(nonce);
        return nonce;
    }

    public static byte[] generateSalt(int size) {
        SecureRandom random = new SecureRandom();
        byte[] salt = new byte[size];
        random.nextBytes(salt);
        return salt;
    }

    private static String toHex(byte[] b, int max) {
        if (b == null) {
            return "null";
        }
        int n = Math.min(b.length, max);
        StringBuilder sb = new StringBuilder(n * 2);
        for (int i = 0; i < n; ++i) {
            sb.append(String.format("%02x", b[i]));
        }
        if (b.length > max) {
            sb.append("...");
        }
        return sb.toString();
    }
}

