/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.tunnelyP2p.crypto;

import java.util.Arrays;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;

public class SessionKeys {
    private final SecretKey encryptionKey;
    private final SecretKey authKey;
    private final byte[] rawEncryptionKey;
    private final byte[] rawAuthKey;

    public SessionKeys(byte[] encryptionKeyBytes, byte[] authKeyBytes) {
        this.rawEncryptionKey = Arrays.copyOf(encryptionKeyBytes, encryptionKeyBytes.length);
        this.rawAuthKey = Arrays.copyOf(authKeyBytes, authKeyBytes.length);
        this.encryptionKey = new SecretKeySpec(encryptionKeyBytes, "ChaCha20");
        this.authKey = new SecretKeySpec(authKeyBytes, "HmacSHA256");
    }

    public SecretKey getEncryptionKey() {
        return this.encryptionKey;
    }

    public SecretKey getAuthKey() {
        return this.authKey;
    }

    public byte[] getRawEncryptionKey() {
        return Arrays.copyOf(this.rawEncryptionKey, this.rawEncryptionKey.length);
    }

    public byte[] getRawAuthKey() {
        return Arrays.copyOf(this.rawAuthKey, this.rawAuthKey.length);
    }

    public void clear() {
        Arrays.fill(this.rawEncryptionKey, (byte)0);
        Arrays.fill(this.rawAuthKey, (byte)0);
    }
}

