/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.tunnelyP2p.diagnostics;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.MulticastSocket;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.ArrayList;
import java.util.List;
import org.texboobcat.tunnelyP2p.nat.NATTraversal;
import org.texboobcat.tunnelyP2p.nat.StunClient;

public class NetworkDiagnostics {
    public static DiagnosticReport runDiagnostics() {
        DiagnosticReport report = new DiagnosticReport();
        report.localIP = NATTraversal.getLocalIP();
        report.hasLocalNetwork = report.localIP != null && !report.localIP.equals("127.0.0.1");
        report.localIPv6 = NATTraversal.getLocalIPv6();
        report.hasLocalIPv6 = report.localIPv6 != null;
        report.hasInternet = NetworkDiagnostics.checkInternetConnectivity();
        report.hasIPv6Internet = NATTraversal.hasIPv6Connectivity();
        report.publicIP = NATTraversal.getPublicIP();
        boolean bl = report.hasPublicIP = report.publicIP != null;
        if (report.hasIPv6Internet) {
            report.publicIPv6 = NATTraversal.getPublicIPv6();
            report.hasPublicIPv6 = report.publicIPv6 != null;
        }
        try {
            StunClient.NatDiagnosis diag = StunClient.diagnoseParallel();
            if (diag != null) {
                report.natType = diag.type;
                if (diag.mapping != null) {
                    report.mappedPublicIP = diag.mapping.publicIP;
                    report.mappedPublicPort = diag.mapping.publicPort;
                    if (!report.hasPublicIP && report.mappedPublicIP != null) {
                        report.publicIP = report.mappedPublicIP;
                        report.hasPublicIP = true;
                    }
                }
                report.stunMappingVaries = diag.mappingVariesAcrossServers;
                report.stunPortPreserving = diag.portPreserving;
                report.natReason = diag.reason;
                report.stunOk = true;
                report.stunSuccessful = diag.successfulProbes;
                report.stunTotal = diag.totalProbes;
                report.stunReliability = diag.getReliabilityScore();
                if (diag.allMappings != null) {
                    report.stunMappings = new ArrayList<StunClient.Mapping>(diag.allMappings);
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (report.natType == null) {
            report.natType = NATTraversal.detectNATType();
        }
        report.behindNAT = report.hasPublicIP && report.hasLocalNetwork && !report.publicIP.equals(report.localIP);
        report.upnpAvailable = NetworkDiagnostics.checkUPnPAvailability();
        report.firewallDetected = NetworkDiagnostics.checkFirewall();
        report.availablePorts = NetworkDiagnostics.findAvailablePorts(25565, 25600);
        return report;
    }

    private static boolean checkInternetConnectivity() {
        String[] testHosts;
        for (String host : testHosts = new String[]{"8.8.8.8", "1.1.1.1", "208.67.222.222"}) {
            try {
                InetAddress address = InetAddress.getByName(host);
                if (!address.isReachable(3000)) continue;
                return true;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return false;
    }

    private static boolean checkUPnPAvailability() {
        try {
            MulticastSocket socket = new MulticastSocket();
            socket.setSoTimeout(1000);
            socket.close();
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    private static boolean checkFirewall() {
        boolean bl;
        ServerSocket socket = new ServerSocket(0);
        try {
            bl = false;
        }
        catch (Throwable throwable) {
            try {
                try {
                    socket.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                return true;
            }
        }
        socket.close();
        return bl;
    }

    private static List<Integer> findAvailablePorts(int start, int end) {
        ArrayList<Integer> available = new ArrayList<Integer>();
        for (int port = start; port <= end && available.size() < 5; ++port) {
            if (!NetworkDiagnostics.isPortAvailable(port)) continue;
            available.add(port);
        }
        return available;
    }

    private static boolean isPortAvailable(int port) {
        boolean bl;
        ServerSocket socket = new ServerSocket(port);
        try {
            bl = true;
        }
        catch (Throwable throwable) {
            try {
                try {
                    socket.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                return false;
            }
        }
        socket.close();
        return bl;
    }

    public static ConnectionTestResult testConnection(String host, int port, boolean useTCP) {
        ConnectionTestResult result = new ConnectionTestResult();
        result.host = host;
        result.port = port;
        result.protocol = useTCP ? "TCP" : "UDP";
        long startTime = System.currentTimeMillis();
        if (useTCP) {
            try (Socket socket = new Socket();){
                socket.connect(new InetSocketAddress(host, port), 5000);
                result.success = true;
                result.latency = System.currentTimeMillis() - startTime;
            }
            catch (IOException e) {
                result.success = false;
                result.error = e.getMessage();
            }
        } else {
            try (DatagramSocket socket = new DatagramSocket();){
                socket.setSoTimeout(5000);
                byte[] sendData = "PING".getBytes();
                DatagramPacket sendPacket = new DatagramPacket(sendData, sendData.length, InetAddress.getByName(host), port);
                socket.send(sendPacket);
                byte[] receiveData = new byte[1024];
                DatagramPacket receivePacket = new DatagramPacket(receiveData, receiveData.length);
                socket.receive(receivePacket);
                result.success = true;
                result.latency = System.currentTimeMillis() - startTime;
            }
            catch (IOException e) {
                result.success = false;
                result.error = e.getMessage();
            }
        }
        return result;
    }

    public static class DiagnosticReport {
        public String localIP;
        public String publicIP;
        public String localIPv6;
        public String publicIPv6;
        public boolean hasLocalNetwork;
        public boolean hasLocalIPv6;
        public boolean hasInternet;
        public boolean hasIPv6Internet;
        public boolean hasPublicIP;
        public boolean hasPublicIPv6;
        public boolean behindNAT;
        public NATTraversal.NATType natType;
        public boolean stunOk;
        public String mappedPublicIP;
        public int mappedPublicPort;
        public boolean stunMappingVaries;
        public boolean stunPortPreserving;
        public String natReason;
        public int stunSuccessful;
        public int stunTotal;
        public double stunReliability;
        public List<StunClient.Mapping> stunMappings = new ArrayList<StunClient.Mapping>();
        public boolean upnpAvailable;
        public boolean firewallDetected;
        public List<Integer> availablePorts;

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("=== Network Diagnostics ===\n");
            sb.append("Local IPv4: ").append(this.localIP).append("\n");
            sb.append("Public IPv4: ").append(this.publicIP != null ? this.publicIP : "Unknown").append("\n");
            sb.append("Local IPv6: ").append(this.localIPv6 != null ? this.localIPv6 : "Not available").append("\n");
            sb.append("Public IPv6: ").append(this.publicIPv6 != null ? this.publicIPv6 : "Not available").append("\n");
            sb.append("Internet (IPv4): ").append(this.hasInternet ? "\u2713 Connected" : "\u2717 No connection").append("\n");
            sb.append("Internet (IPv6): ").append(this.hasIPv6Internet ? "\u2713 Connected" : "\u2717 No connection").append("\n");
            if (this.hasPublicIPv6) {
                sb.append("\u26a1 IPv6 Available: NAT bypass possible!\n");
            }
            sb.append("NAT: ").append((String)(this.behindNAT ? "\u2713 Behind NAT (" + this.natType.getDescription() + ")" : "\u2717 Direct")).append("\n");
            if (this.stunOk && this.mappedPublicIP != null) {
                sb.append("STUN Mapping: ").append(this.mappedPublicIP).append(":").append(this.mappedPublicPort).append("\n");
                sb.append("Port-preserving: ").append(this.stunPortPreserving ? "Yes" : "No").append("\n");
                sb.append("Varies across servers: ").append(this.stunMappingVaries ? "Yes" : "No").append("\n");
                if (this.natReason != null) {
                    sb.append("NAT Reason: ").append(this.natReason).append("\n");
                }
                sb.append("STUN Reachability: ").append(this.stunSuccessful).append("/").append(this.stunTotal).append(" (").append((int)(this.stunReliability * 100.0)).append("%)\n");
                if (!this.stunMappings.isEmpty()) {
                    sb.append("All STUN mappings: ");
                    for (int i = 0; i < this.stunMappings.size(); ++i) {
                        sb.append(this.stunMappings.get(i));
                        if (i + 1 >= this.stunMappings.size()) continue;
                        sb.append(", ");
                    }
                    sb.append("\n");
                }
            }
            sb.append("UPnP: ").append(this.upnpAvailable ? "\u2713 Available" : "\u2717 Not available").append("\n");
            sb.append("Firewall: ").append(this.firewallDetected ? "\u26a0 Detected" : "\u2713 None detected").append("\n");
            sb.append("Available ports: ").append(this.availablePorts).append("\n");
            return sb.toString();
        }

        public String getRecommendation() {
            if (!this.hasInternet) {
                return "No internet connection detected. Check your network settings.";
            }
            if (this.hasPublicIPv6) {
                return "\u2713 IPv6 available! Direct P2P connections will work without port forwarding or NAT traversal.";
            }
            if (this.natType == NATTraversal.NATType.SYMMETRIC) {
                return "Symmetric NAT detected. P2P punching is unlikely. Consider enabling IPv6 on your network, use UPnP/manual port forwarding, or use regular Tunnely with relay servers.";
            }
            if (this.behindNAT && !this.upnpAvailable && !this.stunPortPreserving) {
                return "Behind NAT without UPnP. Manual port forwarding required.";
            }
            if (this.behindNAT && this.stunPortPreserving) {
                if (this.stunReliability >= 0.5) {
                    return "Behind NAT but port-preserving, and STUN reachable. UDP/TCP hole punching is likely to work.";
                }
                return "Behind NAT but port-preserving. STUN reachability is low; punching may work but UPnP/manual forward is safer.";
            }
            if (this.firewallDetected) {
                return "Firewall detected. May need to allow the application through firewall.";
            }
            return "Network configuration looks good for P2P connections.";
        }
    }

    public static class ConnectionTestResult {
        public String host;
        public int port;
        public String protocol;
        public boolean success;
        public long latency;
        public String error;

        public String toString() {
            if (this.success) {
                return String.format("%s connection to %s:%d successful (latency: %dms)", this.protocol, this.host, this.port, this.latency);
            }
            return String.format("%s connection to %s:%d failed: %s", this.protocol, this.host, this.port, this.error);
        }
    }
}

