/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.tunnelyP2p.gui;

import java.util.ArrayList;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import org.texboobcat.tunnelyP2p.diagnostics.NetworkDiagnostics;

public class DiagnosticsScreen
extends class_437 {
    private final class_437 parent;
    private NetworkDiagnostics.DiagnosticReport report;
    private boolean isLoading = true;
    private class_4185 closeButton;
    private class_4185 refreshButton;
    private int scrollOffset = 0;
    private int maxScroll = 0;
    private int contentHeight = 0;
    private static final int TOP_MARGIN = 35;
    private static final int BOTTOM_MARGIN = 45;

    public DiagnosticsScreen(class_437 parent) {
        super((class_2561)class_2561.method_43470((String)"Network Diagnostics"));
        this.parent = parent;
    }

    protected void method_25426() {
        super.method_25426();
        int buttonWidth = 100;
        int buttonHeight = 20;
        int buttonSpacing = 5;
        this.closeButton = class_4185.method_46430((class_2561)class_2561.method_43470((String)"Close"), button -> this.method_25419()).method_46434(this.field_22789 / 2 - buttonWidth - buttonSpacing, this.field_22790 - 30, buttonWidth, buttonHeight).method_46431();
        this.method_37063((class_364)this.closeButton);
        this.refreshButton = class_4185.method_46430((class_2561)class_2561.method_43470((String)"\u00a76Refresh"), button -> this.runDiagnostics()).method_46434(this.field_22789 / 2 + buttonSpacing, this.field_22790 - 30, buttonWidth, buttonHeight).method_46431();
        this.method_37063((class_364)this.refreshButton);
        if (this.isLoading) {
            this.runDiagnostics();
        }
    }

    private void runDiagnostics() {
        this.isLoading = true;
        this.scrollOffset = 0;
        new Thread(() -> {
            NetworkDiagnostics.DiagnosticReport newReport = NetworkDiagnostics.runDiagnostics();
            this.field_22787.execute(() -> {
                this.report = newReport;
                this.isLoading = false;
            });
        }).start();
    }

    public void method_25394(class_332 graphics, int mouseX, int mouseY, float partialTick) {
        this.method_25420(graphics);
        int centerX = this.field_22789 / 2;
        int lineHeight = 11;
        int startY = 20;
        graphics.method_25300(this.field_22793, "\u00a7b\u00a7lNetwork Diagnostics", centerX, startY, 0xFFFFFF);
        if (this.isLoading) {
            graphics.method_25300(this.field_22793, "\u00a7eRunning diagnostics...", centerX, startY + 40, 0xFFFFFF);
            graphics.method_25300(this.field_22793, "\u00a77This may take a few seconds", centerX, startY + 52, 0xAAAAAA);
            super.method_25394(graphics, mouseX, mouseY, partialTick);
            return;
        }
        if (this.report == null) {
            graphics.method_25300(this.field_22793, "\u00a7cFailed to run diagnostics", centerX, startY + 40, 0xFF5555);
            super.method_25394(graphics, mouseX, mouseY, partialTick);
            return;
        }
        int viewportTop = 35;
        int viewportBottom = this.field_22790 - 45;
        int viewportHeight = viewportBottom - viewportTop;
        graphics.method_44379(0, viewportTop, this.field_22789, viewportBottom);
        int actualStartY = viewportTop - this.scrollOffset;
        this.contentHeight = this.renderDiagnostics(graphics, centerX, actualStartY, lineHeight);
        graphics.method_44380();
        this.maxScroll = Math.max(0, this.contentHeight - viewportHeight + 20);
        this.scrollOffset = Math.max(0, Math.min(this.scrollOffset, this.maxScroll));
        if (this.maxScroll > 0) {
            this.renderScrollIndicators(graphics, viewportTop, viewportBottom);
        }
        super.method_25394(graphics, mouseX, mouseY, partialTick);
    }

    private int renderDiagnostics(class_332 graphics, int centerX, int startY, int lineHeight) {
        String[] lines;
        int y = startY;
        int leftCol = centerX - 180;
        graphics.method_25303(this.field_22793, "\u00a7e\u00a7lIP Information", leftCol, y, 0xFFFFFF);
        graphics.method_25303(this.field_22793, "\u00a77Local IPv4:", leftCol, y += lineHeight + 2, 0xAAAAAA);
        graphics.method_25303(this.field_22793, "\u00a7f" + (this.report.localIP != null ? this.report.localIP : "Unknown"), leftCol + 100, y, 0xFFFFFF);
        graphics.method_25303(this.field_22793, "\u00a77Public IPv4:", leftCol, y += lineHeight, 0xAAAAAA);
        graphics.method_25303(this.field_22793, "\u00a7f" + (this.report.publicIP != null ? this.report.publicIP : "Unknown"), leftCol + 100, y, 0xFFFFFF);
        graphics.method_25303(this.field_22793, "\u00a77Local IPv6:", leftCol, y += lineHeight, 0xAAAAAA);
        String ipv6Display = this.report.localIPv6 != null ? this.truncateIPv6(this.report.localIPv6) : "Not available";
        graphics.method_25303(this.field_22793, "\u00a7f" + ipv6Display, leftCol + 100, y, 0xFFFFFF);
        graphics.method_25303(this.field_22793, "\u00a77Public IPv6:", leftCol, y += lineHeight, 0xAAAAAA);
        String pubIPv6Display = this.report.publicIPv6 != null ? this.truncateIPv6(this.report.publicIPv6) : "Not available";
        graphics.method_25303(this.field_22793, "\u00a7f" + pubIPv6Display, leftCol + 100, y, 0xFFFFFF);
        y += lineHeight + 4;
        if (this.report.hasPublicIPv6) {
            graphics.method_25303(this.field_22793, "\u00a7a\u26a1 IPv6 Available - NAT bypass possible!", leftCol, y, 0x55FF55);
            y += lineHeight + 2;
        }
        graphics.method_25303(this.field_22793, "\u00a7e\u00a7lConnectivity", leftCol, y += 2, 0xFFFFFF);
        graphics.method_25303(this.field_22793, "\u00a77Internet (IPv4):", leftCol, y += lineHeight + 2, 0xAAAAAA);
        String inet4 = this.report.hasInternet ? "\u00a7a\u2713 Connected" : "\u00a7c\u2717 No connection";
        graphics.method_25303(this.field_22793, inet4, leftCol + 100, y, 0xFFFFFF);
        graphics.method_25303(this.field_22793, "\u00a77Internet (IPv6):", leftCol, y += lineHeight, 0xAAAAAA);
        String inet6 = this.report.hasIPv6Internet ? "\u00a7a\u2713 Connected" : "\u00a7c\u2717 No connection";
        graphics.method_25303(this.field_22793, inet6, leftCol + 100, y, 0xFFFFFF);
        graphics.method_25303(this.field_22793, "\u00a7e\u00a7lNAT & Firewall", leftCol, y += lineHeight + 4, 0xFFFFFF);
        graphics.method_25303(this.field_22793, "\u00a77NAT Type:", leftCol, y += lineHeight + 2, 0xAAAAAA);
        String natStatus = this.report.behindNAT ? "\u00a7e\u26a0 Behind NAT" : "\u00a7a\u2713 Direct";
        graphics.method_25303(this.field_22793, natStatus, leftCol + 100, y, 0xFFFFFF);
        y += lineHeight;
        if (this.report.natType != null) {
            graphics.method_25303(this.field_22793, "\u00a77NAT Category:", leftCol, y, 0xAAAAAA);
            graphics.method_25303(this.field_22793, "\u00a7f" + this.report.natType.getDescription(), leftCol + 100, y, 0xFFFFFF);
            y += lineHeight;
        }
        if (this.report.stunOk && this.report.mappedPublicIP != null) {
            graphics.method_25303(this.field_22793, "\u00a77STUN Mapping:", leftCol, y, 0xAAAAAA);
            graphics.method_25303(this.field_22793, "\u00a7f" + this.report.mappedPublicIP + ":" + this.report.mappedPublicPort, leftCol + 100, y, 0xFFFFFF);
            graphics.method_25303(this.field_22793, "\u00a77Port Preserving:", leftCol, y += lineHeight, 0xAAAAAA);
            graphics.method_25303(this.field_22793, this.report.stunPortPreserving ? "\u00a7aYes" : "\u00a7cNo", leftCol + 100, y, 0xFFFFFF);
            graphics.method_25303(this.field_22793, "\u00a77Varies Across Servers:", leftCol, y += lineHeight, 0xAAAAAA);
            graphics.method_25303(this.field_22793, this.report.stunMappingVaries ? "\u00a7eYes" : "\u00a7aNo", leftCol + 100, y, 0xFFFFFF);
            graphics.method_25303(this.field_22793, "\u00a77STUN Reachability:", leftCol, y += lineHeight, 0xAAAAAA);
            String reliability = String.format("%d/%d (%.0f%%)", this.report.stunSuccessful, this.report.stunTotal, this.report.stunReliability * 100.0);
            graphics.method_25303(this.field_22793, "\u00a7f" + reliability, leftCol + 100, y, 0xFFFFFF);
            y += lineHeight;
        } else if (this.report.behindNAT) {
            graphics.method_25303(this.field_22793, "\u00a77STUN:", leftCol, y, 0xAAAAAA);
            graphics.method_25303(this.field_22793, "\u00a7cNo response (UDP blocked?)", leftCol + 100, y, 0xFF5555);
            y += lineHeight;
        }
        graphics.method_25303(this.field_22793, "\u00a77UPnP:", leftCol, y, 0xAAAAAA);
        String upnp = this.report.upnpAvailable ? "\u00a7a\u2713 Available" : "\u00a7c\u2717 Not available";
        graphics.method_25303(this.field_22793, upnp, leftCol + 100, y, 0xFFFFFF);
        graphics.method_25303(this.field_22793, "\u00a77Firewall:", leftCol, y += lineHeight, 0xAAAAAA);
        String firewall = this.report.firewallDetected ? "\u00a7e\u26a0 Detected" : "\u00a7a\u2713 None detected";
        graphics.method_25303(this.field_22793, firewall, leftCol + 100, y, 0xFFFFFF);
        y += lineHeight + 4;
        if (!this.report.availablePorts.isEmpty()) {
            graphics.method_25303(this.field_22793, "\u00a77Available Ports:", leftCol, y, 0xAAAAAA);
            StringBuilder ports = new StringBuilder();
            for (int i = 0; i < Math.min(5, this.report.availablePorts.size()); ++i) {
                if (i > 0) {
                    ports.append(", ");
                }
                ports.append(this.report.availablePorts.get(i));
            }
            graphics.method_25303(this.field_22793, "\u00a7f" + ports.toString(), leftCol + 100, y, 0xFFFFFF);
            y += lineHeight + 4;
        }
        graphics.method_25303(this.field_22793, "\u00a76\u00a7lRecommendation", leftCol, y += 4, 0xFFFFFF);
        y += lineHeight + 2;
        String recommendation = this.report.getRecommendation();
        for (String line : lines = this.wrapText(recommendation, 50)) {
            graphics.method_25303(this.field_22793, "\u00a77" + line, leftCol, y, 0xAAAAAA);
            y += lineHeight;
        }
        return y - startY;
    }

    private String truncateIPv6(String ipv6) {
        if (ipv6.length() > 35) {
            return ipv6.substring(0, 32) + "...";
        }
        return ipv6;
    }

    private String[] wrapText(String text, int maxLength) {
        if (text.length() <= maxLength) {
            return new String[]{text};
        }
        String[] words = text.split(" ");
        StringBuilder current = new StringBuilder();
        ArrayList<String> lines = new ArrayList<String>();
        for (String word : words) {
            if (current.length() + word.length() + 1 <= maxLength) {
                if (current.length() > 0) {
                    current.append(" ");
                }
                current.append(word);
                continue;
            }
            if (current.length() > 0) {
                lines.add(current.toString());
                current = new StringBuilder(word);
                continue;
            }
            lines.add(word);
        }
        if (current.length() > 0) {
            lines.add(current.toString());
        }
        return lines.toArray(new String[0]);
    }

    private void renderScrollIndicators(class_332 graphics, int viewportTop, int viewportBottom) {
        int centerX = this.field_22789 / 2;
        int indicatorWidth = 200;
        if (this.scrollOffset > 0) {
            graphics.method_25300(this.field_22793, "\u00a77\u25b2 Scroll up for more", centerX, viewportTop + 2, 0xAAAAAA);
        }
        if (this.scrollOffset < this.maxScroll) {
            graphics.method_25300(this.field_22793, "\u00a77\u25bc Scroll down for more", centerX, viewportBottom - 12, 0xAAAAAA);
        }
        if (this.maxScroll > 0) {
            int scrollBarHeight = viewportBottom - viewportTop;
            int scrollBarX = this.field_22789 - 8;
            int scrollBarY = viewportTop;
            graphics.method_25294(scrollBarX, scrollBarY, scrollBarX + 4, scrollBarY + scrollBarHeight, Integer.MIN_VALUE);
            int thumbHeight = Math.max(20, scrollBarHeight * scrollBarHeight / (scrollBarHeight + this.maxScroll));
            int thumbY = scrollBarY + (int)((float)this.scrollOffset / (float)this.maxScroll * (float)(scrollBarHeight - thumbHeight));
            graphics.method_25294(scrollBarX, thumbY, scrollBarX + 4, thumbY + thumbHeight, -7829368);
        }
    }

    public boolean method_25401(double mouseX, double mouseY, double delta) {
        if (this.maxScroll > 0) {
            int scrollAmount = (int)(delta * -15.0);
            this.scrollOffset = Math.max(0, Math.min(this.maxScroll, this.scrollOffset + scrollAmount));
            return true;
        }
        return super.method_25401(mouseX, mouseY, delta);
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (this.maxScroll > 0) {
            switch (keyCode) {
                case 265: {
                    this.scrollOffset = Math.max(0, this.scrollOffset - 15);
                    return true;
                }
                case 264: {
                    this.scrollOffset = Math.min(this.maxScroll, this.scrollOffset + 15);
                    return true;
                }
                case 266: {
                    this.scrollOffset = Math.max(0, this.scrollOffset - 60);
                    return true;
                }
                case 267: {
                    this.scrollOffset = Math.min(this.maxScroll, this.scrollOffset + 60);
                    return true;
                }
                case 268: {
                    this.scrollOffset = 0;
                    return true;
                }
                case 269: {
                    this.scrollOffset = this.maxScroll;
                    return true;
                }
            }
        }
        return super.method_25404(keyCode, scanCode, modifiers);
    }

    public void method_25419() {
        this.field_22787.method_1507(this.parent);
    }

    public boolean method_25421() {
        return false;
    }
}

