/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.tunnelyP2p.gui;

import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_342;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_746;
import org.texboobcat.tunnelyP2p.TunnelManager;
import org.texboobcat.tunnelyP2p.connection.PeerConnection;
import org.texboobcat.tunnelyP2p.gui.AdvancedStatusScreen;
import org.texboobcat.tunnelyP2p.gui.DiagnosticsScreen;
import org.texboobcat.tunnelyP2p.gui.TunnelStatusScreen;

public class TunnelyManagementScreen
extends class_437 {
    private final class_437 parent;
    private class_4185 createServerButton;
    private class_4185 connectButton;
    private class_4185 copyTokenButton;
    private class_4185 stopButton;
    private class_4185 diagnosticsButton;
    private class_4185 statusScreenButton;
    private class_4185 advancedScreenButton;
    private class_4185 reloadConfigButton;
    private class_4185 closeButton;
    private class_342 maxPeersInput;
    private class_342 ttlInput;
    private class_342 portInput;
    private int scrollOffset = 0;
    private String statusMessage = "";
    private int statusMessageTimer = 0;
    private boolean statusIsError = false;

    public TunnelyManagementScreen(class_437 parent) {
        super((class_2561)class_2561.method_43470((String)"Tunnely Management"));
        this.parent = parent;
    }

    protected void method_25426() {
        super.method_25426();
        int centerX = this.field_22789 / 2;
        int buttonWidth = 150;
        int buttonHeight = 20;
        int inputWidth = 60;
        int spacing = 4;
        int startY = 60;
        TunnelManager.SessionStatus status = TunnelManager.getInstance().getStatus();
        if (!status.active) {
            this.maxPeersInput = new class_342(this.field_22793, centerX - 180, startY, inputWidth, buttonHeight, (class_2561)class_2561.method_43470((String)"Max Peers"));
            this.maxPeersInput.method_1852("4");
            this.maxPeersInput.method_1880(2);
            this.method_37063((class_364)this.maxPeersInput);
            this.ttlInput = new class_342(this.field_22793, centerX - 100, startY, inputWidth, buttonHeight, (class_2561)class_2561.method_43470((String)"TTL"));
            this.ttlInput.method_1852("3600");
            this.ttlInput.method_1880(5);
            this.method_37063((class_364)this.ttlInput);
            this.portInput = new class_342(this.field_22793, centerX - 20, startY, inputWidth, buttonHeight, (class_2561)class_2561.method_43470((String)"MC Port"));
            this.portInput.method_1852("");
            this.portInput.method_1880(5);
            this.portInput.method_47404((class_2561)class_2561.method_43470((String)"Auto"));
            this.method_37063((class_364)this.portInput);
            this.createServerButton = class_4185.method_46430((class_2561)class_2561.method_43470((String)"\u00a7aCreate Server"), button -> this.createTunnelServer()).method_46434(centerX + 60, startY, buttonWidth, buttonHeight).method_46431();
            this.method_37063((class_364)this.createServerButton);
            this.connectButton = class_4185.method_46430((class_2561)class_2561.method_43470((String)"\u00a7bConnect (Paste)"), button -> this.connectFromClipboard()).method_46434(centerX - buttonWidth / 2, startY += buttonHeight + spacing + 10, buttonWidth, buttonHeight).method_46431();
            this.method_37063((class_364)this.connectButton);
            startY += buttonHeight + spacing + 15;
        } else {
            if ("host".equals(status.mode)) {
                this.copyTokenButton = class_4185.method_46430((class_2561)class_2561.method_43470((String)"\u00a7e\ud83d\udccb Copy Token"), button -> this.copyTokenToClipboard()).method_46434(centerX - buttonWidth - spacing / 2, startY, buttonWidth, buttonHeight).method_46431();
                this.method_37063((class_364)this.copyTokenButton);
            }
            this.stopButton = class_4185.method_46430((class_2561)class_2561.method_43470((String)"\u00a7cStop Session"), button -> this.stopSession()).method_46434(centerX + spacing / 2, startY, buttonWidth, buttonHeight).method_46431();
            this.method_37063((class_364)this.stopButton);
            startY += buttonHeight + spacing + 15;
        }
        int utilY = startY;
        this.diagnosticsButton = class_4185.method_46430((class_2561)class_2561.method_43470((String)"\u00a76Run Diagnostics"), button -> this.runDiagnostics()).method_46434(centerX - buttonWidth - spacing / 2, utilY, buttonWidth, buttonHeight).method_46431();
        this.method_37063((class_364)this.diagnosticsButton);
        this.statusScreenButton = class_4185.method_46430((class_2561)class_2561.method_43470((String)"\u00a7bStatus Screen"), button -> this.openStatusScreen()).method_46434(centerX + spacing / 2, utilY, buttonWidth, buttonHeight).method_46431();
        this.method_37063((class_364)this.statusScreenButton);
        this.advancedScreenButton = class_4185.method_46430((class_2561)class_2561.method_43470((String)"\u00a79Advanced Screen"), button -> this.openAdvancedScreen()).method_46434(centerX - buttonWidth - spacing / 2, utilY += buttonHeight + spacing, buttonWidth, buttonHeight).method_46431();
        this.method_37063((class_364)this.advancedScreenButton);
        this.reloadConfigButton = class_4185.method_46430((class_2561)class_2561.method_43470((String)"\u00a77Reload Config"), button -> this.reloadConfig()).method_46434(centerX + spacing / 2, utilY, buttonWidth, buttonHeight).method_46431();
        this.method_37063((class_364)this.reloadConfigButton);
        this.closeButton = class_4185.method_46430((class_2561)class_2561.method_43470((String)"Close"), button -> this.method_25419()).method_46434(centerX - 60, this.field_22790 - 30, 120, buttonHeight).method_46431();
        this.method_37063((class_364)this.closeButton);
    }

    public void method_25394(class_332 graphics, int mouseX, int mouseY, float partialTick) {
        this.method_25420(graphics);
        super.method_25394(graphics, mouseX, mouseY, partialTick);
        int centerX = this.field_22789 / 2;
        int lineHeight = 12;
        graphics.method_25300(this.field_22793, "\u00a7b\u00a7lTunnely Management", centerX, 15, 0xFFFFFF);
        graphics.method_25300(this.field_22793, "\u00a77Quick access to all tunnel commands", centerX, 28, 0xAAAAAA);
        TunnelManager.SessionStatus status = TunnelManager.getInstance().getStatus();
        int statusY = 42;
        if (!status.active) {
            graphics.method_25300(this.field_22793, "\u00a77Status: \u00a7cInactive", centerX, statusY, 0xFFFFFF);
        } else if ("host".equals(status.mode)) {
            String statusText = String.format("\u00a77Status: \u00a7aHosting \u00a77\u2502 Peers: \u00a7f%d", status.peerCount);
            graphics.method_25300(this.field_22793, statusText, centerX, statusY, 0xFFFFFF);
        } else if ("client".equals(status.mode)) {
            graphics.method_25300(this.field_22793, "\u00a77Status: \u00a7aConnected \u00a77\u2502 Host: \u00a7f" + status.hostName, centerX, statusY, 0xFFFFFF);
        }
        if (!status.active) {
            int labelY = 49;
            graphics.method_25303(this.field_22793, "\u00a77Max Peers", centerX - 180, labelY, 0xAAAAAA);
            graphics.method_25303(this.field_22793, "\u00a77TTL (sec)", centerX - 100, labelY, 0xAAAAAA);
            graphics.method_25303(this.field_22793, "\u00a77MC Port", centerX - 20, labelY, 0xAAAAAA);
        }
        if (this.statusMessageTimer > 0) {
            int msgColor = this.statusIsError ? 0xFF5555 : 0x55FF55;
            graphics.method_25300(this.field_22793, this.statusMessage, centerX, this.field_22790 - 50, msgColor);
            --this.statusMessageTimer;
        }
        this.renderQuickStatus(graphics, status, centerX, lineHeight);
    }

    private void renderQuickStatus(class_332 graphics, TunnelManager.SessionStatus status, int centerX, int lineHeight) {
        int startY = this.field_22790 - 85;
        if (!status.active) {
            return;
        }
        graphics.method_25300(this.field_22793, "\u00a78\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500", centerX, startY, 0x555555);
        startY += lineHeight;
        if ("host".equals(status.mode)) {
            if (status.peerCount > 0) {
                graphics.method_25300(this.field_22793, "\u00a77Connected Players:", centerX, startY, 0xFFFFFF);
                startY += lineHeight;
                int count = 0;
                for (PeerConnection peer : TunnelManager.getInstance().getConnectedPeers()) {
                    if (count >= 2) break;
                    String peerInfo = String.format("\u00a7f%s \u00a77\u2191%s \u2193%s", peer.getPeerName(), this.formatBytes(peer.getBytesSent()), this.formatBytes(peer.getBytesReceived()));
                    graphics.method_25300(this.field_22793, peerInfo, centerX, startY, 0xFFFFFF);
                    startY += lineHeight;
                    ++count;
                }
                if (status.peerCount > 2) {
                    graphics.method_25300(this.field_22793, "\u00a77...and " + (status.peerCount - 2) + " more", centerX, startY, 0xAAAAAA);
                }
            } else {
                graphics.method_25300(this.field_22793, "\u00a77No peers connected", centerX, startY, 0xAAAAAA);
            }
        } else if ("client".equals(status.mode)) {
            graphics.method_25300(this.field_22793, "\u00a77Proxy: \u00a7flocalhost:" + status.localPort, centerX, startY, 0xFFFFFF);
            graphics.method_25300(this.field_22793, "\u00a77\u2191 " + this.formatBytes(status.bytesSent) + " \u00a78\u2502 \u00a77\u2193 " + this.formatBytes(status.bytesReceived), centerX, startY += lineHeight, 0xFFFFFF);
        }
    }

    private void createTunnelServer() {
        try {
            int mcPort;
            int maxPeers = Integer.parseInt(this.maxPeersInput.method_1882());
            long ttl = Long.parseLong(this.ttlInput.method_1882());
            int n = mcPort = this.portInput.method_1882().isEmpty() ? -1 : Integer.parseInt(this.portInput.method_1882());
            if (maxPeers < 1 || maxPeers > 32) {
                this.showError("Max peers must be between 1-32");
                return;
            }
            if (ttl < 60L || ttl > 86400L) {
                this.showError("TTL must be between 60-86400 seconds");
                return;
            }
            class_746 player = class_310.method_1551().field_1724;
            if (player != null && player.field_3944 != null) {
                String cmd = mcPort > 0 ? String.format("tunnel create %d %d %d", maxPeers, ttl, mcPort) : String.format("tunnel create %d %d", maxPeers, ttl);
                player.field_3944.method_45730(cmd);
                this.showSuccess("Creating tunnel server...");
                class_310.method_1551().execute(() -> {
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    this.method_25426();
                });
            }
        }
        catch (NumberFormatException e) {
            this.showError("Invalid input values");
        }
    }

    private void connectFromClipboard() {
        class_310 mc = class_310.method_1551();
        if (mc.field_1724 == null || mc.field_1724.field_3944 == null) {
            this.showError("Must be a player to connect");
            return;
        }
        String token = null;
        try {
            token = mc.field_1774.method_1460();
        }
        catch (Throwable ignored) {
            try {
                Clipboard cb = Toolkit.getDefaultToolkit().getSystemClipboard();
                Object data = cb.getData(DataFlavor.stringFlavor);
                token = data != null ? data.toString() : null;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (token == null || token.trim().isEmpty()) {
            this.showError("Clipboard is empty");
            return;
        }
        mc.field_1724.field_3944.method_45730("tunnel connect " + token.trim());
        this.showSuccess("Connecting to host...");
        mc.execute(() -> {
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.method_25426();
        });
    }

    private void copyTokenToClipboard() {
        TunnelManager manager = TunnelManager.getInstance();
        if (!manager.isHosting()) {
            this.showError("Not hosting a server");
            return;
        }
        String token = manager.getActiveServer().getConnectionToken();
        class_310 mc = class_310.method_1551();
        try {
            mc.field_1774.method_1455(token);
            this.showSuccess("Token copied to clipboard!");
        }
        catch (Throwable mcError) {
            try {
                Clipboard clipboard;
                Toolkit toolkit = Toolkit.getDefaultToolkit();
                if (toolkit != null && (clipboard = toolkit.getSystemClipboard()) != null) {
                    clipboard.setContents(new StringSelection(token), null);
                    this.showSuccess("Token copied to clipboard!");
                    return;
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.showError("Failed to copy token");
        }
    }

    private void stopSession() {
        TunnelManager.getInstance().stopAll();
        this.showSuccess("Session stopped");
        class_310.method_1551().execute(this::method_25426);
    }

    private void runDiagnostics() {
        class_310.method_1551().method_1507((class_437)new DiagnosticsScreen(this.parent));
    }

    private void openStatusScreen() {
        class_310.method_1551().method_1507((class_437)new TunnelStatusScreen(this.parent));
    }

    private void openAdvancedScreen() {
        class_310.method_1551().method_1507((class_437)new AdvancedStatusScreen(this.parent));
    }

    private void reloadConfig() {
        class_746 player = class_310.method_1551().field_1724;
        if (player != null && player.field_3944 != null) {
            player.field_3944.method_45730("tunnel config reload");
            this.showSuccess("Config reloaded");
        }
    }

    private void showSuccess(String message) {
        this.statusMessage = "\u00a7a" + message;
        this.statusIsError = false;
        this.statusMessageTimer = 100;
    }

    private void showError(String message) {
        this.statusMessage = "\u00a7c" + message;
        this.statusIsError = true;
        this.statusMessageTimer = 100;
    }

    private String formatBytes(long bytes) {
        if (bytes < 1024L) {
            return bytes + "B";
        }
        if (bytes < 0x100000L) {
            return String.format("%.1fKB", (double)bytes / 1024.0);
        }
        if (bytes < 0x40000000L) {
            return String.format("%.1fMB", (double)bytes / 1048576.0);
        }
        return String.format("%.1fGB", (double)bytes / 1.073741824E9);
    }

    public void method_25419() {
        this.field_22787.method_1507(this.parent);
    }

    public boolean method_25421() {
        return false;
    }

    public void method_25393() {
        super.method_25393();
        if (this.maxPeersInput != null) {
            this.maxPeersInput.method_1865();
        }
        if (this.ttlInput != null) {
            this.ttlInput.method_1865();
        }
        if (this.portInput != null) {
            this.portInput.method_1865();
        }
    }
}

