/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.tunnelyP2p.i18n;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class I18n {
    private static final Map<String, Map<String, String>> translations = new ConcurrentHashMap<String, Map<String, String>>();
    private static volatile String currentLocale = "en_us";

    public static String translate(String key, Object ... args) {
        String translation;
        Map<String, String> locale = translations.get(currentLocale);
        if (locale == null) {
            locale = translations.get("en_us");
        }
        String string = translation = locale != null ? locale.get(key) : null;
        if (translation == null) {
            return key;
        }
        if (args.length > 0) {
            return String.format(translation, args);
        }
        return translation;
    }

    public static String t(String key, Object ... args) {
        return I18n.translate(key, args);
    }

    public static void setLocale(String locale) {
        currentLocale = locale.toLowerCase();
    }

    public static String getLocale() {
        return currentLocale;
    }

    public static void addTranslations(String locale, Map<String, String> trans) {
        translations.computeIfAbsent(locale.toLowerCase(), k -> new ConcurrentHashMap()).putAll(trans);
    }

    private static void loadDefaultTranslations() {
        HashMap<String, String> en = new HashMap<String, String>();
        en.put("commands.tunnel.create.success", "\u00a7a\u00a7l\u2713 Tunnel Created!");
        en.put("commands.tunnel.create.maxpeers", "\u00a77Max Peers: \u00a7f%d");
        en.put("commands.tunnel.create.ttl", "\u00a77TTL: \u00a7f%s");
        en.put("commands.tunnel.create.port", "\u00a77Listening on port: \u00a7f%d");
        en.put("commands.tunnel.create.token", "\u00a7e\u00a7l[CLICK TO COPY TOKEN]");
        en.put("commands.tunnel.create.share", "\u00a77Share this token with friends to allow them to connect.");
        en.put("commands.tunnel.create.already", "\u00a7cAlready hosting a tunnel. Use /tunnel stop first.");
        en.put("commands.tunnel.create.connected", "\u00a7cAlready connected to a host. Use /tunnel stop first.");
        en.put("commands.tunnel.create.failed", "\u00a7cFailed to create tunnel: %s");
        en.put("commands.tunnel.connect.connecting", "\u00a7eConnecting to host...");
        en.put("commands.tunnel.connect.success", "\u00a7a\u00a7l\u2713 Connected!");
        en.put("commands.tunnel.connect.proxy", "\u00a77Local proxy: \u00a7flocalhost:%d");
        en.put("commands.tunnel.connect.addserver", "\u00a77Add server: \u00a7f127.0.0.1:%d");
        en.put("commands.tunnel.connect.instruction", "\u00a7aConnect your Minecraft client to that address to join!");
        en.put("commands.tunnel.connect.already", "\u00a7cAlready connected. Use /tunnel stop first.");
        en.put("commands.tunnel.connect.hosting", "\u00a7cCurrently hosting. Use /tunnel stop first.");
        en.put("commands.tunnel.connect.failed", "\u00a7cConnection failed: %s");
        en.put("commands.tunnel.connect.player", "\u00a7cThis command must be run by a player.");
        en.put("commands.tunnel.stop.success", "\u00a7a\u2713 Tunnel session stopped.");
        en.put("commands.tunnel.stop.none", "\u00a7cNo active tunnel session.");
        en.put("commands.tunnel.token.none", "\u00a7cNo active tunnel. Use /tunnel create first.");
        en.put("commands.tunnel.token.title", "\u00a7a\u00a7lConnection Token:");
        en.put("commands.tunnel.invite.copied", "\u00a7a\u2713 Token copied to clipboard!");
        en.put("commands.tunnel.invite.share", "\u00a77Share it with friends to let them connect.");
        en.put("commands.tunnel.invite.failed", "\u00a7cFailed to copy to clipboard: %s");
        en.put("commands.tunnel.invite.unavailable", "\u00a7cClipboard not available.");
        en.put("commands.tunnel.status.title", "\u00a7b\u00a7l\u2550\u2550\u2550 Tunnel Status \u2550\u2550\u2550");
        en.put("commands.tunnel.status.mode", "\u00a77Mode: %s");
        en.put("commands.tunnel.status.inactive", "\u00a7cInactive");
        en.put("commands.tunnel.status.host", "\u00a7aHost");
        en.put("commands.tunnel.status.client", "\u00a7aClient");
        en.put("commands.tunnel.status.peers", "\u00a77Connected Peers: \u00a7f%d");
        en.put("commands.tunnel.status.connectedto", "\u00a77Connected to: \u00a7f%s");
        en.put("commands.tunnel.status.localproxy", "\u00a77Local proxy: \u00a7flocalhost:%d");
        en.put("commands.tunnel.status.sent", "\u00a77Data sent: \u00a7f%s");
        en.put("commands.tunnel.status.received", "\u00a77Data received: \u00a7f%s");
        en.put("commands.tunnel.status.footer", "\u00a7b\u00a7l\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550");
        en.put("gui.tunnel.title", "Tunnel Status");
        en.put("gui.tunnel.close", "Close");
        en.put("gui.tunnel.stop", "Stop Session");
        en.put("gui.tunnel.status", "\u00a77Status: %s");
        en.put("gui.tunnel.noactive", "\u00a77No active tunnel session");
        en.put("gui.tunnel.usecommands", "\u00a77Use \u00a7f/tunnel create \u00a77to host or \u00a7f/tunnel connect \u00a77to join");
        en.put("gui.tunnel.mode", "\u00a77Mode: %s");
        en.put("gui.tunnel.connectedpeers", "\u00a77Connected Peers: \u00a7f%d");
        en.put("gui.tunnel.players", "\u00a77Connected Players:");
        en.put("gui.tunnel.nopeers", "\u00a77No peers connected yet");
        en.put("gui.tunnel.gettoken", "\u00a77Use \u00a7f/tunnel token \u00a77to get the connection token");
        en.put("nat.upnp.attempting", "[UPnP] Attempting port mapping...");
        en.put("nat.upnp.success", "[UPnP] Port mapping created: %d -> %d");
        en.put("nat.upnp.failed", "[UPnP] Failed to create port mapping: %s");
        en.put("nat.publicip.detected", "Detected public IP: %s");
        en.put("nat.localip", "Local IP: %s");
        en.put("connection.strategy.direct_tcp", "Direct TCP to public IP/port");
        en.put("connection.strategy.direct_local", "Direct TCP to local IP/port (LAN)");
        en.put("connection.strategy.udp_punch", "UDP hole punching");
        en.put("connection.strategy.tcp_punch", "TCP hole punching");
        en.put("connection.strategy.fallback", "Manual configuration required");
        en.put("connection.trying", "Trying %s to %s:%d");
        en.put("connection.success", "[Connection] Success via %s");
        en.put("connection.failed", "  Failed: %s");
        en.put("connection.allfailed", "All connection strategies failed");
        en.put("error.token.expired", "Connection token has expired");
        en.put("error.token.invalid", "Invalid connection token");
        en.put("error.session.invalid", "Invalid session ID");
        en.put("error.auth.failed", "Authentication failed");
        en.put("error.crypto.failed", "Encryption error");
        en.put("error.network.failed", "Network error: %s");
        translations.put("en_us", en);
        I18n.loadSpanishTranslations();
        I18n.loadFrenchTranslations();
        I18n.loadGermanTranslations();
    }

    private static void loadSpanishTranslations() {
        HashMap<String, String> es = new HashMap<String, String>();
        es.put("commands.tunnel.create.success", "\u00a7a\u00a7l\u2713 \u00a1T\u00fanel Creado!");
        es.put("commands.tunnel.create.maxpeers", "\u00a77Pares M\u00e1ximos: \u00a7f%d");
        es.put("commands.tunnel.create.ttl", "\u00a77Duraci\u00f3n: \u00a7f%s");
        es.put("commands.tunnel.create.share", "\u00a77Comparte este token con amigos para permitirles conectarse.");
        es.put("commands.tunnel.connect.success", "\u00a7a\u00a7l\u2713 \u00a1Conectado!");
        es.put("commands.tunnel.connect.instruction", "\u00a7a\u00a1Conecta tu cliente de Minecraft a esa direcci\u00f3n para unirte!");
        es.put("commands.tunnel.stop.success", "\u00a7a\u2713 Sesi\u00f3n de t\u00fanel detenida.");
        es.put("commands.tunnel.status.title", "\u00a7b\u00a7l\u2550\u2550\u2550 Estado del T\u00fanel \u2550\u2550\u2550");
        es.put("gui.tunnel.title", "Estado del T\u00fanel");
        translations.put("es_es", es);
        translations.put("es_mx", es);
    }

    private static void loadFrenchTranslations() {
        HashMap<String, String> fr = new HashMap<String, String>();
        fr.put("commands.tunnel.create.success", "\u00a7a\u00a7l\u2713 Tunnel Cr\u00e9\u00e9!");
        fr.put("commands.tunnel.create.maxpeers", "\u00a77Pairs Maximum: \u00a7f%d");
        fr.put("commands.tunnel.create.share", "\u00a77Partagez ce jeton avec des amis pour leur permettre de se connecter.");
        fr.put("commands.tunnel.connect.success", "\u00a7a\u00a7l\u2713 Connect\u00e9!");
        fr.put("commands.tunnel.stop.success", "\u00a7a\u2713 Session de tunnel arr\u00eat\u00e9e.");
        fr.put("commands.tunnel.status.title", "\u00a7b\u00a7l\u2550\u2550\u2550 \u00c9tat du Tunnel \u2550\u2550\u2550");
        fr.put("gui.tunnel.title", "\u00c9tat du Tunnel");
        translations.put("fr_fr", fr);
    }

    private static void loadGermanTranslations() {
        HashMap<String, String> de = new HashMap<String, String>();
        de.put("commands.tunnel.create.success", "\u00a7a\u00a7l\u2713 Tunnel Erstellt!");
        de.put("commands.tunnel.create.maxpeers", "\u00a77Maximale Peers: \u00a7f%d");
        de.put("commands.tunnel.create.share", "\u00a77Teile diesen Token mit Freunden, um ihnen die Verbindung zu erm\u00f6glichen.");
        de.put("commands.tunnel.connect.success", "\u00a7a\u00a7l\u2713 Verbunden!");
        de.put("commands.tunnel.stop.success", "\u00a7a\u2713 Tunnel-Sitzung beendet.");
        de.put("commands.tunnel.status.title", "\u00a7b\u00a7l\u2550\u2550\u2550 Tunnel-Status \u2550\u2550\u2550");
        de.put("gui.tunnel.title", "Tunnel-Status");
        translations.put("de_de", de);
    }

    static {
        I18n.loadDefaultTranslations();
    }
}

