/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.tunnelyP2p.protocol;

import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.UUID;
import org.texboobcat.tunnelyP2p.protocol.ProtocolMessage;

public class AuthResponseMessage
extends ProtocolMessage {
    private final byte[] signedNonce;
    private final byte[] encryptionNonce;
    private final UUID playerUUID;
    private final String playerName;

    public AuthResponseMessage(byte[] signedNonce, byte[] encryptionNonce, UUID playerUUID, String playerName) {
        super(ProtocolMessage.MessageType.AUTH_RESPONSE);
        this.signedNonce = signedNonce;
        this.encryptionNonce = encryptionNonce;
        this.playerUUID = playerUUID;
        this.playerName = playerName;
    }

    public byte[] getSignedNonce() {
        return this.signedNonce;
    }

    public byte[] getEncryptionNonce() {
        return this.encryptionNonce;
    }

    public UUID getPlayerUUID() {
        return this.playerUUID;
    }

    public String getPlayerName() {
        return this.playerName;
    }

    @Override
    public byte[] serialize() throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(baos);
        dos.writeByte(this.type.getId());
        this.writeByteArray(dos, this.encryptionNonce);
        this.writeByteArray(dos, this.signedNonce);
        this.writeUUID(dos, this.playerUUID);
        dos.writeUTF(this.playerName);
        return baos.toByteArray();
    }

    public static AuthResponseMessage deserializeFrom(DataInputStream dis) throws IOException {
        byte[] encNonce = new AuthResponseMessage(null, null, null, null).readByteArray(dis);
        byte[] signedNonce = new AuthResponseMessage(null, null, null, null).readByteArray(dis);
        UUID playerUUID = new AuthResponseMessage(null, null, null, null).readUUID(dis);
        String playerName = dis.readUTF();
        return new AuthResponseMessage(signedNonce, encNonce, playerUUID, playerName);
    }
}

