/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.tunnelyP2p.protocol;

import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.texboobcat.tunnelyP2p.protocol.ProtocolMessage;

public class ErrorMessage
extends ProtocolMessage {
    private final int errorCode;
    private final String errorMessage;

    public ErrorMessage(int errorCode, String errorMessage) {
        super(ProtocolMessage.MessageType.ERROR);
        this.errorCode = errorCode;
        this.errorMessage = errorMessage;
    }

    public int getErrorCode() {
        return this.errorCode;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    @Override
    public byte[] serialize() throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(baos);
        dos.writeByte(this.type.getId());
        dos.writeInt(this.errorCode);
        dos.writeUTF(this.errorMessage != null ? this.errorMessage : "");
        return baos.toByteArray();
    }

    public static ErrorMessage deserializeFrom(DataInputStream dis) throws IOException {
        int errorCode = dis.readInt();
        String errorMsg = dis.readUTF();
        return new ErrorMessage(errorCode, errorMsg.isEmpty() ? null : errorMsg);
    }
}

