/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.tunnelyP2p.protocol;

import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.UUID;
import org.texboobcat.tunnelyP2p.protocol.ProtocolMessage;

public class HandshakeMessage
extends ProtocolMessage {
    private final int protocolVersion;
    private final UUID sessionId;
    private final byte[] clientPublicKey;
    private final byte[] tokenHash;
    private final long timestamp;

    public HandshakeMessage(int protocolVersion, UUID sessionId, byte[] clientPublicKey, byte[] tokenHash, long timestamp) {
        super(ProtocolMessage.MessageType.HANDSHAKE);
        this.protocolVersion = protocolVersion;
        this.sessionId = sessionId;
        this.clientPublicKey = clientPublicKey;
        this.tokenHash = tokenHash;
        this.timestamp = timestamp;
    }

    public int getProtocolVersion() {
        return this.protocolVersion;
    }

    public UUID getSessionId() {
        return this.sessionId;
    }

    public byte[] getClientPublicKey() {
        return this.clientPublicKey;
    }

    public byte[] getTokenHash() {
        return this.tokenHash;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    @Override
    public byte[] serialize() throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(baos);
        dos.writeByte(this.type.getId());
        dos.writeInt(this.protocolVersion);
        this.writeUUID(dos, this.sessionId);
        this.writeByteArray(dos, this.clientPublicKey);
        this.writeByteArray(dos, this.tokenHash);
        dos.writeLong(this.timestamp);
        return baos.toByteArray();
    }

    public static HandshakeMessage deserializeFrom(DataInputStream dis) throws IOException {
        int version = dis.readInt();
        UUID sessionId = new HandshakeMessage(0, null, null, null, 0L).readUUID(dis);
        byte[] clientPubKey = new HandshakeMessage(0, null, null, null, 0L).readByteArray(dis);
        byte[] tokenHash = new HandshakeMessage(0, null, null, null, 0L).readByteArray(dis);
        long timestamp = dis.readLong();
        return new HandshakeMessage(version, sessionId, clientPubKey, tokenHash, timestamp);
    }
}

