/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.tunnelyP2p.protocol;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.UUID;
import org.texboobcat.tunnelyP2p.protocol.AuthChallengeMessage;
import org.texboobcat.tunnelyP2p.protocol.AuthResponseMessage;
import org.texboobcat.tunnelyP2p.protocol.ErrorMessage;
import org.texboobcat.tunnelyP2p.protocol.HandshakeMessage;
import org.texboobcat.tunnelyP2p.protocol.KeepaliveMessage;
import org.texboobcat.tunnelyP2p.protocol.StreamAckMessage;
import org.texboobcat.tunnelyP2p.protocol.StreamCloseMessage;
import org.texboobcat.tunnelyP2p.protocol.StreamDataMessage;

public abstract class ProtocolMessage {
    protected final MessageType type;

    protected ProtocolMessage(MessageType type) {
        this.type = type;
    }

    public MessageType getType() {
        return this.type;
    }

    public abstract byte[] serialize() throws IOException;

    public static ProtocolMessage deserialize(byte[] data) throws IOException {
        ByteArrayInputStream bais = new ByteArrayInputStream(data);
        DataInputStream dis = new DataInputStream(bais);
        int typeId = dis.readUnsignedByte();
        MessageType type = MessageType.fromId(typeId);
        switch (type.ordinal()) {
            case 0: {
                return HandshakeMessage.deserializeFrom(dis);
            }
            case 1: {
                return AuthChallengeMessage.deserializeFrom(dis);
            }
            case 2: {
                return AuthResponseMessage.deserializeFrom(dis);
            }
            case 3: {
                return StreamDataMessage.deserializeFrom(dis);
            }
            case 4: {
                return StreamAckMessage.deserializeFrom(dis);
            }
            case 5: {
                return StreamCloseMessage.deserializeFrom(dis);
            }
            case 6: {
                return KeepaliveMessage.deserializeFrom(dis);
            }
            case 7: {
                return ErrorMessage.deserializeFrom(dis);
            }
        }
        throw new IOException("Unknown message type: " + String.valueOf((Object)type));
    }

    protected void writeUUID(DataOutputStream dos, UUID uuid) throws IOException {
        dos.writeLong(uuid.getMostSignificantBits());
        dos.writeLong(uuid.getLeastSignificantBits());
    }

    protected UUID readUUID(DataInputStream dis) throws IOException {
        long mostSig = dis.readLong();
        long leastSig = dis.readLong();
        return new UUID(mostSig, leastSig);
    }

    protected void writeByteArray(DataOutputStream dos, byte[] data) throws IOException {
        if (data == null) {
            dos.writeInt(0);
        } else {
            dos.writeInt(data.length);
            dos.write(data);
        }
    }

    protected byte[] readByteArray(DataInputStream dis) throws IOException {
        int length = dis.readInt();
        if (length == 0) {
            return new byte[0];
        }
        byte[] data = new byte[length];
        dis.readFully(data);
        return data;
    }

    public static enum MessageType {
        HANDSHAKE(1),
        AUTH_CHALLENGE(2),
        AUTH_RESPONSE(3),
        STREAM_DATA(4),
        STREAM_ACK(5),
        STREAM_CLOSE(6),
        KEEPALIVE(7),
        ERROR(8);

        private final int id;

        private MessageType(int id) {
            this.id = id;
        }

        public int getId() {
            return this.id;
        }

        public static MessageType fromId(int id) {
            for (MessageType type : MessageType.values()) {
                if (type.id != id) continue;
                return type;
            }
            throw new IllegalArgumentException("Unknown message type: " + id);
        }
    }
}

