/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.tunnelyP2p.qos;

import java.util.concurrent.atomic.AtomicLong;

public class BandwidthLimiter {
    private final long maxBytesPerSecond;
    private final long bucketCapacity;
    private final AtomicLong availableTokens;
    private volatile long lastRefillTime;

    public BandwidthLimiter(long maxBytesPerSecond) {
        this.maxBytesPerSecond = maxBytesPerSecond;
        this.bucketCapacity = maxBytesPerSecond * 2L;
        this.availableTokens = new AtomicLong(this.bucketCapacity);
        this.lastRefillTime = System.currentTimeMillis();
    }

    public boolean tryConsume(long bytes) {
        this.refillTokens();
        long current = this.availableTokens.get();
        if (current >= bytes) {
            if (this.availableTokens.compareAndSet(current, current - bytes)) {
                return true;
            }
            return this.tryConsume(bytes);
        }
        return false;
    }

    public void consume(long bytes) throws InterruptedException {
        while (!this.tryConsume(bytes)) {
            long deficit = bytes - this.availableTokens.get();
            long waitMs = deficit * 1000L / this.maxBytesPerSecond;
            Thread.sleep(Math.max(1L, Math.min(waitMs, 100L)));
        }
    }

    private void refillTokens() {
        long newTokens;
        long current;
        long tokensToAdd;
        long now = System.currentTimeMillis();
        long elapsed = now - this.lastRefillTime;
        if (elapsed > 0L && (tokensToAdd = elapsed * this.maxBytesPerSecond / 1000L) > 0L && this.availableTokens.compareAndSet(current = this.availableTokens.get(), newTokens = Math.min(this.bucketCapacity, current + tokensToAdd))) {
            this.lastRefillTime = now;
        }
    }

    public long getAvailableTokens() {
        this.refillTokens();
        return this.availableTokens.get();
    }

    public double getUtilization() {
        this.refillTokens();
        long available = this.availableTokens.get();
        return (double)(this.bucketCapacity - available) * 100.0 / (double)this.bucketCapacity;
    }

    public void reset() {
        this.availableTokens.set(this.bucketCapacity);
        this.lastRefillTime = System.currentTimeMillis();
    }
}

