/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.tunnelyP2p.token;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Base64;
import java.util.UUID;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.texboobcat.tunnelyP2p.token.ConnectionToken;

public class TokenCodec {
    private static final Gson GSON = new GsonBuilder().disableHtmlEscaping().create();

    public static String encode(ConnectionToken token) {
        JsonObject json = TokenCodec.toJson(token);
        String jsonStr = GSON.toJson(json);
        byte[] compressed = TokenCodec.gzip(jsonStr.getBytes(StandardCharsets.UTF_8));
        return TokenCodec.base64UrlEncode(compressed);
    }

    public static String encodeCanonical(ConnectionToken token) {
        JsonObject json = TokenCodec.toJson(token);
        return GSON.toJson(json);
    }

    private static JsonObject toJson(ConnectionToken token) {
        JsonObject json = new JsonObject();
        json.addProperty("v", token.getProtocolVersion());
        json.addProperty("sid", token.getSessionId().toString());
        json.addProperty("pk", TokenCodec.base64UrlEncode(token.getHostPublicKey()));
        json.addProperty("ts", token.getTimestamp());
        json.addProperty("ttl", token.getTtlSeconds());
        json.addProperty("uuid", token.getHostPlayerUUID().toString());
        json.addProperty("name", token.getHostPlayerName());
        if (token.getSignature() != null && token.getSignature().length > 0) {
            json.addProperty("sig", TokenCodec.base64UrlEncode(token.getSignature()));
        }
        ConnectionToken.NATInfo nat = token.getNatInfo();
        JsonObject natJson = new JsonObject();
        if (nat.getPublicIP() != null) {
            natJson.addProperty("pub_ip", nat.getPublicIP());
        }
        if (nat.getPublicPort() != null) {
            natJson.addProperty("pub_port", nat.getPublicPort());
        }
        if (nat.getLocalIP() != null) {
            natJson.addProperty("loc_ip", nat.getLocalIP());
        }
        if (nat.getLocalPort() != null) {
            natJson.addProperty("loc_port", nat.getLocalPort());
        }
        if (nat.getPublicIPv6() != null) {
            natJson.addProperty("pub_ip6", nat.getPublicIPv6());
        }
        if (nat.getPublicPortv6() != null) {
            natJson.addProperty("pub_port6", nat.getPublicPortv6());
        }
        if (nat.getLocalIPv6() != null) {
            natJson.addProperty("loc_ip6", nat.getLocalIPv6());
        }
        if (nat.getLocalPortv6() != null) {
            natJson.addProperty("loc_port6", nat.getLocalPortv6());
        }
        natJson.addProperty("upnp", nat.isUpnpSuccess());
        if (!nat.getUdpPorts().isEmpty()) {
            JsonArray udpArray = new JsonArray();
            nat.getUdpPorts().forEach(udpArray::add);
            natJson.add("udp", udpArray);
        }
        json.add("nat", natJson);
        return json;
    }

    public static ConnectionToken decode(String encodedToken) throws TokenDecodeException {
        try {
            JsonObject natJson;
            byte[] raw;
            byte[] jsonBytes;
            String jsonStr;
            JsonObject json;
            int version;
            String normalized;
            String string = normalized = encodedToken == null ? "" : encodedToken.trim();
            if (normalized.length() >= 2 && (normalized.startsWith("\"") && normalized.endsWith("\"") || normalized.startsWith("'") && normalized.endsWith("'"))) {
                normalized = normalized.substring(1, normalized.length() - 1);
            }
            if ((version = (json = JsonParser.parseString(jsonStr = new String(jsonBytes = (raw = TokenCodec.base64UrlDecode(normalized = normalized.replaceAll("\\s", ""))).length >= 2 && raw[0] == 31 && (raw[1] & 0xFF) == 139 ? TokenCodec.gunzip(raw) : raw, StandardCharsets.UTF_8)).getAsJsonObject()).get("v").getAsInt()) != 1) {
                throw new TokenDecodeException("Unsupported protocol version: " + version);
            }
            UUID sessionId = UUID.fromString(json.get("sid").getAsString());
            byte[] publicKey = TokenCodec.base64UrlDecode(json.get("pk").getAsString());
            long timestamp = json.get("ts").getAsLong();
            long ttl = json.get("ttl").getAsLong();
            UUID hostUUID = UUID.fromString(json.get("uuid").getAsString());
            String hostName = json.get("name").getAsString();
            byte[] signature = null;
            if (json.has("sig")) {
                signature = TokenCodec.base64UrlDecode(json.get("sig").getAsString());
            }
            String publicIP = (natJson = json.getAsJsonObject("nat")).has("pub_ip") ? natJson.get("pub_ip").getAsString() : null;
            Integer publicPort = natJson.has("pub_port") ? Integer.valueOf(natJson.get("pub_port").getAsInt()) : null;
            String localIP = natJson.has("loc_ip") ? natJson.get("loc_ip").getAsString() : null;
            Integer localPort = natJson.has("loc_port") ? Integer.valueOf(natJson.get("loc_port").getAsInt()) : null;
            String publicIPv6 = natJson.has("pub_ip6") ? natJson.get("pub_ip6").getAsString() : null;
            Integer publicPortv6 = natJson.has("pub_port6") ? Integer.valueOf(natJson.get("pub_port6").getAsInt()) : null;
            String localIPv6 = natJson.has("loc_ip6") ? natJson.get("loc_ip6").getAsString() : null;
            Integer localPortv6 = natJson.has("loc_port6") ? Integer.valueOf(natJson.get("loc_port6").getAsInt()) : null;
            boolean upnpSuccess = natJson.has("upnp") && natJson.get("upnp").getAsBoolean();
            ArrayList<Integer> udpPorts = new ArrayList<Integer>();
            if (natJson.has("udp")) {
                JsonArray udpArray = natJson.getAsJsonArray("udp");
                for (JsonElement elem : udpArray) {
                    udpPorts.add(elem.getAsInt());
                }
            }
            ConnectionToken.NATInfo natInfo = new ConnectionToken.NATInfo(publicIP, publicPort, localIP, localPort, publicIPv6, publicPortv6, localIPv6, localPortv6, upnpSuccess, udpPorts);
            return new ConnectionToken(sessionId, publicKey, natInfo, timestamp, ttl, hostUUID, hostName, signature);
        }
        catch (Exception e) {
            throw new TokenDecodeException("Failed to decode token: " + e.getMessage(), e);
        }
    }

    private static String base64UrlEncode(byte[] data) {
        return Base64.getUrlEncoder().withoutPadding().encodeToString(data);
    }

    private static byte[] base64UrlDecode(String encoded) {
        return Base64.getUrlDecoder().decode(encoded);
    }

    private static byte[] gzip(byte[] input) {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            try (GZIPOutputStream gzip = new GZIPOutputStream(baos);){
                gzip.write(input);
            }
            return baos.toByteArray();
        }
        catch (Exception e) {
            return input;
        }
    }

    private static byte[] gunzip(byte[] input) throws Exception {
        int MAX_DECOMPRESSED_SIZE = 65536;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try (GZIPInputStream gis = new GZIPInputStream(new ByteArrayInputStream(input));){
            int r;
            byte[] buf = new byte[4096];
            int totalRead = 0;
            while ((r = gis.read(buf)) != -1) {
                if ((totalRead += r) > 65536) {
                    throw new TokenDecodeException("Token too large: exceeds 65536 bytes");
                }
                baos.write(buf, 0, r);
            }
        }
        return baos.toByteArray();
    }

    public static class TokenDecodeException
    extends Exception {
        public TokenDecodeException(String message) {
            super(message);
        }

        public TokenDecodeException(String message, Throwable cause) {
            super(message, cause);
        }
    }
}

