/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.tunnelyP2p.udp;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.texboobcat.tunnelyP2p.udp.UdpPacket;

public class ReliableUdpStream
implements AutoCloseable {
    private static final int WINDOW_SIZE = 256;
    private static final int INITIAL_TIMEOUT_MS = 200;
    private static final int MAX_TIMEOUT_MS = 5000;
    private static final int MAX_RETRIES = 10;
    private final DatagramSocket socket;
    private final InetAddress remoteAddress;
    private final int remotePort;
    private final AtomicInteger nextSequenceNum = new AtomicInteger(0);
    private final AtomicInteger nextExpectedSeq = new AtomicInteger(0);
    private final AtomicBoolean running = new AtomicBoolean(false);
    private final ConcurrentHashMap<Integer, UdpPacket> sendWindow = new ConcurrentHashMap();
    private final ConcurrentHashMap<Integer, UdpPacket> receiveWindow = new ConcurrentHashMap();
    private final BlockingQueue<byte[]> receivedData = new LinkedBlockingQueue<byte[]>();
    private volatile int estimatedRTT = 200;
    private volatile int rttDeviation = 100;
    private final ExecutorService executor = Executors.newCachedThreadPool();
    private final ScheduledExecutorService retransmitScheduler = Executors.newScheduledThreadPool(1);
    private DataReceiver dataReceiver;

    public ReliableUdpStream(DatagramSocket socket, InetAddress remoteAddress, int remotePort) {
        this.socket = socket;
        this.remoteAddress = remoteAddress;
        this.remotePort = remotePort;
    }

    public void start() {
        if (this.running.compareAndSet(false, true)) {
            this.executor.submit(this::receiveLoop);
            this.retransmitScheduler.scheduleAtFixedRate(this::checkRetransmissions, 50L, 50L, TimeUnit.MILLISECONDS);
        }
    }

    public void send(byte[] data) throws IOException {
        int chunkSize;
        if (!this.running.get()) {
            throw new IOException("Stream not running");
        }
        for (int offset = 0; offset < data.length; offset += chunkSize) {
            chunkSize = Math.min(1400, data.length - offset);
            byte[] chunk = Arrays.copyOfRange(data, offset, offset + chunkSize);
            this.sendPacket(chunk);
        }
    }

    private void sendPacket(byte[] payload) throws IOException {
        while (this.sendWindow.size() >= 256 && this.running.get()) {
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new IOException("Interrupted while waiting for window");
            }
        }
        int seqNum = this.nextSequenceNum.getAndIncrement();
        byte flags = 16;
        UdpPacket packet = new UdpPacket(seqNum, this.nextExpectedSeq.get(), flags, payload);
        this.sendWindow.put(seqNum, packet);
        this.transmitPacket(packet);
    }

    private void transmitPacket(UdpPacket packet) throws IOException {
        byte[] data = packet.serialize();
        DatagramPacket dgram = new DatagramPacket(data, data.length, this.remoteAddress, this.remotePort);
        this.socket.send(dgram);
        packet.updateSendTime();
    }

    private void receiveLoop() {
        block4: {
            byte[] buffer = new byte[1413];
            try {
                while (this.running.get()) {
                    DatagramPacket dgram = new DatagramPacket(buffer, buffer.length);
                    this.socket.receive(dgram);
                    byte[] data = Arrays.copyOf(dgram.getData(), dgram.getLength());
                    UdpPacket packet = UdpPacket.deserialize(data);
                    this.handleReceivedPacket(packet);
                }
            }
            catch (SocketException dgram) {
            }
            catch (Exception e) {
                if (!this.running.get()) break block4;
                e.printStackTrace();
            }
        }
    }

    private void handleReceivedPacket(UdpPacket packet) throws IOException {
        int ackNum;
        UdpPacket ackedPacket;
        if (packet.hasFlag((byte)2) && (ackedPacket = this.sendWindow.remove(ackNum = packet.getAcknowledgmentNumber())) != null) {
            long rtt = System.currentTimeMillis() - ackedPacket.getSendTime();
            this.updateRTT((int)rtt);
        }
        if (packet.hasFlag((byte)16)) {
            int seqNum = packet.getSequenceNumber();
            this.sendAck(seqNum);
            if (seqNum == this.nextExpectedSeq.get()) {
                this.deliverData(packet.getPayload());
                this.nextExpectedSeq.incrementAndGet();
                this.deliverBufferedPackets();
            } else if (seqNum > this.nextExpectedSeq.get()) {
                this.receiveWindow.put(seqNum, packet);
            }
        }
        if (packet.hasFlag((byte)4)) {
            this.handleFinish();
        }
    }

    private void sendAck(int seqNum) throws IOException {
        UdpPacket ackPacket = new UdpPacket(this.nextSequenceNum.get(), seqNum, 2, null);
        this.transmitPacket(ackPacket);
    }

    private void deliverBufferedPackets() {
        UdpPacket buffered;
        while ((buffered = this.receiveWindow.remove(this.nextExpectedSeq.get())) != null) {
            this.deliverData(buffered.getPayload());
            this.nextExpectedSeq.incrementAndGet();
        }
    }

    private void deliverData(byte[] data) {
        if (this.dataReceiver != null) {
            this.dataReceiver.onDataReceived(data);
        } else {
            this.receivedData.offer(data);
        }
    }

    private void checkRetransmissions() {
        long now = System.currentTimeMillis();
        int timeout = this.calculateTimeout();
        for (Map.Entry<Integer, UdpPacket> entry : this.sendWindow.entrySet()) {
            UdpPacket packet = entry.getValue();
            long elapsed = now - packet.getSendTime();
            if (elapsed <= (long)timeout) continue;
            try {
                this.transmitPacket(packet);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private int calculateTimeout() {
        return Math.min(this.estimatedRTT + 4 * this.rttDeviation, 5000);
    }

    private void updateRTT(int measuredRTT) {
        int alpha = 125;
        int beta = 250;
        int delta = Math.abs(this.estimatedRTT - measuredRTT);
        this.rttDeviation = (this.rttDeviation * (1000 - beta) + delta * beta) / 1000;
        this.estimatedRTT = (this.estimatedRTT * (1000 - alpha) + measuredRTT * alpha) / 1000;
    }

    public byte[] read() throws InterruptedException {
        return this.receivedData.take();
    }

    public byte[] read(long timeout, TimeUnit unit) throws InterruptedException {
        return this.receivedData.poll(timeout, unit);
    }

    public void setDataReceiver(DataReceiver receiver) {
        this.dataReceiver = receiver;
    }

    private void handleFinish() {
        this.close();
    }

    public int getEstimatedRTT() {
        return this.estimatedRTT;
    }

    public int getSendWindowSize() {
        return this.sendWindow.size();
    }

    @Override
    public void close() {
        if (this.running.compareAndSet(true, false)) {
            try {
                UdpPacket finPacket = new UdpPacket(this.nextSequenceNum.getAndIncrement(), this.nextExpectedSeq.get(), 4, null);
                this.transmitPacket(finPacket);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.retransmitScheduler.shutdown();
            this.executor.shutdown();
        }
    }

    public static interface DataReceiver {
        public void onDataReceived(byte[] var1);
    }
}

