/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.tunnelyP2p.udp;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class UdpPacket {
    public static final int HEADER_SIZE = 13;
    public static final int MAX_PAYLOAD_SIZE = 1400;
    public static final byte FLAG_SYN = 1;
    public static final byte FLAG_ACK = 2;
    public static final byte FLAG_FIN = 4;
    public static final byte FLAG_RST = 8;
    public static final byte FLAG_DATA = 16;
    private final int sequenceNumber;
    private final int acknowledgmentNumber;
    private final byte flags;
    private final byte[] payload;
    private long sendTime;

    public UdpPacket(int sequenceNumber, int acknowledgmentNumber, byte flags, byte[] payload) {
        this.sequenceNumber = sequenceNumber;
        this.acknowledgmentNumber = acknowledgmentNumber;
        this.flags = flags;
        this.payload = payload != null ? payload : new byte[]{};
        this.sendTime = System.currentTimeMillis();
    }

    public int getSequenceNumber() {
        return this.sequenceNumber;
    }

    public int getAcknowledgmentNumber() {
        return this.acknowledgmentNumber;
    }

    public byte getFlags() {
        return this.flags;
    }

    public byte[] getPayload() {
        return this.payload;
    }

    public long getSendTime() {
        return this.sendTime;
    }

    public void updateSendTime() {
        this.sendTime = System.currentTimeMillis();
    }

    public boolean hasFlag(byte flag) {
        return (this.flags & flag) != 0;
    }

    public byte[] serialize() throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(baos);
        dos.writeInt(this.sequenceNumber);
        dos.writeInt(this.acknowledgmentNumber);
        dos.writeByte(this.flags);
        dos.writeInt(this.payload.length);
        dos.write(this.payload);
        return baos.toByteArray();
    }

    public static UdpPacket deserialize(byte[] data) throws IOException {
        ByteArrayInputStream bais = new ByteArrayInputStream(data);
        DataInputStream dis = new DataInputStream(bais);
        int seqNum = dis.readInt();
        int ackNum = dis.readInt();
        byte flags = dis.readByte();
        int payloadLength = dis.readInt();
        byte[] payload = new byte[payloadLength];
        dis.readFully(payload);
        return new UdpPacket(seqNum, ackNum, flags, payload);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("UdpPacket[seq=").append(this.sequenceNumber).append(", ack=").append(this.acknowledgmentNumber).append(", flags=");
        if (this.hasFlag((byte)1)) {
            sb.append("SYN ");
        }
        if (this.hasFlag((byte)2)) {
            sb.append("ACK ");
        }
        if (this.hasFlag((byte)4)) {
            sb.append("FIN ");
        }
        if (this.hasFlag((byte)8)) {
            sb.append("RST ");
        }
        if (this.hasFlag((byte)16)) {
            sb.append("DATA ");
        }
        sb.append(", payload=").append(this.payload.length).append("B]");
        return sb.toString();
    }
}

