/*
 * Decompiled with CFR 0.152.
 */
package voiidstudios.vct.api.update;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.URL;
import org.bukkit.event.Listener;
import voiidstudios.vct.VoiidCountdownTimer;
import voiidstudios.vct.api.update.UpdateCheckerResult;
import voiidstudios.vct.managers.MessagesManager;

public class UpdateChecker
implements Listener {
    private static final String API_URL = "https://api.github.com/repos/Voiid-Studios/voiidcountdown/releases/latest";
    private String currentVersion;
    private String latestVersion;

    public UpdateChecker(String currentVersion) {
        this.currentVersion = currentVersion;
    }

    public UpdateCheckerResult check() {
        MessagesManager msgManager = VoiidCountdownTimer.getMessagesManager();
        try {
            HttpURLConnection connection = (HttpURLConnection)new URL(API_URL).openConnection();
            connection.setRequestProperty("User-Agent", "Mozilla/5.0");
            connection.setConnectTimeout(10000);
            connection.setReadTimeout(10000);
            JsonObject release = JsonParser.parseReader((Reader)new InputStreamReader(connection.getInputStream())).getAsJsonObject();
            if (release.get("prerelease").getAsBoolean()) {
                return UpdateCheckerResult.noErrors(null);
            }
            String tag = release.get("tag_name").getAsString().replace("v", "").trim();
            if (!tag.startsWith("2")) {
                return UpdateCheckerResult.noErrors(null);
            }
            this.latestVersion = tag;
            if (!this.latestVersion.equalsIgnoreCase(this.currentVersion)) {
                return UpdateCheckerResult.noErrors(this.latestVersion);
            }
            msgManager.debug("&aYou are using the latest version! :D");
            return UpdateCheckerResult.noErrors(null);
        }
        catch (Exception ex) {
            return UpdateCheckerResult.error();
        }
    }

    public String getLatestVersion() {
        return this.latestVersion;
    }

    public String getCurrentVersion() {
        return this.currentVersion;
    }
}

