/*
 * Decompiled with CFR 0.152.
 */
package voiidstudios.vct.commands;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.Sound;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;
import voiidstudios.vct.VoiidCountdownTimer;
import voiidstudios.vct.api.Timer;
import voiidstudios.vct.api.VCTActions;
import voiidstudios.vct.api.VCTEvent;
import voiidstudios.vct.configs.model.TimerConfig;
import voiidstudios.vct.expansions.ExpansionManager;
import voiidstudios.vct.expansions.ExpansionMetadata;
import voiidstudios.vct.managers.MessagesManager;
import voiidstudios.vct.managers.TimerManager;

public class MainCommand
implements CommandExecutor,
TabCompleter {
    private static final String ADMIN_PERMISSION = "voiidcountdowntimer.admin";
    private static final Map<String, String> COMMAND_PERMISSIONS = new LinkedHashMap<String, String>();
    private static final List<String> ROOT_COMMANDS = new ArrayList<String>();

    static {
        COMMAND_PERMISSIONS.put("help", "voiidcountdowntimer.command.help");
        COMMAND_PERMISSIONS.put("reload", "voiidcountdowntimer.command.reload");
        COMMAND_PERMISSIONS.put("set", "voiidcountdowntimer.command.set");
        COMMAND_PERMISSIONS.put("pause", "voiidcountdowntimer.command.pause");
        COMMAND_PERMISSIONS.put("resume", "voiidcountdowntimer.command.resume");
        COMMAND_PERMISSIONS.put("stop", "voiidcountdowntimer.command.stop");
        COMMAND_PERMISSIONS.put("modify", "voiidcountdowntimer.command.modify");
        COMMAND_PERMISSIONS.put("expansion", "voiidcountdowntimer.command.expansion");
        ROOT_COMMANDS.addAll(COMMAND_PERMISSIONS.keySet());
    }

    public boolean onCommand(CommandSender sender, @NotNull Command command, @NotNull String alias, String[] args) {
        MessagesManager msgManager = VoiidCountdownTimer.getMessagesManager();
        ExpansionManager expansionManager = VoiidCountdownTimer.getExpansionManager();
        if (args.length >= 1) {
            String root = args[0].toLowerCase(Locale.ROOT);
            if (ROOT_COMMANDS.contains(root) && !this.hasCommandPermission(sender, root)) {
                msgManager.send(sender, "command.no_permissions");
                return true;
            }
            if (root.equals("help")) {
                this.help(sender);
                return true;
            }
            if (root.equals("reload")) {
                this.reload(sender, msgManager);
                return true;
            }
            if (root.equals("set")) {
                this.set(sender, args, msgManager);
                return true;
            }
            if (root.equals("pause")) {
                this.pause(sender, msgManager);
                return true;
            }
            if (root.equals("resume")) {
                this.resume(sender, msgManager);
                return true;
            }
            if (root.equals("stop")) {
                this.stop(sender);
                return true;
            }
            if (root.equals("modify")) {
                this.modify(sender, args, msgManager);
                return true;
            }
            if (root.equals("expansion")) {
                this.expansion(sender, args, expansionManager, msgManager);
                return true;
            }
        }
        if (expansionManager != null && expansionManager.executeCommand(sender, args)) {
            return true;
        }
        if (!this.hasCommandPermission(sender, "help")) {
            msgManager.send(sender, "command.no_permissions");
            return true;
        }
        this.help(sender);
        return true;
    }

    public void reload(CommandSender sender, MessagesManager msgManager) {
        VoiidCountdownTimer.getConfigsManager().reload();
        msgManager.send(sender, "command.reload");
        Timer.refreshTimerText();
    }

    public void set(CommandSender sender, String[] args, MessagesManager msgManager) {
        if (args.length < 2) {
            msgManager.send(sender, "timer.set.error");
            return;
        }
        String timeHHMMSS = args[1];
        String timerId = args.length >= 3 ? args[2] : null;
        Timer timer = VCTActions.createTimer(timeHHMMSS, timerId, sender);
        if (timer == null) {
            msgManager.send(sender, "timer.set.format_incorrect");
            return;
        }
        HashMap<String, String> repl = new HashMap<String, String>();
        repl.put("%HH%", String.format("%02d", Integer.parseInt(timer.getTimeLeftHH())));
        repl.put("%MM%", String.format("%02d", Integer.parseInt(timer.getTimeLeftMM())));
        repl.put("%SS%", String.format("%02d", Integer.parseInt(timer.getTimeLeftSS())));
        msgManager.send(sender, "timer_status.start", repl);
    }

    public void pause(CommandSender sender, MessagesManager msgManager) {
        Timer timer = TimerManager.getInstance().getTimer();
        if (timer == null) {
            msgManager.send(sender, "timer_status.not_exists");
            return;
        }
        timer.pause();
        msgManager.send(sender, "timer_status.pause");
        Bukkit.getPluginManager().callEvent((Event)new VCTEvent(timer, VCTEvent.VCTEventType.PAUSE, sender));
    }

    public void resume(CommandSender sender, MessagesManager msgManager) {
        Timer timer = TimerManager.getInstance().getTimer();
        if (timer == null) {
            msgManager.send(sender, "timer_status.not_exists");
            return;
        }
        timer.resume();
        msgManager.send(sender, "timer_status.resume");
        Bukkit.getPluginManager().callEvent((Event)new VCTEvent(timer, VCTEvent.VCTEventType.RESUME, sender));
    }

    public void stop(CommandSender sender) {
        TimerManager.getInstance().deleteTimer(sender);
    }

    public void modify(CommandSender sender, String[] args, MessagesManager msgManager) {
        String modifier;
        if (args.length < 2) {
            msgManager.sendSection(sender, "timer.modify.help", true, null);
            return;
        }
        Timer timer = TimerManager.getInstance().getTimer();
        if (timer == null) {
            msgManager.send(sender, "timer_status.not_exists");
            return;
        }
        switch (modifier = args[1].toLowerCase()) {
            case "add": {
                if (args.length < 3) {
                    msgManager.send(sender, "timer.modify.add.error");
                    return;
                }
                int totalSecondsToAdd = VCTActions.helper_parseTimeToSeconds(args[2]);
                int addHours = 0;
                int addMinutes = 0;
                int addSeconds = 0;
                addHours = totalSecondsToAdd / 3600;
                addMinutes = totalSecondsToAdd % 3600 / 60;
                addSeconds = totalSecondsToAdd % 60;
                if (addHours < 0 || addMinutes < 0 || addMinutes > 59 || addSeconds < 0 || addSeconds > 59) {
                    msgManager.send(sender, "timer.set.format_incorrect");
                    return;
                }
                if (totalSecondsToAdd == 0) {
                    msgManager.send(sender, "timer.set.format_out_range");
                    return;
                }
                boolean addSuccess = VCTActions.modifyTimer("add", args[2], sender);
                if (!addSuccess) {
                    msgManager.send(sender, "timer_status.not_exists");
                    return;
                }
                HashMap<String, String> addRepl = new HashMap<String, String>();
                addRepl.put("%HH%", String.format("%02d", addHours));
                addRepl.put("%MM%", String.format("%02d", addMinutes));
                addRepl.put("%SS%", String.format("%02d", addSeconds));
                msgManager.send(sender, "timer.modify.add.success", addRepl);
                return;
            }
            case "set": {
                if (args.length < 3) {
                    msgManager.send(sender, "timer.modify.set.error");
                    return;
                }
                int totalSecondsToSet = VCTActions.helper_parseTimeToSeconds(args[2]);
                int setHours = 0;
                int setMinutes = 0;
                int setSeconds = 0;
                setHours = totalSecondsToSet / 3600;
                setMinutes = totalSecondsToSet % 3600 / 60;
                setSeconds = totalSecondsToSet % 60;
                if (setHours < 0 || setMinutes < 0 || setMinutes > 59 || setSeconds < 0 || setSeconds > 59) {
                    msgManager.send(sender, "timer.set.format_incorrect");
                    return;
                }
                boolean setSuccess = VCTActions.modifyTimer("set", args[2], sender);
                if (!setSuccess) {
                    msgManager.send(sender, "timer_status.not_exists");
                    return;
                }
                HashMap<String, String> setRepl = new HashMap<String, String>();
                setRepl.put("%HH%", String.format("%02d", setHours));
                setRepl.put("%MM%", String.format("%02d", setMinutes));
                setRepl.put("%SS%", String.format("%02d", setSeconds));
                msgManager.send(sender, "timer.modify.set.success", setRepl);
                return;
            }
            case "take": {
                if (args.length < 3) {
                    msgManager.send(sender, "timer.modify.take.error");
                    return;
                }
                int totalSecondsToTake = VCTActions.helper_parseTimeToSeconds(args[2]);
                int takeHours = 0;
                int takeMinutes = 0;
                int takeSeconds = 0;
                takeHours = totalSecondsToTake / 3600;
                takeMinutes = totalSecondsToTake % 3600 / 60;
                takeSeconds = totalSecondsToTake % 60;
                if (takeHours < 0 || takeMinutes < 0 || takeMinutes > 59 || takeSeconds < 0 || takeSeconds > 59) {
                    msgManager.send(sender, "timer.set.format_incorrect");
                    return;
                }
                boolean takeSuccess = VCTActions.modifyTimer("take", args[2], sender);
                if (!takeSuccess) {
                    msgManager.send(sender, "timer_status.not_exists");
                    return;
                }
                HashMap<String, String> takeRepl = new HashMap<String, String>();
                takeRepl.put("%HH%", String.format("%02d", takeHours));
                takeRepl.put("%MM%", String.format("%02d", takeMinutes));
                takeRepl.put("%SS%", String.format("%02d", takeSeconds));
                msgManager.send(sender, "timer.modify.take.success", takeRepl);
                return;
            }
            case "bossbar_color": {
                if (args.length < 3) {
                    msgManager.send(sender, "timer.modify.bossbar_color.error");
                    return;
                }
                String colorName = args[2].toUpperCase();
                boolean bcSuccess = VCTActions.modifyTimer("bossbar_color", colorName, sender);
                if (bcSuccess) {
                    HashMap<String, String> barcolorRepl = new HashMap<String, String>();
                    barcolorRepl.put("%TIMER%", timer.getTimerId());
                    barcolorRepl.put("%COLOR%", colorName);
                    msgManager.send(sender, "timer.modify.bossbar_color.success", barcolorRepl);
                } else {
                    HashMap<String, String> barcolorInvRepl = new HashMap<String, String>();
                    barcolorInvRepl.put("%COLOR%", colorName);
                    msgManager.send(sender, "timer.modify.bossbar_color.invalid", barcolorInvRepl);
                }
                return;
            }
            case "bossbar_style": {
                if (args.length < 3) {
                    msgManager.send(sender, "timer.modify.bossbar_style.error");
                    return;
                }
                String styleName = args[2].toUpperCase();
                boolean bsSuccess = VCTActions.modifyTimer("bossbar_style", styleName, sender);
                if (bsSuccess) {
                    HashMap<String, String> barstyleRepl = new HashMap<String, String>();
                    barstyleRepl.put("%TIMER%", timer.getTimerId());
                    barstyleRepl.put("%STYLE%", styleName);
                    msgManager.send(sender, "timer.modify.bossbar_style.success", barstyleRepl);
                } else {
                    HashMap<String, String> barstyleInvRepl = new HashMap<String, String>();
                    barstyleInvRepl.put("%STYLE%", styleName);
                    msgManager.send(sender, "timer.modify.bossbar_style.invalid", barstyleInvRepl);
                }
                return;
            }
            case "sound": {
                if (args.length < 3) {
                    msgManager.send(sender, "timer.modify.sound.error");
                    return;
                }
                ArrayList<String> parts = new ArrayList<String>();
                int i = 2;
                while (i < args.length) {
                    parts.add(args[i]);
                    ++i;
                }
                String rawSound = String.join((CharSequence)" ", parts).trim();
                if (!rawSound.startsWith("\"") || !rawSound.endsWith("\"") || rawSound.length() < 2) {
                    msgManager.send(sender, "timer.modify.sound.require_quotes");
                    return;
                }
                rawSound = rawSound.substring(1, rawSound.length() - 1).trim();
                if (rawSound.isEmpty()) {
                    return;
                }
                boolean isVanillaSound = false;
                try {
                    String enumName = rawSound.toUpperCase(Locale.ROOT).replace(':', '_');
                    Sound.valueOf((String)enumName);
                    isVanillaSound = true;
                }
                catch (IllegalArgumentException enumName) {
                    // empty catch block
                }
                boolean soundSuccess = VCTActions.modifyTimer("sound", rawSound, sender);
                if (soundSuccess) {
                    HashMap<String, String> soundRepl = new HashMap<String, String>();
                    soundRepl.put("%TIMER%", timer.getTimerId());
                    soundRepl.put("%SOUND%", rawSound);
                    soundRepl.put("%TYPE%", isVanillaSound ? "vanilla" : "custom");
                    msgManager.send(sender, "timer.modify.sound.success", soundRepl);
                } else {
                    msgManager.send(sender, "timer.modify.sound.error");
                }
                return;
            }
            case "sound_enable": {
                if (args.length < 3) {
                    msgManager.send(sender, "timer.modify.sound_enable.error");
                    return;
                }
                String value = args[2].toLowerCase();
                boolean seSuccess = VCTActions.modifyTimer("sound_enable", value, sender);
                if (seSuccess) {
                    HashMap<String, String> soundenableRepl = new HashMap<String, String>();
                    soundenableRepl.put("%TIMER%", timer.getTimerId());
                    soundenableRepl.put("%SOUNDENABLE%", value);
                    msgManager.send(sender, "timer.modify.sound_enable.success", soundenableRepl);
                } else {
                    msgManager.send(sender, "timer.modify.sound_enable.invalid");
                }
                return;
            }
            case "sound_volume": {
                float newVolume;
                if (args.length < 3) {
                    msgManager.send(sender, "timer.modify.sound_volume.error");
                    return;
                }
                try {
                    newVolume = Float.parseFloat(args[2]);
                }
                catch (NumberFormatException e) {
                    msgManager.send(sender, "timer.modify.sound_volume.invalid");
                    return;
                }
                if (newVolume < 0.1f || newVolume > 2.0f) {
                    msgManager.send(sender, "timer.modify.sound_volume.out_range");
                    return;
                }
                boolean svSuccess = VCTActions.modifyTimer("sound_volume", String.valueOf(newVolume), sender);
                if (svSuccess) {
                    HashMap<String, String> repl = new HashMap<String, String>();
                    repl.put("%TIMER%", timer.getTimerId());
                    repl.put("%VOLUME%", String.valueOf(newVolume));
                    msgManager.send(sender, "timer.modify.sound_volume.success", repl);
                }
                return;
            }
            case "sound_pitch": {
                float newPitch;
                if (args.length < 3) {
                    msgManager.send(sender, "timer.modify.sound_pitch.error");
                    return;
                }
                try {
                    newPitch = Float.parseFloat(args[2]);
                }
                catch (NumberFormatException e) {
                    msgManager.send(sender, "timer.modify.sound_pitch.invalid");
                    return;
                }
                if (newPitch < 0.1f || newPitch > 2.0f) {
                    msgManager.send(sender, "timer.modify.sound_pitch.out_range");
                    return;
                }
                boolean spSuccess = VCTActions.modifyTimer("sound_pitch", String.valueOf(newPitch), sender);
                if (spSuccess) {
                    HashMap<String, String> repl = new HashMap<String, String>();
                    repl.put("%TIMER%", timer.getTimerId());
                    repl.put("%PITCH%", String.valueOf(newPitch));
                    msgManager.send(sender, "timer.modify.sound_pitch.success", repl);
                }
                return;
            }
            case "text": {
                if (args.length < 3) {
                    msgManager.send(sender, "timer.modify.text.error");
                    return;
                }
                ArrayList<String> parts = new ArrayList<String>();
                int i = 2;
                while (i < args.length) {
                    parts.add(args[i]);
                    ++i;
                }
                String rawText = String.join((CharSequence)" ", parts).trim();
                if (!rawText.startsWith("\"") || !rawText.endsWith("\"") || rawText.length() < 2) {
                    msgManager.send(sender, "timer.modify.text.require_quotes");
                    return;
                }
                rawText = rawText.substring(1, rawText.length() - 1);
                if (rawText.isEmpty()) {
                    return;
                }
                boolean textSuccess = VCTActions.modifyTimer("text", rawText, sender);
                if (textSuccess) {
                    HashMap<String, String> repl = new HashMap<String, String>();
                    repl.put("%TIMER%", timer.getTimerId());
                    repl.put("%TEXT%", rawText);
                    msgManager.send(sender, "timer.modify.text.success", repl);
                }
                return;
            }
        }
        msgManager.send(sender, "timer.modify.invalid");
    }

    private void expansion(CommandSender sender, String[] args, ExpansionManager expansionManager, MessagesManager msgManager) {
        if (expansionManager == null) {
            msgManager.send(sender, "expansion.disabled");
            return;
        }
        if (args.length < 2) {
            msgManager.sendSection(sender, "expansion.help", true, null);
            return;
        }
        String action = args[1].toLowerCase(Locale.ROOT);
        String targetName = args.length >= 3 ? args[2] : null;
        switch (action) {
            case "info": {
                if (targetName == null) {
                    msgManager.send(sender, "expansion.no_id_specified");
                    return;
                }
                ExpansionMetadata infoMetadata = expansionManager.getExpansionMetadata(targetName);
                if (infoMetadata == null) {
                    HashMap<String, String> expansionInfoNotFoundRepl = new HashMap<String, String>();
                    expansionInfoNotFoundRepl.put("%EXPANSION%", targetName);
                    msgManager.send(sender, "expansion.not_found", expansionInfoNotFoundRepl);
                    return;
                }
                boolean infoLoaded = expansionManager.isExpansionLoaded(infoMetadata.getName());
                List<String> authors = infoMetadata.getAuthors();
                String authorsText = authors.isEmpty() ? "N/A" : String.join((CharSequence)"&7, &f", authors);
                String description = infoMetadata.getDescription();
                if (description == null || description.trim().isEmpty()) {
                    description = "No description.";
                }
                HashMap<String, String> repl = new HashMap<String, String>();
                repl.put("%EXPANSION%", infoMetadata.getName());
                repl.put("%STATUS%", infoLoaded ? "Enabled" : "Disabled");
                repl.put("%STATUSCOLOR%", infoLoaded ? "&a" : "&c");
                repl.put("%AUTHORS%", authorsText);
                repl.put("%VERSION%", infoMetadata.getVersion());
                repl.put("%DESCRIPTION%", description);
                msgManager.sendSection(sender, "expansion.info", true, repl);
                return;
            }
            case "enable": {
                if (targetName == null) {
                    msgManager.send(sender, "expansion.no_id_specified");
                    return;
                }
                ExpansionMetadata enableMetadata = expansionManager.getExpansionMetadata(targetName);
                if (enableMetadata == null) {
                    HashMap<String, String> expansionEnableNotFoundRepl = new HashMap<String, String>();
                    expansionEnableNotFoundRepl.put("%EXPANSION%", targetName);
                    msgManager.send(sender, "expansion.not_found", expansionEnableNotFoundRepl);
                    return;
                }
                if (expansionManager.isExpansionLoaded(enableMetadata.getName())) {
                    HashMap<String, String> expansionEnableAlreadyEnabledRepl = new HashMap<String, String>();
                    expansionEnableAlreadyEnabledRepl.put("%EXPANSION%", targetName);
                    msgManager.send(sender, "expansion.enable.already_enabled", expansionEnableAlreadyEnabledRepl);
                    return;
                }
                if (expansionManager.enableExpansion(enableMetadata.getName())) {
                    HashMap<String, String> expansionEnableRepl = new HashMap<String, String>();
                    expansionEnableRepl.put("%EXPANSION%", targetName);
                    msgManager.send(sender, "expansion.enable.success", expansionEnableRepl);
                } else {
                    HashMap<String, String> expansionEnableErrorRepl = new HashMap<String, String>();
                    expansionEnableErrorRepl.put("%EXPANSION%", targetName);
                    msgManager.send(sender, "expansion.enable.error", expansionEnableErrorRepl);
                }
                return;
            }
            case "disable": {
                if (targetName == null) {
                    msgManager.send(sender, "expansion.no_id_specified");
                    return;
                }
                ExpansionMetadata disableMetadata = expansionManager.getExpansionMetadata(targetName);
                if (disableMetadata == null) {
                    HashMap<String, String> expansionDisableNotFoundRepl = new HashMap<String, String>();
                    expansionDisableNotFoundRepl.put("%EXPANSION%", targetName);
                    msgManager.send(sender, "expansion.not_found", expansionDisableNotFoundRepl);
                    return;
                }
                if (!expansionManager.isExpansionLoaded(disableMetadata.getName())) {
                    HashMap<String, String> expansionDisableAlreadyDisabledRepl = new HashMap<String, String>();
                    expansionDisableAlreadyDisabledRepl.put("%EXPANSION%", targetName);
                    msgManager.send(sender, "expansion.disable.already_disabled", expansionDisableAlreadyDisabledRepl);
                    return;
                }
                if (expansionManager.disableExpansion(disableMetadata.getName())) {
                    HashMap<String, String> expansionDisableRepl = new HashMap<String, String>();
                    expansionDisableRepl.put("%EXPANSION%", targetName);
                    msgManager.send(sender, "expansion.disable.success", expansionDisableRepl);
                } else {
                    HashMap<String, String> expansionDisableErrorRepl = new HashMap<String, String>();
                    expansionDisableErrorRepl.put("%EXPANSION%", targetName);
                    msgManager.send(sender, "expansion.disable.error", expansionDisableErrorRepl);
                }
                return;
            }
            case "reload": {
                if (targetName == null) {
                    msgManager.send(sender, "expansion.no_id_specified");
                    return;
                }
                ExpansionMetadata reloadMetadata = expansionManager.getExpansionMetadata(targetName);
                if (reloadMetadata == null) {
                    HashMap<String, String> expansionReloadNotFoundRepl = new HashMap<String, String>();
                    expansionReloadNotFoundRepl.put("%EXPANSION%", targetName);
                    msgManager.send(sender, "expansion.not_found", expansionReloadNotFoundRepl);
                    return;
                }
                if (!expansionManager.isExpansionLoaded(reloadMetadata.getName())) {
                    HashMap<String, String> expansionReloadDisabledRepl = new HashMap<String, String>();
                    expansionReloadDisabledRepl.put("%EXPANSION%", targetName);
                    msgManager.send(sender, "expansion.reload.disabled", expansionReloadDisabledRepl);
                    return;
                }
                if (expansionManager.reloadExpansion(reloadMetadata.getName())) {
                    HashMap<String, String> expansionReloadRepl = new HashMap<String, String>();
                    expansionReloadRepl.put("%EXPANSION%", targetName);
                    msgManager.send(sender, "expansion.reload.success", expansionReloadRepl);
                } else {
                    HashMap<String, String> expansionReloadErrorRepl = new HashMap<String, String>();
                    expansionReloadErrorRepl.put("%EXPANSION%", targetName);
                    msgManager.send(sender, "expansion.reload.error", expansionReloadErrorRepl);
                }
                return;
            }
            case "reloadall": {
                int reloaded = expansionManager.reloadAllExpansions();
                if (reloaded == 0) {
                    msgManager.send(sender, "expansion.reloadall.error");
                } else {
                    HashMap<String, String> expansionReloadallRepl = new HashMap<String, String>();
                    expansionReloadallRepl.put("%EXPANSIONS%", targetName);
                    msgManager.send(sender, "expansion.reloadall.success", expansionReloadallRepl);
                }
                return;
            }
        }
        msgManager.send(sender, "expansion.reloadall.invalid");
    }

    public void help(CommandSender sender) {
        HashMap<String, String> repl = new HashMap<String, String>();
        repl.put("%VERSION%", VoiidCountdownTimer.getInstance().getDescription().getVersion());
        VoiidCountdownTimer.getMessagesManager().sendSection(sender, "command.help", true, repl);
        ExpansionManager expansionManager = VoiidCountdownTimer.getExpansionManager();
        if (expansionManager != null) {
            for (String line : expansionManager.getHelpLines()) {
                sender.sendMessage(VoiidCountdownTimer.getMessagesManager().color(line));
            }
        }
    }

    public List<String> onTabComplete(CommandSender sender, @NotNull Command command, @NotNull String label, String[] args) {
        List<String> expansionCompletions;
        boolean hasAdmin;
        ExpansionManager expansionManager = VoiidCountdownTimer.getExpansionManager();
        boolean bl = hasAdmin = sender.isOp() || sender.hasPermission(ADMIN_PERMISSION);
        if (args.length == 1) {
            LinkedHashSet<String> completions = new LinkedHashSet<String>();
            if (hasAdmin) {
                ArrayList<String> commands = new ArrayList<String>();
                commands.add("help");
                commands.add("reload");
                commands.add("set");
                commands.add("pause");
                commands.add("resume");
                commands.add("stop");
                commands.add("modify");
                commands.add("expansion");
                for (String c : commands) {
                    if (!args[0].isEmpty() && !c.startsWith(args[0].toLowerCase())) continue;
                    completions.add(c);
                }
            }
            if (expansionManager != null) {
                completions.addAll(expansionManager.getRootSuggestions(args[0]));
            }
            return completions.isEmpty() ? null : new ArrayList(completions);
        }
        if (hasAdmin) {
            ArrayList<String> subcompletions;
            if (args.length == 2) {
                subcompletions = new ArrayList<String>();
                ArrayList<String> subcommands = new ArrayList<String>();
                if (args[0].equalsIgnoreCase("modify")) {
                    subcommands.add("add");
                    subcommands.add("set");
                    subcommands.add("take");
                    subcommands.add("bossbar_color");
                    subcommands.add("bossbar_style");
                    subcommands.add("sound");
                    subcommands.add("sound_enable");
                    subcommands.add("sound_volume");
                    subcommands.add("sound_pitch");
                    subcommands.add("text");
                } else if (args[0].equalsIgnoreCase("set")) {
                    subcommands.add("<HH:MM:SS>");
                } else if (args[0].equalsIgnoreCase("expansion")) {
                    subcommands.add("info");
                    subcommands.add("enable");
                    subcommands.add("disable");
                    subcommands.add("reload");
                    subcommands.add("reloadall");
                }
                for (String c : subcommands) {
                    if (!args[1].isEmpty() && !c.startsWith(args[1].toLowerCase())) continue;
                    subcompletions.add(c);
                }
                if (!subcompletions.isEmpty()) {
                    return subcompletions;
                }
            } else if (args.length == 3) {
                List<String> timers;
                String action;
                if (args[0].equalsIgnoreCase("expansion") && expansionManager != null && !(action = args[1].toLowerCase(Locale.ROOT)).equals("reloadall")) {
                    List<String> names = expansionManager.getKnownExpansionNames();
                    ArrayList<String> matches = new ArrayList<String>();
                    for (String name : names) {
                        if (!args[2].isEmpty() && !name.toLowerCase(Locale.ROOT).startsWith(args[2].toLowerCase(Locale.ROOT))) continue;
                        matches.add(name);
                    }
                    if (!matches.isEmpty()) {
                        return matches;
                    }
                }
                subcompletions = new ArrayList();
                ArrayList<String> subcommands = new ArrayList<String>();
                if (args[0].equalsIgnoreCase("modify")) {
                    if (args[1].equalsIgnoreCase("bossbar_color")) {
                        subcommands.add("BLUE");
                        subcommands.add("GREEN");
                        subcommands.add("PINK");
                        subcommands.add("PURPLE");
                        subcommands.add("RED");
                        subcommands.add("WHITE");
                        subcommands.add("YELLOW");
                    } else if (args[1].equalsIgnoreCase("bossbar_style")) {
                        subcommands.add("SOLID");
                        subcommands.add("SEGMENTED_6");
                        subcommands.add("SEGMENTED_10");
                        subcommands.add("SEGMENTED_12");
                        subcommands.add("SEGMENTED_20");
                    } else if (args[1].equalsIgnoreCase("sound")) {
                        subcommands.add("<\"sound in quotes\">");
                    } else if (args[1].equalsIgnoreCase("sound_enable")) {
                        subcommands.add("true");
                        subcommands.add("false");
                    } else if (args[1].equalsIgnoreCase("sound_volume") || args[1].equalsIgnoreCase("sound_pitch")) {
                        subcommands.add("<0.1 - 2.0>");
                    } else if (args[1].equalsIgnoreCase("text")) {
                        subcommands.add("<\"text in quotes\">");
                    } else if (args[1].equalsIgnoreCase("add") || args[1].equalsIgnoreCase("set") || args[1].equalsIgnoreCase("take")) {
                        subcommands.add("<HH:MM:SS>");
                    }
                } else if (args[0].equalsIgnoreCase("set") && (timers = this.getTimersCompletions(args, 2, true)) != null) {
                    return timers;
                }
                for (String c : subcommands) {
                    if (!args[2].isEmpty() && !c.startsWith(args[1].toLowerCase())) continue;
                    subcompletions.add(c);
                }
                if (!subcompletions.isEmpty()) {
                    return subcompletions;
                }
            }
        }
        if (expansionManager != null && (expansionCompletions = expansionManager.getTabCompletions(sender, args)) != null && !expansionCompletions.isEmpty()) {
            return expansionCompletions;
        }
        return null;
    }

    private boolean hasCommandPermission(CommandSender sender, String commandKey) {
        if (sender.isOp() || sender.hasPermission(ADMIN_PERMISSION)) {
            return true;
        }
        String permission = COMMAND_PERMISSIONS.get(commandKey);
        if (permission == null) {
            return false;
        }
        return sender.hasPermission(permission);
    }

    public List<String> getTimersCompletions(String[] args, int argTimerPos, boolean onlyEnabled) {
        ArrayList<String> completions = new ArrayList<String>();
        String argTimer = args[argTimerPos].toLowerCase();
        Map<String, TimerConfig> timers = VoiidCountdownTimer.getConfigsManager().getAllTimerConfigs();
        if (timers != null) {
            for (Map.Entry<String, TimerConfig> entry : timers.entrySet()) {
                String id = entry.getKey();
                TimerConfig cfg = entry.getValue();
                if (cfg == null || onlyEnabled && !cfg.isEnabled() || !argTimer.isEmpty() && !id.toLowerCase().startsWith(argTimer)) continue;
                completions.add(id);
            }
        }
        return completions.isEmpty() ? null : completions;
    }
}

