/*
 * Decompiled with CFR 0.152.
 */
package voiidstudios.vct.configs;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import org.bukkit.boss.BarColor;
import org.bukkit.boss.BarStyle;
import org.bukkit.configuration.file.FileConfiguration;
import voiidstudios.vct.VoiidCountdownTimer;
import voiidstudios.vct.configs.CoreFolderConfigManager;
import voiidstudios.vct.configs.MainConfigManager;
import voiidstudios.vct.configs.TimersFolderConfigManager;
import voiidstudios.vct.configs.model.CustomConfig;
import voiidstudios.vct.configs.model.TimerConfig;

public class ConfigsManager {
    private final MainConfigManager mainConfigManager;
    private final TimersFolderConfigManager timerFolderConfigManager;
    private final CoreFolderConfigManager coreFolderConfigManager;
    private final Map<String, TimerConfig> timersConfigs = new LinkedHashMap<String, TimerConfig>();

    public ConfigsManager(VoiidCountdownTimer plugin) {
        this.mainConfigManager = new MainConfigManager(plugin);
        this.timerFolderConfigManager = new TimersFolderConfigManager(plugin, "timers");
        this.coreFolderConfigManager = new CoreFolderConfigManager(plugin, "core");
    }

    public void configure() {
        this.coreFolderConfigManager.configure();
        this.mainConfigManager.configure();
        this.timerFolderConfigManager.configure();
        this.configureTimers();
    }

    public boolean reload() {
        try {
            this.mainConfigManager.reloadConfig();
            this.configureTimers();
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public void configureTimers() {
        this.timersConfigs.clear();
        ArrayList<CustomConfig> vctTimers = this.getTimersConfigs();
        for (CustomConfig configFile : vctTimers) {
            FileConfiguration config = configFile.getConfig();
            if (!config.contains("Timers")) continue;
            for (String key : config.getConfigurationSection("Timers").getKeys(false)) {
                BarStyle style;
                BarColor color;
                String base = "Timers." + key + ".";
                if (!config.contains(String.valueOf(base) + "text")) {
                    config.set(String.valueOf(base) + "text", (Object)"%HH%:%MM%:%SS%");
                }
                if (!config.contains(String.valueOf(base) + "sound")) {
                    config.set(String.valueOf(base) + "sound", (Object)"UI_BUTTON_CLICK");
                }
                if (!config.contains(String.valueOf(base) + "sound_volume")) {
                    config.set(String.valueOf(base) + "sound_volume", (Object)1.0);
                }
                if (!config.contains(String.valueOf(base) + "sound_pitch")) {
                    config.set(String.valueOf(base) + "sound_pitch", (Object)1.0);
                }
                if (!config.contains(String.valueOf(base) + "bossbar_color")) {
                    config.set(String.valueOf(base) + "bossbar_color", (Object)"WHITE");
                }
                if (!config.contains(String.valueOf(base) + "bossbar_style")) {
                    config.set(String.valueOf(base) + "bossbar_style", (Object)"SOLID");
                }
                if (!config.contains(String.valueOf(base) + "format")) {
                    config.set(String.valueOf(base) + "format", (Object)"COUNTDOWN");
                }
                if (!config.contains(String.valueOf(base) + "enabled")) {
                    config.set(String.valueOf(base) + "enabled", (Object)true);
                }
                if (!config.contains(String.valueOf(base) + "sound_enabled")) {
                    config.set(String.valueOf(base) + "sound_enabled", (Object)false);
                }
                configFile.saveConfig();
                boolean enabled = config.getBoolean(String.valueOf(base) + "enabled", true);
                boolean soundEnabled = config.getBoolean(String.valueOf(base) + "sound_enabled", false);
                String text = config.getString(String.valueOf(base) + "text", "%HH%:%MM%:%SS%");
                String sound = config.getString(String.valueOf(base) + "sound", "UI_BUTTON_CLICK");
                float soundVolume = (float)config.getDouble(String.valueOf(base) + "sound_volume", 1.0);
                float soundPitch = (float)config.getDouble(String.valueOf(base) + "sound_pitch", 1.0);
                String colorStr = config.getString(String.valueOf(base) + "bossbar_color", "WHITE");
                String styleStr = config.getString(String.valueOf(base) + "bossbar_style", "SOLID");
                String formatStr = config.getString(String.valueOf(base) + "format", "COUNTDOWN");
                try {
                    color = BarColor.valueOf((String)colorStr.toUpperCase());
                }
                catch (Exception e) {
                    color = BarColor.WHITE;
                }
                try {
                    style = BarStyle.valueOf((String)styleStr.toUpperCase());
                }
                catch (Exception e) {
                    style = BarStyle.SOLID;
                }
                String format = TimerConfig.normalizeFormat(formatStr);
                TimerConfig tc = new TimerConfig(key, text, sound, color, style, format, enabled, soundEnabled, soundVolume, soundPitch);
                this.timersConfigs.put(key, tc);
            }
        }
    }

    public void saveTimerConfig(TimerConfig tc) {
        for (CustomConfig configFile : this.getTimersConfigs()) {
            String base;
            FileConfiguration config = configFile.getConfig();
            if (!config.contains(base = "Timers." + tc.getId() + ".")) continue;
            config.set(String.valueOf(base) + "enabled", (Object)tc.isEnabled());
            config.set(String.valueOf(base) + "sound_enabled", (Object)tc.isSoundEnabled());
            config.set(String.valueOf(base) + "text", (Object)tc.getText());
            config.set(String.valueOf(base) + "sound", (Object)tc.getSound());
            config.set(String.valueOf(base) + "sound_volume", (Object)Float.valueOf(tc.getSoundVolume()));
            config.set(String.valueOf(base) + "sound_pitch", (Object)Float.valueOf(tc.getSoundPitch()));
            config.set(String.valueOf(base) + "bossbar_color", (Object)tc.getColor().toString());
            config.set(String.valueOf(base) + "bossbar_style", (Object)tc.getStyle().toString());
            config.set(String.valueOf(base) + "format", (Object)TimerConfig.normalizeFormat(tc.getFormat()));
            configFile.saveConfig();
            break;
        }
    }

    public TimerConfig getTimerConfig(String id) {
        return this.timersConfigs.get(id);
    }

    public Map<String, TimerConfig> getAllTimerConfigs() {
        return new LinkedHashMap<String, TimerConfig>(this.timersConfigs);
    }

    public ArrayList<CustomConfig> getTimersConfigs() {
        ArrayList<CustomConfig> timers = new ArrayList<CustomConfig>();
        timers.add(this.mainConfigManager.getConfigFile());
        timers.addAll(this.timerFolderConfigManager.getConfigs());
        return timers;
    }

    public MainConfigManager getMainConfigManager() {
        return this.mainConfigManager;
    }
}

