/*
 * Decompiled with CFR 0.152.
 */
package voiidstudios.vct.configs;

import java.io.File;
import java.util.ArrayList;
import voiidstudios.vct.VoiidCountdownTimer;
import voiidstudios.vct.configs.model.CustomConfig;

public abstract class DataFolderConfigManager {
    protected String folderName;
    protected VoiidCountdownTimer plugin;

    public DataFolderConfigManager(VoiidCountdownTimer plugin, String folderName) {
        this.plugin = plugin;
        this.folderName = folderName;
    }

    public void configure() {
        this.createFolder();
        this.loadConfigs();
    }

    public void createFolder() {
        File folder = new File(this.plugin.getDataFolder(), this.folderName);
        folder.mkdirs();
        this.createFiles();
    }

    public CustomConfig getConfigFile(String pathName) {
        CustomConfig customConfig = new CustomConfig(pathName, this.plugin, this.folderName, true);
        customConfig.registerConfig();
        return customConfig;
    }

    public ArrayList<CustomConfig> getConfigs() {
        File[] listOfFiles;
        ArrayList<CustomConfig> configs = new ArrayList<CustomConfig>();
        String pathFile = this.plugin.getDataFolder() + File.separator + this.folderName;
        File folder = new File(pathFile);
        File[] fileArray = listOfFiles = folder.listFiles();
        int n = listOfFiles.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (file.isFile()) {
                String pathName = file.getName();
                CustomConfig commonConfig = new CustomConfig(pathName, this.plugin, this.folderName, true);
                commonConfig.registerConfig();
                configs.add(commonConfig);
            }
            ++n2;
        }
        return configs;
    }

    public abstract void createFiles();

    public abstract void loadConfigs();

    public abstract void saveConfigs();
}

