/*
 * Decompiled with CFR 0.152.
 */
package voiidstudios.vct.expansions.command;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.logging.Level;
import org.bukkit.command.CommandSender;
import org.openjdk.nashorn.api.scripting.ScriptObjectMirror;
import voiidstudios.vct.VoiidCountdownTimer;
import voiidstudios.vct.expansions.ScriptExpansion;
import voiidstudios.vct.managers.MessagesManager;

public class ExpansionCommand {
    private final ScriptExpansion expansion;
    private final String name;
    private final List<String> aliases;
    private final String description;
    private final String usage;
    private final String permission;
    private final ScriptObjectMirror executor;
    private final ScriptObjectMirror tabCompleter;

    public ExpansionCommand(ScriptExpansion expansion, String name, List<String> aliases, String description, String usage, String permission, ScriptObjectMirror executor, ScriptObjectMirror tabCompleter) {
        this.expansion = expansion;
        this.name = name;
        this.aliases = aliases == null ? Collections.emptyList() : Collections.unmodifiableList(new ArrayList<String>(aliases));
        this.description = description == null ? "" : description;
        this.usage = usage == null ? "" : usage;
        this.permission = permission == null ? "" : permission;
        this.executor = executor;
        this.tabCompleter = tabCompleter;
    }

    public String getName() {
        return this.name;
    }

    public List<String> getAliases() {
        return this.aliases;
    }

    public ScriptExpansion getExpansion() {
        return this.expansion;
    }

    public String getDescription() {
        return this.description;
    }

    public String getUsage() {
        return this.usage;
    }

    public List<String> getAllIdentifiers() {
        ArrayList<String> identifiers = new ArrayList<String>();
        identifiers.add(this.name);
        identifiers.addAll(this.aliases);
        return identifiers;
    }

    public boolean execute(CommandSender sender, String[] args) {
        MessagesManager msgManager = VoiidCountdownTimer.getMessagesManager();
        if (this.executor == null) {
            return false;
        }
        if (this.permission != null && !this.permission.isEmpty() && !sender.hasPermission(this.permission)) {
            msgManager.send(sender, "command.no_permissions");
            return true;
        }
        try {
            Object result = this.expansion.callFunction(this.executor, sender, args);
            if (result instanceof Boolean) {
                return (Boolean)result;
            }
            return true;
        }
        catch (Throwable throwable) {
            this.expansion.getPlugin().getLogger().log(Level.SEVERE, String.format(Locale.ROOT, "Failed to execute expansion command '%s' from %s", this.name, this.expansion.getMetadata().getName()), throwable);
            msgManager.send(sender, "expansion.expansion_command.error");
            return true;
        }
    }

    public List<String> tabComplete(CommandSender sender, String[] args) {
        if (this.tabCompleter == null) {
            return Collections.emptyList();
        }
        if (this.permission != null && !this.permission.isEmpty() && !sender.hasPermission(this.permission)) {
            return Collections.emptyList();
        }
        try {
            Object result = this.expansion.callFunction(this.tabCompleter, sender, args);
            return this.expansion.convertToStringList(result);
        }
        catch (Throwable throwable) {
            this.expansion.getPlugin().getLogger().log(Level.SEVERE, String.format(Locale.ROOT, "Failed to tab-complete expansion command '%s' from %s", this.name, this.expansion.getMetadata().getName()), throwable);
            return Collections.emptyList();
        }
    }
}

