/*
 * Decompiled with CFR 0.152.
 */
package voiidstudios.vct.managers;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import voiidstudios.vct.VoiidCountdownTimer;

public class TranslationManager {
    private final VoiidCountdownTimer plugin;
    private FileConfiguration langBase;
    private FileConfiguration langSelected;
    private FileConfiguration langSelectedCustom;
    private FileConfiguration langCustomOverrides;
    private String currentLang = "en_US";

    public TranslationManager(VoiidCountdownTimer plugin) {
        this.plugin = plugin;
    }

    public void loadLanguage(String langCode) {
        this.currentLang = langCode;
        this.langBase = this.loadYaml("core/messages/origins/en_US.yml");
        this.langSelected = this.loadYaml("core/messages/origins/" + langCode + ".yml");
        this.langSelectedCustom = this.loadYaml("core/messages/custom/" + langCode + ".yml");
        this.langCustomOverrides = this.loadYaml("core/messages/custom/custom.yml");
        this.syncMissingKeys();
    }

    private FileConfiguration loadYaml(String path) {
        File file = new File(this.plugin.getDataFolder(), path);
        if (!file.exists()) {
            return new YamlConfiguration();
        }
        return YamlConfiguration.loadConfiguration((File)file);
    }

    public void syncMissingKeys() {
        if (this.langBase == null || this.langSelected == null) {
            return;
        }
        File selectedFile = new File(this.plugin.getDataFolder(), "core/messages/origins/" + this.currentLang + ".yml");
        boolean changed = false;
        for (String key : this.langBase.getKeys(true)) {
            if (this.langSelected.contains(key)) continue;
            this.langSelected.set(key, this.langBase.get(key));
            changed = true;
            this.plugin.getLogger().warning("Added missing translation key to " + this.currentLang + ": " + key);
        }
        if (changed) {
            try {
                this.langSelected.save(selectedFile);
            }
            catch (IOException e) {
                this.plugin.getLogger().severe("Failed to save language file: " + selectedFile.getName());
                e.printStackTrace();
            }
        }
    }

    public String get(String key) {
        return this.getFromConfigurations(key, this.getBaseSources());
    }

    public List<String> getStringList(String key) {
        return this.asStringList(key, this.getBaseSources());
    }

    public String formatKey(String key, Map<String, String> placeholders) {
        String raw = this.get(key);
        if (raw == null) {
            return null;
        }
        return this.formatRaw(raw, placeholders);
    }

    public String formatRaw(String raw, Map<String, String> placeholders) {
        if (raw == null) {
            return null;
        }
        if (placeholders != null) {
            for (Map.Entry<String, String> e : placeholders.entrySet()) {
                raw = raw.replace(e.getKey(), e.getValue());
            }
        }
        return raw;
    }

    public void ensureExists(String key, String defaultValue) {
        boolean changed = false;
        if (this.langBase != null && !this.langBase.contains(key)) {
            this.langBase.set(key, (Object)defaultValue);
            changed = true;
        }
        if (this.langSelected != null && !this.langSelected.contains(key)) {
            this.langSelected.set(key, (Object)defaultValue);
            changed = true;
        }
        if (changed && this.langSelected != null) {
            try {
                this.langSelected.save(new File(this.plugin.getDataFolder(), "core/messages/origins/" + this.currentLang + ".yml"));
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public String getCurrentLanguage() {
        return this.currentLang;
    }

    private List<FileConfiguration> getBaseSources() {
        ArrayList<FileConfiguration> sources = new ArrayList<FileConfiguration>();
        this.addIfNotEmpty(this.langCustomOverrides, sources);
        this.addIfNotEmpty(this.langSelectedCustom, sources);
        this.addIfNotEmpty(this.langSelected, sources);
        this.addIfNotEmpty(this.langBase, sources);
        return sources;
    }

    private void addIfNotEmpty(FileConfiguration config, List<FileConfiguration> list) {
        if (config == null || config.getKeys(true).isEmpty()) {
            return;
        }
        list.add(config);
    }

    private List<String> asStringList(String key, List<FileConfiguration> sources) {
        for (FileConfiguration source : sources) {
            if (!source.isList(key)) continue;
            return source.getStringList(key);
        }
        String raw = this.getFromConfigurations(key, sources);
        if (raw == null) {
            return Collections.emptyList();
        }
        if (!raw.contains("\n")) {
            return Collections.singletonList(raw);
        }
        return Arrays.asList(raw.split("\n"));
    }

    private String getFromConfigurations(String key, List<FileConfiguration> sources) {
        for (FileConfiguration config : sources) {
            if (!config.contains(key)) continue;
            return config.getString(key);
        }
        return null;
    }

    public TranslationBundle forCustomNamespace(String namespace) {
        return new TranslationBundle(namespace);
    }

    public class TranslationBundle {
        private final String namespace;
        private FileConfiguration namespacedSelected;
        private FileConfiguration namespacedDefault;
        private String lastLang;

        private TranslationBundle(String namespace) {
            this.namespace = namespace == null ? "" : namespace.trim();
            this.reload();
        }

        public void reload() {
            this.lastLang = TranslationManager.this.currentLang;
            if (this.namespace.isEmpty()) {
                this.namespacedSelected = new YamlConfiguration();
                this.namespacedDefault = new YamlConfiguration();
                return;
            }
            this.namespacedSelected = TranslationManager.this.loadYaml("core/messages/custom/" + this.namespace + "/" + TranslationManager.this.currentLang + ".yml");
            this.namespacedDefault = TranslationManager.this.loadYaml("core/messages/custom/" + this.namespace + "/en_US.yml");
        }

        public String get(String key) {
            List<FileConfiguration> sources = this.getNamespacedSources();
            return TranslationManager.this.getFromConfigurations(key, sources);
        }

        public List<String> getStringList(String key) {
            return TranslationManager.this.asStringList(key, this.getNamespacedSources());
        }

        public String formatKey(String key, Map<String, String> placeholders) {
            return this.formatRaw(this.get(key), placeholders);
        }

        public String formatRaw(String raw, Map<String, String> placeholders) {
            if (raw == null) {
                return null;
            }
            if (placeholders != null) {
                for (Map.Entry<String, String> entry : placeholders.entrySet()) {
                    raw = raw.replace(entry.getKey(), entry.getValue());
                }
            }
            return raw;
        }

        private List<FileConfiguration> getNamespacedSources() {
            if (!Objects.equals(this.lastLang, TranslationManager.this.currentLang)) {
                this.reload();
            }
            ArrayList<FileConfiguration> sources = new ArrayList<FileConfiguration>();
            TranslationManager.this.addIfNotEmpty(TranslationManager.this.langCustomOverrides, sources);
            TranslationManager.this.addIfNotEmpty(this.namespacedSelected, sources);
            TranslationManager.this.addIfNotEmpty(this.namespacedDefault, sources);
            return sources;
        }
    }
}

