/*
 * Decompiled with CFR 0.152.
 */
package voiidstudios.vct.expansions;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import javax.script.Bindings;
import javax.script.Invocable;
import javax.script.ScriptEngine;
import javax.script.ScriptException;
import org.openjdk.nashorn.api.scripting.NashornScriptEngineFactory;
import org.openjdk.nashorn.api.scripting.ScriptObjectMirror;
import voiidstudios.vct.VoiidCountdownTimer;
import voiidstudios.vct.expansions.ExpansionMetadata;
import voiidstudios.vct.expansions.command.ExpansionCommand;
import voiidstudios.vct.expansions.command.ExpansionCommandRegistry;
import voiidstudios.vct.expansions.exceptions.InvalidExpansionException;
import voiidstudios.vct.expansions.runtime.ExpansionScheduledTask;
import voiidstudios.vct.expansions.runtime.ScriptExpansionContext;

public class ScriptExpansion {
    private final VoiidCountdownTimer plugin;
    private final ExpansionMetadata metadata;
    private final File directory;
    private final File scriptFile;
    private final ExpansionCommandRegistry commandRegistry;
    private final ClassLoader pluginClassLoader;
    private ScriptEngine engine;
    private Invocable invocable;
    private ScriptExpansionContext context;
    private final List<ExpansionScheduledTask> scheduledTasks = new CopyOnWriteArrayList<ExpansionScheduledTask>();

    public ScriptExpansion(VoiidCountdownTimer plugin, ExpansionMetadata metadata, File directory, ExpansionCommandRegistry commandRegistry) throws InvalidExpansionException {
        this.plugin = plugin;
        this.metadata = metadata;
        this.commandRegistry = commandRegistry;
        this.directory = directory;
        this.scriptFile = new File(directory, metadata.getMainScript());
        this.pluginClassLoader = ((Object)((Object)plugin)).getClass().getClassLoader();
        if (!this.scriptFile.exists()) {
            throw new InvalidExpansionException(String.format(Locale.ROOT, "The script '%s' defined by expansion %s does not exist", metadata.getMainScript(), metadata.getName()));
        }
    }

    public VoiidCountdownTimer getPlugin() {
        return this.plugin;
    }

    public ExpansionMetadata getMetadata() {
        return this.metadata;
    }

    public File getDirectory() {
        return this.directory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean load() {
        ClassLoader previous = this.enterContextClassLoader();
        try {
            try {
                this.engine = new NashornScriptEngineFactory().getScriptEngine("--language=es6");
            }
            catch (Throwable throwable) {
                this.plugin.getLogger().log(Level.SEVERE, String.format(Locale.ROOT, "Failed to initialize script engine for expansion %s", this.metadata.getName()), throwable);
                boolean bl = false;
                this.exitContextClassLoader(previous);
                return bl;
            }
            if (this.engine == null) {
                this.plugin.getLogger().severe(String.format(Locale.ROOT, "No JavaScript engine available. Expansion %s will be skipped.", this.metadata.getName()));
                boolean throwable = false;
                return throwable;
            }
            this.context = new ScriptExpansionContext(this.plugin, this);
            Bindings bindings = this.engine.getBindings(100);
            bindings.put("plugin", (Object)this.plugin);
            bindings.put("server", (Object)this.plugin.getServer());
            bindings.put("logger", (Object)this.plugin.getLogger());
            bindings.put("messages", (Object)VoiidCountdownTimer.getMessagesManager());
            try (FileReader reader = new FileReader(this.scriptFile);){
                this.engine.eval(reader);
            }
            catch (IOException | ScriptException exception) {
                this.plugin.getLogger().log(Level.SEVERE, String.format(Locale.ROOT, "Failed to evaluate script for expansion %s", this.metadata.getName()), exception);
                boolean bl = false;
                this.exitContextClassLoader(previous);
                return bl;
            }
            if (!(this.engine instanceof Invocable)) {
                this.plugin.getLogger().severe(String.format(Locale.ROOT, "The script engine for expansion %s does not support Invocable", this.metadata.getName()));
                boolean bl = false;
                return bl;
            }
            this.invocable = (Invocable)((Object)this.engine);
            this.invokeIfPresent("onLoad", this.context);
            this.invokeIfPresent("onEnable", this.context);
            boolean bl = true;
            return bl;
        }
        finally {
            this.exitContextClassLoader(previous);
        }
    }

    public void disable() {
        this.commandRegistry.unregisterCommands(this);
        for (ExpansionScheduledTask task : new ArrayList<ExpansionScheduledTask>(this.scheduledTasks)) {
            task.cancel();
        }
        this.scheduledTasks.clear();
        this.invokeIfPresent("onDisable", this.context);
    }

    public void registerCommand(Object definitionObject) {
        ScriptObjectMirror executor;
        ScriptObjectMirror mirror;
        try {
            mirror = this.requireObject(definitionObject);
        }
        catch (IllegalArgumentException exception) {
            this.plugin.getLogger().warning(String.format(Locale.ROOT, "Unable to register command for expansion %s: %s", this.metadata.getName(), exception.getMessage()));
            return;
        }
        String name = this.optString(mirror, "name");
        if (name == null || name.trim().isEmpty()) {
            this.plugin.getLogger().warning(String.format(Locale.ROOT, "Skipping command registration for expansion %s: missing name", this.metadata.getName()));
            return;
        }
        Object executorObj = mirror.get("execute");
        try {
            executor = this.requireFunction(executorObj);
        }
        catch (IllegalArgumentException exception) {
            this.plugin.getLogger().warning(String.format(Locale.ROOT, "Skipping command '%s' for expansion %s: %s", name, this.metadata.getName(), exception.getMessage()));
            return;
        }
        Object tabCompleterObj = mirror.get("tabComplete");
        ScriptObjectMirror tabCompleter = null;
        if (tabCompleterObj instanceof ScriptObjectMirror && ((ScriptObjectMirror)tabCompleterObj).isFunction()) {
            tabCompleter = (ScriptObjectMirror)tabCompleterObj;
        }
        List<String> aliases = this.convertToStringList(mirror.get("aliases"));
        String description = this.optString(mirror, "description");
        String usage = this.optString(mirror, "usage");
        String permission = this.optString(mirror, "permission");
        ExpansionCommand command = new ExpansionCommand(this, name, aliases, description, usage, permission, executor, tabCompleter);
        this.commandRegistry.registerCommand(this, command);
    }

    public ExpansionScheduledTask trackTask(Object delegate) {
        ExpansionScheduledTask task = new ExpansionScheduledTask(this, delegate);
        this.scheduledTasks.add(task);
        return task;
    }

    public void unregisterTask(ExpansionScheduledTask task) {
        this.scheduledTasks.remove(task);
    }

    public ScriptObjectMirror requireFunction(Object obj) {
        if (obj instanceof ScriptObjectMirror && ((ScriptObjectMirror)obj).isFunction()) {
            return (ScriptObjectMirror)obj;
        }
        throw new IllegalArgumentException("Provided object is not a function");
    }

    public ScriptObjectMirror requireObject(Object obj) {
        if (obj instanceof ScriptObjectMirror) {
            return (ScriptObjectMirror)obj;
        }
        throw new IllegalArgumentException("Provided object is not a script object");
    }

    public Runnable toRunnable(ScriptObjectMirror function) {
        return () -> {
            try {
                this.callFunction(function, new Object[0]);
            }
            catch (Throwable throwable) {
                this.plugin.getLogger().log(Level.SEVERE, String.format(Locale.ROOT, "Error executing scheduled task for expansion %s", this.metadata.getName()), throwable);
            }
        };
    }

    public List<String> convertToStringList(Object raw) {
        ArrayList<String> result;
        ScriptObjectMirror mirror;
        if (raw == null) {
            return Collections.emptyList();
        }
        if (raw instanceof String) {
            return Collections.singletonList((String)raw);
        }
        if (raw instanceof ScriptObjectMirror && (mirror = (ScriptObjectMirror)raw).isArray()) {
            ArrayList<String> result2 = new ArrayList<String>();
            for (Object value : mirror.values()) {
                if (value == null) continue;
                result2.add(String.valueOf(value));
            }
            return result2;
        }
        if (raw instanceof Collection) {
            result = new ArrayList<String>();
            for (Object value : (Collection)raw) {
                if (value == null) continue;
                result.add(String.valueOf(value));
            }
            return result;
        }
        if (raw.getClass().isArray()) {
            result = new ArrayList();
            int length = Array.getLength(raw);
            for (int i = 0; i < length; ++i) {
                Object value = Array.get(raw, i);
                if (value == null) continue;
                result.add(String.valueOf(value));
            }
            return result;
        }
        return Collections.emptyList();
    }

    public String optString(ScriptObjectMirror mirror, String key) {
        Object value = mirror.get(key);
        if (value == null) {
            return null;
        }
        String str = String.valueOf(value);
        return str.isEmpty() ? null : str;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void invokeIfPresent(String function, Object ... args) {
        if (this.invocable == null) {
            return;
        }
        ClassLoader previous = this.enterContextClassLoader();
        try {
            this.invocable.invokeFunction(function, args);
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (Throwable throwable) {
            this.plugin.getLogger().log(Level.SEVERE, String.format(Locale.ROOT, "Error executing %s for expansion %s", function, this.metadata.getName()), throwable);
        }
        finally {
            this.exitContextClassLoader(previous);
        }
    }

    public List<ExpansionScheduledTask> getScheduledTasks() {
        return Collections.unmodifiableList(this.scheduledTasks);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object callFunction(ScriptObjectMirror function, Object ... args) throws Throwable {
        ClassLoader previous = this.enterContextClassLoader();
        try {
            Object object = function.call(null, args);
            return object;
        }
        finally {
            this.exitContextClassLoader(previous);
        }
    }

    private ClassLoader enterContextClassLoader() {
        ClassLoader previous = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.pluginClassLoader);
        return previous;
    }

    private void exitContextClassLoader(ClassLoader previous) {
        Thread.currentThread().setContextClassLoader(previous);
    }
}

