/*
 * Decompiled with CFR 0.152.
 */
package voiidstudios.vct.expansions.runtime;

import io.papermc.paper.threadedregions.scheduler.ScheduledTask;
import java.util.Locale;
import java.util.logging.Logger;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitTask;
import org.openjdk.nashorn.api.scripting.ScriptObjectMirror;
import voiidstudios.vct.VoiidCountdownTimer;
import voiidstudios.vct.expansions.ScriptExpansion;
import voiidstudios.vct.expansions.runtime.ExpansionScheduledTask;
import voiidstudios.vct.managers.MessagesManager;
import voiidstudios.vct.utils.ServerCompatibility;

public class ScriptExpansionContext {
    private final VoiidCountdownTimer plugin;
    private final ScriptExpansion expansion;
    private final Commands commands;
    private final Scheduler scheduler;

    public ScriptExpansionContext(VoiidCountdownTimer plugin, ScriptExpansion expansion) {
        this.plugin = plugin;
        this.expansion = expansion;
        this.commands = new Commands();
        this.scheduler = new Scheduler();
    }

    public VoiidCountdownTimer getPlugin() {
        return this.plugin;
    }

    public Logger getLogger() {
        return this.plugin.getLogger();
    }

    public MessagesManager getMessages() {
        return VoiidCountdownTimer.getMessagesManager();
    }

    public Commands getCommands() {
        return this.commands;
    }

    public Scheduler getScheduler() {
        return this.scheduler;
    }

    public ExpansionScheduledTask runTask(ScriptObjectMirror function) {
        return this.scheduler.runTask(function);
    }

    public ExpansionScheduledTask runTaskLater(ScriptObjectMirror function, long delay) {
        return this.scheduler.runTaskLater(function, delay);
    }

    public ExpansionScheduledTask runTaskTimer(ScriptObjectMirror function, long delay, long period) {
        return this.scheduler.runTaskTimer(function, delay, period);
    }

    public class Commands {
        public void register(Object definition) {
            ScriptExpansionContext.this.expansion.registerCommand(definition);
        }
    }

    public class Scheduler {
        public ExpansionScheduledTask runTask(Object function) {
            return this.schedule(function, 0L, 0L, SchedulerType.RUN);
        }

        public ExpansionScheduledTask runTaskLater(Object function, long delay) {
            return this.schedule(function, delay, 0L, SchedulerType.DELAYED);
        }

        public ExpansionScheduledTask runTaskTimer(Object function, long delay, long period) {
            return this.schedule(function, delay, period, SchedulerType.REPEATING);
        }

        private ExpansionScheduledTask schedule(Object function, long delay, long period, SchedulerType type) {
            ScriptObjectMirror mirror = ScriptExpansionContext.this.expansion.requireFunction(function);
            Runnable runnable = ScriptExpansionContext.this.expansion.toRunnable(mirror);
            if (ServerCompatibility.isFolia()) {
                switch (type.ordinal()) {
                    case 0: {
                        ScheduledTask runTask = Bukkit.getGlobalRegionScheduler().run((Plugin)ScriptExpansionContext.this.plugin, scheduledTask -> runnable.run());
                        return ScriptExpansionContext.this.expansion.trackTask(runTask);
                    }
                    case 1: {
                        ScheduledTask delayed = Bukkit.getGlobalRegionScheduler().runDelayed((Plugin)ScriptExpansionContext.this.plugin, scheduledTask -> runnable.run(), delay);
                        return ScriptExpansionContext.this.expansion.trackTask(delayed);
                    }
                    case 2: {
                        ScheduledTask repeating = Bukkit.getGlobalRegionScheduler().runAtFixedRate((Plugin)ScriptExpansionContext.this.plugin, scheduledTask -> runnable.run(), Math.max(1L, delay), Math.max(1L, period));
                        return ScriptExpansionContext.this.expansion.trackTask(repeating);
                    }
                }
            } else {
                switch (type.ordinal()) {
                    case 0: {
                        BukkitTask runTask = Bukkit.getScheduler().runTask((Plugin)ScriptExpansionContext.this.plugin, runnable);
                        return ScriptExpansionContext.this.expansion.trackTask(runTask);
                    }
                    case 1: {
                        BukkitTask delayed = Bukkit.getScheduler().runTaskLater((Plugin)ScriptExpansionContext.this.plugin, runnable, Math.max(1L, delay));
                        return ScriptExpansionContext.this.expansion.trackTask(delayed);
                    }
                    case 2: {
                        BukkitTask repeating = Bukkit.getScheduler().runTaskTimer((Plugin)ScriptExpansionContext.this.plugin, runnable, Math.max(1L, delay), Math.max(1L, period));
                        return ScriptExpansionContext.this.expansion.trackTask(repeating);
                    }
                }
            }
            throw new IllegalStateException(String.format(Locale.ROOT, "Unsupported scheduler type %s", new Object[]{type}));
        }
    }

    private static enum SchedulerType {
        RUN,
        DELAYED,
        REPEATING;

    }
}

