/*
 * Decompiled with CFR 0.152.
 */
package voiidstudios.vct.managers;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import voiidstudios.vct.VoiidCountdownTimer;

public class TranslationManager {
    private final VoiidCountdownTimer plugin;
    private FileConfiguration langBase;
    private FileConfiguration langSelected;
    private FileConfiguration langCustom;
    private String currentLang = "en_US";

    public TranslationManager(VoiidCountdownTimer plugin) {
        this.plugin = plugin;
    }

    public void loadLanguage(String langCode) {
        this.currentLang = langCode;
        this.langBase = this.loadYaml("core/messages/origins/en_US.yml");
        this.langSelected = this.loadYaml("core/messages/origins/" + langCode + ".yml");
        this.langCustom = this.loadYaml("core/messages/custom/custom.yml");
        this.syncMissingKeys();
    }

    private FileConfiguration loadYaml(String path) {
        File file = new File(this.plugin.getDataFolder(), path);
        if (!file.exists()) {
            return new YamlConfiguration();
        }
        return YamlConfiguration.loadConfiguration((File)file);
    }

    public void syncMissingKeys() {
        if (this.langBase == null || this.langSelected == null) {
            return;
        }
        File selectedFile = new File(this.plugin.getDataFolder(), "core/messages/origins/" + this.currentLang + ".yml");
        boolean changed = false;
        for (String key : this.langBase.getKeys(true)) {
            if (this.langSelected.contains(key)) continue;
            this.langSelected.set(key, this.langBase.get(key));
            changed = true;
            this.plugin.getLogger().warning("[VCT] Added missing translation key to " + this.currentLang + ": " + key);
        }
        if (changed) {
            try {
                this.langSelected.save(selectedFile);
            }
            catch (IOException e) {
                this.plugin.getLogger().severe("Failed to save language file: " + selectedFile.getName());
                e.printStackTrace();
            }
        }
    }

    public String get(String key) {
        if (this.langCustom != null && this.langCustom.contains(key)) {
            return this.langCustom.getString(key);
        }
        if (this.langSelected != null && this.langSelected.contains(key)) {
            return this.langSelected.getString(key);
        }
        if (this.langBase != null && this.langBase.contains(key)) {
            return this.langBase.getString(key);
        }
        return null;
    }

    public List<String> getStringList(String key) {
        if (this.langCustom != null && this.langCustom.isList(key)) {
            return this.langCustom.getStringList(key);
        }
        if (this.langSelected != null && this.langSelected.isList(key)) {
            return this.langSelected.getStringList(key);
        }
        if (this.langBase != null && this.langBase.isList(key)) {
            return this.langBase.getStringList(key);
        }
        String raw = this.get(key);
        if (raw == null) {
            return Collections.emptyList();
        }
        if (!raw.contains("\n")) {
            return Collections.singletonList(raw);
        }
        return Arrays.asList(raw.split("\n"));
    }

    public String formatKey(String key, Map<String, String> placeholders) {
        String raw = this.get(key);
        if (raw == null) {
            return null;
        }
        return this.formatRaw(raw, placeholders);
    }

    public String formatRaw(String raw, Map<String, String> placeholders) {
        if (raw == null) {
            return null;
        }
        if (placeholders != null) {
            for (Map.Entry<String, String> e : placeholders.entrySet()) {
                raw = raw.replace(e.getKey(), e.getValue());
            }
        }
        return raw;
    }

    public void ensureExists(String key, String defaultValue) {
        boolean changed = false;
        if (this.langBase != null && !this.langBase.contains(key)) {
            this.langBase.set(key, (Object)defaultValue);
            changed = true;
        }
        if (this.langSelected != null && !this.langSelected.contains(key)) {
            this.langSelected.set(key, (Object)defaultValue);
            changed = true;
        }
        if (changed && this.langSelected != null) {
            try {
                this.langSelected.save(new File(this.plugin.getDataFolder(), "core/messages/origins/" + this.currentLang + ".yml"));
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

