/*
 * Decompiled with CFR 0.152.
 */
package voiidstudios.vct.configs;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.bukkit.configuration.file.FileConfiguration;
import voiidstudios.vct.VoiidCountdownTimer;
import voiidstudios.vct.configs.model.CustomConfig;
import voiidstudios.vct.utils.Formatter;

public class MainConfigManager {
    private CustomConfig configFile;
    private String language;
    private boolean auto_update;
    private boolean update_notification;
    private int ticks_hide_after_ending;
    private String text_format;
    private int refresh_ticks;
    private boolean save_state_timers;
    private boolean debug_mode;

    public MainConfigManager(VoiidCountdownTimer plugin) {
        this.configFile = new CustomConfig("config.yml", plugin, null, false);
        this.configFile.registerConfig();
        this.checkConfigsUpdate();
    }

    public void configure() {
        FileConfiguration config = this.configFile.getConfig();
        this.language = config.getString("Config.language", "en_US");
        this.auto_update = config.getBoolean("Config.auto_update");
        this.update_notification = config.getBoolean("Config.update_notification");
        this.ticks_hide_after_ending = config.getInt("Config.ticks_hide_after_ending");
        this.text_format = config.getString("Config.text_format");
        this.refresh_ticks = config.getInt("Config.refresh_ticks");
        this.save_state_timers = config.getBoolean("Config.save_state_timers");
        this.debug_mode = config.getBoolean("Config.debug_mode");
    }

    public void reloadConfig() {
        this.configFile.reloadConfig();
        this.configure();
    }

    public FileConfiguration getConfig() {
        return this.configFile.getConfig();
    }

    public CustomConfig getConfigFile() {
        return this.configFile;
    }

    public void saveConfig() {
        this.configFile.saveConfig();
    }

    public void checkConfigsUpdate() {
        Path pathConfig = Paths.get(this.configFile.getRoute(), new String[0]);
        try {
            String text = new String(Files.readAllBytes(pathConfig));
            if (!text.contains("language:")) {
                this.getConfig().set("Config.language", (Object)"en_US");
                this.saveConfig();
            }
            if (!text.contains("auto_update:")) {
                this.getConfig().set("Config.auto_update", (Object)false);
                this.saveConfig();
            }
            if (!text.contains("update_notification:")) {
                this.getConfig().set("Config.update_notification", (Object)true);
                this.saveConfig();
            }
            if (!text.contains("ticks_hide_after_ending:")) {
                this.getConfig().set("Config.ticks_hide_after_ending", (Object)60);
                this.saveConfig();
            }
            if (!text.contains("text_format:")) {
                this.getConfig().set("Config.text_format", (Object)"LEGACY");
                this.saveConfig();
            }
            if (!text.contains("refresh_ticks:")) {
                this.getConfig().set("Config.refresh_ticks", (Object)10);
                this.saveConfig();
            }
            if (!text.contains("save_state_timers:")) {
                this.getConfig().set("Config.save_state_timers", (Object)true);
                this.saveConfig();
            }
            if (!text.contains("debug_mode:")) {
                this.getConfig().set("Config.debug_mode", (Object)false);
                this.saveConfig();
            }
            if (this.getConfig().contains("Timers")) {
                for (String timerKey : this.getConfig().getConfigurationSection("Timers").getKeys(false)) {
                    String base = "Timers." + timerKey + ".";
                    if (!this.getConfig().contains(base + "text")) {
                        this.getConfig().set(base + "text", (Object)"%HH%:%MM%:%SS%");
                    }
                    if (!this.getConfig().contains(base + "sound")) {
                        this.getConfig().set(base + "sound", (Object)"UI_BUTTON_CLICK");
                    }
                    if (!this.getConfig().contains(base + "sound_volume")) {
                        this.getConfig().set(base + "sound_volume", (Object)1.0);
                    }
                    if (!this.getConfig().contains(base + "sound_pitch")) {
                        this.getConfig().set(base + "sound_pitch", (Object)1.0);
                    }
                    if (!this.getConfig().contains(base + "bossbar_color")) {
                        this.getConfig().set(base + "bossbar_color", (Object)"WHITE");
                    }
                    if (!this.getConfig().contains(base + "bossbar_style")) {
                        this.getConfig().set(base + "bossbar_style", (Object)"SOLID");
                    }
                    if (!this.getConfig().contains(base + "enabled")) {
                        this.getConfig().set(base + "enabled", (Object)true);
                    }
                    if (this.getConfig().contains(base + "sound_enabled")) continue;
                    this.getConfig().set(base + "sound_enabled", (Object)false);
                }
                this.saveConfig();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public String getLanguage() {
        return this.language != null ? this.language : "en_US";
    }

    public boolean isAuto_update() {
        return this.auto_update;
    }

    public boolean isUpdate_notification() {
        return this.update_notification;
    }

    public boolean isSave_state_timers() {
        return this.save_state_timers;
    }

    public int getTicks_hide_after_ending() {
        return this.ticks_hide_after_ending;
    }

    public Formatter getFormatter() {
        try {
            return Formatter.valueOf(this.text_format.toUpperCase());
        }
        catch (IllegalArgumentException | NullPointerException e) {
            return Formatter.LEGACY;
        }
    }

    public int getRefresh_ticks() {
        return this.refresh_ticks;
    }

    public boolean isDebug_mode() {
        return this.debug_mode;
    }
}

