/*
 * Decompiled with CFR 0.152.
 */
package voiidstudios.vct.configs.model;

import java.io.File;
import java.io.IOException;
import org.bukkit.configuration.Configuration;
import org.bukkit.configuration.InvalidConfigurationException;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import voiidstudios.vct.VoiidCountdownTimer;

public class CustomConfig {
    private final VoiidCountdownTimer plugin;
    private final String fileName;
    private FileConfiguration fileConfiguration = null;
    private File file = null;
    private String route;
    private final String folderName;
    private final boolean newFile;

    public CustomConfig(String fileName, VoiidCountdownTimer plugin, String folderName, Boolean newFile) {
        this.fileName = fileName;
        this.folderName = folderName;
        this.plugin = plugin;
        this.newFile = newFile;
    }

    public String getPath() {
        return this.fileName;
    }

    public void registerConfig() {
        this.file = this.folderName != null ? new File(this.plugin.getDataFolder() + File.separator + this.folderName, this.fileName) : new File(this.plugin.getDataFolder(), this.fileName);
        this.route = this.file.getPath();
        if (!this.file.exists()) {
            if (this.newFile) {
                try {
                    this.file.createNewFile();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            } else if (this.folderName != null) {
                this.plugin.saveResource(this.folderName + File.separator + this.fileName, false);
            } else {
                this.plugin.saveResource(this.fileName, false);
            }
        }
        this.fileConfiguration = new YamlConfiguration();
        try {
            this.fileConfiguration.load(this.file);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (InvalidConfigurationException e) {
            e.printStackTrace();
        }
    }

    public void saveConfig() {
        try {
            this.fileConfiguration.save(this.file);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public FileConfiguration getConfig() {
        if (this.fileConfiguration == null) {
            this.reloadConfig();
        }
        return this.fileConfiguration;
    }

    public boolean reloadConfig() {
        if (this.fileConfiguration == null) {
            this.file = this.folderName != null ? new File(this.plugin.getDataFolder() + File.separator + this.folderName, this.fileName) : new File(this.plugin.getDataFolder(), this.fileName);
        }
        this.fileConfiguration = YamlConfiguration.loadConfiguration((File)this.file);
        if (this.file != null) {
            YamlConfiguration defConfig = YamlConfiguration.loadConfiguration((File)this.file);
            this.fileConfiguration.setDefaults((Configuration)defConfig);
        }
        return true;
    }

    public String getRoute() {
        return this.route;
    }
}

