/*
 * Decompiled with CFR 0.152.
 */
package voiidstudios.vct.expansions;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Level;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.YamlConfiguration;
import voiidstudios.vct.VoiidCountdownTimer;
import voiidstudios.vct.expansions.ExpansionMetadata;
import voiidstudios.vct.expansions.ScriptExpansion;
import voiidstudios.vct.expansions.command.ExpansionCommandRegistry;
import voiidstudios.vct.expansions.exceptions.InvalidExpansionException;
import voiidstudios.vct.managers.MessagesManager;

public class ExpansionManager {
    private final VoiidCountdownTimer plugin;
    private final ExpansionCommandRegistry commandRegistry = new ExpansionCommandRegistry();
    private final Map<String, ScriptExpansion> loadedExpansions = new LinkedHashMap<String, ScriptExpansion>();
    private final Map<String, ExpansionHandle> discoveredExpansions = new LinkedHashMap<String, ExpansionHandle>();
    private final MessagesManager msgManager = VoiidCountdownTimer.getMessagesManager();
    private final File expansionsDirectory;
    private static final String METADATA_FILE = "expansion.yml";

    public ExpansionManager(VoiidCountdownTimer plugin) {
        this.plugin = plugin;
        this.expansionsDirectory = new File(plugin.getDataFolder(), "expansions");
    }

    public void loadExpansions() {
        if (!this.plugin.getDataFolder().exists() && !this.plugin.getDataFolder().mkdirs()) {
            this.plugin.getLogger().warning("Unable to create the plugin data folder. Expansions will be disabled.");
            return;
        }
        if (!this.expansionsDirectory.exists() && !this.expansionsDirectory.mkdirs()) {
            this.plugin.getLogger().warning("Unable to create the expansions directory. Expansions will be disabled.");
            return;
        }
        this.refreshDiscoveredExpansions();
        if (this.discoveredExpansions.isEmpty()) {
            this.msgManager.debug("No expansions were found to load.");
            return;
        }
        int loadedCount = 0;
        int skippedCount = 0;
        for (ExpansionHandle handle : this.discoveredExpansions.values()) {
            if (!handle.metadata.isEnabled()) {
                ++skippedCount;
                this.msgManager.console(VoiidCountdownTimer.prefix + String.format(Locale.ROOT, "&3The &e%s&3 extension has been skipped because it is disabled.", handle.metadata.getName()));
                continue;
            }
            if (this.loadExpansion(handle)) {
                ++loadedCount;
                continue;
            }
            ++skippedCount;
        }
        this.msgManager.console(VoiidCountdownTimer.prefix + String.format(Locale.ROOT, "&a%d expansion(s) loaded! &3%d expansion(s) skipped.", loadedCount, skippedCount));
    }

    private boolean loadExpansion(ExpansionHandle handle) {
        if (handle == null) {
            return false;
        }
        if (this.loadedExpansions.containsKey(handle.key)) {
            return true;
        }
        if (!handle.metadata.isEnabled()) {
            return false;
        }
        try {
            ScriptExpansion expansion = new ScriptExpansion(this.plugin, handle.metadata, handle.directory, this.commandRegistry);
            if (expansion.load()) {
                this.loadedExpansions.put(handle.key, expansion);
                this.msgManager.console(VoiidCountdownTimer.prefix + String.format(Locale.ROOT, "&aLoaded expansion %s &ev%s", handle.metadata.getName(), handle.metadata.getVersion()));
                return true;
            }
        }
        catch (InvalidExpansionException exception) {
            this.plugin.getLogger().log(Level.WARNING, String.format(Locale.ROOT, "Failed to initialize expansion %s", handle.metadata.getName()), exception);
            this.msgManager.console(VoiidCountdownTimer.prefix + String.format(Locale.ROOT, "&cUnable to load expansion %s", handle.metadata.getName()));
        }
        return false;
    }

    public void shutdown() {
        for (ScriptExpansion expansion : new ArrayList<ScriptExpansion>(this.loadedExpansions.values())) {
            try {
                expansion.disable();
            }
            catch (Exception exception) {
                this.plugin.getLogger().log(Level.WARNING, String.format(Locale.ROOT, "Error while disabling expansion %s", expansion.getMetadata().getName()), exception);
                this.msgManager.console(VoiidCountdownTimer.prefix + String.format(Locale.ROOT, "&cUnable to disable expansion %s", expansion.getMetadata().getName()));
            }
        }
        this.loadedExpansions.clear();
        this.discoveredExpansions.clear();
    }

    public ExpansionCommandRegistry getCommandRegistry() {
        return this.commandRegistry;
    }

    public List<String> getHelpLines() {
        return this.commandRegistry.getHelpLines();
    }

    public List<String> getRootSuggestions(String partial) {
        return this.commandRegistry.getRootSuggestions(partial);
    }

    public List<String> getTabCompletions(CommandSender sender, String[] args) {
        List<String> result = this.commandRegistry.tabComplete(sender, args);
        return result == null ? null : new ArrayList<String>(result);
    }

    public boolean executeCommand(CommandSender sender, String[] args) {
        return this.commandRegistry.execute(sender, args);
    }

    public Map<String, ScriptExpansion> getLoadedExpansions() {
        return Collections.unmodifiableMap(this.loadedExpansions);
    }

    public boolean enableExpansion(String name) {
        boolean updated;
        this.refreshDiscoveredExpansions();
        ExpansionHandle handle = this.discoveredExpansions.get(ExpansionManager.normalizeName(name));
        if (handle == null) {
            return false;
        }
        if (this.loadedExpansions.containsKey(handle.key)) {
            return false;
        }
        String key = handle.key;
        boolean wasEnabled = handle.metadata.isEnabled();
        boolean bl = updated = wasEnabled || this.updateEnabledFlag(handle.directory, true);
        if (!updated) {
            return false;
        }
        this.refreshDiscoveredExpansions();
        handle = this.discoveredExpansions.get(key);
        if (handle == null || !handle.metadata.isEnabled()) {
            return false;
        }
        if (!this.loadExpansion(handle)) {
            if (!wasEnabled) {
                this.updateEnabledFlag(handle.directory, false);
            }
            return false;
        }
        return true;
    }

    public boolean disableExpansion(String name) {
        String key = ExpansionManager.normalizeName(name);
        ScriptExpansion expansion = this.loadedExpansions.get(key);
        if (expansion == null) {
            return false;
        }
        boolean success = true;
        try {
            expansion.disable();
        }
        catch (Exception exception) {
            this.plugin.getLogger().log(Level.WARNING, String.format(Locale.ROOT, "Error while disabling expansion %s", expansion.getMetadata().getName()), exception);
            this.msgManager.console(VoiidCountdownTimer.prefix + String.format(Locale.ROOT, "&cUnable to disable expansion %s", expansion.getMetadata().getName()));
            success = false;
        }
        if (success) {
            this.loadedExpansions.remove(key);
            success = this.updateEnabledFlag(expansion.getDirectory(), false);
        }
        return success;
    }

    public boolean reloadExpansion(String name) {
        String key = ExpansionManager.normalizeName(name);
        ScriptExpansion previous = this.loadedExpansions.get(key);
        if (previous != null) {
            try {
                previous.disable();
            }
            catch (Exception e) {
                this.plugin.getLogger().warning("Failed to disable expansion " + key + " during reload.");
                return false;
            }
        }
        this.refreshDiscoveredExpansions();
        ExpansionHandle handle = this.discoveredExpansions.get(key);
        if (handle == null) {
            return false;
        }
        if (this.loadExpansion(handle)) {
            return true;
        }
        if (previous != null) {
            try {
                previous.load();
                this.loadedExpansions.put(key, previous);
                this.plugin.getLogger().warning("Reload of expansion " + key + " failed. Restored previous version.");
            }
            catch (Exception ex) {
                this.plugin.getLogger().warning("Failed to restore previous version of expansion " + key);
            }
        }
        return false;
    }

    public int reloadAllExpansions() {
        ArrayList<ScriptExpansion> previous = new ArrayList<ScriptExpansion>(this.loadedExpansions.values());
        for (ScriptExpansion exp : previous) {
            try {
                exp.disable();
            }
            catch (Exception exception) {}
        }
        this.loadedExpansions.clear();
        this.refreshDiscoveredExpansions();
        int loadedCount = 0;
        for (ExpansionHandle handle : this.discoveredExpansions.values()) {
            if (!handle.metadata.isEnabled() || !this.loadExpansion(handle)) continue;
            ++loadedCount;
        }
        return loadedCount;
    }

    public ExpansionMetadata getExpansionMetadata(String name) {
        String key = ExpansionManager.normalizeName(name);
        this.refreshDiscoveredExpansions();
        ExpansionHandle handle = this.discoveredExpansions.get(key);
        if (handle != null) {
            return handle.metadata;
        }
        ScriptExpansion expansion = this.loadedExpansions.get(key);
        return expansion == null ? null : expansion.getMetadata();
    }

    public boolean isExpansionLoaded(String name) {
        return this.loadedExpansions.containsKey(ExpansionManager.normalizeName(name));
    }

    public List<String> getKnownExpansionNames() {
        this.refreshDiscoveredExpansions();
        LinkedHashSet<String> names = new LinkedHashSet<String>();
        for (ExpansionHandle handle : this.discoveredExpansions.values()) {
            names.add(handle.metadata.getName());
        }
        for (ScriptExpansion expansion : this.loadedExpansions.values()) {
            names.add(expansion.getMetadata().getName());
        }
        return new ArrayList<String>(names);
    }

    private void refreshDiscoveredExpansions() {
        this.discoveredExpansions.clear();
        File[] children = this.expansionsDirectory.listFiles(File::isDirectory);
        if (children == null) {
            return;
        }
        for (File child : children) {
            ExpansionMetadata metadata;
            File metadataFile = new File(child, METADATA_FILE);
            if (!metadataFile.exists()) {
                this.msgManager.console(VoiidCountdownTimer.prefix + String.format(Locale.ROOT, "&3Skipping expansion in %s because %s is missing", child.getName(), METADATA_FILE));
                continue;
            }
            try {
                metadata = ExpansionMetadata.fromFile(metadataFile);
            }
            catch (InvalidExpansionException exception) {
                this.plugin.getLogger().log(Level.WARNING, String.format(Locale.ROOT, "Invalid expansion metadata in %s", child.getName()), exception);
                this.msgManager.console(VoiidCountdownTimer.prefix + String.format(Locale.ROOT, "&cInvalid expansion metadata in %s", child.getName(), METADATA_FILE));
                continue;
            }
            String key = metadata.getName().toLowerCase(Locale.ROOT);
            if (this.discoveredExpansions.containsKey(key)) {
                this.plugin.getLogger().warning(String.format(Locale.ROOT, "Multiple expansions share the name %s. Skipping directory %s.", metadata.getName(), child.getName()));
                continue;
            }
            this.discoveredExpansions.put(key, new ExpansionHandle(key, child, metadata));
        }
    }

    private boolean updateEnabledFlag(File directory, boolean enabled) {
        if (directory == null) {
            return false;
        }
        File metadataFile = new File(directory, METADATA_FILE);
        if (!metadataFile.exists()) {
            return false;
        }
        YamlConfiguration configuration = YamlConfiguration.loadConfiguration((File)metadataFile);
        configuration.set("enabled", (Object)enabled);
        try {
            configuration.save(metadataFile);
            return true;
        }
        catch (IOException exception) {
            this.plugin.getLogger().log(Level.WARNING, String.format(Locale.ROOT, "Unable to update enabled state for expansion in %s", directory.getName()), exception);
            return false;
        }
    }

    private static String normalizeName(String name) {
        return name == null ? "" : name.toLowerCase(Locale.ROOT);
    }

    private static final class ExpansionHandle {
        private final String key;
        private final File directory;
        private final ExpansionMetadata metadata;

        private ExpansionHandle(String key, File directory, ExpansionMetadata metadata) {
            this.key = key;
            this.directory = directory;
            this.metadata = metadata;
        }
    }
}

