/*
 * Decompiled with CFR 0.152.
 */
package voiidstudios.vct.managers;

import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import voiidstudios.vct.VoiidCountdownTimer;
import voiidstudios.vct.configs.ConfigsManager;
import voiidstudios.vct.configs.MainConfigManager;
import voiidstudios.vct.managers.TranslationManager;

public class MessagesManager {
    private static String prefix;
    private final TranslationManager translations;
    private static ConfigsManager configsManager;

    public MessagesManager(VoiidCountdownTimer plugin) {
        configsManager = plugin.getConfigsManager();
        this.translations = new TranslationManager(plugin);
        this.translations.loadLanguage(configsManager.getMainConfigManager().getLanguage());
    }

    public void loadLanguage(String lang) {
        this.translations.loadLanguage(lang);
    }

    public static void setPrefix(String p) {
        prefix = p;
    }

    private String applyPrefix(boolean usePrefix, String msg) {
        return (usePrefix ? prefix : "") + msg;
    }

    public String color(String msg) {
        if (msg == null) {
            return "\u00a7cMissing message";
        }
        return msg.replace("&", "\u00a7");
    }

    public String getTranslated(String key) {
        return this.getTranslated(key, null, true);
    }

    public String getTranslated(String key, Map<String, String> replacements) {
        return this.getTranslated(key, replacements, true);
    }

    public String getTranslated(String key, Map<String, String> replacements, boolean usePrefix) {
        String msg = this.translations.formatKey(key, replacements);
        if (msg == null) {
            msg = "\u00a7cMissing message: " + key;
        }
        return this.color(this.applyPrefix(usePrefix, msg));
    }

    public String getListAsSingleString(String key, @Nullable Map<String, String> repl) {
        List<String> lines = this.translations.getStringList(key);
        if (lines.isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (String lineRaw : lines) {
            String line = this.translations.formatRaw(lineRaw, repl);
            if (!first) {
                sb.append("\n");
            }
            sb.append(line);
            first = false;
        }
        return this.color(sb.toString());
    }

    public void send(CommandSender sender, String key) {
        this.send(sender, key, true, null);
    }

    public void send(CommandSender sender, String key, Map<String, String> repl) {
        this.send(sender, key, true, repl);
    }

    public void send(CommandSender sender, String key, boolean usePrefix) {
        this.send(sender, key, usePrefix, null);
    }

    public void send(CommandSender sender, String key, boolean usePrefix, Map<String, String> repl) {
        String msg = this.translations.formatKey(key, repl);
        if (msg == null) {
            msg = "\u00a7cMissing message: " + key;
        }
        sender.sendMessage(this.color(this.applyPrefix(usePrefix, msg)));
    }

    private void sendRaw(CommandSender sender, String msg, boolean usePrefix) {
        if (msg == null) {
            return;
        }
        sender.sendMessage(this.color(this.applyPrefix(usePrefix, msg)));
    }

    public void sendList(CommandSender sender, String key, boolean firstHasPrefix, Map<String, String> repl) {
        List<String> lines = this.translations.getStringList(key);
        if (lines.isEmpty()) {
            return;
        }
        boolean first = true;
        for (String lineRaw : lines) {
            String line = this.translations.formatRaw(lineRaw, repl);
            if (first) {
                this.sendRaw(sender, line, firstHasPrefix);
                first = false;
                continue;
            }
            this.sendRaw(sender, line, false);
        }
    }

    public void sendSection(CommandSender sender, String baseKey, boolean headerHasPrefix, Map<String, String> repl) {
        String headerRaw = this.translations.get(baseKey + ".header");
        if (headerRaw != null) {
            String header = this.translations.formatRaw(headerRaw, repl);
            this.sendRaw(sender, header, headerHasPrefix);
        }
        List<String> lines = this.translations.getStringList(baseKey + ".lines");
        for (String lineRaw : lines) {
            String line = this.translations.formatRaw(lineRaw, repl);
            this.sendRaw(sender, line, false);
        }
    }

    public List<String> getList(String key) {
        return this.translations.getStringList(key);
    }

    public TranslationManager.TranslationBundle getCustomTranslations(String namespace) {
        return this.translations.forCustomNamespace(namespace);
    }

    public void console(String msg) {
        Bukkit.getConsoleSender().sendMessage(this.color(msg));
    }

    public void debug(String message) {
        if (configsManager == null) {
            return;
        }
        MainConfigManager main = configsManager.getMainConfigManager();
        if (main != null && main.isDebug_mode()) {
            this.console(prefix + "&8[DEBUG] &r" + message);
        }
    }
}

