/*
 * Decompiled with CFR 0.152.
 */
package voiidstudios.vct.utils;

import java.lang.reflect.Array;
import org.bukkit.command.CommandSender;
import org.jetbrains.annotations.NotNull;
import voiidstudios.vct.VoiidCountdownTimer;
import voiidstudios.vct.utils.ServerVersion;
import voiidstudios.vct.utils.TriFunction;

public enum Formatter {
    MINIMESSAGE((plugin, player, text) -> {
        ServerVersion serverVersion = VoiidCountdownTimer.serverVersion;
        if (plugin.getDependencyManager().isPaper() && serverVersion.serverVersionGreaterEqualThan(serverVersion, ServerVersion.v1_19_R3)) {
            try {
                Class<?> miniMessageClass = Class.forName("net.kyori.adventure.text.minimessage.MiniMessage");
                Object miniMessage = miniMessageClass.getMethod("miniMessage", new Class[0]).invoke(null, new Object[0]);
                try {
                    return miniMessageClass.getMethod("deserialize", String.class).invoke(miniMessage, text);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    try {
                        return miniMessageClass.getMethod("deserialize", CharSequence.class).invoke(miniMessage, text);
                    }
                    catch (NoSuchMethodException noSuchMethodException2) {
                        try {
                            Class<?> tagResolverClass = Class.forName("net.kyori.adventure.text.minimessage.tag.resolver.TagResolver");
                            Object emptyResolvers = Array.newInstance(tagResolverClass, 0);
                            return miniMessageClass.getMethod("deserialize", String.class, emptyResolvers.getClass()).invoke(miniMessage, text, emptyResolvers);
                        }
                        catch (ClassNotFoundException | NoSuchMethodException reflectiveOperationException) {
                        }
                    }
                }
            }
            catch (Exception e) {
                plugin.getLogger().warning("MiniMessage unavailable: " + e.getClass().getName() + ": " + e.getMessage());
            }
        }
        return text.replace("&", "\u00a7");
    }, "MiniMessage"),
    LEGACY((plugin, player, text) -> {
        try {
            Class.forName("net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer");
        }
        catch (ClassNotFoundException e) {
            return text.replace("&", "\u00a7");
        }
        try {
            Class<?> legacyCls = Class.forName("net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer");
            Class<?> builderPublicClass = Class.forName("net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer$Builder");
            Object builder = legacyCls.getMethod("builder", new Class[0]).invoke(null, new Object[0]);
            builderPublicClass.getMethod("character", Character.TYPE).invoke(builder, Character.valueOf('&'));
            try {
                builderPublicClass.getMethod("hexCharacter", Character.TYPE).invoke(builder, Character.valueOf('#'));
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
            try {
                builderPublicClass.getMethod("useUnusualXRepeatedCharacterHexFormat", new Class[0]).invoke(builder, new Object[0]);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
            try {
                builderPublicClass.getMethod("hexColors", new Class[0]).invoke(builder, new Object[0]);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
            Object serializer = builderPublicClass.getMethod("build", new Class[0]).invoke(builder, new Object[0]);
            return legacyCls.getMethod("deserialize", String.class).invoke(serializer, text);
        }
        catch (Exception e) {
            plugin.getLogger().warning("Legacy unavailable: " + e.getClass().getName() + ": " + e.getMessage());
            return text.replace("&", "\u00a7");
        }
    }, "Legacy"),
    UNIVERSAL((plugin, player, text) -> {
        boolean miniCompatible;
        ServerVersion serverVersion = VoiidCountdownTimer.serverVersion;
        boolean bl = miniCompatible = plugin.getDependencyManager().isPaper() && serverVersion.serverVersionGreaterEqualThan(serverVersion, ServerVersion.v1_19_R3) && Formatter.hasMiniMessage();
        if (!Formatter.hasLegacySerializer() || !miniCompatible) {
            return text.replace("&", "\u00a7");
        }
        try {
            Class<?> legacyCls = Class.forName("net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer");
            Class<?> builderPublicClass = Class.forName("net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer$Builder");
            Object builderLegacy = legacyCls.getMethod("builder", new Class[0]).invoke(null, new Object[0]);
            builderPublicClass.getMethod("character", Character.TYPE).invoke(builderLegacy, Character.valueOf('&'));
            builderPublicClass.getMethod("hexCharacter", Character.TYPE).invoke(builderLegacy, Character.valueOf('#'));
            try {
                builderPublicClass.getMethod("useUnusualXRepeatedCharacterHexFormat", new Class[0]).invoke(builderLegacy, new Object[0]);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
            try {
                builderPublicClass.getMethod("hexColors", new Class[0]).invoke(builderLegacy, new Object[0]);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
            Object legacySerializer = builderPublicClass.getMethod("build", new Class[0]).invoke(builderLegacy, new Object[0]);
            Object builderHex = legacyCls.getMethod("builder", new Class[0]).invoke(null, new Object[0]);
            builderPublicClass.getMethod("character", Character.TYPE).invoke(builderHex, Character.valueOf('&'));
            builderPublicClass.getMethod("hexCharacter", Character.TYPE).invoke(builderHex, Character.valueOf('#'));
            try {
                builderPublicClass.getMethod("hexColors", new Class[0]).invoke(builderHex, new Object[0]);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
            Object hexSerializer = builderPublicClass.getMethod("build", new Class[0]).invoke(builderHex, new Object[0]);
            Object compFromLegacy = legacyCls.getMethod("deserialize", String.class).invoke(legacySerializer, text);
            String legacySerialized = (String)legacyCls.getMethod("serialize", Class.forName("net.kyori.adventure.text.Component")).invoke(hexSerializer, compFromLegacy);
            Object component = legacyCls.getMethod("deserialize", String.class).invoke(hexSerializer, legacySerialized);
            Class<?> miniCls = Class.forName("net.kyori.adventure.text.minimessage.MiniMessage");
            Object mini = miniCls.getMethod("miniMessage", new Class[0]).invoke(null, new Object[0]);
            String miniSerialized = (String)miniCls.getMethod("serialize", Class.forName("net.kyori.adventure.text.Component")).invoke(mini, component);
            String cleaned = miniSerialized.replace("\\<", "<").replace("\\\\", "");
            try {
                return miniCls.getMethod("deserialize", String.class).invoke(mini, cleaned);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                try {
                    return miniCls.getMethod("deserialize", CharSequence.class).invoke(mini, cleaned);
                }
                catch (NoSuchMethodException noSuchMethodException2) {
                    try {
                        Class<?> tagResolverClass = Class.forName("net.kyori.adventure.text.minimessage.tag.resolver.TagResolver");
                        Object emptyResolvers = Array.newInstance(tagResolverClass, 0);
                        return miniCls.getMethod("deserialize", String.class, emptyResolvers.getClass()).invoke(mini, cleaned, emptyResolvers);
                    }
                    catch (ClassNotFoundException | NoSuchMethodException reflectiveOperationException) {
                    }
                }
            }
        }
        catch (Exception e) {
            plugin.getLogger().warning("Universal unavailable: " + e.getClass().getName() + ": " + e.getMessage());
        }
        return text.replace("&", "\u00a7");
    }, "Universal");

    private static Boolean HAS_LEGACY_SERIALIZER;
    private static Boolean HAS_MINI_MESSAGE;
    private final TriFunction<VoiidCountdownTimer, CommandSender, String, Object> formatter;
    private final String name;

    private static boolean classExists(String className) {
        try {
            Class.forName(className);
            return true;
        }
        catch (Throwable t) {
            return false;
        }
    }

    private static boolean hasLegacySerializer() {
        if (HAS_LEGACY_SERIALIZER == null) {
            HAS_LEGACY_SERIALIZER = Formatter.classExists("net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer");
        }
        return HAS_LEGACY_SERIALIZER;
    }

    private static boolean hasMiniMessage() {
        if (HAS_MINI_MESSAGE == null) {
            HAS_MINI_MESSAGE = Formatter.classExists("net.kyori.adventure.text.minimessage.MiniMessage");
        }
        return HAS_MINI_MESSAGE;
    }

    private Formatter(TriFunction<VoiidCountdownTimer, CommandSender, String, Object> formatter, String name) {
        this.formatter = formatter;
        this.name = name;
    }

    public Object format(@NotNull VoiidCountdownTimer plugin, @NotNull CommandSender audience, @NotNull String text) {
        return this.formatter.apply(plugin, audience, text);
    }

    static {
        HAS_LEGACY_SERIALIZER = null;
        HAS_MINI_MESSAGE = null;
    }
}

