/*
 * Decompiled with CFR 0.152.
 */
package voiidstudios.vct.configs;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.bukkit.configuration.file.FileConfiguration;
import voiidstudios.vct.VoiidCountdownTimer;
import voiidstudios.vct.configs.model.CustomConfig;
import voiidstudios.vct.utils.Formatter;

public class MainConfigManager {
    private CustomConfig configFile;
    private boolean auto_update;
    private boolean update_notification;
    private int ticks_hide_after_ending;
    private String text_format;
    private int refresh_ticks;
    private boolean save_state_timers;

    public MainConfigManager(VoiidCountdownTimer plugin) {
        this.configFile = new CustomConfig("config.yml", plugin, null, false);
        this.configFile.registerConfig();
        this.checkConfigsUpdate();
    }

    public void configure() {
        FileConfiguration config = this.configFile.getConfig();
        this.auto_update = config.getBoolean("Config.auto_update");
        this.update_notification = config.getBoolean("Config.update_notification");
        this.ticks_hide_after_ending = config.getInt("Config.ticks_hide_after_ending");
        this.text_format = config.getString("Config.text_format");
        this.refresh_ticks = config.getInt("Config.refresh_ticks");
        this.save_state_timers = config.getBoolean("Config.save_state_timers");
    }

    public void reloadConfig() {
        this.configFile.reloadConfig();
        this.configure();
    }

    public FileConfiguration getConfig() {
        return this.configFile.getConfig();
    }

    public CustomConfig getConfigFile() {
        return this.configFile;
    }

    public void saveConfig() {
        this.configFile.saveConfig();
    }

    public void checkConfigsUpdate() {
        Path pathConfig = Paths.get(this.configFile.getRoute(), new String[0]);
        try {
            String text = new String(Files.readAllBytes(pathConfig));
            if (!text.contains("auto_update:")) {
                this.getConfig().set("Config.auto_update", (Object)false);
                this.saveConfig();
            }
            if (!text.contains("update_notification:")) {
                this.getConfig().set("Config.update_notification", (Object)true);
                this.saveConfig();
            }
            if (!text.contains("ticks_hide_after_ending:")) {
                this.getConfig().set("Config.ticks_hide_after_ending", (Object)60);
                this.saveConfig();
            }
            if (!text.contains("text_format:")) {
                this.getConfig().set("Config.text_format", (Object)"LEGACY");
                this.saveConfig();
            }
            if (!text.contains("refresh_ticks:")) {
                this.getConfig().set("Config.refresh_ticks", (Object)10);
                this.saveConfig();
            }
            if (!text.contains("save_state_timers:")) {
                this.getConfig().set("Config.save_state_timers", (Object)true);
                this.saveConfig();
            }
            if (!text.contains("timerSetError:")) {
                this.getConfig().set("Messages.timerSetError", (Object)"&cUse: /vct set <HH:MM:SS>");
                this.getConfig().set("Messages.timerSetFormatIncorrect", (Object)"&cIncorrect format. Please use HH:MM:SS");
                this.getConfig().set("Messages.timerSetFormatInvalid", (Object)"&cThe format does not contain a valid number.");
                this.getConfig().set("Messages.timerSetFormatOutRange", (Object)"&cThe timer must be greater than 0 seconds.");
                this.saveConfig();
            }
            if (!text.contains("timerModifyInvalid:")) {
                this.getConfig().set("Messages.timerModifyInvalid", (Object)"&cUse: /vct modify <modifier>");
                this.saveConfig();
            }
            if (!text.contains("timerModifyAddError:")) {
                this.getConfig().set("Messages.timerModifyAddError", (Object)"&cUse: /vct modify add <HH:MM:SS>");
                this.getConfig().set("Messages.timerModifyAdd", (Object)"&a%HH%:%MM%:%SS% has been added to the timer.");
                this.saveConfig();
            }
            if (!text.contains("timerModifySetError:")) {
                this.getConfig().set("Messages.timerModifySetError", (Object)"&cUse: /vct modify set <HH:MM:SS>");
                this.getConfig().set("Messages.timerModifySet", (Object)"&aThe timer was set to %HH%:%MM%:%SS%.");
                this.saveConfig();
            }
            if (!text.contains("timerModifyTakeError:")) {
                this.getConfig().set("Messages.timerModifyTakeError", (Object)"&cUse: /vct modify take <HH:MM:SS>");
                this.getConfig().set("Messages.timerModifyTake", (Object)"&a%HH%:%MM%:%SS% has been removed from the timer.");
                this.saveConfig();
            }
            if (!text.contains("timerModifyBarcolorError:")) {
                this.getConfig().set("Messages.timerModifyBarcolorError", (Object)"&cUse: /vct modify barcolor <color>. &eYou can use these colors: BLUE, GREEN, PINK, PURPLE, RED, WHITE, or YELLOW.");
                this.getConfig().set("Messages.timerModifyBarcolorInvalid", (Object)"&cThe color \"%COLOR%\" of the timer boss bar is invalid. Use BLUE, GREEN, PINK, PURPLE, RED, WHITE, or YELLOW.");
                this.getConfig().set("Messages.timerModifyBarcolor", (Object)"&aThe color of the timer %TIMER% has been changed to \"%COLOR%\".");
                this.saveConfig();
            }
            if (!text.contains("timerModifyBarstyleError:")) {
                this.getConfig().set("Messages.timerModifyBarstyleError", (Object)"&cUse: /vct modify bossbar_style <style>. &eYou can use these styles: SOLID, SEGMENTED_6, SEGMENTED_10, SEGMENTED_12, or SEGMENTED_20.");
                this.getConfig().set("Messages.timerModifyBarstyleInvalid", (Object)"&cThe style \"%STYLE%\" of the timer boss bar is invalid. Use SOLID, SEGMENTED_6, SEGMENTED_10, SEGMENTED_12, or SEGMENTED_20.");
                this.getConfig().set("Messages.timerModifyBarstyle", (Object)"&aThe style of the timer %TIMER% has been changed to \"%STYLE%\".");
                this.saveConfig();
            }
            if (!text.contains("timerModifySoundError:")) {
                this.getConfig().set("Messages.timerModifySoundError", (Object)"&cUse: /vct modify sound <\"sound in quotes\">");
                this.getConfig().set("Messages.timerModifySoundRequireQuotes", (Object)"&cThe sound needs to be enclosed in quotation marks (\") in order to change it.");
                this.getConfig().set("Messages.timerModifySound", (Object)"&aThe sound of the timer %TIMER% has been changed to \"%SOUND%\" &e(%TYPE%)&a.");
                this.saveConfig();
            }
            if (!text.contains("timerModifySoundenableError:")) {
                this.getConfig().set("Messages.timerModifySoundenableError", (Object)"&cUse: /vct modify soundenable <true|false>");
                this.getConfig().set("Messages.timerModifySoundenableInvalid", (Object)"&cThe boolean is invalid. Use TRUE or FALSE.");
                this.getConfig().set("Messages.timerModifySoundenable", (Object)"&aThe sound enable of the timer %TIMER% has been changed to %SOUNDENABLE%.");
                this.saveConfig();
            }
            if (!text.contains("timerModifySoundvolumeError:")) {
                this.getConfig().set("Messages.timerModifySoundvolumeError", (Object)"&cUse: /vct modify sound_volume <0.1 - 2.0>");
                this.getConfig().set("Messages.timerModifySoundvolumeInvalid", (Object)"&cThe number is invalid. Please use a number between &e0.1 &cand &e2.0.");
                this.getConfig().set("Messages.timerModifySoundvolumeOutRange", (Object)"&cThe volume must be between &e0.1 &cand &e2.0&c.");
                this.getConfig().set("Messages.timerModifySoundvolume", (Object)"&aThe sound_volume of the timer %TIMER% has been changed to &e%VOLUME%&a.");
                this.saveConfig();
            }
            if (!text.contains("timerModifySoundpitchError:")) {
                this.getConfig().set("Messages.timerModifySoundpitchError", (Object)"&cUse: /vct modify sound_pitch <0.1 - 2.0>");
                this.getConfig().set("Messages.timerModifySoundpitchInvalid", (Object)"&cThe number is invalid. Please use a number between &e0.1 &cand &e2.0.");
                this.getConfig().set("Messages.timerModifySoundpitchOutRange", (Object)"&cThe pitch must be between &e0.1 &cand &e2.0&c.");
                this.getConfig().set("Messages.timerModifySoundpitch", (Object)"&aThe sound_pitch of the timer %TIMER% has been changed to &e%PITCH%&a.");
                this.saveConfig();
            }
            if (!text.contains("timerModifyTextError:")) {
                this.getConfig().set("Messages.timerModifyTextError", (Object)"&cUse: /vct modify text <\"text in quotes\">");
                this.getConfig().set("Messages.timerModifyTextRequireQuotes", (Object)"&cThe text needs to be enclosed in quotation marks (\") in order to change it.");
                this.getConfig().set("Messages.timerModifyText", (Object)"&aThe text of the timer %TIMER% has been changed to \"&r%TEXT%&a\".");
                this.saveConfig();
            }
            if (!text.contains("timerStart:")) {
                this.getConfig().set("Messages.timerStart", (Object)"&aTimer started of %HH%:%MM%:%SS%!");
                this.saveConfig();
            }
            if (!text.contains("timerPause:")) {
                this.getConfig().set("Messages.timerPause", (Object)"&6Timer paused!");
                this.saveConfig();
            }
            if (!text.contains("timerResume:")) {
                this.getConfig().set("Messages.timerResume", (Object)"&6Timer resumed!");
                this.saveConfig();
            }
            if (!text.contains("timerStop:")) {
                this.getConfig().set("Messages.timerStop", (Object)"&6Timer stopped!");
                this.saveConfig();
            }
            if (!text.contains("timerDontExists:")) {
                this.getConfig().set("Messages.timerDontExists", (Object)"&cThe timer does not exist.");
                this.saveConfig();
            }
            if (!text.contains("timerConfigNotFound:")) {
                this.getConfig().set("Messages.timerConfigNotFound", (Object)"&cThe timer configuration could not be found.");
                this.saveConfig();
            }
            if (this.getConfig().contains("Timers")) {
                for (String timerKey : this.getConfig().getConfigurationSection("Timers").getKeys(false)) {
                    String base = "Timers." + timerKey + ".";
                    if (!this.getConfig().contains(base + "text")) {
                        this.getConfig().set(base + "text", (Object)"%HH%:%MM%:%SS%");
                    }
                    if (!this.getConfig().contains(base + "sound")) {
                        this.getConfig().set(base + "sound", (Object)"UI_BUTTON_CLICK");
                    }
                    if (!this.getConfig().contains(base + "sound_volume")) {
                        this.getConfig().set(base + "sound_volume", (Object)1.0);
                    }
                    if (!this.getConfig().contains(base + "sound_pitch")) {
                        this.getConfig().set(base + "sound_pitch", (Object)1.0);
                    }
                    if (!this.getConfig().contains(base + "bossbar_color")) {
                        this.getConfig().set(base + "bossbar_color", (Object)"WHITE");
                    }
                    if (!this.getConfig().contains(base + "bossbar_style")) {
                        this.getConfig().set(base + "bossbar_style", (Object)"SOLID");
                    }
                    if (!this.getConfig().contains(base + "enabled")) {
                        this.getConfig().set(base + "enabled", (Object)true);
                    }
                    if (this.getConfig().contains(base + "sound_enabled")) continue;
                    this.getConfig().set(base + "sound_enabled", (Object)false);
                }
                this.saveConfig();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public boolean isAuto_update() {
        return this.auto_update;
    }

    public boolean isUpdate_notification() {
        return this.update_notification;
    }

    public boolean isSave_state_timers() {
        return this.save_state_timers;
    }

    public int getTicks_hide_after_ending() {
        return this.ticks_hide_after_ending;
    }

    public Formatter getFormatter() {
        try {
            return Formatter.valueOf(this.text_format.toUpperCase());
        }
        catch (IllegalArgumentException | NullPointerException e) {
            return Formatter.LEGACY;
        }
    }

    public int getRefresh_ticks() {
        return this.refresh_ticks;
    }
}

