/*
 * Decompiled with CFR 0.152.
 */
package voiidstudios.vct.api;

import me.clip.placeholderapi.expansion.PlaceholderExpansion;
import org.bukkit.OfflinePlayer;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import voiidstudios.vct.VoiidCountdownTimer;
import voiidstudios.vct.api.Timer;
import voiidstudios.vct.configs.model.TimerConfig;
import voiidstudios.vct.managers.TimerManager;

public class PAPIExpansion
extends PlaceholderExpansion {
    private final JavaPlugin plugin;

    public PAPIExpansion(JavaPlugin plugin) {
        this.plugin = plugin;
    }

    @NotNull
    public String getIdentifier() {
        return "vct";
    }

    @NotNull
    public String getAuthor() {
        return String.join((CharSequence)",", this.plugin.getDescription().getAuthors());
    }

    @NotNull
    public String getVersion() {
        return this.plugin.getDescription().getVersion();
    }

    @Nullable
    public String onRequest(OfflinePlayer player, @NotNull String params) {
        String id = null;
        String base = params;
        int idx = params.indexOf(58);
        if (idx > 0) {
            base = params.substring(0, idx);
            id = params.substring(idx + 1);
            if (id.isEmpty()) {
                id = null;
            }
        }
        switch (base.toLowerCase()) {
            case "timer_hhmmss": {
                return this.getTimerValueHHMMSS(id);
            }
            case "timer_hh": {
                return this.getTimerValueHH(id);
            }
            case "timer_mm": {
                return this.getTimerValueMM(id);
            }
            case "timer_ss": {
                return this.getTimerValueSS(id);
            }
            case "timer_active": {
                return this.isTimerActive(id);
            }
            case "timer_running": {
                return this.isTimerRunning(id);
            }
            case "timer_paused": {
                return this.isTimerPaused(id);
            }
        }
        return null;
    }

    private Timer getActiveTimerIfMatches(String id) {
        Timer current = TimerManager.getInstance().getTimer();
        if (id == null) {
            return current;
        }
        if (current != null && current.getTimerId() != null && current.getTimerId().equalsIgnoreCase(id)) {
            return current;
        }
        return null;
    }

    private TimerConfig getConfigIfExists(String id) {
        if (id == null) {
            return null;
        }
        return VoiidCountdownTimer.getConfigsManager().getTimerConfig(id);
    }

    private String getTimerValueHHMMSS(String id) {
        Timer t = this.getActiveTimerIfMatches(id);
        if (t != null) {
            return t.getTimeLeft();
        }
        TimerConfig cfg = this.getConfigIfExists(id);
        return cfg != null ? "00:00:00" : null;
    }

    private String getTimerValueHH(String id) {
        Timer t = this.getActiveTimerIfMatches(id);
        if (t != null) {
            return t.getTimeLeftHH();
        }
        TimerConfig cfg = this.getConfigIfExists(id);
        return cfg != null ? "00" : null;
    }

    private String getTimerValueMM(String id) {
        Timer t = this.getActiveTimerIfMatches(id);
        if (t != null) {
            return t.getTimeLeftMM();
        }
        TimerConfig cfg = this.getConfigIfExists(id);
        return cfg != null ? "00" : null;
    }

    private String getTimerValueSS(String id) {
        Timer t = this.getActiveTimerIfMatches(id);
        if (t != null) {
            return t.getTimeLeftSS();
        }
        TimerConfig cfg = this.getConfigIfExists(id);
        return cfg != null ? "00" : null;
    }

    private String isTimerActive(String id) {
        if (id == null) {
            return String.valueOf(TimerManager.getInstance().getTimer() != null);
        }
        Timer t = this.getActiveTimerIfMatches(id);
        if (t != null) {
            return "true";
        }
        TimerConfig cfg = this.getConfigIfExists(id);
        return cfg != null ? "false" : null;
    }

    private String isTimerRunning(String id) {
        Timer t = this.getActiveTimerIfMatches(id);
        if (t != null) {
            return String.valueOf(t.isActive());
        }
        TimerConfig cfg = this.getConfigIfExists(id);
        return cfg != null ? "false" : null;
    }

    private String isTimerPaused(String id) {
        Timer t = this.getActiveTimerIfMatches(id);
        if (t != null) {
            return String.valueOf(!t.isActive());
        }
        TimerConfig cfg = this.getConfigIfExists(id);
        return cfg != null ? "false" : null;
    }
}

