/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom.mask;

import com.mojang.datafixers.util.Pair;
import com.moulberry.axiom.DefaultBlocks;
import com.moulberry.axiom.block_maps.BlockColourMap;
import com.moulberry.axiom.clipboard.Selection;
import com.moulberry.axiom.collections.Position2dToIntMap;
import com.moulberry.axiom.mask.LuaJavaLoader;
import com.moulberry.axiom.mask.MaskContext;
import com.moulberry.axiom.noise.SimplexNoise;
import com.moulberry.axiom.noise.VoronoiEdgesNoise;
import com.moulberry.axiom.tools.Tool;
import com.moulberry.axiom.utils.ItemStackDataHelper;
import com.moulberry.axiom.utils.OkLabColourUtils;
import com.moulberry.axiom.utils.Utf8ChatOutputStream;
import imgui.extension.texteditor.TextEditorLanguageDefinition;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ThreadLocalRandom;
import net.minecraft.class_124;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_5321;
import net.minecraft.class_638;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_6885;
import net.minecraft.class_746;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import org.jetbrains.annotations.Nullable;
import org.luaj.vm2.Globals;
import org.luaj.vm2.LoadState;
import org.luaj.vm2.LuaBoolean;
import org.luaj.vm2.LuaFunction;
import org.luaj.vm2.LuaNil;
import org.luaj.vm2.LuaNumber;
import org.luaj.vm2.LuaString;
import org.luaj.vm2.LuaTable;
import org.luaj.vm2.LuaThread;
import org.luaj.vm2.LuaValue;
import org.luaj.vm2.Prototype;
import org.luaj.vm2.Varargs;
import org.luaj.vm2.compiler.LuaC;
import org.luaj.vm2.lib.Bit32Lib;
import org.luaj.vm2.lib.OneArgFunction;
import org.luaj.vm2.lib.TableLib;
import org.luaj.vm2.lib.ThreeArgFunction;
import org.luaj.vm2.lib.TwoArgFunction;
import org.luaj.vm2.lib.VarArgFunction;
import org.luaj.vm2.lib.jse.JseBaseLib;
import org.luaj.vm2.lib.jse.JseMathLib;
import org.luaj.vm2.lib.jse.JseStringLib;

public class LuaHelper {
    private static final LuaValue LUA_X = LuaValue.valueOf("x");
    private static final LuaValue LUA_Y = LuaValue.valueOf("y");
    private static final LuaValue LUA_Z = LuaValue.valueOf("z");
    private static final LuaValue LUA_PLAYER_X = LuaValue.valueOf("player_x");
    private static final LuaValue LUA_PLAYER_Y = LuaValue.valueOf("player_y");
    private static final LuaValue LUA_PLAYER_Z = LuaValue.valueOf("player_z");
    private static final LuaValue LUA_PLAYER_YAW = LuaValue.valueOf("player_yaw");
    private static final LuaValue LUA_PLAYER_PITCH = LuaValue.valueOf("player_pitch");
    private static final LuaValue LUA_ACTIVE_BLOCK_STATE = LuaValue.valueOf("activeBlockState");
    private static LuaTable luaTableBlock = null;

    public static String getAvailableLuaFunctions(boolean allowSetBlock) {
        Object functions = "Custom variables:\nx, y, z -> coords of target location\nblocks.abc -> retrieve the id for a Block, eg. blocks.stone for the id of stone\nplayer_x, player_y, player_z, player_yaw, player_pitch -> position of player when executing script\nactiveBlockState -> the BlockState in the 'Active Block State' window\n\nCustom functions:\ngetBlock(x, y, z) -> get the Block id at position xyz\ngetBlockState(x, y, z) -> get the BlockState id at position xyz\ngetHighestBlockYAt(x, z) -> get the y coordinate of the highest solid block at xz\ngetSimplexNoise(x, y, z, (seed)) -> sample simplex noise at position x, y, z\ngetVoronoiEdgeNoise(x, y, z, (seed)) -> sample voronoi edge noise at position xyz\nisSolid(block) -> get if the block argument is solid\nisBlockTagged(block, \"tag\") -> get if the block argument has the given block tag\nwithBlockProperty(block, \"property=value\", ...) -> update property to value for block\ngetBlockProperty(block, \"property\") -> gets the value of a property as a string, or nil if it doesn't exist\ngetBlockRGB(block) -> gets the average rgb of the given block\nfindClosestBlockToRGB(rgb, (flags), (index)) -> finds the block that's closest to the given RGB value\nisSelected(x, y, z) -> get if position xyz is selected, or true if there is no selection\n";
        if (allowSetBlock) {
            functions = (String)functions + "setBlock(x, y, z, block) -> set an additional block at the position x, y, z\n";
        }
        return functions;
    }

    public static TextEditorLanguageDefinition createTextEditorLanguageDefinition(boolean allowSetBlock) {
        TextEditorLanguageDefinition lang = TextEditorLanguageDefinition.lua();
        Map<String, String> identifiers = Map.ofEntries(Map.entry("getBlock", "get the Block id at position"), Map.entry("getBlockState", "get the BlockState id at position"), Map.entry("getHighestBlockYAt", "get the y coordinate of the highest solid block"), Map.entry("getSimplexNoise", "sample simplex noise at position"), Map.entry("getVoronoiEdgeNoise", "sample voronoi edge noise at position"), Map.entry("isSolid", "get if the block argument is solid"), Map.entry("isBlockTagged", "get if the block argument has the given block tag"), Map.entry("withBlockProperty", "update property to value for block"), Map.entry("getBlockProperty", "gets the value of a property as a string, or nil if it doesn't exist"), Map.entry("getBlockRGB", "gets the average rgb of the given block"), Map.entry("findClosestBlockToRGB", "finds the block that's closest to the given RGB value"), Map.entry("isSelected", "checks if the position is selected, always true if there is no selection"));
        if (allowSetBlock) {
            identifiers = new HashMap<String, String>(identifiers);
            identifiers.put("setBlock", "set an additional block at the position x, y, z");
        }
        lang.setIdentifiers(identifiers);
        return lang;
    }

    public static Globals createSandboxed() {
        Globals globals = new Globals();
        globals.load(new JseBaseLib());
        globals.load(new Bit32Lib());
        globals.load(new TableLib());
        globals.load(new JseStringLib());
        globals.load(new JseMathLib());
        globals.set("dofile", LuaValue.NIL);
        globals.set("loadfile", LuaValue.NIL);
        globals.set("collectgarbage", LuaValue.NIL);
        LuaNil.s_metatable = LuaHelper.makeReadOnly(LuaNil.s_metatable);
        LuaNumber.s_metatable = LuaHelper.makeReadOnly(LuaNumber.s_metatable);
        LuaBoolean.s_metatable = LuaHelper.makeReadOnly(LuaBoolean.s_metatable);
        LuaString.s_metatable = LuaHelper.makeReadOnly(LuaString.s_metatable);
        LuaFunction.s_metatable = LuaHelper.makeReadOnly(LuaFunction.s_metatable);
        LuaThread.s_metatable = LuaHelper.makeReadOnly(LuaThread.s_metatable);
        LoadState.install(globals);
        LuaC.install(globals);
        globals.finder = null;
        globals.STDOUT = new PrintStream((OutputStream)new Utf8ChatOutputStream(class_124.field_1068), false, StandardCharsets.UTF_8);
        globals.STDERR = new PrintStream((OutputStream)new Utf8ChatOutputStream(class_124.field_1061), false, StandardCharsets.UTF_8);
        return globals;
    }

    public static LuaFunction compile(String script, Globals globals) {
        try {
            Prototype prototype = LuaC.instance.compile(new ByteArrayInputStream(script.getBytes(StandardCharsets.UTF_8)), "script");
            LuaJavaLoader loader = new LuaJavaLoader(LuaHelper.class.getClassLoader());
            String classname = "com.moulberry.axiom.dynamic.LuaScript" + ThreadLocalRandom.current().nextLong(Long.MAX_VALUE);
            return loader.load(prototype, classname, "script.lua", globals);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static int blockToInternalId(class_2248 block) {
        return class_7923.field_41175.method_10206((Object)block);
    }

    public static int stateToInternalId(class_2680 blockState) {
        return -class_2248.field_10651.method_10206((Object)blockState) - 1;
    }

    @Nullable
    public static class_2680 internalIdToState(int id) {
        if (id < 0) {
            int stateId = -id - 1;
            return (class_2680)class_2248.field_10651.method_10200(stateId);
        }
        Optional holderOpt = class_7923.field_41175.method_40265(id);
        if (!holderOpt.isPresent()) {
            return null;
        }
        return DefaultBlocks.forBlock((class_2248)((class_6880.class_6883)holderOpt.get()).comp_349());
    }

    @Nullable
    private static class_6885.class_6888<class_2248> lookupTag(String tag, Map<String, Optional<class_6885.class_6888<class_2248>>> cache) {
        Optional<class_6885.class_6888<class_2248>> cached = cache.get(tag);
        if (cached != null) {
            return cached.orElse(null);
        }
        class_2960 resourceLocation = class_2960.method_60654((String)tag);
        Optional<class_6885.class_6888> tagOpt = class_7923.field_41175.method_40266(class_6862.method_40092((class_5321)class_7924.field_41254, (class_2960)resourceLocation));
        if (tagOpt.isEmpty()) {
            tagOpt = class_7923.field_41175.method_40272().filter(pair -> ((class_6862)pair.getFirst()).comp_327().method_12832().equals(tag)).findAny().map(Pair::getSecond);
        }
        cache.put(tag, (Optional<class_6885.class_6888<class_2248>>)tagOpt);
        return tagOpt.orElse(null);
    }

    public static void initializeGeneric(Globals globals, final @Nullable SetBlockInterface setBlockInterface) {
        final class_638 level = class_310.method_1551().field_1687;
        final class_2338.class_2339 mutableBlockPos = new class_2338.class_2339();
        final Position2dToIntMap heightmap = new Position2dToIntMap(Integer.MIN_VALUE);
        globals.set(LUA_X, (LuaValue)LuaValue.valueOf(0));
        globals.set(LUA_Y, (LuaValue)LuaValue.valueOf(0));
        globals.set(LUA_Z, (LuaValue)LuaValue.valueOf(0));
        LuaHelper.updateExtraVariables(globals);
        globals.set("getBlock", (LuaValue)new ThreeArgFunction(){

            @Override
            public LuaValue call(LuaValue x, LuaValue y, LuaValue z) {
                class_2680 blockState = level.method_8320((class_2338)mutableBlockPos.method_10103(x.toint(), y.toint(), z.toint()));
                return LuaValue.valueOf(LuaHelper.blockToInternalId(blockState.method_26204()));
            }
        });
        globals.set("getBlockState", (LuaValue)new ThreeArgFunction(){

            @Override
            public LuaValue call(LuaValue x, LuaValue y, LuaValue z) {
                class_2680 blockState = level.method_8320((class_2338)mutableBlockPos.method_10103(x.toint(), y.toint(), z.toint()));
                return LuaValue.valueOf(LuaHelper.stateToInternalId(blockState));
            }
        });
        globals.set("isSolid", (LuaValue)new OneArgFunction(){

            @Override
            public LuaValue call(LuaValue arg) {
                int id = arg.toint();
                class_2680 blockState = LuaHelper.internalIdToState(id);
                if (blockState == null) {
                    return LuaValue.NIL;
                }
                return LuaValue.valueOf(blockState.method_51366());
            }
        });
        final HashMap cachedBlockTags = new HashMap();
        globals.set("isBlockTagged", (LuaValue)new TwoArgFunction(){

            @Override
            public LuaValue call(LuaValue arg1, LuaValue arg2) {
                int id = arg1.toint();
                class_2680 blockState = LuaHelper.internalIdToState(id);
                if (blockState == null) {
                    return LuaValue.NIL;
                }
                String tag = arg2.tojstring().toLowerCase(Locale.ROOT);
                class_6885.class_6888<class_2248> set = LuaHelper.lookupTag(tag, cachedBlockTags);
                if (set == null) {
                    return LuaValue.error("tag '" + tag + "' doesn't exist");
                }
                return LuaValue.valueOf(blockState.method_40143(set));
            }
        });
        globals.set("getFluidBlockStateOrAir", (LuaValue)new OneArgFunction(){

            @Override
            public LuaValue call(LuaValue arg) {
                int id = arg.toint();
                class_2680 blockState = LuaHelper.internalIdToState(id);
                if (blockState == null) {
                    return LuaValue.NIL;
                }
                return LuaValue.valueOf(LuaHelper.stateToInternalId(blockState.method_26227().method_15759()));
            }
        });
        final int randomSeed = ThreadLocalRandom.current().nextInt();
        globals.set("getSimplexNoise", (LuaValue)new VarArgFunction(){

            @Override
            public Varargs onInvoke(Varargs args) {
                LuaValue seedArg = args.arg(4);
                double x = args.arg(1).todouble();
                double y = args.arg(2).todouble();
                double z = args.arg(3).todouble();
                if (!seedArg.isnil()) {
                    return LuaValue.valueOf(SimplexNoise.evaluateStatic(x, y, z, seedArg.toint()));
                }
                return LuaValue.valueOf(SimplexNoise.evaluateStatic(x, y, z, randomSeed));
            }
        });
        globals.set("getVoronoiEdgeNoise", (LuaValue)new VarArgFunction(){

            @Override
            public Varargs onInvoke(Varargs args) {
                LuaValue seedArg = args.arg(4);
                double x = args.arg(1).todouble();
                double y = args.arg(2).todouble();
                double z = args.arg(3).todouble();
                if (!seedArg.isnil()) {
                    return LuaValue.valueOf(VoronoiEdgesNoise.evaluateStatic(x, y, z, seedArg.toint(), 1.0f));
                }
                return LuaValue.valueOf(VoronoiEdgesNoise.evaluateStatic(x, y, z, randomSeed, 1.0f));
            }
        });
        globals.set("getBlockProperty", (LuaValue)new TwoArgFunction(){

            @Override
            public LuaValue call(LuaValue arg1, LuaValue arg2) {
                int block = arg1.toint();
                class_2680 blockState = LuaHelper.internalIdToState(block);
                if (blockState == null) {
                    return LuaValue.NIL;
                }
                class_2689 stateDefinition = blockState.method_26204().method_9595();
                class_2769 property = stateDefinition.method_11663(arg2.tojstring().trim().toLowerCase(Locale.ROOT));
                if (property == null) {
                    return LuaValue.NIL;
                }
                return LuaValue.valueOf(LuaHelper.serialize(blockState, property));
            }
        });
        globals.set("getBlockRGB", (LuaValue)new OneArgFunction(){

            @Override
            public LuaValue call(LuaValue arg1) {
                int block = arg1.toint();
                class_2680 blockState = LuaHelper.internalIdToState(block);
                if (blockState == null) {
                    return LuaValue.NIL;
                }
                class_243 lab = BlockColourMap.getLab(blockState.method_26204());
                if (lab == null) {
                    return LuaValue.NIL;
                }
                return LuaValue.valueOf(OkLabColourUtils.lab2rgb(lab.field_1352, lab.field_1351, lab.field_1350));
            }
        });
        globals.set("findClosestBlockToRGB", (LuaValue)new VarArgFunction(){

            @Override
            public LuaValue onInvoke(Varargs args) {
                int rgb = args.arg(1).toint();
                int flags = BlockColourMap.FLAG_SOLID | BlockColourMap.FLAG_OPAQUE | BlockColourMap.FLAG_FULL_CUBE;
                if (!args.arg(2).isnil()) {
                    flags = args.arg(2).toint();
                }
                int index = 1;
                if (!args.arg(3).isnil()) {
                    index = args.arg(3).toint();
                }
                if (index <= 0) {
                    return LuaValue.error("index must be greater than zero");
                }
                double[] lab = new double[3];
                OkLabColourUtils.rgb2lab(rgb >> 16 & 0xFF, rgb >> 8 & 0xFF, rgb & 0xFF, lab);
                List<class_2680> list = BlockColourMap.getNearestLabN(lab[0], lab[1], lab[2], flags, index);
                class_2680 blockState = list.get(list.size() - 1);
                return LuaValue.valueOf(LuaHelper.stateToInternalId(blockState));
            }
        });
        globals.set("withBlockProperty", (LuaValue)new VarArgFunction(){

            @Override
            public Varargs onInvoke(Varargs args) {
                int block = args.toint(1);
                class_2680 blockState = LuaHelper.internalIdToState(block);
                class_2689 stateDefinition = blockState.method_26204().method_9595();
                int count = args.narg() - 1;
                for (int i = 0; i < count; ++i) {
                    String string = args.tojstring(i + 2);
                    for (String propertySetter : string.split(",")) {
                        String[] split = propertySetter.split("=");
                        if (split.length >= 2) {
                            String propertyName = split[0].trim().toLowerCase(Locale.ROOT);
                            class_2769 property = stateDefinition.method_11663(propertyName);
                            if (property == null) continue;
                            String propertyValue = split[1].trim().toLowerCase(Locale.ROOT);
                            blockState = ItemStackDataHelper.updateStateString(blockState, property, propertyValue);
                            continue;
                        }
                        return LuaValue.argerror(i + 2, "missing equals sign. for example 'facing=west'");
                    }
                }
                return LuaValue.valueOf(LuaHelper.stateToInternalId(blockState));
            }
        });
        globals.set("getHighestBlockYAt", (LuaValue)new TwoArgFunction(){

            @Override
            public LuaValue call(LuaValue x, LuaValue z) {
                int zi;
                int xi = x.toint();
                int currentValue = heightmap.get(xi, zi = z.toint());
                if (currentValue == Integer.MIN_VALUE) {
                    int y = level.method_31600() - 1;
                    while (true) {
                        class_2680 blockState;
                        if ((blockState = level.method_8320((class_2338)mutableBlockPos.method_10103(xi, y, zi))).method_26204() == class_2246.field_10243 || blockState.method_51366()) {
                            heightmap.put(xi, zi, y);
                            return LuaValue.valueOf(y);
                        }
                        --y;
                    }
                }
                return LuaValue.valueOf(currentValue);
            }
        });
        if (setBlockInterface != null) {
            globals.set("setBlock", (LuaValue)new VarArgFunction(){

                @Override
                public Varargs onInvoke(Varargs args) {
                    int x = args.arg(1).toint();
                    int y = args.arg(2).toint();
                    int z = args.arg(3).toint();
                    int id = args.arg(4).toint();
                    class_2680 blockState = LuaHelper.internalIdToState(id);
                    if (blockState != null) {
                        setBlockInterface.setBlock(x, y, z, blockState);
                    }
                    return LuaValue.NIL;
                }
            });
        }
        globals.set("isSelected", (LuaValue)new ThreeArgFunction(){

            @Override
            public LuaValue call(LuaValue x, LuaValue y, LuaValue z) {
                return LuaValue.valueOf(Selection.contains(x.toint(), y.toint(), z.toint()));
            }
        });
        globals.set("blocks", (LuaValue)LuaHelper.getBlockTable());
    }

    private static <T extends Comparable<T>> String serialize(class_2680 blockState, class_2769<T> property) {
        Comparable comparable = blockState.method_11654(property);
        return property.method_11901(comparable);
    }

    public static void initializeMask(Globals globals, final MaskContext maskContext, int x, int y, int z) {
        globals.set(LUA_X, (LuaValue)LuaValue.valueOf(x));
        globals.set(LUA_Y, (LuaValue)LuaValue.valueOf(y));
        globals.set(LUA_Z, (LuaValue)LuaValue.valueOf(z));
        LuaHelper.updateExtraVariables(globals);
        globals.set("getBlock", (LuaValue)new ThreeArgFunction(){

            @Override
            public LuaValue call(LuaValue x, LuaValue y, LuaValue z) {
                class_2680 blockState = maskContext.getBlockStateAt(x.toint(), y.toint(), z.toint());
                return LuaValue.valueOf(LuaHelper.blockToInternalId(blockState.method_26204()));
            }
        });
        globals.set("getBlockState", (LuaValue)new ThreeArgFunction(){

            @Override
            public LuaValue call(LuaValue x, LuaValue y, LuaValue z) {
                class_2680 blockState = maskContext.getBlockStateAt(x.toint(), y.toint(), z.toint());
                return LuaValue.valueOf(LuaHelper.stateToInternalId(blockState));
            }
        });
        globals.set("isSolid", (LuaValue)new OneArgFunction(){

            @Override
            public LuaValue call(LuaValue arg) {
                int id = arg.toint();
                class_2680 blockState = LuaHelper.internalIdToState(id);
                if (blockState == null) {
                    return LuaValue.NIL;
                }
                return LuaValue.valueOf(blockState.method_51366());
            }
        });
        final HashMap cachedBlockTags = new HashMap();
        globals.set("isBlockTagged", (LuaValue)new TwoArgFunction(){

            @Override
            public LuaValue call(LuaValue arg1, LuaValue arg2) {
                int id = arg1.toint();
                class_2680 blockState = LuaHelper.internalIdToState(id);
                if (blockState == null) {
                    return LuaValue.NIL;
                }
                String tag = arg2.tojstring().toLowerCase(Locale.ROOT);
                class_6885.class_6888<class_2248> set = LuaHelper.lookupTag(tag, cachedBlockTags);
                if (set == null) {
                    return LuaValue.error("tag '" + tag + "' doesn't exist");
                }
                return LuaValue.valueOf(blockState.method_40143(set));
            }
        });
        globals.set("getFluidBlockStateOrAir", (LuaValue)new OneArgFunction(){

            @Override
            public LuaValue call(LuaValue arg) {
                int id = arg.toint();
                class_2680 blockState = LuaHelper.internalIdToState(id);
                if (blockState == null) {
                    return LuaValue.NIL;
                }
                return LuaValue.valueOf(LuaHelper.stateToInternalId(blockState.method_26227().method_15759()));
            }
        });
        final int randomSeed = ThreadLocalRandom.current().nextInt();
        globals.set("getSimplexNoise", (LuaValue)new VarArgFunction(){

            @Override
            public Varargs onInvoke(Varargs args) {
                LuaValue seedArg = args.arg(4);
                double x = args.arg(1).todouble();
                double y = args.arg(2).todouble();
                double z = args.arg(3).todouble();
                if (!seedArg.isnil()) {
                    return LuaValue.valueOf(SimplexNoise.evaluateStatic(x, y, z, seedArg.toint()));
                }
                return LuaValue.valueOf(SimplexNoise.evaluateStatic(x, y, z, randomSeed));
            }
        });
        globals.set("getVoronoiEdgeNoise", (LuaValue)new VarArgFunction(){

            @Override
            public Varargs onInvoke(Varargs args) {
                LuaValue seedArg = args.arg(4);
                double x = args.arg(1).todouble();
                double y = args.arg(2).todouble();
                double z = args.arg(3).todouble();
                if (!seedArg.isnil()) {
                    return LuaValue.valueOf(VoronoiEdgesNoise.evaluateStatic(x, y, z, seedArg.toint(), 1.0f));
                }
                return LuaValue.valueOf(VoronoiEdgesNoise.evaluateStatic(x, y, z, randomSeed, 1.0f));
            }
        });
        globals.set("getBlockProperty", (LuaValue)new TwoArgFunction(){

            @Override
            public LuaValue call(LuaValue arg1, LuaValue arg2) {
                int block = arg1.toint();
                class_2680 blockState = LuaHelper.internalIdToState(block);
                class_2689 stateDefinition = blockState.method_26204().method_9595();
                class_2769 property = stateDefinition.method_11663(arg2.tojstring().trim().toLowerCase(Locale.ROOT));
                if (property == null) {
                    return LuaValue.NIL;
                }
                return LuaValue.valueOf(LuaHelper.serialize(blockState, property));
            }
        });
        globals.set("withBlockProperty", (LuaValue)new ThreeArgFunction(){

            @Override
            public LuaValue call(LuaValue block, LuaValue propertyName, LuaValue propertyValue) {
                class_2680 blockState = LuaHelper.internalIdToState(block.toint());
                class_2689 stateDefinition = blockState.method_26204().method_9595();
                class_2769 property = stateDefinition.method_11663(propertyName.tojstring());
                if (property != null) {
                    blockState = ItemStackDataHelper.updateStateString(blockState, property, propertyValue.tojstring());
                }
                return LuaValue.valueOf(LuaHelper.stateToInternalId(blockState));
            }
        });
        globals.set("getHighestBlockYAt", (LuaValue)new TwoArgFunction(){

            @Override
            public LuaValue call(LuaValue x, LuaValue z) {
                return LuaValue.valueOf(maskContext.getHighestBlock(x.toint(), z.toint()));
            }
        });
        globals.set("isSelected", (LuaValue)new ThreeArgFunction(){

            @Override
            public LuaValue call(LuaValue x, LuaValue y, LuaValue z) {
                return LuaValue.valueOf(Selection.contains(x.toint(), y.toint(), z.toint()));
            }
        });
        globals.set("blocks", (LuaValue)LuaHelper.getBlockTable());
    }

    public static void setPosition(Globals globals, int x, int y, int z) {
        globals.set(LUA_X, (LuaValue)LuaValue.valueOf(x));
        globals.set(LUA_Y, (LuaValue)LuaValue.valueOf(y));
        globals.set(LUA_Z, (LuaValue)LuaValue.valueOf(z));
    }

    public static void updateExtraVariables(Globals globals) {
        class_746 player = class_310.method_1551().field_1724;
        if (player != null) {
            globals.set(LUA_PLAYER_X, (LuaValue)LuaValue.valueOf(player.method_23317()));
            globals.set(LUA_PLAYER_Y, (LuaValue)LuaValue.valueOf(player.method_23318()));
            globals.set(LUA_PLAYER_Z, (LuaValue)LuaValue.valueOf(player.method_23321()));
            globals.set(LUA_PLAYER_YAW, (LuaValue)LuaValue.valueOf(player.method_36454()));
            globals.set(LUA_PLAYER_PITCH, (LuaValue)LuaValue.valueOf(player.method_36455()));
        }
        globals.set(LUA_ACTIVE_BLOCK_STATE, (LuaValue)LuaValue.valueOf(LuaHelper.stateToInternalId(Tool.getActiveBlock())));
    }

    private static LuaTable getBlockTable() {
        if (luaTableBlock != null) {
            return luaTableBlock;
        }
        luaTableBlock = new LuaTable();
        HashMap<String, LuaTable> subTables = new HashMap<String, LuaTable>();
        for (class_2248 block : class_7923.field_41175) {
            class_2960 key = class_7923.field_41175.method_10221((Object)block);
            int value = class_7923.field_41175.method_10206((Object)block);
            String namespace = key.method_12836();
            if (namespace.equals("minecraft")) {
                luaTableBlock.set(key.method_12832(), value);
                continue;
            }
            if (!subTables.containsKey(namespace)) {
                LuaTable subTable = new LuaTable();
                luaTableBlock.set(namespace, (LuaValue)subTable);
                subTables.put(namespace, subTable);
            }
            ((LuaTable)subTables.get(namespace)).set(key.method_12832(), value);
        }
        return luaTableBlock;
    }

    public static LuaTable makeReadOnly(LuaValue value) {
        if (value == null) {
            return null;
        }
        if (value instanceof ReadOnlyLuaTable) {
            ReadOnlyLuaTable readOnlyLuaTable = (ReadOnlyLuaTable)value;
            return readOnlyLuaTable;
        }
        return new ReadOnlyLuaTable(value);
    }

    @FunctionalInterface
    public static interface SetBlockInterface {
        public void setBlock(int var1, int var2, int var3, class_2680 var4);
    }

    static class ReadOnlyLuaTable
    extends LuaTable {
        public ReadOnlyLuaTable(LuaValue table) {
            this.presize(table.length(), 0);
            Varargs n = table.next(LuaValue.NIL);
            while (!n.arg1().isnil()) {
                LuaValue key = n.arg1();
                LuaValue value = n.arg(2);
                super.rawset(key, value.istable() ? new ReadOnlyLuaTable(value) : value);
                n = table.next(n.arg1());
            }
        }

        @Override
        public LuaValue setmetatable(LuaValue metatable) {
            return ReadOnlyLuaTable.error("table is read-only");
        }

        @Override
        public void set(int key, LuaValue value) {
            ReadOnlyLuaTable.error("table is read-only");
        }

        @Override
        public void rawset(int key, LuaValue value) {
            ReadOnlyLuaTable.error("table is read-only");
        }

        @Override
        public void rawset(LuaValue key, LuaValue value) {
            ReadOnlyLuaTable.error("table is read-only");
        }

        @Override
        public LuaValue remove(int pos) {
            return ReadOnlyLuaTable.error("table is read-only");
        }
    }
}

