/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom.packets;

import com.moulberry.axiom.ClientEvents;
import com.moulberry.axiom.VersionUtils;
import com.moulberry.axiom.packets.AxiomServerboundPacket;
import com.moulberry.axiom.packets.SupportedProtocol;
import com.moulberry.axiom.restrictions.AxiomPermission;
import com.moulberry.axiom.utils.BooleanWrapper;
import com.moulberry.axiom.utils.ChatUtils;
import com.moulberry.axiom.utils.EntityDataUtils;
import java.util.List;
import java.util.UUID;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_1530;
import net.minecraft.class_1533;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2374;
import net.minecraft.class_243;
import net.minecraft.class_2470;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3730;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;

public class AxiomServerboundSpawnEntity
implements AxiomServerboundPacket {
    public static final class_2960 IDENTIFIER = class_2960.method_60654((String)"axiom:spawn_entity");
    private final List<SpawnEntry> entries;
    private static final class_2470[] ROTATION_VALUES = class_2470.values();
    private static final class_2561 UNSUPPORTED_MESSAGE = class_2561.method_43470((String)"Server doesn't support (or doesn't allow) spawning entities").method_27692(class_124.field_1061);

    public AxiomServerboundSpawnEntity(List<SpawnEntry> entries) {
        this.entries = entries;
    }

    public AxiomServerboundSpawnEntity(class_2540 friendlyByteBuf) {
        this.entries = friendlyByteBuf.method_34066(SpawnEntry::new);
    }

    @Override
    public class_2960 id() {
        return IDENTIFIER;
    }

    @Override
    public void write(class_2540 friendlyByteBuf) {
        friendlyByteBuf.method_34062(this.entries, SpawnEntry::write);
    }

    @Override
    public void handle(MinecraftServer server, class_3222 player) {
        if (!AxiomServerboundPacket.canUseAxiom(player, AxiomPermission.ENTITY_SPAWN)) {
            return;
        }
        for (SpawnEntry entry : this.entries) {
            BooleanWrapper usedNewUuid;
            class_1297 spawned;
            class_2487 compoundTag;
            class_1297 entityCopyFrom;
            class_2487 tag;
            class_2338 blockPos = class_2338.method_49638((class_2374)entry.position);
            if (!class_1937.method_25953((class_2338)blockPos)) continue;
            class_2487 class_24872 = tag = entry.tag == null ? new class_2487() : entry.tag;
            class_3218 serverLevel = player.method_51469();
            if (serverLevel.method_14190(entry.newUuid) != null) continue;
            if (entry.copyFrom != null && (entityCopyFrom = serverLevel.method_14190(entry.copyFrom)) != null && (compoundTag = EntityDataUtils.saveAsPassenger(entityCopyFrom)) != null) {
                compoundTag.method_10551("Dimension");
                tag = tag.method_10543(compoundTag);
            }
            if (!tag.method_10545("id") || (spawned = VersionUtils.genericLoadEntityRecursive(tag, (class_1937)serverLevel, class_3730.field_16462, arg_0 -> AxiomServerboundSpawnEntity.lambda$handle$0(usedNewUuid = new BooleanWrapper(false), entry, arg_0))) == null) continue;
            serverLevel.method_30736(spawned);
        }
    }

    public static void register() {
        AxiomServerboundPacket.register(IDENTIFIER, AxiomServerboundSpawnEntity::new);
    }

    @Override
    public void send() {
        if (!ClientEvents.serverSupportsProtocol(SupportedProtocol.CREATE_ENTITY)) {
            ChatUtils.error(UNSUPPORTED_MESSAGE);
            return;
        }
        AxiomServerboundPacket.super.send();
    }

    private static /* synthetic */ class_1297 lambda$handle$0(BooleanWrapper usedNewUuid, SpawnEntry entry, class_1297 entity) {
        if (usedNewUuid.value) {
            entity.method_5826(UUID.randomUUID());
        } else {
            usedNewUuid.value = true;
            entity.method_5826(entry.newUuid);
        }
        if (entity instanceof class_1530) {
            class_1533 itemFrame;
            class_1530 hangingEntity = (class_1530)entity;
            float changedYaw = entry.yaw - entity.method_36454();
            int rotations = Math.round(changedYaw / 90.0f);
            hangingEntity.method_5832(ROTATION_VALUES[rotations & 3]);
            if (entity instanceof class_1533 && (itemFrame = (class_1533)entity).method_5735().method_10166() == class_2350.class_2351.field_11052) {
                itemFrame.method_6939(itemFrame.method_6934() - Math.round(changedYaw / 45.0f));
            }
        }
        entity.method_5814(entry.position.field_1352, entry.position.field_1351, entry.position.field_1350);
        entity.method_36456(entry.yaw);
        entity.method_36457(entry.pitch);
        entity.method_5847(entity.method_36454());
        return entity;
    }

    public record SpawnEntry(UUID newUuid, class_243 position, float yaw, float pitch, @Nullable UUID copyFrom, class_2487 tag) {
        public SpawnEntry(class_2540 friendlyByteBuf) {
            this(friendlyByteBuf.method_10790(), friendlyByteBuf.method_52996(), friendlyByteBuf.readFloat(), friendlyByteBuf.readFloat(), (UUID)friendlyByteBuf.method_43827(buf -> buf.method_10790()), friendlyByteBuf.method_10798());
        }

        public static void write(class_2540 friendlyByteBuf, SpawnEntry entry) {
            friendlyByteBuf.method_10797(entry.newUuid);
            friendlyByteBuf.method_52940(entry.position.field_1352);
            friendlyByteBuf.method_52940(entry.position.field_1351);
            friendlyByteBuf.method_52940(entry.position.field_1350);
            friendlyByteBuf.method_52941(entry.yaw);
            friendlyByteBuf.method_52941(entry.pitch);
            friendlyByteBuf.method_43826((Object)entry.copyFrom, (buf, uuid) -> buf.method_10797(uuid));
            friendlyByteBuf.method_10794((class_2520)entry.tag);
        }
    }
}

