/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom.render;

import com.moulberry.axiom.Axiom;
import com.moulberry.axiom.collections.Position2ObjectMap;
import com.moulberry.axiom.collections.PositionSet;
import com.moulberry.axiom.core_rendering.AxiomBufferUsage;
import com.moulberry.axiom.core_rendering.AxiomDraw;
import com.moulberry.axiom.core_rendering.AxiomDrawBuffer;
import com.moulberry.axiom.core_rendering.AxiomRenderPipeline;
import com.moulberry.axiom.core_rendering.AxiomRenderPipelines;
import com.moulberry.axiom.core_rendering.AxiomRenderer;
import com.moulberry.axiom.render.BlockTessellator;
import com.moulberry.axiom.render.MeshDataHelper;
import com.moulberry.axiom.render.SortStateWrapper;
import com.moulberry.axiom.render.VertexConsumerProvider;
import com.moulberry.axiom.utils.IrisApiWrapper;
import com.moulberry.axiom.utils.NvidiumApiWrapper;
import com.moulberry.axiom.utils.RenderHelper;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import net.fabricmc.fabric.api.blockview.v2.FabricBlockView;
import net.fabricmc.fabric.api.rendering.data.v1.RenderAttachedBlockView;
import net.minecraft.class_1920;
import net.minecraft.class_1921;
import net.minecraft.class_1937;
import net.minecraft.class_1944;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2464;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_276;
import net.minecraft.class_2791;
import net.minecraft.class_2806;
import net.minecraft.class_2841;
import net.minecraft.class_287;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_310;
import net.minecraft.class_3568;
import net.minecraft.class_3610;
import net.minecraft.class_4076;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4696;
import net.minecraft.class_5819;
import net.minecraft.class_638;
import net.minecraft.class_6539;
import net.minecraft.class_750;
import net.minecraft.class_776;
import net.minecraft.class_778;
import net.minecraft.class_8251;
import net.minecraft.class_9799;
import net.minecraft.class_9801;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Vector3f;

public class ChunkRenderOverrider {
    private static final Position2ObjectMap<class_2680> blocksOverride = new Position2ObjectMap(k -> new class_2680[4096]);
    private static final AtomicBoolean stopBuilding = new AtomicBoolean(false);
    private static final ExecutorService executor = Executors.newSingleThreadExecutor();
    private static final Lock lock = new ReentrantLock();
    private static String lockedBy = null;
    private static BooleanCutoutMode pendingBooleanCutoutMode = null;
    private static final class_750 chunkBufferBuilderPack = new class_750();
    private static final Long2ObjectMap<RenderedChunkData> chunkData = new Long2ObjectOpenHashMap();
    private static LongSet dirtyChunks = new LongOpenHashSet();
    private static Future<CompileData> compileFuture = null;
    private static final EnumSet<AxiomChunkOverrideLayer> globalHasBlocks = EnumSet.noneOf(AxiomChunkOverrideLayer.class);
    private static long lastSortMillis;
    private static float lastSortX;
    private static float lastSortY;
    private static float lastSortZ;
    private static int lastSortChunkX;
    private static int lastSortChunkY;
    private static int lastSortChunkZ;
    private static boolean overridenChunksChanged;
    private static boolean overridenChunksChangedLast;
    private static boolean disabled;
    private static final List<RenderedChunkData> sortedChunkData;

    private static class_2680[] loadBlocks(long k) {
        class_2338 pos;
        class_2791 chunk;
        Object[] array = new class_2680[4096];
        if (class_310.method_1551().field_1687 != null && (chunk = class_310.method_1551().field_1687.method_8402((pos = class_2338.method_10092((long)k)).method_10263(), pos.method_10260(), class_2806.field_12803, false)) != null) {
            int sectionIndex = chunk.method_31603(pos.method_10264());
            class_2841 states = chunk.method_38259(sectionIndex).method_12265();
            int index = 0;
            for (int z = 0; z < 16; ++z) {
                for (int y = 0; y < 16; ++y) {
                    for (int x = 0; x < 16; ++x) {
                        array[index++] = (class_2680)states.method_12321(x, y, z);
                    }
                }
            }
            return array;
        }
        Arrays.fill(array, class_2246.field_10124.method_9564());
        return array;
    }

    public static void acquire(String identifier) {
        if (lockedBy != null || !lock.tryLock()) {
            throw new Error("ChunkRenderOverrider: '" + identifier + "' tried to acquire() when it shouldn't have OR '" + lockedBy + "' forgot to call release()... naughty naughty");
        }
        lockedBy = identifier;
    }

    public static void release(String identifier) {
        if (!identifier.equals(lockedBy)) {
            throw new Error("ChunkRenderOverrider: '" + identifier + "' tried to release() even though '" + lockedBy + "' owns it");
        }
        lockedBy = null;
        ChunkRenderOverrider.clear();
        lock.unlock();
    }

    public static void invalidateChunkSection(int x, int y, int z) {
        if (chunkData.isEmpty()) {
            return;
        }
        long key = class_2338.method_10064((int)x, (int)y, (int)z);
        if (chunkData.containsKey(key)) {
            dirtyChunks.add(key);
        }
    }

    public static void clear() {
        if (compileFuture != null) {
            stopBuilding.set(true);
        }
        blocksOverride.clear();
        dirtyChunks.clear();
        sortedChunkData.forEach(data -> data.buffers.forEach((type2, buffer) -> buffer.close()));
        pendingBooleanCutoutMode = null;
        globalHasBlocks.clear();
        sortedChunkData.clear();
        if (NvidiumApiWrapper.isNvidiumAvailable()) {
            ChunkRenderOverrider.unhideAllNvidium();
        }
        chunkData.clear();
        overridenChunksChanged = true;
    }

    private static void unhideAllNvidium() {
        LongIterator longIterator = chunkData.keySet().longIterator();
        while (longIterator.hasNext()) {
            long pos = longIterator.nextLong();
            NvidiumApiWrapper.showSection(class_2338.method_10061((long)pos), class_2338.method_10071((long)pos), class_2338.method_10083((long)pos));
        }
    }

    public static boolean isOverridingSection(int sx, int sy, int sz) {
        return !disabled && chunkData.containsKey(class_2338.method_10064((int)sx, (int)sy, (int)sz));
    }

    public static boolean hasOverridenChunksChanged() {
        return overridenChunksChanged || overridenChunksChangedLast;
    }

    public static void afterRenderLevel() {
        overridenChunksChangedLast = overridenChunksChanged;
        overridenChunksChanged = false;
    }

    public static void render(AxiomChunkOverrideLayer layer, class_276 target, Matrix4f modelViewMatrix, double cameraX, double cameraY, double cameraZ) {
        if (Axiom.configuration.internal.disableChunkRenderOverrider || IrisApiWrapper.isUsingShaders()) {
            disabled = true;
            return;
        }
        disabled = false;
        if (sortedChunkData.isEmpty()) {
            return;
        }
        if (!globalHasBlocks.contains((Object)layer)) {
            return;
        }
        AxiomRenderPipeline pipeline = switch (layer.ordinal()) {
            default -> throw new IncompatibleClassChangeError();
            case 0 -> AxiomRenderPipelines.TERRAIN_SOLID_PIPELINE;
            case 1 -> AxiomRenderPipelines.TERRAIN_CUTOUT_MIPPED_PIPELINE;
            case 2 -> AxiomRenderPipelines.TERRAIN_CUTOUT_PIPELINE;
            case 3 -> AxiomRenderPipelines.TERRAIN_TRANSLUCENT_PIPELINE;
            case 4 -> AxiomRenderPipelines.TERRAIN_TRIPWIRE_PIPELINE;
        };
        ArrayList<AxiomDraw> axiomDraws = new ArrayList<AxiomDraw>(sortedChunkData.size());
        if (layer.needsSorting) {
            for (int i = sortedChunkData.size() - 1; i >= 0; --i) {
                RenderedChunkData chunkDatum = sortedChunkData.get(i);
                AxiomDrawBuffer buffer = chunkDatum.buffers.get((Object)layer);
                if (buffer == null) continue;
                Vector3f modelOffset = new Vector3f((float)((double)chunkDatum.offsetX - cameraX), (float)((double)chunkDatum.offsetY - cameraY), (float)((double)chunkDatum.offsetZ - cameraZ));
                axiomDraws.add(new AxiomDraw(buffer, null, modelOffset));
            }
        } else {
            for (RenderedChunkData chunkDatum : sortedChunkData) {
                AxiomDrawBuffer buffer = chunkDatum.buffers.get((Object)layer);
                if (buffer == null) continue;
                Vector3f modelOffset = new Vector3f((float)((double)chunkDatum.offsetX - cameraX), (float)((double)chunkDatum.offsetY - cameraY), (float)((double)chunkDatum.offsetZ - cameraZ));
                axiomDraws.add(new AxiomDraw(buffer, null, modelOffset));
            }
        }
        RenderHelper.pushModelViewMatrix(modelViewMatrix);
        AxiomRenderer.renderPipeline(pipeline, target, axiomDraws);
        RenderHelper.popModelViewStack();
    }

    public static void revertBlock(int x, int y, int z) {
        int mz;
        int pz;
        int my;
        int py;
        int mx;
        if (Axiom.configuration.internal.disableChunkRenderOverrider) {
            return;
        }
        class_638 level = class_310.method_1551().field_1687;
        if (level == null || y < level.method_31607() || y > level.method_31600() - 1) {
            return;
        }
        int cx = x >> 4;
        int cy = y >> 4;
        int cz = z >> 4;
        blocksOverride.put(x, y, z, null);
        dirtyChunks.add(class_2338.method_10064((int)cx, (int)cy, (int)cz));
        int px = x + 1 >> 4;
        if (px != cx) {
            long pos = class_2338.method_10064((int)px, (int)cy, (int)cz);
            blocksOverride.getOrCreateChunk(pos);
            dirtyChunks.add(pos);
        }
        if ((mx = x - 1 >> 4) != cx) {
            long pos = class_2338.method_10064((int)mx, (int)cy, (int)cz);
            blocksOverride.getOrCreateChunk(pos);
            dirtyChunks.add(pos);
        }
        if ((py = y + 1 >> 4) != cy && py <= level.method_31597() - 1) {
            long pos = class_2338.method_10064((int)cx, (int)py, (int)cz);
            blocksOverride.getOrCreateChunk(pos);
            dirtyChunks.add(pos);
        }
        if ((my = y - 1 >> 4) != cy && my >= level.method_32891()) {
            long pos = class_2338.method_10064((int)cx, (int)my, (int)cz);
            blocksOverride.getOrCreateChunk(pos);
            dirtyChunks.add(pos);
        }
        if ((pz = z + 1 >> 4) != cz) {
            long pos = class_2338.method_10064((int)cx, (int)cy, (int)pz);
            blocksOverride.getOrCreateChunk(pos);
            dirtyChunks.add(pos);
        }
        if ((mz = z - 1 >> 4) != cz) {
            long pos = class_2338.method_10064((int)cx, (int)cy, (int)mz);
            blocksOverride.getOrCreateChunk(pos);
            dirtyChunks.add(pos);
        }
    }

    public static void setBlock(int x, int y, int z, class_2680 block) {
        int mz;
        int pz;
        int my;
        int py;
        int mx;
        if (Axiom.configuration.internal.disableChunkRenderOverrider) {
            return;
        }
        class_638 level = class_310.method_1551().field_1687;
        if (level == null || y < level.method_31607() || y > level.method_31600() - 1) {
            return;
        }
        int cx = x >> 4;
        int cy = y >> 4;
        int cz = z >> 4;
        blocksOverride.put(x, y, z, block);
        dirtyChunks.add(class_2338.method_10064((int)cx, (int)cy, (int)cz));
        int px = x + 1 >> 4;
        if (px != cx) {
            long pos = class_2338.method_10064((int)px, (int)cy, (int)cz);
            blocksOverride.getOrCreateChunk(pos);
            dirtyChunks.add(pos);
        }
        if ((mx = x - 1 >> 4) != cx) {
            long pos = class_2338.method_10064((int)mx, (int)cy, (int)cz);
            blocksOverride.getOrCreateChunk(pos);
            dirtyChunks.add(pos);
        }
        if ((py = y + 1 >> 4) != cy && py <= level.method_31597() - 1) {
            long pos = class_2338.method_10064((int)cx, (int)py, (int)cz);
            blocksOverride.getOrCreateChunk(pos);
            dirtyChunks.add(pos);
        }
        if ((my = y - 1 >> 4) != cy && my >= level.method_32891()) {
            long pos = class_2338.method_10064((int)cx, (int)my, (int)cz);
            blocksOverride.getOrCreateChunk(pos);
            dirtyChunks.add(pos);
        }
        if ((pz = z + 1 >> 4) != cz) {
            long pos = class_2338.method_10064((int)cx, (int)cy, (int)pz);
            blocksOverride.getOrCreateChunk(pos);
            dirtyChunks.add(pos);
        }
        if ((mz = z - 1 >> 4) != cz) {
            long pos = class_2338.method_10064((int)cx, (int)cy, (int)mz);
            blocksOverride.getOrCreateChunk(pos);
            dirtyChunks.add(pos);
        }
    }

    public static void uploadDirty(double sortX, double sortY, double sortZ) {
        if (Axiom.configuration.internal.disableChunkRenderOverrider) {
            dirtyChunks.clear();
            return;
        }
        if (compileFuture != null && compileFuture.isDone()) {
            CompileData asyncCompileChunkData;
            try {
                asyncCompileChunkData = compileFuture.get();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            if (asyncCompileChunkData == null || stopBuilding.get()) {
                chunkBufferBuilderPack.method_23501();
            } else {
                boolean hasNvidium = NvidiumApiWrapper.isNvidiumAvailable();
                if (asyncCompileChunkData.clear()) {
                    if (hasNvidium) {
                        ChunkRenderOverrider.unhideAllNvidium();
                    }
                    overridenChunksChanged |= !chunkData.isEmpty();
                    sortedChunkData.forEach(data -> data.buffers.forEach((type2, buffer) -> buffer.close()));
                    sortedChunkData.clear();
                    chunkData.clear();
                }
                for (CompiledChunkData compiled : asyncCompileChunkData.compiledChunks()) {
                    long pos = class_2338.method_10064((int)(compiled.offsetX >> 4), (int)(compiled.offsetY >> 4), (int)(compiled.offsetZ >> 4));
                    RenderedChunkData chunkDatum = (RenderedChunkData)chunkData.get(pos);
                    if (chunkDatum == null) {
                        chunkDatum = new RenderedChunkData(compiled.offsetX, compiled.offsetY, compiled.offsetZ);
                        chunkData.put(pos, (Object)chunkDatum);
                        overridenChunksChanged = true;
                        if (hasNvidium) {
                            NvidiumApiWrapper.hideSection(compiled.offsetX >> 4, compiled.offsetY >> 4, compiled.offsetZ >> 4);
                        }
                        float dx = lastSortChunkX * 16 - chunkDatum.offsetX;
                        float dy = lastSortChunkY * 16 - chunkDatum.offsetY;
                        float dz = lastSortChunkZ * 16 - chunkDatum.offsetZ;
                        chunkDatum.distanceSqToCamera = dx * dx + dy * dy + dz * dz;
                        int min2 = 0;
                        int max2 = sortedChunkData.size();
                        int pivot = (min2 + max2) / 2;
                        while (min2 != max2) {
                            RenderedChunkData pivotElement = sortedChunkData.get(pivot);
                            if (chunkDatum.distanceSqToCamera < pivotElement.distanceSqToCamera) {
                                max2 = pivot;
                            } else {
                                min2 = pivot + 1;
                            }
                            pivot = (min2 + max2) / 2;
                        }
                        sortedChunkData.add(pivot, chunkDatum);
                    }
                    assert (chunkDatum.offsetX == compiled.offsetX);
                    assert (chunkDatum.offsetY == compiled.offsetY);
                    assert (chunkDatum.offsetZ == compiled.offsetZ);
                    chunkDatum.hasBlocks.clear();
                    chunkDatum.hasBlocks.addAll(compiled.buffers.keySet());
                    chunkDatum.sortState = compiled.sortState;
                    for (Map.Entry<AxiomChunkOverrideLayer, class_9801> entry : compiled.buffers.entrySet()) {
                        AxiomDrawBuffer buffer = chunkDatum.buffers.computeIfAbsent(entry.getKey(), k -> new AxiomDrawBuffer(AxiomBufferUsage.STATIC_WRITE));
                        buffer.upload(entry.getValue());
                    }
                    globalHasBlocks.addAll(chunkDatum.hasBlocks);
                }
                chunkBufferBuilderPack.method_22705();
            }
            compileFuture = null;
            stopBuilding.set(false);
        }
        if (compileFuture == null) {
            if (!dirtyChunks.isEmpty()) {
                pendingBooleanCutoutMode = null;
            } else if (pendingBooleanCutoutMode != null) {
                blocksOverride.clear();
                class_2338 offset = pendingBooleanCutoutMode.offset();
                int offsetX = offset.method_10263();
                int offsetY = offset.method_10264();
                int offsetZ = offset.method_10260();
                pendingBooleanCutoutMode.positionSet().forEach((x, y, z) -> ChunkRenderOverrider.setBlock(x + offsetX, y + offsetY, z + offsetZ, class_2246.field_10124.method_9564()));
            }
            if (!dirtyChunks.isEmpty()) {
                class_638 level = class_310.method_1551().field_1687;
                if (level == null) {
                    throw new IllegalStateException();
                }
                LongSet chunksToUpload = dirtyChunks;
                dirtyChunks = new LongOpenHashSet();
                boolean clear = pendingBooleanCutoutMode != null;
                Position2ObjectMap<class_2680> copied = new Position2ObjectMap<class_2680>(ChunkRenderOverrider::loadBlocks);
                LongOpenHashSet chunksToUploadAndNeighbors = new LongOpenHashSet();
                LongIterator iter = chunksToUpload.iterator();
                while (iter.hasNext()) {
                    long l = iter.nextLong();
                    int cx = class_2338.method_10061((long)l);
                    int cy = class_2338.method_10071((long)l);
                    int cz = class_2338.method_10083((long)l);
                    chunksToUploadAndNeighbors.add(l);
                    int minY = cy > level.method_32891() ? -1 : 0;
                    int maxY = cy < level.method_31597() - 1 ? 1 : 0;
                    for (int oy = minY; oy <= maxY; ++oy) {
                        for (int ox = -1; ox <= 1; ++ox) {
                            for (int oz = -1; oz <= 1; ++oz) {
                                chunksToUploadAndNeighbors.add(class_2338.method_10064((int)(cx + ox), (int)(cy + oy), (int)(cz + oz)));
                            }
                        }
                    }
                }
                copied.mergeAllFrom(blocksOverride, (LongSet)chunksToUploadAndNeighbors);
                MappedBlockAndTintGetter blockAndTintGetter = new MappedBlockAndTintGetter(copied, (class_1937)class_310.method_1551().field_1687);
                compileFuture = executor.submit(() -> {
                    ArrayList<CompiledChunkData> list = new ArrayList<CompiledChunkData>(chunksToUpload.size());
                    class_776 blockRenderDispatcher = class_310.method_1551().method_1541();
                    class_4587 poseStack = new class_4587();
                    class_2338.class_2339 blockPos = new class_2338.class_2339();
                    BlockTessellator blockTessellator = new BlockTessellator(class_310.method_1588(), false);
                    LongIterator longIterator = chunksToUpload.iterator();
                    while (longIterator.hasNext()) {
                        long pos = (Long)longIterator.next();
                        if (stopBuilding.compareAndSet(true, false)) {
                            return null;
                        }
                        int offsetX = class_2338.method_10061((long)pos) * 16;
                        int offsetY = class_2338.method_10071((long)pos) * 16;
                        int offsetZ = class_2338.method_10083((long)pos) * 16;
                        CompiledChunkData compiled = new CompiledChunkData(offsetX, offsetY, offsetZ);
                        EnumMap<AxiomChunkOverrideLayer, class_287> bufferBuilderMap = new EnumMap<AxiomChunkOverrideLayer, class_287>(AxiomChunkOverrideLayer.class);
                        class_2680[] blocks = (class_2680[])copied.getChunk(pos);
                        if (blocks == null) continue;
                        class_5819 rand = class_5819.method_43047();
                        class_778.method_20544();
                        int index = 0;
                        for (int z = 0; z < 16; ++z) {
                            for (int y = 0; y < 16; ++y) {
                                for (int x = 0; x < 16; ++x) {
                                    class_9799 byteBufferBuilder;
                                    class_287 bufferBuilder;
                                    AxiomChunkOverrideLayer layer;
                                    class_1921 renderType;
                                    class_2680 blockState = blocks[index++];
                                    blockPos.method_10103(offsetX + x, offsetY + y, offsetZ + z);
                                    class_3610 fluidState = blockState.method_26227();
                                    if (!fluidState.method_15769()) {
                                        renderType = class_4696.method_23680((class_3610)fluidState);
                                        layer = AxiomChunkOverrideLayer.fromVanilla(renderType);
                                        if (bufferBuilderMap.containsKey((Object)layer)) {
                                            bufferBuilder = (class_287)bufferBuilderMap.get((Object)layer);
                                        } else {
                                            byteBufferBuilder = chunkBufferBuilderPack.method_3154(renderType);
                                            bufferBuilder = new class_287(byteBufferBuilder, class_293.class_5596.field_27382, class_290.field_1590);
                                            bufferBuilderMap.put(layer, bufferBuilder);
                                        }
                                        blockRenderDispatcher.method_3352((class_2338)blockPos, blockAndTintGetter, (class_4588)bufferBuilder, blockState, fluidState);
                                    }
                                    if (blockState.method_26217() != class_2464.field_11458) continue;
                                    renderType = class_4696.method_23679((class_2680)blockState);
                                    layer = AxiomChunkOverrideLayer.fromVanilla(renderType);
                                    if (bufferBuilderMap.containsKey((Object)layer)) {
                                        bufferBuilder = (class_287)bufferBuilderMap.get((Object)layer);
                                    } else {
                                        byteBufferBuilder = chunkBufferBuilderPack.method_3154(renderType);
                                        bufferBuilder = new class_287(byteBufferBuilder, class_293.class_5596.field_27382, class_290.field_1590);
                                        bufferBuilderMap.put(layer, bufferBuilder);
                                    }
                                    poseStack.method_22903();
                                    poseStack.method_46416((float)x, (float)y, (float)z);
                                    blockTessellator.tessellateBlock(blockRenderDispatcher, blockState, blockAndTintGetter, (class_2338)blockPos, bufferBuilder, rand, poseStack);
                                    poseStack.method_22909();
                                }
                            }
                        }
                        for (Map.Entry entry : bufferBuilderMap.entrySet()) {
                            AxiomChunkOverrideLayer layer = entry.getKey();
                            class_287 builder = (class_287)entry.getValue();
                            if (layer.needsSorting) {
                                MeshDataHelper.MeshDataAndSortState meshDataAndSortState = MeshDataHelper.buildAndSort(builder, class_8251.method_49906((float)((float)(sortX - (double)compiled.offsetX)), (float)((float)(sortY - (double)compiled.offsetY)), (float)((float)(sortZ - (double)compiled.offsetZ))));
                                if (meshDataAndSortState == null) continue;
                                compiled.buffers.put(layer, meshDataAndSortState.meshData());
                                compiled.sortState = meshDataAndSortState.sortStateWrapper();
                                continue;
                            }
                            class_9801 meshData = builder.method_60794();
                            if (meshData == null) continue;
                            compiled.buffers.put(layer, meshData);
                        }
                        list.add(compiled);
                        class_778.method_20545();
                    }
                    return new CompileData(list, clear);
                });
            }
            pendingBooleanCutoutMode = null;
        }
        boolean hasLayerWithSorting = false;
        for (AxiomChunkOverrideLayer layer : globalHasBlocks) {
            if (!layer.needsSorting) continue;
            hasLayerWithSorting = true;
            break;
        }
        if (!hasLayerWithSorting) {
            return;
        }
        long currentTime = System.currentTimeMillis();
        if (currentTime - lastSortMillis < 200L) {
            return;
        }
        lastSortMillis = currentTime;
        double dX = sortX - (double)lastSortX;
        double dY = sortY - (double)lastSortY;
        double dZ = sortZ - (double)lastSortZ;
        if (dX * dX + dY * dY + dZ * dZ > 1.0) {
            lastSortX = (float)sortX;
            lastSortY = (float)sortY;
            lastSortZ = (float)sortZ;
            int chunkX = class_4076.method_32204((double)sortX);
            int chunkY = class_4076.method_32204((double)sortY);
            int chunkZ = class_4076.method_32204((double)sortZ);
            boolean resortChunkList = chunkX != lastSortChunkX || chunkY != lastSortChunkY || chunkZ != lastSortChunkZ;
            VertexConsumerProvider provider = VertexConsumerProvider.shared();
            for (RenderedChunkData chunkDatum : sortedChunkData) {
                for (Map.Entry<AxiomChunkOverrideLayer, AxiomDrawBuffer> entry : chunkDatum.buffers.entrySet()) {
                    if (!entry.getKey().needsSorting) continue;
                    float relSortX = (float)(sortX - (double)chunkDatum.offsetX);
                    float relSortY = (float)(sortY - (double)chunkDatum.offsetY);
                    float relSortZ = (float)(sortZ - (double)chunkDatum.offsetZ);
                    class_287 bufferBuilder = provider.begin(class_293.class_5596.field_27382, class_290.field_1590);
                    AxiomDrawBuffer vertexBuffer = entry.getValue();
                    if (vertexBuffer == null || chunkDatum.sortState == null) continue;
                    chunkDatum.sortState = MeshDataHelper.resort(bufferBuilder, chunkDatum.sortState, vertexBuffer, class_8251.method_49906((float)relSortX, (float)relSortY, (float)relSortZ));
                }
                if (!resortChunkList) continue;
                float dx = chunkX * 16 - chunkDatum.offsetX;
                float dy = chunkY * 16 - chunkDatum.offsetY;
                float dz = chunkZ * 16 - chunkDatum.offsetZ;
                chunkDatum.distanceSqToCamera = dx * dx + dy * dy + dz * dz;
            }
            if (resortChunkList) {
                lastSortChunkX = chunkX;
                lastSortChunkY = chunkY;
                lastSortChunkZ = chunkZ;
                sortedChunkData.sort(Comparator.comparingDouble(c -> -c.distanceSqToCamera));
            }
        }
    }

    public static void cutoutBoolean(PositionSet set, class_2338 offset) {
        if (Axiom.configuration.internal.disableChunkRenderOverrider) {
            return;
        }
        if (set.isEmpty()) {
            return;
        }
        pendingBooleanCutoutMode = new BooleanCutoutMode(set, offset);
    }

    static {
        overridenChunksChanged = false;
        overridenChunksChangedLast = false;
        disabled = false;
        sortedChunkData = new ArrayList<RenderedChunkData>();
    }

    private record BooleanCutoutMode(PositionSet positionSet, class_2338 offset) {
    }

    public static enum AxiomChunkOverrideLayer {
        SOLID(false, false),
        CUTOUT_MIPPED(false, false),
        CUTOUT(false, false),
        TRANSLUCENT(true, true),
        TRIPWIRE(false, false);

        public final boolean needsSorting;
        public final boolean isTranslucent;

        private AxiomChunkOverrideLayer(boolean needsSorting, boolean isTranslucent) {
            this.needsSorting = needsSorting;
            this.isTranslucent = isTranslucent;
        }

        public static AxiomChunkOverrideLayer fromVanilla(class_1921 layer) {
            if (layer == class_1921.method_23577()) {
                return SOLID;
            }
            if (layer == class_1921.method_23579()) {
                return CUTOUT_MIPPED;
            }
            if (layer == class_1921.method_23581()) {
                return CUTOUT;
            }
            if (layer == class_1921.method_29997()) {
                return TRIPWIRE;
            }
            return TRANSLUCENT;
        }
    }

    private static final class RenderedChunkData {
        EnumMap<AxiomChunkOverrideLayer, AxiomDrawBuffer> buffers = new EnumMap(AxiomChunkOverrideLayer.class);
        EnumSet<AxiomChunkOverrideLayer> hasBlocks = EnumSet.noneOf(AxiomChunkOverrideLayer.class);
        SortStateWrapper sortState = null;
        int offsetX;
        int offsetY;
        int offsetZ;
        float distanceSqToCamera;

        public RenderedChunkData(int offsetX, int offsetY, int offsetZ) {
            this.offsetX = offsetX;
            this.offsetY = offsetY;
            this.offsetZ = offsetZ;
        }
    }

    private record CompileData(List<CompiledChunkData> compiledChunks, boolean clear) {
    }

    private static final class CompiledChunkData {
        EnumMap<AxiomChunkOverrideLayer, class_9801> buffers = new EnumMap(AxiomChunkOverrideLayer.class);
        SortStateWrapper sortState = null;
        int offsetX;
        int offsetY;
        int offsetZ;

        public CompiledChunkData(int offsetX, int offsetY, int offsetZ) {
            this.offsetX = offsetX;
            this.offsetY = offsetY;
            this.offsetZ = offsetZ;
        }
    }

    private static final class MappedBlockAndTintGetter
    implements FabricBlockView,
    class_1920,
    RenderAttachedBlockView {
        private final Position2ObjectMap<class_2680> map;
        private final class_1937 level;

        private MappedBlockAndTintGetter(Position2ObjectMap<class_2680> map, class_1937 level) {
            this.map = map;
            this.level = level;
        }

        public float method_24852(class_2350 direction, boolean hasShade) {
            return this.level.method_24852(direction, hasShade);
        }

        @NotNull
        public class_3568 method_22336() {
            throw new UnsupportedOperationException();
        }

        public int method_8314(@NotNull class_1944 lightLayer, @NotNull class_2338 blockPos) {
            return lightLayer == class_1944.field_9282 ? 0 : 15;
        }

        public int method_22335(@NotNull class_2338 blockPos, int i) {
            return 15;
        }

        public int method_23752(@NotNull class_2338 blockPos, @NotNull class_6539 colorResolver) {
            return this.level.method_23752(blockPos, colorResolver);
        }

        @Nullable
        public class_2586 method_8321(@NotNull class_2338 blockPos) {
            return null;
        }

        @NotNull
        public class_2680 method_8320(class_2338 blockPos) {
            class_2680 mapped = this.map.get(blockPos.method_10263(), blockPos.method_10264(), blockPos.method_10260());
            return Objects.requireNonNullElse(mapped, class_2246.field_10124.method_9564());
        }

        @NotNull
        public class_3610 method_8316(@NotNull class_2338 blockPos) {
            return this.method_8320(blockPos).method_26227();
        }

        public int method_31605() {
            return this.level.method_31605();
        }

        public int method_31607() {
            return this.level.method_31607();
        }
    }
}

