/*
 * Decompiled with CFR 0.152.
 */
package org.luaj.vm2;

import org.luaj.vm2.LuaDouble;
import org.luaj.vm2.LuaNumber;
import org.luaj.vm2.LuaString;
import org.luaj.vm2.LuaValue;
import org.luaj.vm2.lib.MathLib;

public class LuaInteger
extends LuaNumber {
    private static final LuaInteger[] intValues = new LuaInteger[512];
    public final int v;

    public static LuaInteger valueOf(int i) {
        return i <= 255 && i >= -256 ? intValues[i + 256] : new LuaInteger(i);
    }

    public static LuaNumber valueOf(long l) {
        int i = (int)l;
        return l == (long)i ? (i <= 255 && i >= -256 ? intValues[i + 256] : new LuaInteger(i)) : LuaDouble.valueOf(l);
    }

    LuaInteger(int i) {
        this.v = i;
    }

    @Override
    public boolean isint() {
        return true;
    }

    @Override
    public boolean isinttype() {
        return true;
    }

    @Override
    public boolean islong() {
        return true;
    }

    @Override
    public byte tobyte() {
        return (byte)this.v;
    }

    @Override
    public char tochar() {
        return (char)this.v;
    }

    @Override
    public double todouble() {
        return this.v;
    }

    @Override
    public float tofloat() {
        return this.v;
    }

    @Override
    public int toint() {
        return this.v;
    }

    @Override
    public long tolong() {
        return this.v;
    }

    @Override
    public short toshort() {
        return (short)this.v;
    }

    @Override
    public double optdouble(double defval) {
        return this.v;
    }

    @Override
    public int optint(int defval) {
        return this.v;
    }

    @Override
    public LuaInteger optinteger(LuaInteger defval) {
        return this;
    }

    @Override
    public long optlong(long defval) {
        return this.v;
    }

    @Override
    public String tojstring() {
        return Integer.toString(this.v);
    }

    @Override
    public LuaString strvalue() {
        return LuaString.valueOf(Integer.toString(this.v));
    }

    @Override
    public LuaString optstring(LuaString defval) {
        return LuaString.valueOf(Integer.toString(this.v));
    }

    @Override
    public LuaValue tostring() {
        return LuaString.valueOf(Integer.toString(this.v));
    }

    @Override
    public String optjstring(String defval) {
        return Integer.toString(this.v);
    }

    @Override
    public LuaInteger checkinteger() {
        return this;
    }

    @Override
    public boolean isstring() {
        return true;
    }

    public int hashCode() {
        return this.v;
    }

    public static int hashCode(int x) {
        return x;
    }

    @Override
    public LuaValue neg() {
        return LuaInteger.valueOf(-((long)this.v));
    }

    @Override
    public boolean equals(Object o) {
        return o instanceof LuaInteger ? ((LuaInteger)o).v == this.v : false;
    }

    @Override
    public LuaValue eq(LuaValue val) {
        return val.raweq(this.v) ? TRUE : FALSE;
    }

    @Override
    public boolean eq_b(LuaValue val) {
        return val.raweq(this.v);
    }

    @Override
    public boolean raweq(LuaValue val) {
        return val.raweq(this.v);
    }

    @Override
    public boolean raweq(double val) {
        return (double)this.v == val;
    }

    @Override
    public boolean raweq(int val) {
        return this.v == val;
    }

    @Override
    public LuaValue add(LuaValue rhs) {
        return rhs.add(this.v);
    }

    @Override
    public LuaValue add(double lhs) {
        return LuaDouble.valueOf(lhs + (double)this.v);
    }

    @Override
    public LuaValue add(int lhs) {
        return LuaInteger.valueOf((long)lhs + (long)this.v);
    }

    @Override
    public LuaValue sub(LuaValue rhs) {
        return rhs.subFrom(this.v);
    }

    @Override
    public LuaValue sub(double rhs) {
        return LuaDouble.valueOf((double)this.v - rhs);
    }

    @Override
    public LuaValue sub(int rhs) {
        return LuaValue.valueOf(this.v - rhs);
    }

    @Override
    public LuaValue subFrom(double lhs) {
        return LuaDouble.valueOf(lhs - (double)this.v);
    }

    @Override
    public LuaValue subFrom(int lhs) {
        return LuaInteger.valueOf((long)lhs - (long)this.v);
    }

    @Override
    public LuaValue mul(LuaValue rhs) {
        return rhs.mul(this.v);
    }

    @Override
    public LuaValue mul(double lhs) {
        return LuaDouble.valueOf(lhs * (double)this.v);
    }

    @Override
    public LuaValue mul(int lhs) {
        return LuaInteger.valueOf((long)lhs * (long)this.v);
    }

    @Override
    public LuaValue pow(LuaValue rhs) {
        return rhs.powWith(this.v);
    }

    @Override
    public LuaValue pow(double rhs) {
        return MathLib.dpow(this.v, rhs);
    }

    @Override
    public LuaValue pow(int rhs) {
        return MathLib.dpow(this.v, rhs);
    }

    @Override
    public LuaValue powWith(double lhs) {
        return MathLib.dpow(lhs, this.v);
    }

    @Override
    public LuaValue powWith(int lhs) {
        return MathLib.dpow(lhs, this.v);
    }

    @Override
    public LuaValue div(LuaValue rhs) {
        return rhs.divInto(this.v);
    }

    @Override
    public LuaValue div(double rhs) {
        return LuaDouble.ddiv(this.v, rhs);
    }

    @Override
    public LuaValue div(int rhs) {
        return LuaDouble.ddiv(this.v, rhs);
    }

    @Override
    public LuaValue divInto(double lhs) {
        return LuaDouble.ddiv(lhs, this.v);
    }

    @Override
    public LuaValue mod(LuaValue rhs) {
        return rhs.modFrom(this.v);
    }

    @Override
    public LuaValue mod(double rhs) {
        return LuaDouble.dmod(this.v, rhs);
    }

    @Override
    public LuaValue mod(int rhs) {
        return LuaDouble.dmod(this.v, rhs);
    }

    @Override
    public LuaValue modFrom(double lhs) {
        return LuaDouble.dmod(lhs, this.v);
    }

    @Override
    public LuaValue lt(LuaValue rhs) {
        return rhs instanceof LuaNumber ? (rhs.gt_b(this.v) ? TRUE : FALSE) : super.lt(rhs);
    }

    @Override
    public LuaValue lt(double rhs) {
        return (double)this.v < rhs ? TRUE : FALSE;
    }

    @Override
    public LuaValue lt(int rhs) {
        return this.v < rhs ? TRUE : FALSE;
    }

    @Override
    public boolean lt_b(LuaValue rhs) {
        return rhs instanceof LuaNumber ? rhs.gt_b(this.v) : super.lt_b(rhs);
    }

    @Override
    public boolean lt_b(int rhs) {
        return this.v < rhs;
    }

    @Override
    public boolean lt_b(double rhs) {
        return (double)this.v < rhs;
    }

    @Override
    public LuaValue lteq(LuaValue rhs) {
        return rhs instanceof LuaNumber ? (rhs.gteq_b(this.v) ? TRUE : FALSE) : super.lteq(rhs);
    }

    @Override
    public LuaValue lteq(double rhs) {
        return (double)this.v <= rhs ? TRUE : FALSE;
    }

    @Override
    public LuaValue lteq(int rhs) {
        return this.v <= rhs ? TRUE : FALSE;
    }

    @Override
    public boolean lteq_b(LuaValue rhs) {
        return rhs instanceof LuaNumber ? rhs.gteq_b(this.v) : super.lteq_b(rhs);
    }

    @Override
    public boolean lteq_b(int rhs) {
        return this.v <= rhs;
    }

    @Override
    public boolean lteq_b(double rhs) {
        return (double)this.v <= rhs;
    }

    @Override
    public LuaValue gt(LuaValue rhs) {
        return rhs instanceof LuaNumber ? (rhs.lt_b(this.v) ? TRUE : FALSE) : super.gt(rhs);
    }

    @Override
    public LuaValue gt(double rhs) {
        return (double)this.v > rhs ? TRUE : FALSE;
    }

    @Override
    public LuaValue gt(int rhs) {
        return this.v > rhs ? TRUE : FALSE;
    }

    @Override
    public boolean gt_b(LuaValue rhs) {
        return rhs instanceof LuaNumber ? rhs.lt_b(this.v) : super.gt_b(rhs);
    }

    @Override
    public boolean gt_b(int rhs) {
        return this.v > rhs;
    }

    @Override
    public boolean gt_b(double rhs) {
        return (double)this.v > rhs;
    }

    @Override
    public LuaValue gteq(LuaValue rhs) {
        return rhs instanceof LuaNumber ? (rhs.lteq_b(this.v) ? TRUE : FALSE) : super.gteq(rhs);
    }

    @Override
    public LuaValue gteq(double rhs) {
        return (double)this.v >= rhs ? TRUE : FALSE;
    }

    @Override
    public LuaValue gteq(int rhs) {
        return this.v >= rhs ? TRUE : FALSE;
    }

    @Override
    public boolean gteq_b(LuaValue rhs) {
        return rhs instanceof LuaNumber ? rhs.lteq_b(this.v) : super.gteq_b(rhs);
    }

    @Override
    public boolean gteq_b(int rhs) {
        return this.v >= rhs;
    }

    @Override
    public boolean gteq_b(double rhs) {
        return (double)this.v >= rhs;
    }

    @Override
    public int strcmp(LuaString rhs) {
        this.typerror("attempt to compare number with string");
        return 0;
    }

    @Override
    public int checkint() {
        return this.v;
    }

    @Override
    public long checklong() {
        return this.v;
    }

    @Override
    public double checkdouble() {
        return this.v;
    }

    @Override
    public String checkjstring() {
        return String.valueOf(this.v);
    }

    @Override
    public LuaString checkstring() {
        return LuaInteger.valueOf(String.valueOf(this.v));
    }

    static {
        for (int i = 0; i < 512; ++i) {
            LuaInteger.intValues[i] = new LuaInteger(i - 256);
        }
    }
}

