/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom;

import com.moulberry.axiom.Axiom;
import com.moulberry.axiom.hooks.ServerPlayerExt;
import com.moulberry.axiom.packets.AxiomClientboundEnable;
import com.moulberry.axiom.packets.AxiomClientboundRedoHandshake;
import com.moulberry.axiom.packets.AxiomClientboundRestrictions;
import com.moulberry.axiom.packets.AxiomClientboundUpdateAvailableDispatchSends;
import com.moulberry.axiom.restrictions.AxiomPermission;
import com.moulberry.axiom.restrictions.AxiomPermissionSet;
import com.moulberry.axiom.restrictions.Restrictions;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.lang.reflect.Method;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import net.fabricmc.api.EnvType;
import net.fabricmc.fabric.api.entity.event.v1.ServerEntityWorldChangeEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.fabricmc.fabric.api.util.TriState;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1297;
import net.minecraft.class_2561;
import net.minecraft.class_3222;

public class AxiomServer {
    private static final int ALLOWED_DISPATCH_SENDS_PER_SECOND = 1024;
    public static final Set<UUID> activeAxiomPlayers = new HashSet<UUID>();
    public static final Set<UUID> failedPermissionPlayers = new HashSet<UUID>();
    private static final Map<UUID, Restrictions> playerRestrictions = new HashMap<UUID, Restrictions>();
    private static final Map<UUID, AxiomPermissionSet> playerPermissions = new HashMap<UUID, AxiomPermissionSet>();
    private static final Object2IntOpenHashMap<UUID> availableDispatchSends = new Object2IntOpenHashMap();
    private static boolean checkedForFabricPermissionAPI = false;
    private static Method permissionCheckMethod = null;

    public static void register() {
        ServerTickEvents.END_SERVER_TICK.register(minecraftServer -> {
            HashSet<UUID> stillActiveAxiomPlayers = new HashSet<UUID>();
            HashSet<UUID> stillFailedAxiomPlayers = new HashSet<UUID>();
            playerPermissions.clear();
            for (class_3222 player : minecraftServer.method_3760().method_14571()) {
                if (activeAxiomPlayers.contains(player.method_5667())) {
                    if (!AxiomServer.hasPermission(player, AxiomPermission.USE)) {
                        new AxiomClientboundEnable(false, null).send(player);
                        failedPermissionPlayers.add(player.method_5667());
                        continue;
                    }
                    stillActiveAxiomPlayers.add(player.method_5667());
                    AxiomServer.tickPlayer(player);
                    continue;
                }
                if (!failedPermissionPlayers.contains(player.method_5667())) continue;
                if (AxiomServer.hasPermission(player, AxiomPermission.USE)) {
                    new AxiomClientboundRedoHandshake().send(player);
                    failedPermissionPlayers.remove(player.method_5667());
                    continue;
                }
                stillFailedAxiomPlayers.add(player.method_5667());
            }
            activeAxiomPlayers.retainAll(stillActiveAxiomPlayers);
            availableDispatchSends.keySet().retainAll(stillActiveAxiomPlayers);
            playerRestrictions.keySet().retainAll(stillActiveAxiomPlayers);
            failedPermissionPlayers.retainAll(stillFailedAxiomPlayers);
        });
        ServerEntityWorldChangeEvents.AFTER_PLAYER_CHANGE_WORLD.register((player, origin, destination) -> {
            playerPermissions.remove(player.method_5667());
            playerRestrictions.remove(player.method_5667());
            availableDispatchSends.removeInt((Object)player.method_5667());
        });
    }

    public static boolean supportsServerBlueprints() {
        return FabricLoader.getInstance().getEnvironmentType() == EnvType.SERVER;
    }

    public static boolean consumeDispatchSends(class_3222 player, int sends, int clientAvailableDispatchSends) {
        int currentSends = availableDispatchSends.getOrDefault((Object)player.method_5667(), 20480);
        currentSends -= sends * 20;
        currentSends = Math.min(currentSends, clientAvailableDispatchSends * 20);
        availableDispatchSends.put((Object)player.method_5667(), currentSends);
        if (currentSends < -20480) {
            player.field_13987.method_52396((class_2561)class_2561.method_43470((String)"You are sending updates too fast!"));
            return false;
        }
        return true;
    }

    public static void onAxiomActive(class_3222 player) {
        activeAxiomPlayers.add(player.method_5667());
        failedPermissionPlayers.remove(player.method_5667());
        playerPermissions.remove(player.method_5667());
        playerRestrictions.remove(player.method_5667());
        AxiomServer.tickPlayer(player);
    }

    private static void tickPlayer(class_3222 player) {
        Restrictions oldRestrictions;
        if (!availableDispatchSends.containsKey((Object)player.method_5667())) {
            availableDispatchSends.put((Object)player.method_5667(), 20480);
            new AxiomClientboundUpdateAvailableDispatchSends(1024, 1024).send(player);
        } else {
            int previousAllowed20 = availableDispatchSends.getInt((Object)player.method_5667());
            int newAllowed20 = Math.min(20480, previousAllowed20 + 1024);
            availableDispatchSends.put((Object)player.method_5667(), newAllowed20);
            int previousAllowed = previousAllowed20 / 20;
            int newAllowed = newAllowed20 / 20;
            if (previousAllowed != newAllowed) {
                new AxiomClientboundUpdateAvailableDispatchSends(newAllowed - previousAllowed, 1024).send(player);
            }
        }
        Restrictions restrictions = AxiomServer.calculateRestrictions(player);
        boolean restrictionsChanged = playerRestrictions.containsKey(player.method_5667()) ? !Objects.equals(restrictions, oldRestrictions = playerRestrictions.get(player.method_5667())) : true;
        if (restrictionsChanged) {
            new AxiomClientboundRestrictions(restrictions).send(player);
            playerRestrictions.put(player.method_5667(), restrictions);
        }
    }

    private static Restrictions calculateRestrictions(class_3222 player) {
        if (player.method_64475(2)) {
            Restrictions restrictions = new Restrictions();
            restrictions.allowedPermissions = EnumSet.of(AxiomPermission.ALL);
            return restrictions;
        }
        AxiomPermissionSet permissionSet = AxiomServer.getPermissions(player);
        if (permissionSet.contains(AxiomPermission.ALL)) {
            Restrictions restrictions = new Restrictions();
            restrictions.allowedPermissions = EnumSet.of(AxiomPermission.ALL);
            return restrictions;
        }
        EnumSet<AxiomPermission> allowed = EnumSet.noneOf(AxiomPermission.class);
        EnumSet<AxiomPermission> denied = EnumSet.noneOf(AxiomPermission.class);
        for (AxiomPermission permission : permissionSet.explicitlyAllowed) {
            if (permission.parent != null && permissionSet.explicitlyAllowed.contains((Object)permission.parent)) continue;
            allowed.add(permission);
        }
        for (AxiomPermission permission : permissionSet.explicitlyDenied) {
            if (permission.parent != null && permissionSet.explicitlyDenied.contains((Object)permission.parent)) continue;
            denied.add(permission);
        }
        Restrictions restrictions = new Restrictions();
        restrictions.allowedPermissions = allowed;
        restrictions.deniedPermissions = denied;
        return restrictions;
    }

    private static AxiomPermissionSet calculatePermissions(class_3222 player) {
        if (player.method_64475(2)) {
            return AxiomPermissionSet.ALL;
        }
        AxiomServer.checkForFabricPermissionAPI();
        if (permissionCheckMethod == null) {
            return AxiomPermissionSet.NONE;
        }
        try {
            EnumSet<AxiomPermission> allowed = EnumSet.noneOf(AxiomPermission.class);
            EnumSet<AxiomPermission> denied = EnumSet.noneOf(AxiomPermission.class);
            block7: for (AxiomPermission permission : AxiomPermission.values()) {
                TriState value = (TriState)permissionCheckMethod.invoke(null, player, permission.getPermissionNode());
                switch (value) {
                    case FALSE: {
                        denied.add(permission);
                        continue block7;
                    }
                    case DEFAULT: {
                        continue block7;
                    }
                    case TRUE: {
                        allowed.add(permission);
                    }
                }
            }
            return new AxiomPermissionSet(allowed, denied);
        }
        catch (Throwable t2) {
            Axiom.LOGGER.error("Error when trying to check permission using fabric permission api", t2);
            permissionCheckMethod = null;
            return AxiomPermissionSet.NONE;
        }
    }

    public static boolean usingDeprecatedAxiomStarPermission(class_3222 player) {
        AxiomServer.checkForFabricPermissionAPI();
        if (permissionCheckMethod == null) {
            return false;
        }
        if (player.method_64475(2)) {
            return false;
        }
        try {
            TriState value = (TriState)permissionCheckMethod.invoke(null, player, "*");
            if (value == TriState.TRUE) {
                return false;
            }
            value = (TriState)permissionCheckMethod.invoke(null, player, "axiom.*");
            return value == TriState.TRUE;
        }
        catch (Throwable t2) {
            Axiom.LOGGER.error("Error when trying to check permission using fabric permission api", t2);
            permissionCheckMethod = null;
            return false;
        }
    }

    public static boolean isNoPhysicalTrigger(class_3222 serverPlayer) {
        return AxiomServer.canUseAxiom(serverPlayer, AxiomPermission.PLAYER_SETNOPHYSICALTRIGGER) && ((ServerPlayerExt)serverPlayer).axiom$isNoPhysicalTrigger();
    }

    public static boolean canUseAxiom(class_3222 player) {
        return activeAxiomPlayers.contains(player.method_5667());
    }

    public static boolean canUseAxiom(class_3222 player, AxiomPermission axiomPermission) {
        return activeAxiomPlayers.contains(player.method_5667()) && AxiomServer.hasPermission(player, axiomPermission);
    }

    private static void checkForFabricPermissionAPI() {
        if (!checkedForFabricPermissionAPI) {
            checkedForFabricPermissionAPI = true;
            try {
                Class<?> clazz = Class.forName("me.lucko.fabric.api.permissions.v0.Permissions");
                permissionCheckMethod = clazz.getMethod("getPermissionValue", class_1297.class, String.class);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public static AxiomPermissionSet getPermissions(class_3222 player) {
        return playerPermissions.computeIfAbsent(player.method_5667(), uuid -> AxiomServer.calculatePermissions(player));
    }

    public static boolean hasPermission(class_3222 player, AxiomPermission axiomPermission) {
        if (player.method_64475(2)) {
            return true;
        }
        return AxiomServer.getPermissions(player).contains(axiomPermission);
    }
}

