/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom;

import java.lang.ref.Cleaner;
import net.minecraft.class_128;
import net.minecraft.class_310;

public class GlobalCleaner {
    public static final Cleaner INSTANCE = Cleaner.create();

    public static LeakChecker createLeakChecker(Object object, String name) {
        StackTraceElement[] trace = Thread.currentThread().getStackTrace();
        String callingClass = trace[3].getClassName();
        StringBuilder builder = new StringBuilder();
        builder.append(name).append(" [").append(callingClass).append("]\n");
        for (int i = 3; i < trace.length; ++i) {
            builder.append("\tat ").append(trace[i]).append("\n");
        }
        LeakCheckerImpl leakChecker = new LeakCheckerImpl(builder.toString());
        INSTANCE.register(object, leakChecker);
        return leakChecker;
    }

    private static class LeakCheckerImpl
    implements Runnable,
    LeakChecker {
        private boolean active = true;
        private final String trace;

        public LeakCheckerImpl(String trace) {
            this.trace = trace;
        }

        @Override
        public void run() {
            if (this.active) {
                class_310.method_1551().method_1494(new class_128(this.trace, (Throwable)new Error("LeakChecker was triggered!")));
            }
        }

        @Override
        public void disarm() {
            this.active = false;
        }
    }

    public static interface LeakChecker
    extends Runnable {
        public void disarm();
    }
}

