/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom.marker;

import com.moulberry.axiom.VersionUtilsNbt;
import com.moulberry.axiom.hooks.MarkerEntityExt;
import com.moulberry.axiom.utils.NbtHelper;
import java.util.UUID;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2540;
import net.minecraft.class_6335;
import org.jetbrains.annotations.Nullable;

public record MarkerData(UUID uuid, class_243 position, @Nullable String name, @Nullable class_243 minRegion, @Nullable class_243 maxRegion, int lineArgb, float lineThickness, int faceArgb) {
    public static MarkerData read(class_2540 friendlyByteBuf) {
        UUID uuid = friendlyByteBuf.method_10790();
        class_243 position = friendlyByteBuf.method_52996();
        String name = (String)friendlyByteBuf.method_43827(class_2540::method_19772);
        class_243 minRegion = null;
        class_243 maxRegion = null;
        int lineArgb = 0;
        float lineThickness = 0.0f;
        int faceArgb = 0;
        byte flags = friendlyByteBuf.readByte();
        if (flags != 0) {
            minRegion = friendlyByteBuf.method_52996();
            maxRegion = friendlyByteBuf.method_52996();
            if ((flags & 2) != 0) {
                lineArgb = friendlyByteBuf.readInt();
            }
            if ((flags & 4) != 0) {
                lineThickness = friendlyByteBuf.readFloat();
            }
            if ((flags & 8) != 0) {
                faceArgb = friendlyByteBuf.readInt();
            }
        }
        return new MarkerData(uuid, position, name, minRegion, maxRegion, lineArgb, lineThickness, faceArgb);
    }

    public static void write(class_2540 friendlyByteBuf, MarkerData markerData) {
        friendlyByteBuf.method_10797(markerData.uuid);
        friendlyByteBuf.method_52940(markerData.position.field_1352);
        friendlyByteBuf.method_52940(markerData.position.field_1351);
        friendlyByteBuf.method_52940(markerData.position.field_1350);
        friendlyByteBuf.method_43826((Object)markerData.name, class_2540::method_10814);
        if (markerData.minRegion != null && markerData.maxRegion != null) {
            int flags = 1;
            if (markerData.lineArgb != 0) {
                flags = (byte)(flags | 2);
            }
            if (markerData.lineThickness != 0.0f) {
                flags = (byte)(flags | 4);
            }
            if (markerData.faceArgb != 0) {
                flags = (byte)(flags | 8);
            }
            friendlyByteBuf.method_52997(flags);
            friendlyByteBuf.method_52940(markerData.minRegion.field_1352);
            friendlyByteBuf.method_52940(markerData.minRegion.field_1351);
            friendlyByteBuf.method_52940(markerData.minRegion.field_1350);
            friendlyByteBuf.method_52940(markerData.maxRegion.field_1352);
            friendlyByteBuf.method_52940(markerData.maxRegion.field_1351);
            friendlyByteBuf.method_52940(markerData.maxRegion.field_1350);
            if (markerData.lineArgb != 0) {
                friendlyByteBuf.method_53002(markerData.lineArgb);
            }
            if (markerData.lineThickness != 0.0f) {
                friendlyByteBuf.method_52941(markerData.lineThickness);
            }
            if (markerData.faceArgb != 0) {
                friendlyByteBuf.method_53002(markerData.faceArgb);
            }
        } else {
            friendlyByteBuf.method_52997(0);
        }
    }

    public static MarkerData createFrom(class_6335 marker) {
        class_243 position = marker.method_19538();
        class_2487 data = ((MarkerEntityExt)marker).axiom$getData();
        String name = VersionUtilsNbt.helperCompoundTagGetString(data, "name").orElse("").trim();
        if (name.isEmpty()) {
            name = null;
        }
        class_243 minRegion = null;
        class_243 maxRegion = null;
        int lineArgb = 0;
        float lineThickness = 0.0f;
        int faceArgb = 0;
        if (data.method_10545("min") && data.method_10545("max")) {
            double maxZ;
            double maxY;
            double maxX;
            class_2499 max2;
            class_2499 min2 = NbtHelper.getList(data, "min", 6);
            if (min2.size() == 3) {
                double minX = VersionUtilsNbt.helperListTagGetDoubleOr(min2, 0, 0.0);
                double minY = VersionUtilsNbt.helperListTagGetDoubleOr(min2, 1, 0.0);
                double minZ = VersionUtilsNbt.helperListTagGetDoubleOr(min2, 2, 0.0);
                minRegion = new class_243(minX, minY, minZ);
            }
            if ((max2 = NbtHelper.getList(data, "max", 6)).size() == 3) {
                maxX = VersionUtilsNbt.helperListTagGetDoubleOr(max2, 0, 0.0);
                maxY = VersionUtilsNbt.helperListTagGetDoubleOr(max2, 1, 0.0);
                maxZ = VersionUtilsNbt.helperListTagGetDoubleOr(max2, 2, 0.0);
                maxRegion = new class_243(maxX, maxY, maxZ);
            }
            if (minRegion == null && (min2 = NbtHelper.getList(data, "min", 8)).size() == 3) {
                double minX = MarkerData.calculateCoordinate(VersionUtilsNbt.helperListTagGetStringOr(min2, 0, ""), position.field_1352);
                double minY = MarkerData.calculateCoordinate(VersionUtilsNbt.helperListTagGetStringOr(min2, 1, ""), position.field_1351);
                double minZ = MarkerData.calculateCoordinate(VersionUtilsNbt.helperListTagGetStringOr(min2, 2, ""), position.field_1350);
                if (Double.isFinite(minX) && Double.isFinite(minY) && Double.isFinite(minZ)) {
                    minRegion = new class_243(minX, minY, minZ);
                }
            }
            if (maxRegion == null && (max2 = NbtHelper.getList(data, "max", 8)).size() == 3) {
                maxX = MarkerData.calculateCoordinate(VersionUtilsNbt.helperListTagGetStringOr(max2, 0, ""), position.field_1352);
                maxY = MarkerData.calculateCoordinate(VersionUtilsNbt.helperListTagGetStringOr(max2, 1, ""), position.field_1351);
                maxZ = MarkerData.calculateCoordinate(VersionUtilsNbt.helperListTagGetStringOr(max2, 2, ""), position.field_1350);
                if (Double.isFinite(maxX) && Double.isFinite(maxY) && Double.isFinite(maxZ)) {
                    maxRegion = new class_243(maxX, maxY, maxZ);
                }
            }
            if (minRegion != null && maxRegion != null) {
                lineArgb = VersionUtilsNbt.helperCompoundTagGetIntOr(data, "line_argb", 0);
                lineThickness = VersionUtilsNbt.helperCompoundTagGetIntOr(data, "line_thickness", 0);
                faceArgb = VersionUtilsNbt.helperCompoundTagGetIntOr(data, "face_argb", 0);
            }
        }
        return new MarkerData(marker.method_5667(), position, name, minRegion, maxRegion, lineArgb, lineThickness, faceArgb);
    }

    private static double calculateCoordinate(String coordinate, double position) {
        boolean relative = (coordinate = coordinate.trim()).startsWith("~");
        if (relative) {
            coordinate = coordinate.substring(1).trim();
        }
        try {
            double value = Double.parseDouble(coordinate);
            if (relative) {
                return position + value;
            }
            return value;
        }
        catch (NumberFormatException e) {
            return Double.NaN;
        }
    }
}

