/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom.scaling;

import com.moulberry.axiom.collections.PositionSet;
import com.moulberry.axiom.render.regions.ChunkedBlockRegion;
import net.minecraft.class_2680;

public class Scale2x {
    private static boolean isSolid(class_2680 blockState) {
        return !blockState.method_45474();
    }

    private static boolean isSolidOrNonSolid(class_2680 blockState, boolean solid) {
        return !blockState.method_26215() && blockState.method_45474() != solid;
    }

    public static ChunkedBlockRegion scale2x(ChunkedBlockRegion in, boolean postProcessing) {
        PositionSet solid = new PositionSet();
        PositionSet nonSolid = new PositionSet();
        in.forEachEntry((x, y, z, block) -> {
            if (block.method_26215()) {
                return;
            }
            boolean isSolid = Scale2x.isSolid(block);
            PositionSet set = isSolid ? solid : nonSolid;
            boolean plusXAir = !Scale2x.isSolidOrNonSolid(in.getBlockStateOrAir(x + 1, y, z), isSolid);
            boolean plusYAir = !Scale2x.isSolidOrNonSolid(in.getBlockStateOrAir(x, y + 1, z), isSolid);
            boolean plusZAir = !Scale2x.isSolidOrNonSolid(in.getBlockStateOrAir(x, y, z + 1), isSolid);
            boolean minusXAir = !Scale2x.isSolidOrNonSolid(in.getBlockStateOrAir(x - 1, y, z), isSolid);
            boolean minusYAir = !Scale2x.isSolidOrNonSolid(in.getBlockStateOrAir(x, y - 1, z), isSolid);
            boolean minusZAir = !Scale2x.isSolidOrNonSolid(in.getBlockStateOrAir(x, y, z - 1), isSolid);
            set.add(x * 2, y * 2, z * 2);
            set.add(x * 2 + 1, y * 2, z * 2);
            set.add(x * 2, y * 2 + 1, z * 2);
            set.add(x * 2 + 1, y * 2 + 1, z * 2);
            set.add(x * 2, y * 2, z * 2 + 1);
            set.add(x * 2 + 1, y * 2, z * 2 + 1);
            set.add(x * 2, y * 2 + 1, z * 2 + 1);
            set.add(x * 2 + 1, y * 2 + 1, z * 2 + 1);
            if (!(plusXAir || plusYAir || plusZAir || minusXAir || minusYAir || minusZAir)) {
                return;
            }
            for (int i = 0; i <= 8; ++i) {
                boolean zAir;
                int xo = i & 1;
                int yo = (i & 2) >> 1;
                int zo = (i & 4) >> 2;
                int bxo = xo * 2 - 1;
                int byo = yo * 2 - 1;
                int bzo = zo * 2 - 1;
                boolean xAir = xo == 0 ? minusXAir : plusXAir;
                boolean yAir = yo == 0 ? minusYAir : plusYAir;
                boolean bl = zAir = zo == 0 ? minusZAir : plusZAir;
                if (!xAir || !yAir || !zAir || !Scale2x.isSolidOrNonSolid(in.getBlockStateOrAir(x + bxo, y + byo, z + bzo), isSolid) || Scale2x.isSolidOrNonSolid(in.getBlockStateOrAir(x, y + byo, z + bzo), isSolid) || Scale2x.isSolidOrNonSolid(in.getBlockStateOrAir(x + bxo, y, z + bzo), isSolid) || Scale2x.isSolidOrNonSolid(in.getBlockStateOrAir(x + bxo, y + byo, z), isSolid)) continue;
                set.add(x * 2 + xo + bxo, y * 2 + yo, z * 2 + zo);
                set.add(x * 2 + xo, y * 2 + yo + byo, z * 2 + zo);
                set.add(x * 2 + xo, y * 2 + yo, z * 2 + zo + bzo);
                set.add(x * 2 + xo + bxo, y * 2 + yo + byo, z * 2 + zo);
                set.add(x * 2 + xo + bxo, y * 2 + yo, z * 2 + zo + bzo);
                set.add(x * 2 + xo, y * 2 + yo + byo, z * 2 + zo + bzo);
            }
        });
        PositionSet newSolid = new PositionSet();
        PositionSet newNonSolid = new PositionSet();
        in.forEachChunk((cx, cy, cz, blocks) -> {
            cx <<= 4;
            cy <<= 4;
            cz <<= 4;
            int index = 0;
            for (int z = 0; z < 16; ++z) {
                for (int y = 0; y < 16; ++y) {
                    for (int x = 0; x < 16; ++x) {
                        class_2680 t2;
                        if ((t2 = blocks[index++]) == null || t2.method_26215()) {
                            Scale2x.processOutside(solid, newSolid, cx + x, cy + y, cz + z);
                            Scale2x.processOutside(nonSolid, newNonSolid, cx + x, cy + y, cz + z);
                            continue;
                        }
                        if (!Scale2x.isSolid(t2)) {
                            Scale2x.processOutside(solid, newSolid, cx + x, cy + y, cz + z);
                            continue;
                        }
                        Scale2x.processOutside(nonSolid, newNonSolid, cx + x, cy + y, cz + z);
                    }
                }
            }
        });
        newSolid.forEach(solid::add);
        newNonSolid.forEach(nonSolid::add);
        ChunkedBlockRegion out = new ChunkedBlockRegion();
        if (!nonSolid.isEmpty()) {
            Scale2x.applyToRegion(in, nonSolid, out, false);
        }
        if (!solid.isEmpty()) {
            Scale2x.applyToRegion(in, solid, out, true);
        }
        out.dirtyAll();
        return out;
    }

    private static void processOutside(PositionSet set, PositionSet newSet, int nx, int ny, int nz) {
        for (int i = 0; i <= 8; ++i) {
            int xo = i & 1;
            int yo = (i & 2) >> 1;
            int zo = (i & 4) >> 2;
            boolean neighborXIsSolid = set.contains(nx * 2 + xo * 3 - 1, ny * 2 + yo, nz * 2 + zo);
            boolean neighborYIsSolid = set.contains(nx * 2 + xo, ny * 2 + yo * 3 - 1, nz * 2 + zo);
            boolean neighborZIsSolid = set.contains(nx * 2 + xo, ny * 2 + yo, nz * 2 + zo * 3 - 1);
            boolean oppositeXIsAir = !set.contains(nx * 2 - xo * 3 + 2, ny * 2 + yo, nz * 2 + zo);
            boolean oppositeYIsAir = !set.contains(nx * 2 + xo, ny * 2 - yo * 3 + 2, nz * 2 + zo);
            boolean oppositeZIsAir = !set.contains(nx * 2 + xo, ny * 2 + yo, nz * 2 - zo * 3 + 2);
            int oppositeAirCount = 0;
            if (oppositeXIsAir) {
                ++oppositeAirCount;
            }
            if (oppositeYIsAir) {
                ++oppositeAirCount;
            }
            if (oppositeZIsAir) {
                ++oppositeAirCount;
            }
            if (neighborXIsSolid && neighborYIsSolid && neighborZIsSolid && oppositeAirCount >= 2) {
                newSet.add(nx * 2 + xo, ny * 2 + yo, nz * 2 + zo);
                continue;
            }
            if (neighborYIsSolid && neighborZIsSolid && oppositeYIsAir && oppositeZIsAir && set.contains(nx * 2 + xo, ny * 2 + yo * 3 - 1, nz * 2 + (1 - zo)) && set.contains(nx * 2 + xo, ny * 2 + (1 - yo), nz * 2 + zo * 3 - 1) && set.contains(nx * 2 + (1 - xo), ny * 2 + yo * 3 - 1, nz * 2 + zo) && set.contains(nx * 2 + (1 - xo), ny * 2, nz * 2 + zo * 3 - 1)) {
                if (set.contains(nx * 2 + xo * 3 - 1, ny * 2 + yo * 3 - 1, nz * 2 + zo) && set.contains(nx * 2 + xo * 3 - 1, ny * 2 + yo, nz * 2 + zo * 3 - 1)) {
                    newSet.add(nx * 2 + xo, ny * 2 + yo, nz * 2 + zo);
                    continue;
                }
                if (set.contains(nx * 2 - xo * 3 + 2, ny * 2 + yo * 3 - 1, nz * 2 + zo) && set.contains(nx * 2 - xo * 3 + 2, ny * 2 + yo, nz * 2 + zo * 3 - 1)) continue;
                newSet.add(nx * 2 + xo, ny * 2 + yo, nz * 2 + zo);
                newSet.add(nx * 2 + xo, ny * 2 + yo * 3 - 1, nz * 2 + zo * 3 - 1);
                continue;
            }
            if (neighborXIsSolid && neighborZIsSolid && oppositeXIsAir && oppositeZIsAir && set.contains(nx * 2 + xo * 3 - 1, ny * 2 + yo, nz * 2 + (1 - zo)) && set.contains(nx * 2 + (1 - xo), ny * 2 + yo, nz * 2 + zo * 3 - 1) && set.contains(nx * 2 + xo * 3 - 1, ny * 2 + (1 - yo), nz * 2 + zo) && set.contains(nx * 2 + xo, ny * 2 + (1 - yo), nz * 2 + zo * 3 - 1)) {
                if (set.contains(nx * 2 + xo * 3 - 1, ny * 2 + yo * 3 - 1, nz * 2 + zo) && set.contains(nx * 2 + xo, ny * 2 + yo * 3 - 1, nz * 2 + zo * 3 - 1)) {
                    newSet.add(nx * 2 + xo, ny * 2 + yo, nz * 2 + zo);
                    continue;
                }
                if (set.contains(nx * 2 + xo * 3 - 1, ny * 2 - yo * 3 + 2, nz * 2 + zo) && set.contains(nx * 2 + xo, ny * 2 - yo * 3 + 2, nz * 2 + zo * 3 - 1)) continue;
                newSet.add(nx * 2 + xo, ny * 2 + yo, nz * 2 + zo);
                newSet.add(nx * 2 + xo * 3 - 1, ny * 2 + yo, nz * 2 + zo * 3 - 1);
                continue;
            }
            if (!neighborXIsSolid || !neighborYIsSolid || !oppositeXIsAir || !oppositeYIsAir || !set.contains(nx * 2 + xo * 3 - 1, ny * 2 + (1 - yo), nz * 2 + zo) || !set.contains(nx * 2 + (1 - xo), ny * 2 + yo * 3 - 1, nz * 2 + zo) || !set.contains(nx * 2 + xo * 3 - 1, ny * 2 + yo, nz * 2 + (1 - zo)) || !set.contains(nx * 2 + xo, ny * 2 + yo * 3 - 1, nz * 2 + (1 - zo))) continue;
            if (set.contains(nx * 2 + xo * 3 - 1, ny * 2 + yo, nz * 2 + zo * 3 - 1) && set.contains(nx * 2 + xo, ny * 2 + yo * 3 - 1, nz * 2 + zo * 3 - 1)) {
                newSet.add(nx * 2 + xo, ny * 2 + yo, nz * 2 + zo);
                continue;
            }
            if (set.contains(nx * 2 + xo * 3 - 1, ny * 2 + yo, nz * 2 - zo * 3 + 2) && set.contains(nx * 2 + xo, ny * 2 + yo * 3 - 1, nz * 2 - zo * 3 + 2)) continue;
            newSet.add(nx * 2 + xo, ny * 2 + yo, nz * 2 + zo);
            newSet.add(nx * 2 + xo * 3 - 1, ny * 2 + yo * 3 - 1, nz * 2 + zo);
        }
    }

    private static void applyToRegion(ChunkedBlockRegion in, PositionSet set, ChunkedBlockRegion out, boolean solid) {
        PositionSet ignore = new PositionSet();
        PositionSet tooMuchIgnore = new PositionSet();
        set.forEach((x, y, z) -> {
            int xo = (x & 1) * 2 - 1;
            int yo = (y & 1) * 2 - 1;
            int zo = (z & 1) * 2 - 1;
            if (set.contains(x + xo, y + yo, z + zo)) {
                return;
            }
            if (set.contains(x, y + yo, z + zo)) {
                return;
            }
            if (set.contains(x + xo, y, z + zo)) {
                return;
            }
            if (set.contains(x + xo, y + yo, z)) {
                return;
            }
            if (set.contains(x + xo, y, z)) {
                return;
            }
            if (set.contains(x, y + yo, z)) {
                return;
            }
            if (set.contains(x, y, z + zo)) {
                return;
            }
            if (!set.contains(x - xo, y, z)) {
                return;
            }
            if (!set.contains(x, y - yo, z)) {
                return;
            }
            if (!set.contains(x, y, z - zo)) {
                return;
            }
            if (set.contains(x + xo, y - yo, z)) {
                return;
            }
            if (set.contains(x + xo, y, z - zo)) {
                return;
            }
            if (set.contains(x - xo, y + yo, z)) {
                return;
            }
            if (set.contains(x, y + yo, z - zo)) {
                return;
            }
            if (set.contains(x - xo, y, z + zo)) {
                return;
            }
            if (set.contains(x, y - yo, z + zo)) {
                return;
            }
            if (set.contains(x - xo, y + yo, z + zo)) {
                return;
            }
            if (set.contains(x + xo, y - yo, z + zo)) {
                return;
            }
            if (set.contains(x + xo, y + yo, z - zo)) {
                return;
            }
            ignore.add(x, y, z);
        });
        ignore.forEach((x, y, z) -> {
            int neighbors = 0;
            if (ignore.contains(x + 1, y, z)) {
                ++neighbors;
            }
            if (ignore.contains(x - 1, y, z)) {
                ++neighbors;
            }
            if (ignore.contains(x, y + 1, z)) {
                ++neighbors;
            }
            if (ignore.contains(x, y - 1, z)) {
                ++neighbors;
            }
            if (ignore.contains(x, y, z + 1)) {
                ++neighbors;
            }
            if (ignore.contains(x, y, z - 1)) {
                ++neighbors;
            }
            if (neighbors >= 2) {
                tooMuchIgnore.add(x, y, z);
            }
        });
        set.forEach((x, y, z) -> {
            if (!(!ignore.contains(x, y, z) || tooMuchIgnore.contains(x + 1, y, z) || tooMuchIgnore.contains(x - 1, y, z) || tooMuchIgnore.contains(x, y + 1, z) || tooMuchIgnore.contains(x, y - 1, z) || tooMuchIgnore.contains(x, y, z + 1) || tooMuchIgnore.contains(x, y, z - 1))) {
                return;
            }
            int bx = x >> 1;
            int by = y >> 1;
            int bz = z >> 1;
            class_2680 center = in.getBlockStateOrAir(bx, by, bz);
            class_2680 neighborX = in.getBlockStateOrAir(bx + (x & 1) * 2 - 1, by, bz);
            class_2680 neighborY = in.getBlockStateOrAir(bx, by + (y & 1) * 2 - 1, bz);
            class_2680 neighborZ = in.getBlockStateOrAir(bx, by, bz + (z & 1) * 2 - 1);
            if (Scale2x.isSolidOrNonSolid(center, solid)) {
                int z1;
                if (center == in.getBlockStateOrAir(bx + (x & 1) * 2 - 1, by + (y & 1) * 2 - 1, bz + (z & 1) * 2 - 1)) {
                    out.addBlockWithoutDirty(x, y, z, center);
                    return;
                }
                if (center == in.getBlockStateOrAir(bx, by + (y & 1) * 2 - 1, bz + (z & 1) * 2 - 1)) {
                    out.addBlockWithoutDirty(x, y, z, center);
                    return;
                }
                if (center == in.getBlockStateOrAir(bx + (x & 1) * 2 - 1, by, bz + (z & 1) * 2 - 1)) {
                    out.addBlockWithoutDirty(x, y, z, center);
                    return;
                }
                if (center == in.getBlockStateOrAir(bx + (x & 1) * 2 - 1, by + (y & 1) * 2 - 1, bz)) {
                    out.addBlockWithoutDirty(x, y, z, center);
                    return;
                }
                int x1 = x <= 0 ? x - 1 : x;
                int y1 = y <= 0 ? y - 1 : y;
                int n = z1 = z <= 0 ? z - 1 : z;
                int ring = !Scale2x.isSolidOrNonSolid(neighborY, solid) ? Math.max(Math.abs(x1), Math.abs(z1)) : (!Scale2x.isSolidOrNonSolid(neighborX, solid) ? Math.max(Math.abs(y1), Math.abs(z1)) : (!Scale2x.isSolidOrNonSolid(neighborZ, solid) ? Math.max(Math.abs(x1), Math.abs(y1)) : 0));
                if ((ring & 1) == 1) {
                    out.addBlockWithoutDirty(x, y, z, center);
                    return;
                }
            }
            if (Scale2x.isSolidOrNonSolid(center, solid)) {
                if (center == neighborY || center == neighborX || center == neighborZ) {
                    out.addBlockWithoutDirty(x, y, z, center);
                } else if (Scale2x.isSolidOrNonSolid(neighborY, solid)) {
                    if (Scale2x.isSolidOrNonSolid(neighborX, solid) && neighborX == neighborZ) {
                        out.addBlockWithoutDirty(x, y, z, neighborX);
                    } else if (neighborY == neighborX || neighborY == neighborZ) {
                        out.addBlockWithoutDirty(x, y, z, neighborY);
                    } else {
                        out.addBlockWithoutDirty(x, y, z, center);
                    }
                } else if (Scale2x.isSolidOrNonSolid(neighborX, solid)) {
                    if (neighborX == neighborZ) {
                        out.addBlockWithoutDirty(x, y, z, neighborX);
                    } else {
                        out.addBlockWithoutDirty(x, y, z, center);
                    }
                } else {
                    out.addBlockWithoutDirty(x, y, z, center);
                }
            } else if (Scale2x.isSolidOrNonSolid(neighborY, solid)) {
                if (Scale2x.isSolidOrNonSolid(neighborX, solid) && neighborX == neighborZ) {
                    out.addBlockWithoutDirty(x, y, z, neighborX);
                } else {
                    out.addBlockWithoutDirty(x, y, z, neighborY);
                }
            } else if (Scale2x.isSolidOrNonSolid(neighborX, solid)) {
                out.addBlockWithoutDirty(x, y, z, neighborX);
            } else if (Scale2x.isSolidOrNonSolid(neighborZ, solid)) {
                out.addBlockWithoutDirty(x, y, z, neighborZ);
            }
        });
    }
}

