/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom.annotations;

import com.moulberry.axiom.annotations.data.AnnotationData;
import com.moulberry.axiom.render.annotations.Annotations;
import java.util.UUID;
import net.minecraft.class_2540;
import org.joml.Quaternionf;
import org.joml.Vector3f;

public interface AnnotationUpdateAction {
    public void apply();

    public void write(class_2540 var1);

    public static AnnotationUpdateAction read(class_2540 friendlyByteBuf) {
        byte type2 = friendlyByteBuf.readByte();
        if (type2 == 0) {
            UUID uuid = friendlyByteBuf.method_10790();
            AnnotationData annotationData = AnnotationData.read(friendlyByteBuf);
            if (annotationData == null) {
                return null;
            }
            return new CreateAnnotation(uuid, annotationData);
        }
        if (type2 == 1) {
            return new DeleteAnnotation(friendlyByteBuf.method_10790());
        }
        if (type2 == 2) {
            return new MoveAnnotation(friendlyByteBuf.method_10790(), new Vector3f(friendlyByteBuf.readFloat(), friendlyByteBuf.readFloat(), friendlyByteBuf.readFloat()));
        }
        if (type2 == 3) {
            return new ClearAllAnnotations();
        }
        if (type2 == 4) {
            return new RotateAnnotation(friendlyByteBuf.method_10790(), new Quaternionf(friendlyByteBuf.readFloat(), friendlyByteBuf.readFloat(), friendlyByteBuf.readFloat(), friendlyByteBuf.readFloat()));
        }
        return null;
    }

    public record CreateAnnotation(UUID uuid, AnnotationData annotationData) implements AnnotationUpdateAction
    {
        @Override
        public void apply() {
            Annotations.add(this.uuid, this.annotationData);
        }

        @Override
        public void write(class_2540 friendlyByteBuf) {
            friendlyByteBuf.method_52997(0);
            friendlyByteBuf.method_10797(this.uuid);
            this.annotationData.write(friendlyByteBuf);
        }
    }

    public record DeleteAnnotation(UUID uuid) implements AnnotationUpdateAction
    {
        @Override
        public void apply() {
            Annotations.remove(this.uuid);
        }

        @Override
        public void write(class_2540 friendlyByteBuf) {
            friendlyByteBuf.method_52997(1);
            friendlyByteBuf.method_10797(this.uuid);
        }
    }

    public record MoveAnnotation(UUID uuid, Vector3f to) implements AnnotationUpdateAction
    {
        @Override
        public void apply() {
            Annotations.move(this.uuid, this.to);
        }

        @Override
        public void write(class_2540 friendlyByteBuf) {
            friendlyByteBuf.method_52997(2);
            friendlyByteBuf.method_10797(this.uuid);
            friendlyByteBuf.method_52941(this.to.x);
            friendlyByteBuf.method_52941(this.to.y);
            friendlyByteBuf.method_52941(this.to.z);
        }
    }

    public record ClearAllAnnotations() implements AnnotationUpdateAction
    {
        @Override
        public void apply() {
            Annotations.clear();
        }

        @Override
        public void write(class_2540 friendlyByteBuf) {
            friendlyByteBuf.method_52997(3);
        }
    }

    public record RotateAnnotation(UUID uuid, Quaternionf to) implements AnnotationUpdateAction
    {
        @Override
        public void apply() {
            Annotations.rotate(this.uuid, this.to);
        }

        @Override
        public void write(class_2540 friendlyByteBuf) {
            friendlyByteBuf.method_52997(4);
            friendlyByteBuf.method_10797(this.uuid);
            friendlyByteBuf.method_52941(this.to.x);
            friendlyByteBuf.method_52941(this.to.y);
            friendlyByteBuf.method_52941(this.to.z);
            friendlyByteBuf.method_52941(this.to.w);
        }
    }
}

